# Copyright (c) Meta Platforms, Inc. and affiliates.
# All rights reserved.

# This source code is licensed under the license found in the
# LICENSE file in the root directory of this source tree.

from facebook_business.adobjects.abstractobject import AbstractObject
from facebook_business.adobjects.abstractcrudobject import AbstractCrudObject
from facebook_business.adobjects.objectparser import ObjectParser
from facebook_business.api import FacebookRequest
from facebook_business.typechecker import TypeChecker

"""
This class is auto-generated.

For any issues or feature requests related to this class, please let us know on
github and we'll fix in our codegen framework. We'll not be able to accept
pull request for this class.
"""

class ManagedPartnerBusiness(
    AbstractCrudObject,
):

    def __init__(self, fbid=None, parent_id=None, api=None):
        self._isManagedPartnerBusiness = True
        super(ManagedPartnerBusiness, self).__init__(fbid, parent_id, api)

    class Field(AbstractObject.Field):
        ad_account = 'ad_account'
        catalog_segment = 'catalog_segment'
        extended_credit = 'extended_credit'
        page = 'page'
        seller_business_info = 'seller_business_info'
        seller_business_status = 'seller_business_status'
        template = 'template'
        ad_account_currency = 'ad_account_currency'
        catalog_id = 'catalog_id'
        child_business_external_id = 'child_business_external_id'
        credit_limit = 'credit_limit'
        line_of_credit_id = 'line_of_credit_id'
        name = 'name'
        no_ad_account = 'no_ad_account'
        page_name = 'page_name'
        page_profile_image_url = 'page_profile_image_url'
        partition_type = 'partition_type'
        partner_facebook_page_url = 'partner_facebook_page_url'
        partner_registration_countries = 'partner_registration_countries'
        sales_rep_email = 'sales_rep_email'
        seller_external_website_url = 'seller_external_website_url'
        seller_targeting_countries = 'seller_targeting_countries'
        skip_partner_page_creation = 'skip_partner_page_creation'
        survey_business_type = 'survey_business_type'
        survey_num_assets = 'survey_num_assets'
        survey_num_people = 'survey_num_people'
        timezone_id = 'timezone_id'
        vertical = 'vertical'

    class PartitionType:
        auth = 'AUTH'
        fixed = 'FIXED'
        fixed_without_partition = 'FIXED_WITHOUT_PARTITION'

    class SurveyBusinessType:
        advertiser = 'ADVERTISER'
        agency = 'AGENCY'
        app_developer = 'APP_DEVELOPER'
        publisher = 'PUBLISHER'

    class TimezoneId:
        value_0 = '0'
        value_1 = '1'
        value_2 = '2'
        value_3 = '3'
        value_4 = '4'
        value_5 = '5'
        value_6 = '6'
        value_7 = '7'
        value_8 = '8'
        value_9 = '9'
        value_10 = '10'
        value_11 = '11'
        value_12 = '12'
        value_13 = '13'
        value_14 = '14'
        value_15 = '15'
        value_16 = '16'
        value_17 = '17'
        value_18 = '18'
        value_19 = '19'
        value_20 = '20'
        value_21 = '21'
        value_22 = '22'
        value_23 = '23'
        value_24 = '24'
        value_25 = '25'
        value_26 = '26'
        value_27 = '27'
        value_28 = '28'
        value_29 = '29'
        value_30 = '30'
        value_31 = '31'
        value_32 = '32'
        value_33 = '33'
        value_34 = '34'
        value_35 = '35'
        value_36 = '36'
        value_37 = '37'
        value_38 = '38'
        value_39 = '39'
        value_40 = '40'
        value_41 = '41'
        value_42 = '42'
        value_43 = '43'
        value_44 = '44'
        value_45 = '45'
        value_46 = '46'
        value_47 = '47'
        value_48 = '48'
        value_49 = '49'
        value_50 = '50'
        value_51 = '51'
        value_52 = '52'
        value_53 = '53'
        value_54 = '54'
        value_55 = '55'
        value_56 = '56'
        value_57 = '57'
        value_58 = '58'
        value_59 = '59'
        value_60 = '60'
        value_61 = '61'
        value_62 = '62'
        value_63 = '63'
        value_64 = '64'
        value_65 = '65'
        value_66 = '66'
        value_67 = '67'
        value_68 = '68'
        value_69 = '69'
        value_70 = '70'
        value_71 = '71'
        value_72 = '72'
        value_73 = '73'
        value_74 = '74'
        value_75 = '75'
        value_76 = '76'
        value_77 = '77'
        value_78 = '78'
        value_79 = '79'
        value_80 = '80'
        value_81 = '81'
        value_82 = '82'
        value_83 = '83'
        value_84 = '84'
        value_85 = '85'
        value_86 = '86'
        value_87 = '87'
        value_88 = '88'
        value_89 = '89'
        value_90 = '90'
        value_91 = '91'
        value_92 = '92'
        value_93 = '93'
        value_94 = '94'
        value_95 = '95'
        value_96 = '96'
        value_97 = '97'
        value_98 = '98'
        value_99 = '99'
        value_100 = '100'
        value_101 = '101'
        value_102 = '102'
        value_103 = '103'
        value_104 = '104'
        value_105 = '105'
        value_106 = '106'
        value_107 = '107'
        value_108 = '108'
        value_109 = '109'
        value_110 = '110'
        value_111 = '111'
        value_112 = '112'
        value_113 = '113'
        value_114 = '114'
        value_115 = '115'
        value_116 = '116'
        value_117 = '117'
        value_118 = '118'
        value_119 = '119'
        value_120 = '120'
        value_121 = '121'
        value_122 = '122'
        value_123 = '123'
        value_124 = '124'
        value_125 = '125'
        value_126 = '126'
        value_127 = '127'
        value_128 = '128'
        value_129 = '129'
        value_130 = '130'
        value_131 = '131'
        value_132 = '132'
        value_133 = '133'
        value_134 = '134'
        value_135 = '135'
        value_136 = '136'
        value_137 = '137'
        value_138 = '138'
        value_139 = '139'
        value_140 = '140'
        value_141 = '141'
        value_142 = '142'
        value_143 = '143'
        value_144 = '144'
        value_145 = '145'
        value_146 = '146'
        value_147 = '147'
        value_148 = '148'
        value_149 = '149'
        value_150 = '150'
        value_151 = '151'
        value_152 = '152'
        value_153 = '153'
        value_154 = '154'
        value_155 = '155'
        value_156 = '156'
        value_157 = '157'
        value_158 = '158'
        value_159 = '159'
        value_160 = '160'
        value_161 = '161'
        value_162 = '162'
        value_163 = '163'
        value_164 = '164'
        value_165 = '165'
        value_166 = '166'
        value_167 = '167'
        value_168 = '168'
        value_169 = '169'
        value_170 = '170'
        value_171 = '171'
        value_172 = '172'
        value_173 = '173'
        value_174 = '174'
        value_175 = '175'
        value_176 = '176'
        value_177 = '177'
        value_178 = '178'
        value_179 = '179'
        value_180 = '180'
        value_181 = '181'
        value_182 = '182'
        value_183 = '183'
        value_184 = '184'
        value_185 = '185'
        value_186 = '186'
        value_187 = '187'
        value_188 = '188'
        value_189 = '189'
        value_190 = '190'
        value_191 = '191'
        value_192 = '192'
        value_193 = '193'
        value_194 = '194'
        value_195 = '195'
        value_196 = '196'
        value_197 = '197'
        value_198 = '198'
        value_199 = '199'
        value_200 = '200'
        value_201 = '201'
        value_202 = '202'
        value_203 = '203'
        value_204 = '204'
        value_205 = '205'
        value_206 = '206'
        value_207 = '207'
        value_208 = '208'
        value_209 = '209'
        value_210 = '210'
        value_211 = '211'
        value_212 = '212'
        value_213 = '213'
        value_214 = '214'
        value_215 = '215'
        value_216 = '216'
        value_217 = '217'
        value_218 = '218'
        value_219 = '219'
        value_220 = '220'
        value_221 = '221'
        value_222 = '222'
        value_223 = '223'
        value_224 = '224'
        value_225 = '225'
        value_226 = '226'
        value_227 = '227'
        value_228 = '228'
        value_229 = '229'
        value_230 = '230'
        value_231 = '231'
        value_232 = '232'
        value_233 = '233'
        value_234 = '234'
        value_235 = '235'
        value_236 = '236'
        value_237 = '237'
        value_238 = '238'
        value_239 = '239'
        value_240 = '240'
        value_241 = '241'
        value_242 = '242'
        value_243 = '243'
        value_244 = '244'
        value_245 = '245'
        value_246 = '246'
        value_247 = '247'
        value_248 = '248'
        value_249 = '249'
        value_250 = '250'
        value_251 = '251'
        value_252 = '252'
        value_253 = '253'
        value_254 = '254'
        value_255 = '255'
        value_256 = '256'
        value_257 = '257'
        value_258 = '258'
        value_259 = '259'
        value_260 = '260'
        value_261 = '261'
        value_262 = '262'
        value_263 = '263'
        value_264 = '264'
        value_265 = '265'
        value_266 = '266'
        value_267 = '267'
        value_268 = '268'
        value_269 = '269'
        value_270 = '270'
        value_271 = '271'
        value_272 = '272'
        value_273 = '273'
        value_274 = '274'
        value_275 = '275'
        value_276 = '276'
        value_277 = '277'
        value_278 = '278'
        value_279 = '279'
        value_280 = '280'
        value_281 = '281'
        value_282 = '282'
        value_283 = '283'
        value_284 = '284'
        value_285 = '285'
        value_286 = '286'
        value_287 = '287'
        value_288 = '288'
        value_289 = '289'
        value_290 = '290'
        value_291 = '291'
        value_292 = '292'
        value_293 = '293'
        value_294 = '294'
        value_295 = '295'
        value_296 = '296'
        value_297 = '297'
        value_298 = '298'
        value_299 = '299'
        value_300 = '300'
        value_301 = '301'
        value_302 = '302'
        value_303 = '303'
        value_304 = '304'
        value_305 = '305'
        value_306 = '306'
        value_307 = '307'
        value_308 = '308'
        value_309 = '309'
        value_310 = '310'
        value_311 = '311'
        value_312 = '312'
        value_313 = '313'
        value_314 = '314'
        value_315 = '315'
        value_316 = '316'
        value_317 = '317'
        value_318 = '318'
        value_319 = '319'
        value_320 = '320'
        value_321 = '321'
        value_322 = '322'
        value_323 = '323'
        value_324 = '324'
        value_325 = '325'
        value_326 = '326'
        value_327 = '327'
        value_328 = '328'
        value_329 = '329'
        value_330 = '330'
        value_331 = '331'
        value_332 = '332'
        value_333 = '333'
        value_334 = '334'
        value_335 = '335'
        value_336 = '336'
        value_337 = '337'
        value_338 = '338'
        value_339 = '339'
        value_340 = '340'
        value_341 = '341'
        value_342 = '342'
        value_343 = '343'
        value_344 = '344'
        value_345 = '345'
        value_346 = '346'
        value_347 = '347'
        value_348 = '348'
        value_349 = '349'
        value_350 = '350'
        value_351 = '351'
        value_352 = '352'
        value_353 = '353'
        value_354 = '354'
        value_355 = '355'
        value_356 = '356'
        value_357 = '357'
        value_358 = '358'
        value_359 = '359'
        value_360 = '360'
        value_361 = '361'
        value_362 = '362'
        value_363 = '363'
        value_364 = '364'
        value_365 = '365'
        value_366 = '366'
        value_367 = '367'
        value_368 = '368'
        value_369 = '369'
        value_370 = '370'
        value_371 = '371'
        value_372 = '372'
        value_373 = '373'
        value_374 = '374'
        value_375 = '375'
        value_376 = '376'
        value_377 = '377'
        value_378 = '378'
        value_379 = '379'
        value_380 = '380'
        value_381 = '381'
        value_382 = '382'
        value_383 = '383'
        value_384 = '384'
        value_385 = '385'
        value_386 = '386'
        value_387 = '387'
        value_388 = '388'
        value_389 = '389'
        value_390 = '390'
        value_391 = '391'
        value_392 = '392'
        value_393 = '393'
        value_394 = '394'
        value_395 = '395'
        value_396 = '396'
        value_397 = '397'
        value_398 = '398'
        value_399 = '399'
        value_400 = '400'
        value_401 = '401'
        value_402 = '402'
        value_403 = '403'
        value_404 = '404'
        value_405 = '405'
        value_406 = '406'
        value_407 = '407'
        value_408 = '408'
        value_409 = '409'
        value_410 = '410'
        value_411 = '411'
        value_412 = '412'
        value_413 = '413'
        value_414 = '414'
        value_415 = '415'
        value_416 = '416'
        value_417 = '417'
        value_418 = '418'
        value_419 = '419'
        value_420 = '420'
        value_421 = '421'
        value_422 = '422'
        value_423 = '423'
        value_424 = '424'
        value_425 = '425'
        value_426 = '426'
        value_427 = '427'
        value_428 = '428'
        value_429 = '429'
        value_430 = '430'
        value_431 = '431'
        value_432 = '432'
        value_433 = '433'
        value_434 = '434'
        value_435 = '435'
        value_436 = '436'
        value_437 = '437'
        value_438 = '438'
        value_439 = '439'
        value_440 = '440'
        value_441 = '441'
        value_442 = '442'
        value_443 = '443'
        value_444 = '444'
        value_445 = '445'
        value_446 = '446'
        value_447 = '447'
        value_448 = '448'
        value_449 = '449'
        value_450 = '450'
        value_451 = '451'
        value_452 = '452'
        value_453 = '453'
        value_454 = '454'
        value_455 = '455'
        value_456 = '456'
        value_457 = '457'
        value_458 = '458'
        value_459 = '459'
        value_460 = '460'
        value_461 = '461'
        value_462 = '462'
        value_463 = '463'
        value_464 = '464'
        value_465 = '465'
        value_466 = '466'
        value_467 = '467'
        value_468 = '468'
        value_469 = '469'
        value_470 = '470'
        value_471 = '471'
        value_472 = '472'
        value_473 = '473'
        value_474 = '474'
        value_475 = '475'
        value_476 = '476'
        value_477 = '477'
        value_478 = '478'
        value_479 = '479'
        value_480 = '480'

    class Vertical:
        advertising = 'ADVERTISING'
        automotive = 'AUTOMOTIVE'
        consumer_packaged_goods = 'CONSUMER_PACKAGED_GOODS'
        ecommerce = 'ECOMMERCE'
        education = 'EDUCATION'
        energy_and_utilities = 'ENERGY_AND_UTILITIES'
        entertainment_and_media = 'ENTERTAINMENT_AND_MEDIA'
        financial_services = 'FINANCIAL_SERVICES'
        gaming = 'GAMING'
        government_and_politics = 'GOVERNMENT_AND_POLITICS'
        health = 'HEALTH'
        luxury = 'LUXURY'
        marketing = 'MARKETING'
        non_profit = 'NON_PROFIT'
        not_set = 'NOT_SET'
        organizations_and_associations = 'ORGANIZATIONS_AND_ASSOCIATIONS'
        other = 'OTHER'
        professional_services = 'PROFESSIONAL_SERVICES'
        restaurant = 'RESTAURANT'
        retail = 'RETAIL'
        technology = 'TECHNOLOGY'
        telecom = 'TELECOM'
        travel = 'TRAVEL'

    # @deprecated get_endpoint function is deprecated
    @classmethod
    def get_endpoint(cls):
        return 'managed_partner_businesses'

    # @deprecated api_create is being deprecated
    def api_create(self, parent_id, fields=None, params=None, batch=None, success=None, failure=None, pending=False):
        from facebook_business.adobjects.business import Business
        return Business(api=self._api, fbid=parent_id).create_managed_partner_business(fields, params, batch, success, failure, pending)

    _field_types = {
        'ad_account': 'AdAccount',
        'catalog_segment': 'ProductCatalog',
        'extended_credit': 'ManagedPartnerExtendedCredit',
        'page': 'Page',
        'seller_business_info': 'Object',
        'seller_business_status': 'string',
        'template': 'list<Object>',
        'ad_account_currency': 'string',
        'catalog_id': 'string',
        'child_business_external_id': 'string',
        'credit_limit': 'unsigned int',
        'line_of_credit_id': 'string',
        'name': 'string',
        'no_ad_account': 'bool',
        'page_name': 'string',
        'page_profile_image_url': 'string',
        'partition_type': 'PartitionType',
        'partner_facebook_page_url': 'string',
        'partner_registration_countries': 'list<string>',
        'sales_rep_email': 'string',
        'seller_external_website_url': 'string',
        'seller_targeting_countries': 'list<string>',
        'skip_partner_page_creation': 'bool',
        'survey_business_type': 'SurveyBusinessType',
        'survey_num_assets': 'unsigned int',
        'survey_num_people': 'unsigned int',
        'timezone_id': 'TimezoneId',
        'vertical': 'Vertical',
    }
    @classmethod
    def _get_field_enum_info(cls):
        field_enum_info = {}
        field_enum_info['PartitionType'] = ManagedPartnerBusiness.PartitionType.__dict__.values()
        field_enum_info['SurveyBusinessType'] = ManagedPartnerBusiness.SurveyBusinessType.__dict__.values()
        field_enum_info['TimezoneId'] = ManagedPartnerBusiness.TimezoneId.__dict__.values()
        field_enum_info['Vertical'] = ManagedPartnerBusiness.Vertical.__dict__.values()
        return field_enum_info


