# Copyright (c) Meta Platforms, Inc. and affiliates.
# All rights reserved.

# This source code is licensed under the license found in the
# LICENSE file in the root directory of this source tree.

from facebook_business.adobjects.abstractobject import AbstractObject
from facebook_business.adobjects.abstractcrudobject import AbstractCrudObject
from facebook_business.adobjects.objectparser import ObjectParser
from facebook_business.api import FacebookRequest
from facebook_business.typechecker import TypeChecker

"""
This class is auto-generated.

For any issues or feature requests related to this class, please let us know on
github and we'll fix in our codegen framework. We'll not be able to accept
pull request for this class.
"""

class VehicleOffer(
    AbstractCrudObject,
):

    def __init__(self, fbid=None, parent_id=None, api=None):
        self._isVehicleOffer = True
        super(VehicleOffer, self).__init__(fbid, parent_id, api)

    class Field(AbstractObject.Field):
        amount_currency = 'amount_currency'
        amount_percentage = 'amount_percentage'
        amount_price = 'amount_price'
        amount_qualifier = 'amount_qualifier'
        applinks = 'applinks'
        availability = 'availability'
        body_style = 'body_style'
        cashback_currency = 'cashback_currency'
        cashback_price = 'cashback_price'
        category_specific_fields = 'category_specific_fields'
        currency = 'currency'
        custom_label_0 = 'custom_label_0'
        custom_label_1 = 'custom_label_1'
        custom_label_2 = 'custom_label_2'
        custom_label_3 = 'custom_label_3'
        custom_label_4 = 'custom_label_4'
        custom_number_0 = 'custom_number_0'
        custom_number_1 = 'custom_number_1'
        custom_number_2 = 'custom_number_2'
        custom_number_3 = 'custom_number_3'
        custom_number_4 = 'custom_number_4'
        dma_codes = 'dma_codes'
        downpayment_currency = 'downpayment_currency'
        downpayment_price = 'downpayment_price'
        downpayment_qualifier = 'downpayment_qualifier'
        drivetrain = 'drivetrain'
        end_date = 'end_date'
        end_time = 'end_time'
        exterior_color = 'exterior_color'
        fuel_type = 'fuel_type'
        generation = 'generation'
        id = 'id'
        image_fetch_status = 'image_fetch_status'
        images = 'images'
        interior_color = 'interior_color'
        interior_upholstery = 'interior_upholstery'
        make = 'make'
        model = 'model'
        offer_description = 'offer_description'
        offer_disclaimer = 'offer_disclaimer'
        offer_type = 'offer_type'
        price = 'price'
        product_priority_0 = 'product_priority_0'
        product_priority_1 = 'product_priority_1'
        product_priority_2 = 'product_priority_2'
        product_priority_3 = 'product_priority_3'
        product_priority_4 = 'product_priority_4'
        sanitized_images = 'sanitized_images'
        start_date = 'start_date'
        start_time = 'start_time'
        tags = 'tags'
        term_length = 'term_length'
        term_qualifier = 'term_qualifier'
        title = 'title'
        transmission = 'transmission'
        trim = 'trim'
        unit_price = 'unit_price'
        url = 'url'
        vehicle_offer_id = 'vehicle_offer_id'
        visibility = 'visibility'
        year = 'year'

    class ImageFetchStatus:
        direct_upload = 'DIRECT_UPLOAD'
        fetched = 'FETCHED'
        fetch_failed = 'FETCH_FAILED'
        no_status = 'NO_STATUS'
        outdated = 'OUTDATED'
        partial_fetch = 'PARTIAL_FETCH'

    class Visibility:
        published = 'PUBLISHED'
        staging = 'STAGING'

    def api_get(self, fields=None, params=None, batch=None, success=None, failure=None, pending=False):
        from facebook_business.utils import api_utils
        if batch is None and (success is not None or failure is not None):
          api_utils.warning('`success` and `failure` callback only work for batch call.')
        param_types = {
        }
        enums = {
        }
        request = FacebookRequest(
            node_id=self['id'],
            method='GET',
            endpoint='/',
            api=self._api,
            param_checker=TypeChecker(param_types, enums),
            target_class=VehicleOffer,
            api_type='NODE',
            response_parser=ObjectParser(reuse_object=self),
        )
        request.add_params(params)
        request.add_fields(fields)

        if batch is not None:
            request.add_to_batch(batch, success=success, failure=failure)
            return request
        elif pending:
            return request
        else:
            self.assure_call()
            return request.execute()

    def get_channels_to_integrity_status(self, fields=None, params=None, batch=None, success=None, failure=None, pending=False):
        from facebook_business.utils import api_utils
        if batch is None and (success is not None or failure is not None):
          api_utils.warning('`success` and `failure` callback only work for batch call.')
        from facebook_business.adobjects.catalogitemchannelstointegritystatus import CatalogItemChannelsToIntegrityStatus
        param_types = {
        }
        enums = {
        }
        request = FacebookRequest(
            node_id=self['id'],
            method='GET',
            endpoint='/channels_to_integrity_status',
            api=self._api,
            param_checker=TypeChecker(param_types, enums),
            target_class=CatalogItemChannelsToIntegrityStatus,
            api_type='EDGE',
            response_parser=ObjectParser(target_class=CatalogItemChannelsToIntegrityStatus, api=self._api),
        )
        request.add_params(params)
        request.add_fields(fields)

        if batch is not None:
            request.add_to_batch(batch, success=success, failure=failure)
            return request
        elif pending:
            return request
        else:
            self.assure_call()
            return request.execute()

    def get_override_details(self, fields=None, params=None, batch=None, success=None, failure=None, pending=False):
        from facebook_business.utils import api_utils
        if batch is None and (success is not None or failure is not None):
          api_utils.warning('`success` and `failure` callback only work for batch call.')
        from facebook_business.adobjects.overridedetails import OverrideDetails
        param_types = {
            'keys': 'list<string>',
            'type': 'type_enum',
        }
        enums = {
            'type_enum': OverrideDetails.Type.__dict__.values(),
        }
        request = FacebookRequest(
            node_id=self['id'],
            method='GET',
            endpoint='/override_details',
            api=self._api,
            param_checker=TypeChecker(param_types, enums),
            target_class=OverrideDetails,
            api_type='EDGE',
            response_parser=ObjectParser(target_class=OverrideDetails, api=self._api),
        )
        request.add_params(params)
        request.add_fields(fields)

        if batch is not None:
            request.add_to_batch(batch, success=success, failure=failure)
            return request
        elif pending:
            return request
        else:
            self.assure_call()
            return request.execute()

    def get_videos_metadata(self, fields=None, params=None, batch=None, success=None, failure=None, pending=False):
        from facebook_business.utils import api_utils
        if batch is None and (success is not None or failure is not None):
          api_utils.warning('`success` and `failure` callback only work for batch call.')
        from facebook_business.adobjects.dynamicvideometadata import DynamicVideoMetadata
        param_types = {
        }
        enums = {
        }
        request = FacebookRequest(
            node_id=self['id'],
            method='GET',
            endpoint='/videos_metadata',
            api=self._api,
            param_checker=TypeChecker(param_types, enums),
            target_class=DynamicVideoMetadata,
            api_type='EDGE',
            response_parser=ObjectParser(target_class=DynamicVideoMetadata, api=self._api),
        )
        request.add_params(params)
        request.add_fields(fields)

        if batch is not None:
            request.add_to_batch(batch, success=success, failure=failure)
            return request
        elif pending:
            return request
        else:
            self.assure_call()
            return request.execute()

    _field_types = {
        'amount_currency': 'string',
        'amount_percentage': 'float',
        'amount_price': 'string',
        'amount_qualifier': 'string',
        'applinks': 'CatalogItemAppLinks',
        'availability': 'string',
        'body_style': 'string',
        'cashback_currency': 'string',
        'cashback_price': 'string',
        'category_specific_fields': 'CatalogSubVerticalList',
        'currency': 'string',
        'custom_label_0': 'string',
        'custom_label_1': 'string',
        'custom_label_2': 'string',
        'custom_label_3': 'string',
        'custom_label_4': 'string',
        'custom_number_0': 'unsigned int',
        'custom_number_1': 'unsigned int',
        'custom_number_2': 'unsigned int',
        'custom_number_3': 'unsigned int',
        'custom_number_4': 'unsigned int',
        'dma_codes': 'list<string>',
        'downpayment_currency': 'string',
        'downpayment_price': 'string',
        'downpayment_qualifier': 'string',
        'drivetrain': 'string',
        'end_date': 'string',
        'end_time': 'int',
        'exterior_color': 'string',
        'fuel_type': 'string',
        'generation': 'string',
        'id': 'string',
        'image_fetch_status': 'ImageFetchStatus',
        'images': 'list<string>',
        'interior_color': 'string',
        'interior_upholstery': 'string',
        'make': 'string',
        'model': 'string',
        'offer_description': 'string',
        'offer_disclaimer': 'string',
        'offer_type': 'string',
        'price': 'string',
        'product_priority_0': 'float',
        'product_priority_1': 'float',
        'product_priority_2': 'float',
        'product_priority_3': 'float',
        'product_priority_4': 'float',
        'sanitized_images': 'list<string>',
        'start_date': 'string',
        'start_time': 'int',
        'tags': 'list<string>',
        'term_length': 'unsigned int',
        'term_qualifier': 'string',
        'title': 'string',
        'transmission': 'string',
        'trim': 'string',
        'unit_price': 'Object',
        'url': 'string',
        'vehicle_offer_id': 'string',
        'visibility': 'Visibility',
        'year': 'int',
    }
    @classmethod
    def _get_field_enum_info(cls):
        field_enum_info = {}
        field_enum_info['ImageFetchStatus'] = VehicleOffer.ImageFetchStatus.__dict__.values()
        field_enum_info['Visibility'] = VehicleOffer.Visibility.__dict__.values()
        return field_enum_info


