# How-To Guides

**Practical, task-oriented guides for common AssertLang workflows.**

---

## Overview

How-To guides show you how to accomplish specific tasks with AssertLang. Each guide is:
- **Task-focused** - Solves a specific problem
- **Step-by-step** - Clear instructions from start to finish
- **Practical** - Real-world examples you can use immediately
- **Tested** - All code examples work and are verified

---

## Getting Started

### Basics

| Guide | Time | Difficulty | Description |
|-------|------|------------|-------------|
| [Write Your First Contract](getting-started/first-contract.md) | 10 min | Beginner | Create and validate your first PW contract |
| [Generate Code for Multiple Languages](getting-started/multi-language.md) | 15 min | Beginner | Compile contracts to Python, Go, Rust, JavaScript |
| [Test Your Contracts](getting-started/testing-contracts.md) | 20 min | Beginner | Write tests that verify contract behavior |
| [Debug Contract Violations](getting-started/debugging.md) | 15 min | Beginner | Read error messages and fix violations |

---

## Integration

### Framework Integration

| Guide | Time | Difficulty | Description |
|-------|------|------------|-------------|
| [Integrate with CrewAI](integration/crewai.md) | 30 min | Intermediate | Add contracts to CrewAI agents |
| [Integrate with LangGraph](integration/langgraph.md) | 30 min | Intermediate | Validate LangGraph state transitions |
| [Set Up MCP Server](integration/mcp-server.md) | 20 min | Intermediate | Expose AssertLang via MCP for Claude |
| [Use with Pydantic](integration/pydantic.md) | 25 min | Intermediate | Generate Pydantic models from contracts |

---

## Advanced

### Advanced Patterns

| Guide | Time | Difficulty | Description |
|-------|------|------------|-------------|
| [Build a State Machine](advanced/state-machine.md) | 45 min | Advanced | Implement validated state machines |
| [Use Pattern Matching](advanced/pattern-matching.md) | 30 min | Advanced | Match and destructure with stdlib |
| [Handle Complex Types](advanced/complex-types.md) | 40 min | Advanced | Work with Option, Result, generics |
| [Optimize Performance](advanced/performance.md) | 30 min | Advanced | Disable contracts in production |

---

## Deployment

### Production

| Guide | Time | Difficulty | Description |
|-------|------|------------|-------------|
| [Deploy to Production](deployment/production.md) | 60 min | Advanced | Production deployment checklist |
| [Set Up CI/CD](deployment/ci-cd.md) | 45 min | Advanced | Automate testing and deployment |
| [Monitor Contract Violations](deployment/monitoring.md) | 30 min | Advanced | Track violations in production |

---

## By Use Case

### Common Tasks

**For Beginners:**
1. [Write Your First Contract](getting-started/first-contract.md) - Start here
2. [Generate Python Code](getting-started/multi-language.md) - See it work
3. [Test Your Contracts](getting-started/testing-contracts.md) - Verify behavior

**For API Developers:**
1. [Integrate with CrewAI](integration/crewai.md) - Multi-agent systems
2. [Use with Pydantic](integration/pydantic.md) - Data validation
3. [Deploy to Production](deployment/production.md) - Go live

**For AI Engineers:**
1. [Set Up MCP Server](integration/mcp-server.md) - Claude integration
2. [Integrate with LangGraph](integration/langgraph.md) - State graphs
3. [Build a State Machine](advanced/state-machine.md) - Complex workflows

---

## Quick Links

- **[Quickstart](../../QUICKSTART.md)** - 5-minute getting started
- **[Cookbook](../cookbook/index.md)** - Common patterns and recipes
- **[API Reference](../reference/contract-syntax.md)** - Complete language reference
- **[Examples](../../examples/real_world/)** - Real-world implementations

---

**Status**: 🚧 In progress - Guides being added weekly

**Last Updated**: 2025-10-15
