# PW v2.1 Roadmap - Quick Reference

**Timeline**: 6 weeks (2025-10-07 to 2025-11-18)
**Goal**: Production-ready PW language
**Target Confidence**: 95% (from current 85%)

---

## Week-by-Week Plan

### Week 1: Critical Fixes 🔴
**Must-Have for Stability**

- [ ] **Type Validation** (2 days)
  - Validate return types match declarations
  - Reject type mismatches (int vs string)
  - Reject missing return types
  - Add type inference for `let` statements
  - **Tests**: 20+ type validation tests

- [ ] **Fix Whitespace Bug** (1 day)
  - Debug test timeout in `test_parser_whitespace.py`
  - Fix lexer infinite loop
  - **Tests**: All whitespace tests pass < 5s

- [ ] **Multi-line Syntax** (2 days)
  - Support multi-line function parameters
  - Support multi-line function calls
  - **Tests**: 10+ multi-line tests

**Deliverable**: Stable v2.0.1 with no critical bugs

---

### Week 2: Loops 🔄
**Core Language Feature**

- [ ] **For Loops** (2 days)
  ```pw
  for (item in items) { }
  for (i, item in enumerate(items)) { }
  for (i in range(0, 10)) { }
  ```
  - **Tests**: 15+ for loop tests

- [ ] **While Loops** (1 day)
  ```pw
  while (condition) { }
  while (true) { break; }
  ```
  - **Tests**: 10+ while loop tests

**Deliverable**: v2.0.2 with complete loop support

---

### Week 3: Collections & Classes 📦
**Data Structures**

- [ ] **Arrays** (3 days)
  ```pw
  let nums: array<int> = [1, 2, 3];
  nums[0] = 10;
  nums.push(4);
  let sum = nums.sum();
  ```
  - **Tests**: 20+ array tests

- [ ] **Maps** (2 days)
  ```pw
  let user: map<string, any> = {"name": "Alice"};
  user["age"] = 30;
  ```
  - **Tests**: 15+ map tests

**Deliverable**: v2.0.3 with collections

---

### Week 4: Classes & Real-World Testing 🏗️
**OOP & Validation**

- [ ] **Classes** (4 days)
  ```pw
  class User {
      id: string;
      constructor(id: string) { self.id = id; }
      function greet() -> string { return "Hi"; }
  }
  ```
  - **Tests**: 25+ class tests

- [ ] **3 Real Programs** (3 days)
  1. Calculator CLI tool
  2. Simple HTTP API server
  3. CSV data processor
  - All must compile & run in all 5 languages

**Deliverable**: v2.1.0b3-beta with OOP

---

### Week 5: Tooling & UX 🛠️
**Developer Experience**

- [ ] **Complete CLI Tool** (2 days)
  ```bash
  pw build file.al --lang python -o file.py
  pw run file.al
  pw compile file.al -o file.pw.json
  ```

- [ ] **Better Error Messages** (1 day)
  ```
  Error: Type mismatch
    --> calculator.pw:18:5
     |
  18 |     return "string";
     |            ^^^^^^^^ expected int, found string
  ```

- [ ] **Round-Trip Tests** (2 days)
  - PW → Python → PW (semantic equivalence)
  - All 5 languages tested
  - **Tests**: 50+ round-trip tests

**Deliverable**: v2.1.0b3-rc1 with great UX

---

### Week 6: Documentation & Launch 📚
**Polish & Release**

- [ ] **Update All Docs** (2 days)
  - README.md - Add all new features
  - PW_LANGUAGE_GUIDE.md - Complete reference
  - New guides: ARRAYS_AND_MAPS.md, CLASSES.md, LOOPS.md

- [ ] **Performance Benchmarks** (1 day)
  - 50K line file < 5s
  - 1000 classes < 10s
  - Document performance characteristics

- [ ] **Final Testing** (2 days)
  - Run all 240+ tests
  - Validate all 3 real programs
  - Security audit
  - Final bug fixes

**Deliverable**: v2.1.0b3 Production Release 🚀

---

## Success Metrics

### Current (v2.0.0-beta)
- ✅ Functions, conditionals, basic types
- ✅ 60/60 stress tests passed
- ✅ 5 target languages
- ⚠️ No loops, classes, arrays
- ⚠️ Type validation missing

### Target (v2.1.0b3)
- ✅ Type validation (100% accurate)
- ✅ Loops (for, while, break, continue)
- ✅ Classes (properties, methods, constructors)
- ✅ Arrays/Lists (literals, indexing, methods)
- ✅ Maps/Dictionaries (literals, access)
- ✅ Multi-line syntax support
- ✅ 3 real-world programs work
- ✅ Round-trip tests (90%+ pass)
- ✅ CLI tool complete
- ✅ 240+ tests passing (60 current + 180 new)
- ✅ Great error messages
- ✅ Complete documentation

---

## Test Coverage Plan

| Category | Tests | Status |
|----------|-------|--------|
| **Existing** | | |
| Stress tests | 60 | ✅ Done |
| **New Tests** | | |
| Type validation | 20 | ⏳ Week 1 |
| Multi-line syntax | 10 | ⏳ Week 1 |
| For loops | 15 | ⏳ Week 2 |
| While loops | 10 | ⏳ Week 2 |
| Arrays | 20 | ⏳ Week 3 |
| Maps | 15 | ⏳ Week 3 |
| Classes | 25 | ⏳ Week 4 |
| Round-trip | 50 | ⏳ Week 5 |
| CLI | 15 | ⏳ Week 5 |
| **Total** | **240** | **6 weeks** |

---

## Risk Mitigation

### High Risk Items
1. **Classes** - Cross-language translation complex
   - Mitigation: Start simple (no inheritance), defer advanced to v2.2
   - Fallback: Ship v2.1 without classes if needed

2. **Round-trip Testing** - May uncover semantic issues
   - Mitigation: Accept 80% accuracy initially
   - Fallback: Focus on forward translation only

3. **Whitespace Bug** - Unknown root cause
   - Mitigation: Extensive debug logging
   - Fallback: Document edge cases, add workaround

### Contingency Plans
- If Week 4 classes too complex: Skip to Week 5, defer classes to v2.2
- If round-trip fails: Document limitations, focus on forward translation
- If any week runs over: Cut scope, maintain quality over features

---

## File Structure (New Files)

```
tests/
├── test_type_validation.py      # Week 1
├── test_multiline_syntax.py     # Week 1
├── test_for_loops.py            # Week 2
├── test_while_loops.py          # Week 2
├── test_arrays.py               # Week 3
├── test_maps.py                 # Week 3
├── test_classes.py              # Week 4
├── test_roundtrip.py            # Week 5
├── test_cli.py                  # Week 5
└── benchmarks/                  # Week 6
    ├── bench_compilation.py
    └── bench_large_files.py

examples/real_world/              # Week 4
├── calculator_cli.al
├── api_server.al
└── csv_processor.al

cli/
└── main.py                      # Week 5

docs/
├── ARRAYS_AND_MAPS.md           # Week 6
├── CLASSES.md                   # Week 6
├── LOOPS.md                     # Week 6
└── CLI_REFERENCE.md             # Week 6
```

---

## Key Dependencies

### Week 1 → Week 2
Type validation must work before implementing loops (need to validate loop variables)

### Week 2 → Week 3
Loops must work for arrays (need to iterate over collections)

### Week 3 → Week 4
Arrays/maps must work for classes (class properties use collections)

### Week 4 → Week 5
Real programs must exist to test CLI tool

### Week 5 → Week 6
Round-trip tests inform documentation updates

---

## Daily Checklist (Copy for Each Day)

- [ ] Morning: Review yesterday's progress
- [ ] Write tests first (TDD)
- [ ] Implement feature
- [ ] Run tests (all must pass)
- [ ] Update CURRENT_WORK.md
- [ ] Commit with descriptive message
- [ ] Push to backup (origin)
- [ ] Evening: Update roadmap if blocked

---

## Quick Commands

```bash
# Run specific test
python3 tests/test_type_validation.py

# Run all tests
pytest tests/ -v

# Build example
python3 -c "from dsl.al_parser import parse_file; ..."

# Check progress
git log --oneline -10
cat CURRENT_WORK.md
```

---

## Launch Checklist (Week 6, Day 5)

- [ ] All 240+ tests passing
- [ ] All 3 real programs compile & run (5 languages)
- [ ] Performance benchmarks meet targets
- [ ] Documentation complete & accurate
- [ ] CHANGELOG.md updated
- [ ] Version bumped to 2.1.0b3
- [ ] Git tag: v2.1.0b3
- [ ] PR to main branch
- [ ] Merge to main
- [ ] Announce release

---

**Created**: 2025-10-07
**Updated**: 2025-10-07
**Status**: Plan approved, ready to execute
**Next Action**: Week 1, Day 1 - Create `tests/test_type_validation.py`
