# Copyright (c) 2024 Snowflake Inc.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
# http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

import pytest


def test_global(runner):
    result = runner.invoke(["-h"])

    assert result.exit_code == 0

    assert "Snowflake CLI tool for developers" in result.output


@pytest.mark.parametrize(
    "namespace, expected",
    [
        ("object", "Manages Snowflake objects"),
        ("snowpark", "Manages procedures and functions."),
        ("streamlit", " Manages a Streamlit app in Snowflake."),
    ],
)
def test_namespace(namespace, expected, runner):
    result = runner.invoke([namespace, "-h"])

    assert result.exit_code == 0

    assert expected in result.output
