import json
from pathlib import Path


def add_lint_and_type_check_task(repo_root: Path) -> None:
    vscode_dir = repo_root / ".vscode"
    vscode_dir.mkdir(parents=True, exist_ok=True)
    tasks_json_path = vscode_dir / "tasks.json"

    task_to_add = {
        "label": "lint_and_type_check",
        "type": "shell",
        "linux": {"command": "bash", "args": ["./.ai/scripts/lint_and_type_check.sh"]},
        "osx": {"command": "bash", "args": ["./.ai/scripts/lint_and_type_check.sh"]},
        "windows": {"command": "pwsh", "args": ["-File", "./.ai/scripts/lint_and_type_check.ps1"]},
        "presentation": {"reveal": "always", "panel": "new"},
        "problemMatcher": [],
    }

    if tasks_json_path.exists():
        with tasks_json_path.open("r") as f:
            tasks_config = json.load(f)
        if "tasks" not in tasks_config:
            tasks_config["tasks"] = []
        existing_labels = {task.get("label") for task in tasks_config.get("tasks", [])}
        if "lintAndTypeCheck" not in existing_labels:
            tasks_config["tasks"].append(task_to_add)
    else:
        tasks_config = {"version": "2.0.0", "tasks": [task_to_add]}

    with tasks_json_path.open("w") as f:
        json.dump(tasks_config, f, indent="\t")
