# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['AgentlessScanningAwsScanOptionsArgs', 'AgentlessScanningAwsScanOptions']

@pulumi.input_type
class AgentlessScanningAwsScanOptionsArgs:
    def __init__(__self__, *,
                 aws_account_id: pulumi.Input[_builtins.str],
                 lambda_: pulumi.Input[_builtins.bool],
                 sensitive_data: pulumi.Input[_builtins.bool],
                 vuln_containers_os: pulumi.Input[_builtins.bool],
                 vuln_host_os: pulumi.Input[_builtins.bool]):
        """
        The set of arguments for constructing a AgentlessScanningAwsScanOptions resource.
        :param pulumi.Input[_builtins.str] aws_account_id: The AWS account ID for which agentless scanning is configured. Must be a valid AWS account ID.
        :param pulumi.Input[_builtins.bool] lambda_: Indicates if scanning of Lambda functions is enabled.
        :param pulumi.Input[_builtins.bool] sensitive_data: Indicates if scanning for sensitive data is enabled.
        :param pulumi.Input[_builtins.bool] vuln_containers_os: Indicates if scanning for vulnerabilities in containers is enabled.
        :param pulumi.Input[_builtins.bool] vuln_host_os: Indicates if scanning for vulnerabilities in hosts is enabled.
        """
        pulumi.set(__self__, "aws_account_id", aws_account_id)
        pulumi.set(__self__, "lambda_", lambda_)
        pulumi.set(__self__, "sensitive_data", sensitive_data)
        pulumi.set(__self__, "vuln_containers_os", vuln_containers_os)
        pulumi.set(__self__, "vuln_host_os", vuln_host_os)

    @_builtins.property
    @pulumi.getter(name="awsAccountId")
    def aws_account_id(self) -> pulumi.Input[_builtins.str]:
        """
        The AWS account ID for which agentless scanning is configured. Must be a valid AWS account ID.
        """
        return pulumi.get(self, "aws_account_id")

    @aws_account_id.setter
    def aws_account_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "aws_account_id", value)

    @_builtins.property
    @pulumi.getter(name="lambda")
    def lambda_(self) -> pulumi.Input[_builtins.bool]:
        """
        Indicates if scanning of Lambda functions is enabled.
        """
        return pulumi.get(self, "lambda_")

    @lambda_.setter
    def lambda_(self, value: pulumi.Input[_builtins.bool]):
        pulumi.set(self, "lambda_", value)

    @_builtins.property
    @pulumi.getter(name="sensitiveData")
    def sensitive_data(self) -> pulumi.Input[_builtins.bool]:
        """
        Indicates if scanning for sensitive data is enabled.
        """
        return pulumi.get(self, "sensitive_data")

    @sensitive_data.setter
    def sensitive_data(self, value: pulumi.Input[_builtins.bool]):
        pulumi.set(self, "sensitive_data", value)

    @_builtins.property
    @pulumi.getter(name="vulnContainersOs")
    def vuln_containers_os(self) -> pulumi.Input[_builtins.bool]:
        """
        Indicates if scanning for vulnerabilities in containers is enabled.
        """
        return pulumi.get(self, "vuln_containers_os")

    @vuln_containers_os.setter
    def vuln_containers_os(self, value: pulumi.Input[_builtins.bool]):
        pulumi.set(self, "vuln_containers_os", value)

    @_builtins.property
    @pulumi.getter(name="vulnHostOs")
    def vuln_host_os(self) -> pulumi.Input[_builtins.bool]:
        """
        Indicates if scanning for vulnerabilities in hosts is enabled.
        """
        return pulumi.get(self, "vuln_host_os")

    @vuln_host_os.setter
    def vuln_host_os(self, value: pulumi.Input[_builtins.bool]):
        pulumi.set(self, "vuln_host_os", value)


@pulumi.input_type
class _AgentlessScanningAwsScanOptionsState:
    def __init__(__self__, *,
                 aws_account_id: Optional[pulumi.Input[_builtins.str]] = None,
                 lambda_: Optional[pulumi.Input[_builtins.bool]] = None,
                 sensitive_data: Optional[pulumi.Input[_builtins.bool]] = None,
                 vuln_containers_os: Optional[pulumi.Input[_builtins.bool]] = None,
                 vuln_host_os: Optional[pulumi.Input[_builtins.bool]] = None):
        """
        Input properties used for looking up and filtering AgentlessScanningAwsScanOptions resources.
        :param pulumi.Input[_builtins.str] aws_account_id: The AWS account ID for which agentless scanning is configured. Must be a valid AWS account ID.
        :param pulumi.Input[_builtins.bool] lambda_: Indicates if scanning of Lambda functions is enabled.
        :param pulumi.Input[_builtins.bool] sensitive_data: Indicates if scanning for sensitive data is enabled.
        :param pulumi.Input[_builtins.bool] vuln_containers_os: Indicates if scanning for vulnerabilities in containers is enabled.
        :param pulumi.Input[_builtins.bool] vuln_host_os: Indicates if scanning for vulnerabilities in hosts is enabled.
        """
        if aws_account_id is not None:
            pulumi.set(__self__, "aws_account_id", aws_account_id)
        if lambda_ is not None:
            pulumi.set(__self__, "lambda_", lambda_)
        if sensitive_data is not None:
            pulumi.set(__self__, "sensitive_data", sensitive_data)
        if vuln_containers_os is not None:
            pulumi.set(__self__, "vuln_containers_os", vuln_containers_os)
        if vuln_host_os is not None:
            pulumi.set(__self__, "vuln_host_os", vuln_host_os)

    @_builtins.property
    @pulumi.getter(name="awsAccountId")
    def aws_account_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The AWS account ID for which agentless scanning is configured. Must be a valid AWS account ID.
        """
        return pulumi.get(self, "aws_account_id")

    @aws_account_id.setter
    def aws_account_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "aws_account_id", value)

    @_builtins.property
    @pulumi.getter(name="lambda")
    def lambda_(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Indicates if scanning of Lambda functions is enabled.
        """
        return pulumi.get(self, "lambda_")

    @lambda_.setter
    def lambda_(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "lambda_", value)

    @_builtins.property
    @pulumi.getter(name="sensitiveData")
    def sensitive_data(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Indicates if scanning for sensitive data is enabled.
        """
        return pulumi.get(self, "sensitive_data")

    @sensitive_data.setter
    def sensitive_data(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "sensitive_data", value)

    @_builtins.property
    @pulumi.getter(name="vulnContainersOs")
    def vuln_containers_os(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Indicates if scanning for vulnerabilities in containers is enabled.
        """
        return pulumi.get(self, "vuln_containers_os")

    @vuln_containers_os.setter
    def vuln_containers_os(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "vuln_containers_os", value)

    @_builtins.property
    @pulumi.getter(name="vulnHostOs")
    def vuln_host_os(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Indicates if scanning for vulnerabilities in hosts is enabled.
        """
        return pulumi.get(self, "vuln_host_os")

    @vuln_host_os.setter
    def vuln_host_os(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "vuln_host_os", value)


@pulumi.type_token("datadog:index/agentlessScanningAwsScanOptions:AgentlessScanningAwsScanOptions")
class AgentlessScanningAwsScanOptions(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 aws_account_id: Optional[pulumi.Input[_builtins.str]] = None,
                 lambda_: Optional[pulumi.Input[_builtins.bool]] = None,
                 sensitive_data: Optional[pulumi.Input[_builtins.bool]] = None,
                 vuln_containers_os: Optional[pulumi.Input[_builtins.bool]] = None,
                 vuln_host_os: Optional[pulumi.Input[_builtins.bool]] = None,
                 __props__=None):
        """
        Provides a Datadog Agentless Scanning AWS scan options resource. This can be used to activate and configure Agentless scan options for an AWS account.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_datadog as datadog

        # Configure agentless scanning for an AWS account
        example = datadog.AgentlessScanningAwsScanOptions("example",
            aws_account_id="123456789012",
            lambda_=True,
            sensitive_data=False,
            vuln_containers_os=True,
            vuln_host_os=True)
        ```

        ## Import

        The `pulumi import` command can be used, for example:

        #!/bin/sh

        Import existing agentless scanning AWS scan options by AWS account ID

        ```sh
        $ pulumi import datadog:index/agentlessScanningAwsScanOptions:AgentlessScanningAwsScanOptions example 123456789012
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] aws_account_id: The AWS account ID for which agentless scanning is configured. Must be a valid AWS account ID.
        :param pulumi.Input[_builtins.bool] lambda_: Indicates if scanning of Lambda functions is enabled.
        :param pulumi.Input[_builtins.bool] sensitive_data: Indicates if scanning for sensitive data is enabled.
        :param pulumi.Input[_builtins.bool] vuln_containers_os: Indicates if scanning for vulnerabilities in containers is enabled.
        :param pulumi.Input[_builtins.bool] vuln_host_os: Indicates if scanning for vulnerabilities in hosts is enabled.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AgentlessScanningAwsScanOptionsArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Datadog Agentless Scanning AWS scan options resource. This can be used to activate and configure Agentless scan options for an AWS account.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_datadog as datadog

        # Configure agentless scanning for an AWS account
        example = datadog.AgentlessScanningAwsScanOptions("example",
            aws_account_id="123456789012",
            lambda_=True,
            sensitive_data=False,
            vuln_containers_os=True,
            vuln_host_os=True)
        ```

        ## Import

        The `pulumi import` command can be used, for example:

        #!/bin/sh

        Import existing agentless scanning AWS scan options by AWS account ID

        ```sh
        $ pulumi import datadog:index/agentlessScanningAwsScanOptions:AgentlessScanningAwsScanOptions example 123456789012
        ```

        :param str resource_name: The name of the resource.
        :param AgentlessScanningAwsScanOptionsArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AgentlessScanningAwsScanOptionsArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 aws_account_id: Optional[pulumi.Input[_builtins.str]] = None,
                 lambda_: Optional[pulumi.Input[_builtins.bool]] = None,
                 sensitive_data: Optional[pulumi.Input[_builtins.bool]] = None,
                 vuln_containers_os: Optional[pulumi.Input[_builtins.bool]] = None,
                 vuln_host_os: Optional[pulumi.Input[_builtins.bool]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AgentlessScanningAwsScanOptionsArgs.__new__(AgentlessScanningAwsScanOptionsArgs)

            if aws_account_id is None and not opts.urn:
                raise TypeError("Missing required property 'aws_account_id'")
            __props__.__dict__["aws_account_id"] = aws_account_id
            if lambda_ is None and not opts.urn:
                raise TypeError("Missing required property 'lambda_'")
            __props__.__dict__["lambda_"] = lambda_
            if sensitive_data is None and not opts.urn:
                raise TypeError("Missing required property 'sensitive_data'")
            __props__.__dict__["sensitive_data"] = sensitive_data
            if vuln_containers_os is None and not opts.urn:
                raise TypeError("Missing required property 'vuln_containers_os'")
            __props__.__dict__["vuln_containers_os"] = vuln_containers_os
            if vuln_host_os is None and not opts.urn:
                raise TypeError("Missing required property 'vuln_host_os'")
            __props__.__dict__["vuln_host_os"] = vuln_host_os
        super(AgentlessScanningAwsScanOptions, __self__).__init__(
            'datadog:index/agentlessScanningAwsScanOptions:AgentlessScanningAwsScanOptions',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            aws_account_id: Optional[pulumi.Input[_builtins.str]] = None,
            lambda_: Optional[pulumi.Input[_builtins.bool]] = None,
            sensitive_data: Optional[pulumi.Input[_builtins.bool]] = None,
            vuln_containers_os: Optional[pulumi.Input[_builtins.bool]] = None,
            vuln_host_os: Optional[pulumi.Input[_builtins.bool]] = None) -> 'AgentlessScanningAwsScanOptions':
        """
        Get an existing AgentlessScanningAwsScanOptions resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] aws_account_id: The AWS account ID for which agentless scanning is configured. Must be a valid AWS account ID.
        :param pulumi.Input[_builtins.bool] lambda_: Indicates if scanning of Lambda functions is enabled.
        :param pulumi.Input[_builtins.bool] sensitive_data: Indicates if scanning for sensitive data is enabled.
        :param pulumi.Input[_builtins.bool] vuln_containers_os: Indicates if scanning for vulnerabilities in containers is enabled.
        :param pulumi.Input[_builtins.bool] vuln_host_os: Indicates if scanning for vulnerabilities in hosts is enabled.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AgentlessScanningAwsScanOptionsState.__new__(_AgentlessScanningAwsScanOptionsState)

        __props__.__dict__["aws_account_id"] = aws_account_id
        __props__.__dict__["lambda_"] = lambda_
        __props__.__dict__["sensitive_data"] = sensitive_data
        __props__.__dict__["vuln_containers_os"] = vuln_containers_os
        __props__.__dict__["vuln_host_os"] = vuln_host_os
        return AgentlessScanningAwsScanOptions(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="awsAccountId")
    def aws_account_id(self) -> pulumi.Output[_builtins.str]:
        """
        The AWS account ID for which agentless scanning is configured. Must be a valid AWS account ID.
        """
        return pulumi.get(self, "aws_account_id")

    @_builtins.property
    @pulumi.getter(name="lambda")
    def lambda_(self) -> pulumi.Output[_builtins.bool]:
        """
        Indicates if scanning of Lambda functions is enabled.
        """
        return pulumi.get(self, "lambda_")

    @_builtins.property
    @pulumi.getter(name="sensitiveData")
    def sensitive_data(self) -> pulumi.Output[_builtins.bool]:
        """
        Indicates if scanning for sensitive data is enabled.
        """
        return pulumi.get(self, "sensitive_data")

    @_builtins.property
    @pulumi.getter(name="vulnContainersOs")
    def vuln_containers_os(self) -> pulumi.Output[_builtins.bool]:
        """
        Indicates if scanning for vulnerabilities in containers is enabled.
        """
        return pulumi.get(self, "vuln_containers_os")

    @_builtins.property
    @pulumi.getter(name="vulnHostOs")
    def vuln_host_os(self) -> pulumi.Output[_builtins.bool]:
        """
        Indicates if scanning for vulnerabilities in hosts is enabled.
        """
        return pulumi.get(self, "vuln_host_os")

