# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['ApmRetentionFilterOrderArgs', 'ApmRetentionFilterOrder']

@pulumi.input_type
class ApmRetentionFilterOrderArgs:
    def __init__(__self__, *,
                 filter_ids: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]):
        """
        The set of arguments for constructing a ApmRetentionFilterOrder resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] filter_ids: The filter IDs list. The order of filters IDs in this attribute defines the overall APM retention filters order.
        """
        pulumi.set(__self__, "filter_ids", filter_ids)

    @_builtins.property
    @pulumi.getter(name="filterIds")
    def filter_ids(self) -> pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]:
        """
        The filter IDs list. The order of filters IDs in this attribute defines the overall APM retention filters order.
        """
        return pulumi.get(self, "filter_ids")

    @filter_ids.setter
    def filter_ids(self, value: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]):
        pulumi.set(self, "filter_ids", value)


@pulumi.input_type
class _ApmRetentionFilterOrderState:
    def __init__(__self__, *,
                 filter_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None):
        """
        Input properties used for looking up and filtering ApmRetentionFilterOrder resources.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] filter_ids: The filter IDs list. The order of filters IDs in this attribute defines the overall APM retention filters order.
        """
        if filter_ids is not None:
            pulumi.set(__self__, "filter_ids", filter_ids)

    @_builtins.property
    @pulumi.getter(name="filterIds")
    def filter_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The filter IDs list. The order of filters IDs in this attribute defines the overall APM retention filters order.
        """
        return pulumi.get(self, "filter_ids")

    @filter_ids.setter
    def filter_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "filter_ids", value)


@pulumi.type_token("datadog:index/apmRetentionFilterOrder:ApmRetentionFilterOrder")
class ApmRetentionFilterOrder(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 filter_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        """
        Provides a Datadog [APM Retention Filters API](https://docs.datadoghq.com/api/v2/apm-retention-filters/) resource, which is used to manage Datadog APM retention filters order.

        ## Example Usage

        ## Import

        The `pulumi import` command can be used, for example:

        Import existing APM retention filter order

        Note: Value of <foo> can be anything as this id is not stored by the resource

        ```sh
        $ pulumi import datadog:index/apmRetentionFilterOrder:ApmRetentionFilterOrder bar <foo>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] filter_ids: The filter IDs list. The order of filters IDs in this attribute defines the overall APM retention filters order.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ApmRetentionFilterOrderArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Datadog [APM Retention Filters API](https://docs.datadoghq.com/api/v2/apm-retention-filters/) resource, which is used to manage Datadog APM retention filters order.

        ## Example Usage

        ## Import

        The `pulumi import` command can be used, for example:

        Import existing APM retention filter order

        Note: Value of <foo> can be anything as this id is not stored by the resource

        ```sh
        $ pulumi import datadog:index/apmRetentionFilterOrder:ApmRetentionFilterOrder bar <foo>
        ```

        :param str resource_name: The name of the resource.
        :param ApmRetentionFilterOrderArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ApmRetentionFilterOrderArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 filter_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ApmRetentionFilterOrderArgs.__new__(ApmRetentionFilterOrderArgs)

            if filter_ids is None and not opts.urn:
                raise TypeError("Missing required property 'filter_ids'")
            __props__.__dict__["filter_ids"] = filter_ids
        super(ApmRetentionFilterOrder, __self__).__init__(
            'datadog:index/apmRetentionFilterOrder:ApmRetentionFilterOrder',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            filter_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None) -> 'ApmRetentionFilterOrder':
        """
        Get an existing ApmRetentionFilterOrder resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] filter_ids: The filter IDs list. The order of filters IDs in this attribute defines the overall APM retention filters order.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ApmRetentionFilterOrderState.__new__(_ApmRetentionFilterOrderState)

        __props__.__dict__["filter_ids"] = filter_ids
        return ApmRetentionFilterOrder(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="filterIds")
    def filter_ids(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        The filter IDs list. The order of filters IDs in this attribute defines the overall APM retention filters order.
        """
        return pulumi.get(self, "filter_ids")

