# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['ApplicationKeyArgs', 'ApplicationKey']

@pulumi.input_type
class ApplicationKeyArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[_builtins.str],
                 scopes: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None):
        """
        The set of arguments for constructing a ApplicationKey resource.
        :param pulumi.Input[_builtins.str] name: Name for Application Key.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] scopes: Authorization scopes for the Application Key. Application Keys configured with no scopes have full access.
        """
        pulumi.set(__self__, "name", name)
        if scopes is not None:
            pulumi.set(__self__, "scopes", scopes)

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Input[_builtins.str]:
        """
        Name for Application Key.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def scopes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Authorization scopes for the Application Key. Application Keys configured with no scopes have full access.
        """
        return pulumi.get(self, "scopes")

    @scopes.setter
    def scopes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "scopes", value)


@pulumi.input_type
class _ApplicationKeyState:
    def __init__(__self__, *,
                 key: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 scopes: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None):
        """
        Input properties used for looking up and filtering ApplicationKey resources.
        :param pulumi.Input[_builtins.str] key: The value of the Application Key.
        :param pulumi.Input[_builtins.str] name: Name for Application Key.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] scopes: Authorization scopes for the Application Key. Application Keys configured with no scopes have full access.
        """
        if key is not None:
            pulumi.set(__self__, "key", key)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if scopes is not None:
            pulumi.set(__self__, "scopes", scopes)

    @_builtins.property
    @pulumi.getter
    def key(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The value of the Application Key.
        """
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "key", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name for Application Key.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def scopes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Authorization scopes for the Application Key. Application Keys configured with no scopes have full access.
        """
        return pulumi.get(self, "scopes")

    @scopes.setter
    def scopes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "scopes", value)


@pulumi.type_token("datadog:index/applicationKey:ApplicationKey")
class ApplicationKey(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 scopes: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        """
        Provides a Datadog Application Key resource. This can be used to create and manage Datadog Application Keys. Import functionality for this resource is deprecated and will be removed in a future release with prior notice. Securely store your application keys using a secret management system or use this resource to create and manage new application keys.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_datadog as datadog

        # Source the permissions for scoped keys
        dd_perms = datadog.get_permissions()
        # Create an unrestricted Application Key
        # This key inherits all permissions of the user that owns the key
        unrestricted_key = datadog.ApplicationKey("unrestricted_key", name="Unrestricted Application Key")
        # Create a scoped Application Key for monitor management
        monitor_management_key = datadog.ApplicationKey("monitor_management_key",
            name="Monitor Management Key",
            scopes=[
                dd_perms.permissions["monitorsRead"],
                dd_perms.permissions["monitorsWrite"],
            ])
        ```

        ## Import

        The `pulumi import` command can be used, for example:

        ```sh
        $ pulumi import datadog:index/applicationKey:ApplicationKey foo 11111111-2222-3333-4444-555555555555
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] name: Name for Application Key.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] scopes: Authorization scopes for the Application Key. Application Keys configured with no scopes have full access.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ApplicationKeyArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Datadog Application Key resource. This can be used to create and manage Datadog Application Keys. Import functionality for this resource is deprecated and will be removed in a future release with prior notice. Securely store your application keys using a secret management system or use this resource to create and manage new application keys.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_datadog as datadog

        # Source the permissions for scoped keys
        dd_perms = datadog.get_permissions()
        # Create an unrestricted Application Key
        # This key inherits all permissions of the user that owns the key
        unrestricted_key = datadog.ApplicationKey("unrestricted_key", name="Unrestricted Application Key")
        # Create a scoped Application Key for monitor management
        monitor_management_key = datadog.ApplicationKey("monitor_management_key",
            name="Monitor Management Key",
            scopes=[
                dd_perms.permissions["monitorsRead"],
                dd_perms.permissions["monitorsWrite"],
            ])
        ```

        ## Import

        The `pulumi import` command can be used, for example:

        ```sh
        $ pulumi import datadog:index/applicationKey:ApplicationKey foo 11111111-2222-3333-4444-555555555555
        ```

        :param str resource_name: The name of the resource.
        :param ApplicationKeyArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ApplicationKeyArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 scopes: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ApplicationKeyArgs.__new__(ApplicationKeyArgs)

            if name is None and not opts.urn:
                raise TypeError("Missing required property 'name'")
            __props__.__dict__["name"] = name
            __props__.__dict__["scopes"] = scopes
            __props__.__dict__["key"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["key"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(ApplicationKey, __self__).__init__(
            'datadog:index/applicationKey:ApplicationKey',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            key: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            scopes: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None) -> 'ApplicationKey':
        """
        Get an existing ApplicationKey resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] key: The value of the Application Key.
        :param pulumi.Input[_builtins.str] name: Name for Application Key.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] scopes: Authorization scopes for the Application Key. Application Keys configured with no scopes have full access.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ApplicationKeyState.__new__(_ApplicationKeyState)

        __props__.__dict__["key"] = key
        __props__.__dict__["name"] = name
        __props__.__dict__["scopes"] = scopes
        return ApplicationKey(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def key(self) -> pulumi.Output[_builtins.str]:
        """
        The value of the Application Key.
        """
        return pulumi.get(self, "key")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Name for Application Key.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def scopes(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        Authorization scopes for the Application Key. Application Keys configured with no scopes have full access.
        """
        return pulumi.get(self, "scopes")

