# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['AzureUcConfigArgs', 'AzureUcConfig']

@pulumi.input_type
class AzureUcConfigArgs:
    def __init__(__self__, *,
                 account_id: pulumi.Input[_builtins.str],
                 client_id: pulumi.Input[_builtins.str],
                 scope: pulumi.Input[_builtins.str],
                 actual_bill_config: Optional[pulumi.Input['AzureUcConfigActualBillConfigArgs']] = None,
                 amortized_bill_config: Optional[pulumi.Input['AzureUcConfigAmortizedBillConfigArgs']] = None):
        """
        The set of arguments for constructing a AzureUcConfig resource.
        :param pulumi.Input[_builtins.str] account_id: The tenant ID of the Azure account.
        :param pulumi.Input[_builtins.str] client_id: The client ID of the Azure account.
        :param pulumi.Input[_builtins.str] scope: The scope of your observed subscription.
        :param pulumi.Input['AzureUcConfigActualBillConfigArgs'] actual_bill_config: Configuration for the actual cost export.
        :param pulumi.Input['AzureUcConfigAmortizedBillConfigArgs'] amortized_bill_config: Configuration for the amortized cost export.
        """
        pulumi.set(__self__, "account_id", account_id)
        pulumi.set(__self__, "client_id", client_id)
        pulumi.set(__self__, "scope", scope)
        if actual_bill_config is not None:
            pulumi.set(__self__, "actual_bill_config", actual_bill_config)
        if amortized_bill_config is not None:
            pulumi.set(__self__, "amortized_bill_config", amortized_bill_config)

    @_builtins.property
    @pulumi.getter(name="accountId")
    def account_id(self) -> pulumi.Input[_builtins.str]:
        """
        The tenant ID of the Azure account.
        """
        return pulumi.get(self, "account_id")

    @account_id.setter
    def account_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "account_id", value)

    @_builtins.property
    @pulumi.getter(name="clientId")
    def client_id(self) -> pulumi.Input[_builtins.str]:
        """
        The client ID of the Azure account.
        """
        return pulumi.get(self, "client_id")

    @client_id.setter
    def client_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "client_id", value)

    @_builtins.property
    @pulumi.getter
    def scope(self) -> pulumi.Input[_builtins.str]:
        """
        The scope of your observed subscription.
        """
        return pulumi.get(self, "scope")

    @scope.setter
    def scope(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "scope", value)

    @_builtins.property
    @pulumi.getter(name="actualBillConfig")
    def actual_bill_config(self) -> Optional[pulumi.Input['AzureUcConfigActualBillConfigArgs']]:
        """
        Configuration for the actual cost export.
        """
        return pulumi.get(self, "actual_bill_config")

    @actual_bill_config.setter
    def actual_bill_config(self, value: Optional[pulumi.Input['AzureUcConfigActualBillConfigArgs']]):
        pulumi.set(self, "actual_bill_config", value)

    @_builtins.property
    @pulumi.getter(name="amortizedBillConfig")
    def amortized_bill_config(self) -> Optional[pulumi.Input['AzureUcConfigAmortizedBillConfigArgs']]:
        """
        Configuration for the amortized cost export.
        """
        return pulumi.get(self, "amortized_bill_config")

    @amortized_bill_config.setter
    def amortized_bill_config(self, value: Optional[pulumi.Input['AzureUcConfigAmortizedBillConfigArgs']]):
        pulumi.set(self, "amortized_bill_config", value)


@pulumi.input_type
class _AzureUcConfigState:
    def __init__(__self__, *,
                 account_id: Optional[pulumi.Input[_builtins.str]] = None,
                 actual_bill_config: Optional[pulumi.Input['AzureUcConfigActualBillConfigArgs']] = None,
                 amortized_bill_config: Optional[pulumi.Input['AzureUcConfigAmortizedBillConfigArgs']] = None,
                 client_id: Optional[pulumi.Input[_builtins.str]] = None,
                 created_at: Optional[pulumi.Input[_builtins.str]] = None,
                 error_messages: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 scope: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 status_updated_at: Optional[pulumi.Input[_builtins.str]] = None,
                 updated_at: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering AzureUcConfig resources.
        :param pulumi.Input[_builtins.str] account_id: The tenant ID of the Azure account.
        :param pulumi.Input['AzureUcConfigActualBillConfigArgs'] actual_bill_config: Configuration for the actual cost export.
        :param pulumi.Input['AzureUcConfigAmortizedBillConfigArgs'] amortized_bill_config: Configuration for the amortized cost export.
        :param pulumi.Input[_builtins.str] client_id: The client ID of the Azure account.
        :param pulumi.Input[_builtins.str] created_at: The timestamp when the Azure Usage Cost configuration was created.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] error_messages: List of error messages if the Azure Usage Cost configuration encountered any issues during setup or data processing.
        :param pulumi.Input[_builtins.str] scope: The scope of your observed subscription.
        :param pulumi.Input[_builtins.str] status: The current status of the Azure Usage Cost configuration.
        :param pulumi.Input[_builtins.str] status_updated_at: The timestamp when the configuration status was last updated.
        :param pulumi.Input[_builtins.str] updated_at: The timestamp when the Azure Usage Cost configuration was last modified.
        """
        if account_id is not None:
            pulumi.set(__self__, "account_id", account_id)
        if actual_bill_config is not None:
            pulumi.set(__self__, "actual_bill_config", actual_bill_config)
        if amortized_bill_config is not None:
            pulumi.set(__self__, "amortized_bill_config", amortized_bill_config)
        if client_id is not None:
            pulumi.set(__self__, "client_id", client_id)
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if error_messages is not None:
            pulumi.set(__self__, "error_messages", error_messages)
        if scope is not None:
            pulumi.set(__self__, "scope", scope)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if status_updated_at is not None:
            pulumi.set(__self__, "status_updated_at", status_updated_at)
        if updated_at is not None:
            pulumi.set(__self__, "updated_at", updated_at)

    @_builtins.property
    @pulumi.getter(name="accountId")
    def account_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The tenant ID of the Azure account.
        """
        return pulumi.get(self, "account_id")

    @account_id.setter
    def account_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "account_id", value)

    @_builtins.property
    @pulumi.getter(name="actualBillConfig")
    def actual_bill_config(self) -> Optional[pulumi.Input['AzureUcConfigActualBillConfigArgs']]:
        """
        Configuration for the actual cost export.
        """
        return pulumi.get(self, "actual_bill_config")

    @actual_bill_config.setter
    def actual_bill_config(self, value: Optional[pulumi.Input['AzureUcConfigActualBillConfigArgs']]):
        pulumi.set(self, "actual_bill_config", value)

    @_builtins.property
    @pulumi.getter(name="amortizedBillConfig")
    def amortized_bill_config(self) -> Optional[pulumi.Input['AzureUcConfigAmortizedBillConfigArgs']]:
        """
        Configuration for the amortized cost export.
        """
        return pulumi.get(self, "amortized_bill_config")

    @amortized_bill_config.setter
    def amortized_bill_config(self, value: Optional[pulumi.Input['AzureUcConfigAmortizedBillConfigArgs']]):
        pulumi.set(self, "amortized_bill_config", value)

    @_builtins.property
    @pulumi.getter(name="clientId")
    def client_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The client ID of the Azure account.
        """
        return pulumi.get(self, "client_id")

    @client_id.setter
    def client_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "client_id", value)

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The timestamp when the Azure Usage Cost configuration was created.
        """
        return pulumi.get(self, "created_at")

    @created_at.setter
    def created_at(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "created_at", value)

    @_builtins.property
    @pulumi.getter(name="errorMessages")
    def error_messages(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of error messages if the Azure Usage Cost configuration encountered any issues during setup or data processing.
        """
        return pulumi.get(self, "error_messages")

    @error_messages.setter
    def error_messages(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "error_messages", value)

    @_builtins.property
    @pulumi.getter
    def scope(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The scope of your observed subscription.
        """
        return pulumi.get(self, "scope")

    @scope.setter
    def scope(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "scope", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The current status of the Azure Usage Cost configuration.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter(name="statusUpdatedAt")
    def status_updated_at(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The timestamp when the configuration status was last updated.
        """
        return pulumi.get(self, "status_updated_at")

    @status_updated_at.setter
    def status_updated_at(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status_updated_at", value)

    @_builtins.property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The timestamp when the Azure Usage Cost configuration was last modified.
        """
        return pulumi.get(self, "updated_at")

    @updated_at.setter
    def updated_at(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "updated_at", value)


@pulumi.type_token("datadog:index/azureUcConfig:AzureUcConfig")
class AzureUcConfig(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_id: Optional[pulumi.Input[_builtins.str]] = None,
                 actual_bill_config: Optional[pulumi.Input[Union['AzureUcConfigActualBillConfigArgs', 'AzureUcConfigActualBillConfigArgsDict']]] = None,
                 amortized_bill_config: Optional[pulumi.Input[Union['AzureUcConfigAmortizedBillConfigArgs', 'AzureUcConfigAmortizedBillConfigArgsDict']]] = None,
                 client_id: Optional[pulumi.Input[_builtins.str]] = None,
                 scope: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Provides a Datadog Azure Usage Cost configuration resource. This can be used to create and manage Azure Cost Export configurations for Cloud Cost Management. Azure configurations require both actual and amortized cost export settings.

        ## Example Usage

        ## Import

        The `pulumi import` command can be used, for example:

        ```sh
        $ pulumi import datadog:index/azureUcConfig:AzureUcConfig example <cloud_account_id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] account_id: The tenant ID of the Azure account.
        :param pulumi.Input[Union['AzureUcConfigActualBillConfigArgs', 'AzureUcConfigActualBillConfigArgsDict']] actual_bill_config: Configuration for the actual cost export.
        :param pulumi.Input[Union['AzureUcConfigAmortizedBillConfigArgs', 'AzureUcConfigAmortizedBillConfigArgsDict']] amortized_bill_config: Configuration for the amortized cost export.
        :param pulumi.Input[_builtins.str] client_id: The client ID of the Azure account.
        :param pulumi.Input[_builtins.str] scope: The scope of your observed subscription.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AzureUcConfigArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Datadog Azure Usage Cost configuration resource. This can be used to create and manage Azure Cost Export configurations for Cloud Cost Management. Azure configurations require both actual and amortized cost export settings.

        ## Example Usage

        ## Import

        The `pulumi import` command can be used, for example:

        ```sh
        $ pulumi import datadog:index/azureUcConfig:AzureUcConfig example <cloud_account_id>
        ```

        :param str resource_name: The name of the resource.
        :param AzureUcConfigArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AzureUcConfigArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_id: Optional[pulumi.Input[_builtins.str]] = None,
                 actual_bill_config: Optional[pulumi.Input[Union['AzureUcConfigActualBillConfigArgs', 'AzureUcConfigActualBillConfigArgsDict']]] = None,
                 amortized_bill_config: Optional[pulumi.Input[Union['AzureUcConfigAmortizedBillConfigArgs', 'AzureUcConfigAmortizedBillConfigArgsDict']]] = None,
                 client_id: Optional[pulumi.Input[_builtins.str]] = None,
                 scope: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AzureUcConfigArgs.__new__(AzureUcConfigArgs)

            if account_id is None and not opts.urn:
                raise TypeError("Missing required property 'account_id'")
            __props__.__dict__["account_id"] = account_id
            __props__.__dict__["actual_bill_config"] = actual_bill_config
            __props__.__dict__["amortized_bill_config"] = amortized_bill_config
            if client_id is None and not opts.urn:
                raise TypeError("Missing required property 'client_id'")
            __props__.__dict__["client_id"] = client_id
            if scope is None and not opts.urn:
                raise TypeError("Missing required property 'scope'")
            __props__.__dict__["scope"] = scope
            __props__.__dict__["created_at"] = None
            __props__.__dict__["error_messages"] = None
            __props__.__dict__["status"] = None
            __props__.__dict__["status_updated_at"] = None
            __props__.__dict__["updated_at"] = None
        super(AzureUcConfig, __self__).__init__(
            'datadog:index/azureUcConfig:AzureUcConfig',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            account_id: Optional[pulumi.Input[_builtins.str]] = None,
            actual_bill_config: Optional[pulumi.Input[Union['AzureUcConfigActualBillConfigArgs', 'AzureUcConfigActualBillConfigArgsDict']]] = None,
            amortized_bill_config: Optional[pulumi.Input[Union['AzureUcConfigAmortizedBillConfigArgs', 'AzureUcConfigAmortizedBillConfigArgsDict']]] = None,
            client_id: Optional[pulumi.Input[_builtins.str]] = None,
            created_at: Optional[pulumi.Input[_builtins.str]] = None,
            error_messages: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            scope: Optional[pulumi.Input[_builtins.str]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None,
            status_updated_at: Optional[pulumi.Input[_builtins.str]] = None,
            updated_at: Optional[pulumi.Input[_builtins.str]] = None) -> 'AzureUcConfig':
        """
        Get an existing AzureUcConfig resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] account_id: The tenant ID of the Azure account.
        :param pulumi.Input[Union['AzureUcConfigActualBillConfigArgs', 'AzureUcConfigActualBillConfigArgsDict']] actual_bill_config: Configuration for the actual cost export.
        :param pulumi.Input[Union['AzureUcConfigAmortizedBillConfigArgs', 'AzureUcConfigAmortizedBillConfigArgsDict']] amortized_bill_config: Configuration for the amortized cost export.
        :param pulumi.Input[_builtins.str] client_id: The client ID of the Azure account.
        :param pulumi.Input[_builtins.str] created_at: The timestamp when the Azure Usage Cost configuration was created.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] error_messages: List of error messages if the Azure Usage Cost configuration encountered any issues during setup or data processing.
        :param pulumi.Input[_builtins.str] scope: The scope of your observed subscription.
        :param pulumi.Input[_builtins.str] status: The current status of the Azure Usage Cost configuration.
        :param pulumi.Input[_builtins.str] status_updated_at: The timestamp when the configuration status was last updated.
        :param pulumi.Input[_builtins.str] updated_at: The timestamp when the Azure Usage Cost configuration was last modified.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AzureUcConfigState.__new__(_AzureUcConfigState)

        __props__.__dict__["account_id"] = account_id
        __props__.__dict__["actual_bill_config"] = actual_bill_config
        __props__.__dict__["amortized_bill_config"] = amortized_bill_config
        __props__.__dict__["client_id"] = client_id
        __props__.__dict__["created_at"] = created_at
        __props__.__dict__["error_messages"] = error_messages
        __props__.__dict__["scope"] = scope
        __props__.__dict__["status"] = status
        __props__.__dict__["status_updated_at"] = status_updated_at
        __props__.__dict__["updated_at"] = updated_at
        return AzureUcConfig(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="accountId")
    def account_id(self) -> pulumi.Output[_builtins.str]:
        """
        The tenant ID of the Azure account.
        """
        return pulumi.get(self, "account_id")

    @_builtins.property
    @pulumi.getter(name="actualBillConfig")
    def actual_bill_config(self) -> pulumi.Output[Optional['outputs.AzureUcConfigActualBillConfig']]:
        """
        Configuration for the actual cost export.
        """
        return pulumi.get(self, "actual_bill_config")

    @_builtins.property
    @pulumi.getter(name="amortizedBillConfig")
    def amortized_bill_config(self) -> pulumi.Output[Optional['outputs.AzureUcConfigAmortizedBillConfig']]:
        """
        Configuration for the amortized cost export.
        """
        return pulumi.get(self, "amortized_bill_config")

    @_builtins.property
    @pulumi.getter(name="clientId")
    def client_id(self) -> pulumi.Output[_builtins.str]:
        """
        The client ID of the Azure account.
        """
        return pulumi.get(self, "client_id")

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> pulumi.Output[_builtins.str]:
        """
        The timestamp when the Azure Usage Cost configuration was created.
        """
        return pulumi.get(self, "created_at")

    @_builtins.property
    @pulumi.getter(name="errorMessages")
    def error_messages(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        List of error messages if the Azure Usage Cost configuration encountered any issues during setup or data processing.
        """
        return pulumi.get(self, "error_messages")

    @_builtins.property
    @pulumi.getter
    def scope(self) -> pulumi.Output[_builtins.str]:
        """
        The scope of your observed subscription.
        """
        return pulumi.get(self, "scope")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.str]:
        """
        The current status of the Azure Usage Cost configuration.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter(name="statusUpdatedAt")
    def status_updated_at(self) -> pulumi.Output[_builtins.str]:
        """
        The timestamp when the configuration status was last updated.
        """
        return pulumi.get(self, "status_updated_at")

    @_builtins.property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> pulumi.Output[_builtins.str]:
        """
        The timestamp when the Azure Usage Cost configuration was last modified.
        """
        return pulumi.get(self, "updated_at")

