# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['CloudWorkloadSecurityAgentRuleArgs', 'CloudWorkloadSecurityAgentRule']

@pulumi.input_type
class CloudWorkloadSecurityAgentRuleArgs:
    def __init__(__self__, *,
                 expression: pulumi.Input[_builtins.str],
                 name: pulumi.Input[_builtins.str],
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None):
        """
        The set of arguments for constructing a CloudWorkloadSecurityAgentRule resource.
        :param pulumi.Input[_builtins.str] expression: The SECL expression of the Agent rule.
        :param pulumi.Input[_builtins.str] name: The name of the Agent rule.
        :param pulumi.Input[_builtins.str] description: The description of the Agent rule. Defaults to `""`.
        :param pulumi.Input[_builtins.bool] enabled: Whether the Agent rule is enabled. Defaults to `true`.
        """
        pulumi.set(__self__, "expression", expression)
        pulumi.set(__self__, "name", name)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)

    @_builtins.property
    @pulumi.getter
    def expression(self) -> pulumi.Input[_builtins.str]:
        """
        The SECL expression of the Agent rule.
        """
        return pulumi.get(self, "expression")

    @expression.setter
    def expression(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "expression", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the Agent rule.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The description of the Agent rule. Defaults to `""`.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether the Agent rule is enabled. Defaults to `true`.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enabled", value)


@pulumi.input_type
class _CloudWorkloadSecurityAgentRuleState:
    def __init__(__self__, *,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 expression: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering CloudWorkloadSecurityAgentRule resources.
        :param pulumi.Input[_builtins.str] description: The description of the Agent rule. Defaults to `""`.
        :param pulumi.Input[_builtins.bool] enabled: Whether the Agent rule is enabled. Defaults to `true`.
        :param pulumi.Input[_builtins.str] expression: The SECL expression of the Agent rule.
        :param pulumi.Input[_builtins.str] name: The name of the Agent rule.
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if expression is not None:
            pulumi.set(__self__, "expression", expression)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The description of the Agent rule. Defaults to `""`.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether the Agent rule is enabled. Defaults to `true`.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enabled", value)

    @_builtins.property
    @pulumi.getter
    def expression(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The SECL expression of the Agent rule.
        """
        return pulumi.get(self, "expression")

    @expression.setter
    def expression(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "expression", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the Agent rule.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)


@pulumi.type_token("datadog:index/cloudWorkloadSecurityAgentRule:CloudWorkloadSecurityAgentRule")
class CloudWorkloadSecurityAgentRule(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 expression: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_datadog as datadog

        my_agent_rule = datadog.CloudWorkloadSecurityAgentRule("my_agent_rule",
            name="my_agent_rule",
            description="My agent rule",
            enabled=True,
            expression="exec.file.name == \\"java\\"")
        ```

        ## Import

        The `pulumi import` command can be used, for example:

        Cloud Workload Security Agent rules can be imported using ID, e.g.

        ```sh
        $ pulumi import datadog:index/cloudWorkloadSecurityAgentRule:CloudWorkloadSecurityAgentRule my_agent_rule m0o-hto-lkb
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] description: The description of the Agent rule. Defaults to `""`.
        :param pulumi.Input[_builtins.bool] enabled: Whether the Agent rule is enabled. Defaults to `true`.
        :param pulumi.Input[_builtins.str] expression: The SECL expression of the Agent rule.
        :param pulumi.Input[_builtins.str] name: The name of the Agent rule.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: CloudWorkloadSecurityAgentRuleArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_datadog as datadog

        my_agent_rule = datadog.CloudWorkloadSecurityAgentRule("my_agent_rule",
            name="my_agent_rule",
            description="My agent rule",
            enabled=True,
            expression="exec.file.name == \\"java\\"")
        ```

        ## Import

        The `pulumi import` command can be used, for example:

        Cloud Workload Security Agent rules can be imported using ID, e.g.

        ```sh
        $ pulumi import datadog:index/cloudWorkloadSecurityAgentRule:CloudWorkloadSecurityAgentRule my_agent_rule m0o-hto-lkb
        ```

        :param str resource_name: The name of the resource.
        :param CloudWorkloadSecurityAgentRuleArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(CloudWorkloadSecurityAgentRuleArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 expression: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = CloudWorkloadSecurityAgentRuleArgs.__new__(CloudWorkloadSecurityAgentRuleArgs)

            __props__.__dict__["description"] = description
            __props__.__dict__["enabled"] = enabled
            if expression is None and not opts.urn:
                raise TypeError("Missing required property 'expression'")
            __props__.__dict__["expression"] = expression
            if name is None and not opts.urn:
                raise TypeError("Missing required property 'name'")
            __props__.__dict__["name"] = name
        super(CloudWorkloadSecurityAgentRule, __self__).__init__(
            'datadog:index/cloudWorkloadSecurityAgentRule:CloudWorkloadSecurityAgentRule',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            expression: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None) -> 'CloudWorkloadSecurityAgentRule':
        """
        Get an existing CloudWorkloadSecurityAgentRule resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] description: The description of the Agent rule. Defaults to `""`.
        :param pulumi.Input[_builtins.bool] enabled: Whether the Agent rule is enabled. Defaults to `true`.
        :param pulumi.Input[_builtins.str] expression: The SECL expression of the Agent rule.
        :param pulumi.Input[_builtins.str] name: The name of the Agent rule.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _CloudWorkloadSecurityAgentRuleState.__new__(_CloudWorkloadSecurityAgentRuleState)

        __props__.__dict__["description"] = description
        __props__.__dict__["enabled"] = enabled
        __props__.__dict__["expression"] = expression
        __props__.__dict__["name"] = name
        return CloudWorkloadSecurityAgentRule(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The description of the Agent rule. Defaults to `""`.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Whether the Agent rule is enabled. Defaults to `true`.
        """
        return pulumi.get(self, "enabled")

    @_builtins.property
    @pulumi.getter
    def expression(self) -> pulumi.Output[_builtins.str]:
        """
        The SECL expression of the Agent rule.
        """
        return pulumi.get(self, "expression")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the Agent rule.
        """
        return pulumi.get(self, "name")

