# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['CustomAllocationRuleArgs', 'CustomAllocationRule']

@pulumi.input_type
class CustomAllocationRuleArgs:
    def __init__(__self__, *,
                 enabled: pulumi.Input[_builtins.bool],
                 providernames: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]],
                 rule_name: pulumi.Input[_builtins.str],
                 costs_to_allocates: Optional[pulumi.Input[Sequence[pulumi.Input['CustomAllocationRuleCostsToAllocateArgs']]]] = None,
                 strategy: Optional[pulumi.Input['CustomAllocationRuleStrategyArgs']] = None):
        """
        The set of arguments for constructing a CustomAllocationRule resource.
        :param pulumi.Input[_builtins.bool] enabled: Whether the custom allocation rule is enabled.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] providernames: List of cloud providers the rule applies to. Valid values include `aws`, `azure`, and `gcp`.
        :param pulumi.Input[_builtins.str] rule_name: The name of the custom allocation rule. This field is immutable - changing it will force replacement of the resource.
        """
        pulumi.set(__self__, "enabled", enabled)
        pulumi.set(__self__, "providernames", providernames)
        pulumi.set(__self__, "rule_name", rule_name)
        if costs_to_allocates is not None:
            pulumi.set(__self__, "costs_to_allocates", costs_to_allocates)
        if strategy is not None:
            pulumi.set(__self__, "strategy", strategy)

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> pulumi.Input[_builtins.bool]:
        """
        Whether the custom allocation rule is enabled.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: pulumi.Input[_builtins.bool]):
        pulumi.set(self, "enabled", value)

    @_builtins.property
    @pulumi.getter
    def providernames(self) -> pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]:
        """
        List of cloud providers the rule applies to. Valid values include `aws`, `azure`, and `gcp`.
        """
        return pulumi.get(self, "providernames")

    @providernames.setter
    def providernames(self, value: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]):
        pulumi.set(self, "providernames", value)

    @_builtins.property
    @pulumi.getter(name="ruleName")
    def rule_name(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the custom allocation rule. This field is immutable - changing it will force replacement of the resource.
        """
        return pulumi.get(self, "rule_name")

    @rule_name.setter
    def rule_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "rule_name", value)

    @_builtins.property
    @pulumi.getter(name="costsToAllocates")
    def costs_to_allocates(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CustomAllocationRuleCostsToAllocateArgs']]]]:
        return pulumi.get(self, "costs_to_allocates")

    @costs_to_allocates.setter
    def costs_to_allocates(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CustomAllocationRuleCostsToAllocateArgs']]]]):
        pulumi.set(self, "costs_to_allocates", value)

    @_builtins.property
    @pulumi.getter
    def strategy(self) -> Optional[pulumi.Input['CustomAllocationRuleStrategyArgs']]:
        return pulumi.get(self, "strategy")

    @strategy.setter
    def strategy(self, value: Optional[pulumi.Input['CustomAllocationRuleStrategyArgs']]):
        pulumi.set(self, "strategy", value)


@pulumi.input_type
class _CustomAllocationRuleState:
    def __init__(__self__, *,
                 costs_to_allocates: Optional[pulumi.Input[Sequence[pulumi.Input['CustomAllocationRuleCostsToAllocateArgs']]]] = None,
                 created: Optional[pulumi.Input[_builtins.str]] = None,
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 last_modified_user_uuid: Optional[pulumi.Input[_builtins.str]] = None,
                 order_id: Optional[pulumi.Input[_builtins.int]] = None,
                 providernames: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 rejected: Optional[pulumi.Input[_builtins.bool]] = None,
                 rule_name: Optional[pulumi.Input[_builtins.str]] = None,
                 strategy: Optional[pulumi.Input['CustomAllocationRuleStrategyArgs']] = None,
                 updated: Optional[pulumi.Input[_builtins.str]] = None,
                 version: Optional[pulumi.Input[_builtins.int]] = None):
        """
        Input properties used for looking up and filtering CustomAllocationRule resources.
        :param pulumi.Input[_builtins.str] created: The timestamp (in ISO 8601 format) when the rule was created.
        :param pulumi.Input[_builtins.bool] enabled: Whether the custom allocation rule is enabled.
        :param pulumi.Input[_builtins.str] last_modified_user_uuid: The UUID of the user who last modified the rule.
        :param pulumi.Input[_builtins.int] order_id: The order of the rule in the list of custom allocation rules. This field is read-only. Use the `CustomAllocationRules` resource to manage rule order.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] providernames: List of cloud providers the rule applies to. Valid values include `aws`, `azure`, and `gcp`.
        :param pulumi.Input[_builtins.bool] rejected: Whether the rule was rejected by the API during creation due to validation errors. This field is read-only.
        :param pulumi.Input[_builtins.str] rule_name: The name of the custom allocation rule. This field is immutable - changing it will force replacement of the resource.
        :param pulumi.Input[_builtins.str] updated: The timestamp (in ISO 8601 format) when the rule was last updated.
        :param pulumi.Input[_builtins.int] version: The version number of the rule. This increments each time the rule is updated.
        """
        if costs_to_allocates is not None:
            pulumi.set(__self__, "costs_to_allocates", costs_to_allocates)
        if created is not None:
            pulumi.set(__self__, "created", created)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if last_modified_user_uuid is not None:
            pulumi.set(__self__, "last_modified_user_uuid", last_modified_user_uuid)
        if order_id is not None:
            pulumi.set(__self__, "order_id", order_id)
        if providernames is not None:
            pulumi.set(__self__, "providernames", providernames)
        if rejected is not None:
            pulumi.set(__self__, "rejected", rejected)
        if rule_name is not None:
            pulumi.set(__self__, "rule_name", rule_name)
        if strategy is not None:
            pulumi.set(__self__, "strategy", strategy)
        if updated is not None:
            pulumi.set(__self__, "updated", updated)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @_builtins.property
    @pulumi.getter(name="costsToAllocates")
    def costs_to_allocates(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CustomAllocationRuleCostsToAllocateArgs']]]]:
        return pulumi.get(self, "costs_to_allocates")

    @costs_to_allocates.setter
    def costs_to_allocates(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CustomAllocationRuleCostsToAllocateArgs']]]]):
        pulumi.set(self, "costs_to_allocates", value)

    @_builtins.property
    @pulumi.getter
    def created(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The timestamp (in ISO 8601 format) when the rule was created.
        """
        return pulumi.get(self, "created")

    @created.setter
    def created(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "created", value)

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether the custom allocation rule is enabled.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enabled", value)

    @_builtins.property
    @pulumi.getter(name="lastModifiedUserUuid")
    def last_modified_user_uuid(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The UUID of the user who last modified the rule.
        """
        return pulumi.get(self, "last_modified_user_uuid")

    @last_modified_user_uuid.setter
    def last_modified_user_uuid(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "last_modified_user_uuid", value)

    @_builtins.property
    @pulumi.getter(name="orderId")
    def order_id(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The order of the rule in the list of custom allocation rules. This field is read-only. Use the `CustomAllocationRules` resource to manage rule order.
        """
        return pulumi.get(self, "order_id")

    @order_id.setter
    def order_id(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "order_id", value)

    @_builtins.property
    @pulumi.getter
    def providernames(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of cloud providers the rule applies to. Valid values include `aws`, `azure`, and `gcp`.
        """
        return pulumi.get(self, "providernames")

    @providernames.setter
    def providernames(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "providernames", value)

    @_builtins.property
    @pulumi.getter
    def rejected(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether the rule was rejected by the API during creation due to validation errors. This field is read-only.
        """
        return pulumi.get(self, "rejected")

    @rejected.setter
    def rejected(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "rejected", value)

    @_builtins.property
    @pulumi.getter(name="ruleName")
    def rule_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the custom allocation rule. This field is immutable - changing it will force replacement of the resource.
        """
        return pulumi.get(self, "rule_name")

    @rule_name.setter
    def rule_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "rule_name", value)

    @_builtins.property
    @pulumi.getter
    def strategy(self) -> Optional[pulumi.Input['CustomAllocationRuleStrategyArgs']]:
        return pulumi.get(self, "strategy")

    @strategy.setter
    def strategy(self, value: Optional[pulumi.Input['CustomAllocationRuleStrategyArgs']]):
        pulumi.set(self, "strategy", value)

    @_builtins.property
    @pulumi.getter
    def updated(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The timestamp (in ISO 8601 format) when the rule was last updated.
        """
        return pulumi.get(self, "updated")

    @updated.setter
    def updated(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "updated", value)

    @_builtins.property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The version number of the rule. This increments each time the rule is updated.
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "version", value)


@pulumi.type_token("datadog:index/customAllocationRule:CustomAllocationRule")
class CustomAllocationRule(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 costs_to_allocates: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CustomAllocationRuleCostsToAllocateArgs', 'CustomAllocationRuleCostsToAllocateArgsDict']]]]] = None,
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 providernames: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 rule_name: Optional[pulumi.Input[_builtins.str]] = None,
                 strategy: Optional[pulumi.Input[Union['CustomAllocationRuleStrategyArgs', 'CustomAllocationRuleStrategyArgsDict']]] = None,
                 __props__=None):
        """
        Provides a Datadog Custom Allocation Rule resource. Custom allocation rules allow you to allocate cloud costs based on tags and filters.

        ## Example Usage

        ## Import

        The `pulumi import` command can be used, for example:

        ```sh
        $ pulumi import datadog:index/customAllocationRule:CustomAllocationRule new_list <rule_id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] enabled: Whether the custom allocation rule is enabled.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] providernames: List of cloud providers the rule applies to. Valid values include `aws`, `azure`, and `gcp`.
        :param pulumi.Input[_builtins.str] rule_name: The name of the custom allocation rule. This field is immutable - changing it will force replacement of the resource.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: CustomAllocationRuleArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Datadog Custom Allocation Rule resource. Custom allocation rules allow you to allocate cloud costs based on tags and filters.

        ## Example Usage

        ## Import

        The `pulumi import` command can be used, for example:

        ```sh
        $ pulumi import datadog:index/customAllocationRule:CustomAllocationRule new_list <rule_id>
        ```

        :param str resource_name: The name of the resource.
        :param CustomAllocationRuleArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(CustomAllocationRuleArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 costs_to_allocates: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CustomAllocationRuleCostsToAllocateArgs', 'CustomAllocationRuleCostsToAllocateArgsDict']]]]] = None,
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 providernames: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 rule_name: Optional[pulumi.Input[_builtins.str]] = None,
                 strategy: Optional[pulumi.Input[Union['CustomAllocationRuleStrategyArgs', 'CustomAllocationRuleStrategyArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = CustomAllocationRuleArgs.__new__(CustomAllocationRuleArgs)

            __props__.__dict__["costs_to_allocates"] = costs_to_allocates
            if enabled is None and not opts.urn:
                raise TypeError("Missing required property 'enabled'")
            __props__.__dict__["enabled"] = enabled
            if providernames is None and not opts.urn:
                raise TypeError("Missing required property 'providernames'")
            __props__.__dict__["providernames"] = providernames
            if rule_name is None and not opts.urn:
                raise TypeError("Missing required property 'rule_name'")
            __props__.__dict__["rule_name"] = rule_name
            __props__.__dict__["strategy"] = strategy
            __props__.__dict__["created"] = None
            __props__.__dict__["last_modified_user_uuid"] = None
            __props__.__dict__["order_id"] = None
            __props__.__dict__["rejected"] = None
            __props__.__dict__["updated"] = None
            __props__.__dict__["version"] = None
        super(CustomAllocationRule, __self__).__init__(
            'datadog:index/customAllocationRule:CustomAllocationRule',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            costs_to_allocates: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CustomAllocationRuleCostsToAllocateArgs', 'CustomAllocationRuleCostsToAllocateArgsDict']]]]] = None,
            created: Optional[pulumi.Input[_builtins.str]] = None,
            enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            last_modified_user_uuid: Optional[pulumi.Input[_builtins.str]] = None,
            order_id: Optional[pulumi.Input[_builtins.int]] = None,
            providernames: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            rejected: Optional[pulumi.Input[_builtins.bool]] = None,
            rule_name: Optional[pulumi.Input[_builtins.str]] = None,
            strategy: Optional[pulumi.Input[Union['CustomAllocationRuleStrategyArgs', 'CustomAllocationRuleStrategyArgsDict']]] = None,
            updated: Optional[pulumi.Input[_builtins.str]] = None,
            version: Optional[pulumi.Input[_builtins.int]] = None) -> 'CustomAllocationRule':
        """
        Get an existing CustomAllocationRule resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] created: The timestamp (in ISO 8601 format) when the rule was created.
        :param pulumi.Input[_builtins.bool] enabled: Whether the custom allocation rule is enabled.
        :param pulumi.Input[_builtins.str] last_modified_user_uuid: The UUID of the user who last modified the rule.
        :param pulumi.Input[_builtins.int] order_id: The order of the rule in the list of custom allocation rules. This field is read-only. Use the `CustomAllocationRules` resource to manage rule order.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] providernames: List of cloud providers the rule applies to. Valid values include `aws`, `azure`, and `gcp`.
        :param pulumi.Input[_builtins.bool] rejected: Whether the rule was rejected by the API during creation due to validation errors. This field is read-only.
        :param pulumi.Input[_builtins.str] rule_name: The name of the custom allocation rule. This field is immutable - changing it will force replacement of the resource.
        :param pulumi.Input[_builtins.str] updated: The timestamp (in ISO 8601 format) when the rule was last updated.
        :param pulumi.Input[_builtins.int] version: The version number of the rule. This increments each time the rule is updated.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _CustomAllocationRuleState.__new__(_CustomAllocationRuleState)

        __props__.__dict__["costs_to_allocates"] = costs_to_allocates
        __props__.__dict__["created"] = created
        __props__.__dict__["enabled"] = enabled
        __props__.__dict__["last_modified_user_uuid"] = last_modified_user_uuid
        __props__.__dict__["order_id"] = order_id
        __props__.__dict__["providernames"] = providernames
        __props__.__dict__["rejected"] = rejected
        __props__.__dict__["rule_name"] = rule_name
        __props__.__dict__["strategy"] = strategy
        __props__.__dict__["updated"] = updated
        __props__.__dict__["version"] = version
        return CustomAllocationRule(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="costsToAllocates")
    def costs_to_allocates(self) -> pulumi.Output[Optional[Sequence['outputs.CustomAllocationRuleCostsToAllocate']]]:
        return pulumi.get(self, "costs_to_allocates")

    @_builtins.property
    @pulumi.getter
    def created(self) -> pulumi.Output[_builtins.str]:
        """
        The timestamp (in ISO 8601 format) when the rule was created.
        """
        return pulumi.get(self, "created")

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> pulumi.Output[_builtins.bool]:
        """
        Whether the custom allocation rule is enabled.
        """
        return pulumi.get(self, "enabled")

    @_builtins.property
    @pulumi.getter(name="lastModifiedUserUuid")
    def last_modified_user_uuid(self) -> pulumi.Output[_builtins.str]:
        """
        The UUID of the user who last modified the rule.
        """
        return pulumi.get(self, "last_modified_user_uuid")

    @_builtins.property
    @pulumi.getter(name="orderId")
    def order_id(self) -> pulumi.Output[_builtins.int]:
        """
        The order of the rule in the list of custom allocation rules. This field is read-only. Use the `CustomAllocationRules` resource to manage rule order.
        """
        return pulumi.get(self, "order_id")

    @_builtins.property
    @pulumi.getter
    def providernames(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        List of cloud providers the rule applies to. Valid values include `aws`, `azure`, and `gcp`.
        """
        return pulumi.get(self, "providernames")

    @_builtins.property
    @pulumi.getter
    def rejected(self) -> pulumi.Output[_builtins.bool]:
        """
        Whether the rule was rejected by the API during creation due to validation errors. This field is read-only.
        """
        return pulumi.get(self, "rejected")

    @_builtins.property
    @pulumi.getter(name="ruleName")
    def rule_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the custom allocation rule. This field is immutable - changing it will force replacement of the resource.
        """
        return pulumi.get(self, "rule_name")

    @_builtins.property
    @pulumi.getter
    def strategy(self) -> pulumi.Output[Optional['outputs.CustomAllocationRuleStrategy']]:
        return pulumi.get(self, "strategy")

    @_builtins.property
    @pulumi.getter
    def updated(self) -> pulumi.Output[_builtins.str]:
        """
        The timestamp (in ISO 8601 format) when the rule was last updated.
        """
        return pulumi.get(self, "updated")

    @_builtins.property
    @pulumi.getter
    def version(self) -> pulumi.Output[_builtins.int]:
        """
        The version number of the rule. This increments each time the rule is updated.
        """
        return pulumi.get(self, "version")

