# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['DatasetArgs', 'Dataset']

@pulumi.input_type
class DatasetArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[_builtins.str],
                 principals: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]],
                 product_filters: Optional[pulumi.Input[Sequence[pulumi.Input['DatasetProductFilterArgs']]]] = None):
        """
        The set of arguments for constructing a Dataset resource.
        :param pulumi.Input[_builtins.str] name: The name of the dataset.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] principals: An array of principals. A principal is a subject or group of subjects. Each principal is formatted as `type:id`. Supported types: `role` and `team`.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "principals", principals)
        if product_filters is not None:
            pulumi.set(__self__, "product_filters", product_filters)

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the dataset.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def principals(self) -> pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]:
        """
        An array of principals. A principal is a subject or group of subjects. Each principal is formatted as `type:id`. Supported types: `role` and `team`.
        """
        return pulumi.get(self, "principals")

    @principals.setter
    def principals(self, value: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]):
        pulumi.set(self, "principals", value)

    @_builtins.property
    @pulumi.getter(name="productFilters")
    def product_filters(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DatasetProductFilterArgs']]]]:
        return pulumi.get(self, "product_filters")

    @product_filters.setter
    def product_filters(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DatasetProductFilterArgs']]]]):
        pulumi.set(self, "product_filters", value)


@pulumi.input_type
class _DatasetState:
    def __init__(__self__, *,
                 created_at: Optional[pulumi.Input[_builtins.str]] = None,
                 created_by: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 principals: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 product_filters: Optional[pulumi.Input[Sequence[pulumi.Input['DatasetProductFilterArgs']]]] = None):
        """
        Input properties used for looking up and filtering Dataset resources.
        :param pulumi.Input[_builtins.str] created_at: Indicates when the dataset was created (in ISO 8601).
        :param pulumi.Input[_builtins.str] created_by: Indicates who created the dataset.
        :param pulumi.Input[_builtins.str] name: The name of the dataset.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] principals: An array of principals. A principal is a subject or group of subjects. Each principal is formatted as `type:id`. Supported types: `role` and `team`.
        """
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if created_by is not None:
            pulumi.set(__self__, "created_by", created_by)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if principals is not None:
            pulumi.set(__self__, "principals", principals)
        if product_filters is not None:
            pulumi.set(__self__, "product_filters", product_filters)

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Indicates when the dataset was created (in ISO 8601).
        """
        return pulumi.get(self, "created_at")

    @created_at.setter
    def created_at(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "created_at", value)

    @_builtins.property
    @pulumi.getter(name="createdBy")
    def created_by(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Indicates who created the dataset.
        """
        return pulumi.get(self, "created_by")

    @created_by.setter
    def created_by(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "created_by", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the dataset.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def principals(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        An array of principals. A principal is a subject or group of subjects. Each principal is formatted as `type:id`. Supported types: `role` and `team`.
        """
        return pulumi.get(self, "principals")

    @principals.setter
    def principals(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "principals", value)

    @_builtins.property
    @pulumi.getter(name="productFilters")
    def product_filters(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DatasetProductFilterArgs']]]]:
        return pulumi.get(self, "product_filters")

    @product_filters.setter
    def product_filters(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DatasetProductFilterArgs']]]]):
        pulumi.set(self, "product_filters", value)


@pulumi.type_token("datadog:index/dataset:Dataset")
class Dataset(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 principals: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 product_filters: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DatasetProductFilterArgs', 'DatasetProductFilterArgsDict']]]]] = None,
                 __props__=None):
        """
        Provides a Datadog Dataset resource. This can be used to create and manage Datadog datasets.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_datadog as datadog

        # Create new dataset resource
        foo = datadog.Dataset("foo",
            name="HR Dataset",
            principals=["role:00000000-0000-1111-0000-000000000000"],
            product_filters=[{
                "product": "rum",
                "filters": ["@application.id:123"],
            }])
        ```

        ## Import

        The `pulumi import` command can be used, for example:

        ```sh
        $ pulumi import datadog:index/dataset:Dataset foo "<dataset_id>"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] name: The name of the dataset.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] principals: An array of principals. A principal is a subject or group of subjects. Each principal is formatted as `type:id`. Supported types: `role` and `team`.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: DatasetArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Datadog Dataset resource. This can be used to create and manage Datadog datasets.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_datadog as datadog

        # Create new dataset resource
        foo = datadog.Dataset("foo",
            name="HR Dataset",
            principals=["role:00000000-0000-1111-0000-000000000000"],
            product_filters=[{
                "product": "rum",
                "filters": ["@application.id:123"],
            }])
        ```

        ## Import

        The `pulumi import` command can be used, for example:

        ```sh
        $ pulumi import datadog:index/dataset:Dataset foo "<dataset_id>"
        ```

        :param str resource_name: The name of the resource.
        :param DatasetArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(DatasetArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 principals: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 product_filters: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DatasetProductFilterArgs', 'DatasetProductFilterArgsDict']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = DatasetArgs.__new__(DatasetArgs)

            if name is None and not opts.urn:
                raise TypeError("Missing required property 'name'")
            __props__.__dict__["name"] = name
            if principals is None and not opts.urn:
                raise TypeError("Missing required property 'principals'")
            __props__.__dict__["principals"] = principals
            __props__.__dict__["product_filters"] = product_filters
            __props__.__dict__["created_at"] = None
            __props__.__dict__["created_by"] = None
        super(Dataset, __self__).__init__(
            'datadog:index/dataset:Dataset',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            created_at: Optional[pulumi.Input[_builtins.str]] = None,
            created_by: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            principals: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            product_filters: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DatasetProductFilterArgs', 'DatasetProductFilterArgsDict']]]]] = None) -> 'Dataset':
        """
        Get an existing Dataset resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] created_at: Indicates when the dataset was created (in ISO 8601).
        :param pulumi.Input[_builtins.str] created_by: Indicates who created the dataset.
        :param pulumi.Input[_builtins.str] name: The name of the dataset.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] principals: An array of principals. A principal is a subject or group of subjects. Each principal is formatted as `type:id`. Supported types: `role` and `team`.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _DatasetState.__new__(_DatasetState)

        __props__.__dict__["created_at"] = created_at
        __props__.__dict__["created_by"] = created_by
        __props__.__dict__["name"] = name
        __props__.__dict__["principals"] = principals
        __props__.__dict__["product_filters"] = product_filters
        return Dataset(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> pulumi.Output[_builtins.str]:
        """
        Indicates when the dataset was created (in ISO 8601).
        """
        return pulumi.get(self, "created_at")

    @_builtins.property
    @pulumi.getter(name="createdBy")
    def created_by(self) -> pulumi.Output[_builtins.str]:
        """
        Indicates who created the dataset.
        """
        return pulumi.get(self, "created_by")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the dataset.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def principals(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        An array of principals. A principal is a subject or group of subjects. Each principal is formatted as `type:id`. Supported types: `role` and `team`.
        """
        return pulumi.get(self, "principals")

    @_builtins.property
    @pulumi.getter(name="productFilters")
    def product_filters(self) -> pulumi.Output[Optional[Sequence['outputs.DatasetProductFilter']]]:
        return pulumi.get(self, "product_filters")

