# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['GcpUcConfigArgs', 'GcpUcConfig']

@pulumi.input_type
class GcpUcConfigArgs:
    def __init__(__self__, *,
                 billing_account_id: pulumi.Input[_builtins.str],
                 bucket_name: pulumi.Input[_builtins.str],
                 export_dataset_name: pulumi.Input[_builtins.str],
                 export_project_name: pulumi.Input[_builtins.str],
                 service_account: pulumi.Input[_builtins.str],
                 export_prefix: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a GcpUcConfig resource.
        :param pulumi.Input[_builtins.str] billing_account_id: The Google Cloud account ID.
        :param pulumi.Input[_builtins.str] bucket_name: The Google Cloud bucket name used to store the Usage Cost export.
        :param pulumi.Input[_builtins.str] export_dataset_name: The export dataset name used for the Google Cloud Usage Cost report.
        :param pulumi.Input[_builtins.str] export_project_name: The name of the Google Cloud Usage Cost report.
        :param pulumi.Input[_builtins.str] service_account: The unique Google Cloud service account email.
        :param pulumi.Input[_builtins.str] export_prefix: The export prefix used for the Google Cloud Usage Cost report.
        """
        pulumi.set(__self__, "billing_account_id", billing_account_id)
        pulumi.set(__self__, "bucket_name", bucket_name)
        pulumi.set(__self__, "export_dataset_name", export_dataset_name)
        pulumi.set(__self__, "export_project_name", export_project_name)
        pulumi.set(__self__, "service_account", service_account)
        if export_prefix is not None:
            pulumi.set(__self__, "export_prefix", export_prefix)

    @_builtins.property
    @pulumi.getter(name="billingAccountId")
    def billing_account_id(self) -> pulumi.Input[_builtins.str]:
        """
        The Google Cloud account ID.
        """
        return pulumi.get(self, "billing_account_id")

    @billing_account_id.setter
    def billing_account_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "billing_account_id", value)

    @_builtins.property
    @pulumi.getter(name="bucketName")
    def bucket_name(self) -> pulumi.Input[_builtins.str]:
        """
        The Google Cloud bucket name used to store the Usage Cost export.
        """
        return pulumi.get(self, "bucket_name")

    @bucket_name.setter
    def bucket_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "bucket_name", value)

    @_builtins.property
    @pulumi.getter(name="exportDatasetName")
    def export_dataset_name(self) -> pulumi.Input[_builtins.str]:
        """
        The export dataset name used for the Google Cloud Usage Cost report.
        """
        return pulumi.get(self, "export_dataset_name")

    @export_dataset_name.setter
    def export_dataset_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "export_dataset_name", value)

    @_builtins.property
    @pulumi.getter(name="exportProjectName")
    def export_project_name(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the Google Cloud Usage Cost report.
        """
        return pulumi.get(self, "export_project_name")

    @export_project_name.setter
    def export_project_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "export_project_name", value)

    @_builtins.property
    @pulumi.getter(name="serviceAccount")
    def service_account(self) -> pulumi.Input[_builtins.str]:
        """
        The unique Google Cloud service account email.
        """
        return pulumi.get(self, "service_account")

    @service_account.setter
    def service_account(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "service_account", value)

    @_builtins.property
    @pulumi.getter(name="exportPrefix")
    def export_prefix(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The export prefix used for the Google Cloud Usage Cost report.
        """
        return pulumi.get(self, "export_prefix")

    @export_prefix.setter
    def export_prefix(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "export_prefix", value)


@pulumi.input_type
class _GcpUcConfigState:
    def __init__(__self__, *,
                 billing_account_id: Optional[pulumi.Input[_builtins.str]] = None,
                 bucket_name: Optional[pulumi.Input[_builtins.str]] = None,
                 created_at: Optional[pulumi.Input[_builtins.str]] = None,
                 dataset: Optional[pulumi.Input[_builtins.str]] = None,
                 error_messages: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 export_dataset_name: Optional[pulumi.Input[_builtins.str]] = None,
                 export_prefix: Optional[pulumi.Input[_builtins.str]] = None,
                 export_project_name: Optional[pulumi.Input[_builtins.str]] = None,
                 months: Optional[pulumi.Input[_builtins.int]] = None,
                 service_account: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 status_updated_at: Optional[pulumi.Input[_builtins.str]] = None,
                 updated_at: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering GcpUcConfig resources.
        :param pulumi.Input[_builtins.str] billing_account_id: The Google Cloud account ID.
        :param pulumi.Input[_builtins.str] bucket_name: The Google Cloud bucket name used to store the Usage Cost export.
        :param pulumi.Input[_builtins.str] created_at: The timestamp when the GCP UC configuration was created.
        :param pulumi.Input[_builtins.str] dataset: The dataset name used for the GCP Usage Cost export.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] error_messages: List of error messages if the GCP UC configuration encountered any issues during setup or data processing.
        :param pulumi.Input[_builtins.str] export_dataset_name: The export dataset name used for the Google Cloud Usage Cost report.
        :param pulumi.Input[_builtins.str] export_prefix: The export prefix used for the Google Cloud Usage Cost report.
        :param pulumi.Input[_builtins.str] export_project_name: The name of the Google Cloud Usage Cost report.
        :param pulumi.Input[_builtins.int] months: The number of months of usage data to include in the export.
        :param pulumi.Input[_builtins.str] service_account: The unique Google Cloud service account email.
        :param pulumi.Input[_builtins.str] status: The current status of the GCP UC configuration.
        :param pulumi.Input[_builtins.str] status_updated_at: The timestamp when the configuration status was last updated.
        :param pulumi.Input[_builtins.str] updated_at: The timestamp when the GCP UC configuration was last modified.
        """
        if billing_account_id is not None:
            pulumi.set(__self__, "billing_account_id", billing_account_id)
        if bucket_name is not None:
            pulumi.set(__self__, "bucket_name", bucket_name)
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if dataset is not None:
            pulumi.set(__self__, "dataset", dataset)
        if error_messages is not None:
            pulumi.set(__self__, "error_messages", error_messages)
        if export_dataset_name is not None:
            pulumi.set(__self__, "export_dataset_name", export_dataset_name)
        if export_prefix is not None:
            pulumi.set(__self__, "export_prefix", export_prefix)
        if export_project_name is not None:
            pulumi.set(__self__, "export_project_name", export_project_name)
        if months is not None:
            pulumi.set(__self__, "months", months)
        if service_account is not None:
            pulumi.set(__self__, "service_account", service_account)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if status_updated_at is not None:
            pulumi.set(__self__, "status_updated_at", status_updated_at)
        if updated_at is not None:
            pulumi.set(__self__, "updated_at", updated_at)

    @_builtins.property
    @pulumi.getter(name="billingAccountId")
    def billing_account_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Google Cloud account ID.
        """
        return pulumi.get(self, "billing_account_id")

    @billing_account_id.setter
    def billing_account_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "billing_account_id", value)

    @_builtins.property
    @pulumi.getter(name="bucketName")
    def bucket_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Google Cloud bucket name used to store the Usage Cost export.
        """
        return pulumi.get(self, "bucket_name")

    @bucket_name.setter
    def bucket_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "bucket_name", value)

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The timestamp when the GCP UC configuration was created.
        """
        return pulumi.get(self, "created_at")

    @created_at.setter
    def created_at(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "created_at", value)

    @_builtins.property
    @pulumi.getter
    def dataset(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The dataset name used for the GCP Usage Cost export.
        """
        return pulumi.get(self, "dataset")

    @dataset.setter
    def dataset(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "dataset", value)

    @_builtins.property
    @pulumi.getter(name="errorMessages")
    def error_messages(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of error messages if the GCP UC configuration encountered any issues during setup or data processing.
        """
        return pulumi.get(self, "error_messages")

    @error_messages.setter
    def error_messages(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "error_messages", value)

    @_builtins.property
    @pulumi.getter(name="exportDatasetName")
    def export_dataset_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The export dataset name used for the Google Cloud Usage Cost report.
        """
        return pulumi.get(self, "export_dataset_name")

    @export_dataset_name.setter
    def export_dataset_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "export_dataset_name", value)

    @_builtins.property
    @pulumi.getter(name="exportPrefix")
    def export_prefix(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The export prefix used for the Google Cloud Usage Cost report.
        """
        return pulumi.get(self, "export_prefix")

    @export_prefix.setter
    def export_prefix(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "export_prefix", value)

    @_builtins.property
    @pulumi.getter(name="exportProjectName")
    def export_project_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the Google Cloud Usage Cost report.
        """
        return pulumi.get(self, "export_project_name")

    @export_project_name.setter
    def export_project_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "export_project_name", value)

    @_builtins.property
    @pulumi.getter
    def months(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The number of months of usage data to include in the export.
        """
        return pulumi.get(self, "months")

    @months.setter
    def months(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "months", value)

    @_builtins.property
    @pulumi.getter(name="serviceAccount")
    def service_account(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The unique Google Cloud service account email.
        """
        return pulumi.get(self, "service_account")

    @service_account.setter
    def service_account(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "service_account", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The current status of the GCP UC configuration.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter(name="statusUpdatedAt")
    def status_updated_at(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The timestamp when the configuration status was last updated.
        """
        return pulumi.get(self, "status_updated_at")

    @status_updated_at.setter
    def status_updated_at(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status_updated_at", value)

    @_builtins.property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The timestamp when the GCP UC configuration was last modified.
        """
        return pulumi.get(self, "updated_at")

    @updated_at.setter
    def updated_at(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "updated_at", value)


@pulumi.type_token("datadog:index/gcpUcConfig:GcpUcConfig")
class GcpUcConfig(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 billing_account_id: Optional[pulumi.Input[_builtins.str]] = None,
                 bucket_name: Optional[pulumi.Input[_builtins.str]] = None,
                 export_dataset_name: Optional[pulumi.Input[_builtins.str]] = None,
                 export_prefix: Optional[pulumi.Input[_builtins.str]] = None,
                 export_project_name: Optional[pulumi.Input[_builtins.str]] = None,
                 service_account: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Provides a Datadog GcpUcConfig resource. This can be used to create and manage Datadog gcp_uc_config.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_datadog as datadog

        # Create new GCP Usage Cost configuration resource
        example = datadog.GcpUcConfig("example",
            billing_account_id="123456_ABCDEF_123456",
            bucket_name="my-gcp-cost-bucket",
            export_dataset_name="billing_export",
            export_prefix="datadog_cloud_cost_detailed_usage_export",
            export_project_name="my-gcp-project",
            service_account="datadog-cost-management@my-gcp-project.iam.gserviceaccount.com")
        ```

        ## Import

        The `pulumi import` command can be used, for example:

        ```sh
        $ pulumi import datadog:index/gcpUcConfig:GcpUcConfig example <cloud_account_id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] billing_account_id: The Google Cloud account ID.
        :param pulumi.Input[_builtins.str] bucket_name: The Google Cloud bucket name used to store the Usage Cost export.
        :param pulumi.Input[_builtins.str] export_dataset_name: The export dataset name used for the Google Cloud Usage Cost report.
        :param pulumi.Input[_builtins.str] export_prefix: The export prefix used for the Google Cloud Usage Cost report.
        :param pulumi.Input[_builtins.str] export_project_name: The name of the Google Cloud Usage Cost report.
        :param pulumi.Input[_builtins.str] service_account: The unique Google Cloud service account email.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: GcpUcConfigArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Datadog GcpUcConfig resource. This can be used to create and manage Datadog gcp_uc_config.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_datadog as datadog

        # Create new GCP Usage Cost configuration resource
        example = datadog.GcpUcConfig("example",
            billing_account_id="123456_ABCDEF_123456",
            bucket_name="my-gcp-cost-bucket",
            export_dataset_name="billing_export",
            export_prefix="datadog_cloud_cost_detailed_usage_export",
            export_project_name="my-gcp-project",
            service_account="datadog-cost-management@my-gcp-project.iam.gserviceaccount.com")
        ```

        ## Import

        The `pulumi import` command can be used, for example:

        ```sh
        $ pulumi import datadog:index/gcpUcConfig:GcpUcConfig example <cloud_account_id>
        ```

        :param str resource_name: The name of the resource.
        :param GcpUcConfigArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(GcpUcConfigArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 billing_account_id: Optional[pulumi.Input[_builtins.str]] = None,
                 bucket_name: Optional[pulumi.Input[_builtins.str]] = None,
                 export_dataset_name: Optional[pulumi.Input[_builtins.str]] = None,
                 export_prefix: Optional[pulumi.Input[_builtins.str]] = None,
                 export_project_name: Optional[pulumi.Input[_builtins.str]] = None,
                 service_account: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = GcpUcConfigArgs.__new__(GcpUcConfigArgs)

            if billing_account_id is None and not opts.urn:
                raise TypeError("Missing required property 'billing_account_id'")
            __props__.__dict__["billing_account_id"] = billing_account_id
            if bucket_name is None and not opts.urn:
                raise TypeError("Missing required property 'bucket_name'")
            __props__.__dict__["bucket_name"] = bucket_name
            if export_dataset_name is None and not opts.urn:
                raise TypeError("Missing required property 'export_dataset_name'")
            __props__.__dict__["export_dataset_name"] = export_dataset_name
            __props__.__dict__["export_prefix"] = export_prefix
            if export_project_name is None and not opts.urn:
                raise TypeError("Missing required property 'export_project_name'")
            __props__.__dict__["export_project_name"] = export_project_name
            if service_account is None and not opts.urn:
                raise TypeError("Missing required property 'service_account'")
            __props__.__dict__["service_account"] = service_account
            __props__.__dict__["created_at"] = None
            __props__.__dict__["dataset"] = None
            __props__.__dict__["error_messages"] = None
            __props__.__dict__["months"] = None
            __props__.__dict__["status"] = None
            __props__.__dict__["status_updated_at"] = None
            __props__.__dict__["updated_at"] = None
        super(GcpUcConfig, __self__).__init__(
            'datadog:index/gcpUcConfig:GcpUcConfig',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            billing_account_id: Optional[pulumi.Input[_builtins.str]] = None,
            bucket_name: Optional[pulumi.Input[_builtins.str]] = None,
            created_at: Optional[pulumi.Input[_builtins.str]] = None,
            dataset: Optional[pulumi.Input[_builtins.str]] = None,
            error_messages: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            export_dataset_name: Optional[pulumi.Input[_builtins.str]] = None,
            export_prefix: Optional[pulumi.Input[_builtins.str]] = None,
            export_project_name: Optional[pulumi.Input[_builtins.str]] = None,
            months: Optional[pulumi.Input[_builtins.int]] = None,
            service_account: Optional[pulumi.Input[_builtins.str]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None,
            status_updated_at: Optional[pulumi.Input[_builtins.str]] = None,
            updated_at: Optional[pulumi.Input[_builtins.str]] = None) -> 'GcpUcConfig':
        """
        Get an existing GcpUcConfig resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] billing_account_id: The Google Cloud account ID.
        :param pulumi.Input[_builtins.str] bucket_name: The Google Cloud bucket name used to store the Usage Cost export.
        :param pulumi.Input[_builtins.str] created_at: The timestamp when the GCP UC configuration was created.
        :param pulumi.Input[_builtins.str] dataset: The dataset name used for the GCP Usage Cost export.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] error_messages: List of error messages if the GCP UC configuration encountered any issues during setup or data processing.
        :param pulumi.Input[_builtins.str] export_dataset_name: The export dataset name used for the Google Cloud Usage Cost report.
        :param pulumi.Input[_builtins.str] export_prefix: The export prefix used for the Google Cloud Usage Cost report.
        :param pulumi.Input[_builtins.str] export_project_name: The name of the Google Cloud Usage Cost report.
        :param pulumi.Input[_builtins.int] months: The number of months of usage data to include in the export.
        :param pulumi.Input[_builtins.str] service_account: The unique Google Cloud service account email.
        :param pulumi.Input[_builtins.str] status: The current status of the GCP UC configuration.
        :param pulumi.Input[_builtins.str] status_updated_at: The timestamp when the configuration status was last updated.
        :param pulumi.Input[_builtins.str] updated_at: The timestamp when the GCP UC configuration was last modified.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _GcpUcConfigState.__new__(_GcpUcConfigState)

        __props__.__dict__["billing_account_id"] = billing_account_id
        __props__.__dict__["bucket_name"] = bucket_name
        __props__.__dict__["created_at"] = created_at
        __props__.__dict__["dataset"] = dataset
        __props__.__dict__["error_messages"] = error_messages
        __props__.__dict__["export_dataset_name"] = export_dataset_name
        __props__.__dict__["export_prefix"] = export_prefix
        __props__.__dict__["export_project_name"] = export_project_name
        __props__.__dict__["months"] = months
        __props__.__dict__["service_account"] = service_account
        __props__.__dict__["status"] = status
        __props__.__dict__["status_updated_at"] = status_updated_at
        __props__.__dict__["updated_at"] = updated_at
        return GcpUcConfig(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="billingAccountId")
    def billing_account_id(self) -> pulumi.Output[_builtins.str]:
        """
        The Google Cloud account ID.
        """
        return pulumi.get(self, "billing_account_id")

    @_builtins.property
    @pulumi.getter(name="bucketName")
    def bucket_name(self) -> pulumi.Output[_builtins.str]:
        """
        The Google Cloud bucket name used to store the Usage Cost export.
        """
        return pulumi.get(self, "bucket_name")

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> pulumi.Output[_builtins.str]:
        """
        The timestamp when the GCP UC configuration was created.
        """
        return pulumi.get(self, "created_at")

    @_builtins.property
    @pulumi.getter
    def dataset(self) -> pulumi.Output[_builtins.str]:
        """
        The dataset name used for the GCP Usage Cost export.
        """
        return pulumi.get(self, "dataset")

    @_builtins.property
    @pulumi.getter(name="errorMessages")
    def error_messages(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        List of error messages if the GCP UC configuration encountered any issues during setup or data processing.
        """
        return pulumi.get(self, "error_messages")

    @_builtins.property
    @pulumi.getter(name="exportDatasetName")
    def export_dataset_name(self) -> pulumi.Output[_builtins.str]:
        """
        The export dataset name used for the Google Cloud Usage Cost report.
        """
        return pulumi.get(self, "export_dataset_name")

    @_builtins.property
    @pulumi.getter(name="exportPrefix")
    def export_prefix(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The export prefix used for the Google Cloud Usage Cost report.
        """
        return pulumi.get(self, "export_prefix")

    @_builtins.property
    @pulumi.getter(name="exportProjectName")
    def export_project_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the Google Cloud Usage Cost report.
        """
        return pulumi.get(self, "export_project_name")

    @_builtins.property
    @pulumi.getter
    def months(self) -> pulumi.Output[_builtins.int]:
        """
        The number of months of usage data to include in the export.
        """
        return pulumi.get(self, "months")

    @_builtins.property
    @pulumi.getter(name="serviceAccount")
    def service_account(self) -> pulumi.Output[_builtins.str]:
        """
        The unique Google Cloud service account email.
        """
        return pulumi.get(self, "service_account")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.str]:
        """
        The current status of the GCP UC configuration.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter(name="statusUpdatedAt")
    def status_updated_at(self) -> pulumi.Output[_builtins.str]:
        """
        The timestamp when the configuration status was last updated.
        """
        return pulumi.get(self, "status_updated_at")

    @_builtins.property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> pulumi.Output[_builtins.str]:
        """
        The timestamp when the GCP UC configuration was last modified.
        """
        return pulumi.get(self, "updated_at")

