# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetAzureUcConfigResult',
    'AwaitableGetAzureUcConfigResult',
    'get_azure_uc_config',
    'get_azure_uc_config_output',
]

@pulumi.output_type
class GetAzureUcConfigResult:
    """
    A collection of values returned by getAzureUcConfig.
    """
    def __init__(__self__, account_id=None, actual_bill_config=None, amortized_bill_config=None, client_id=None, cloud_account_id=None, created_at=None, error_messages=None, id=None, scope=None, status=None, status_updated_at=None, updated_at=None):
        if account_id and not isinstance(account_id, str):
            raise TypeError("Expected argument 'account_id' to be a str")
        pulumi.set(__self__, "account_id", account_id)
        if actual_bill_config and not isinstance(actual_bill_config, dict):
            raise TypeError("Expected argument 'actual_bill_config' to be a dict")
        pulumi.set(__self__, "actual_bill_config", actual_bill_config)
        if amortized_bill_config and not isinstance(amortized_bill_config, dict):
            raise TypeError("Expected argument 'amortized_bill_config' to be a dict")
        pulumi.set(__self__, "amortized_bill_config", amortized_bill_config)
        if client_id and not isinstance(client_id, str):
            raise TypeError("Expected argument 'client_id' to be a str")
        pulumi.set(__self__, "client_id", client_id)
        if cloud_account_id and not isinstance(cloud_account_id, int):
            raise TypeError("Expected argument 'cloud_account_id' to be a int")
        pulumi.set(__self__, "cloud_account_id", cloud_account_id)
        if created_at and not isinstance(created_at, str):
            raise TypeError("Expected argument 'created_at' to be a str")
        pulumi.set(__self__, "created_at", created_at)
        if error_messages and not isinstance(error_messages, list):
            raise TypeError("Expected argument 'error_messages' to be a list")
        pulumi.set(__self__, "error_messages", error_messages)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if scope and not isinstance(scope, str):
            raise TypeError("Expected argument 'scope' to be a str")
        pulumi.set(__self__, "scope", scope)
        if status and not isinstance(status, str):
            raise TypeError("Expected argument 'status' to be a str")
        pulumi.set(__self__, "status", status)
        if status_updated_at and not isinstance(status_updated_at, str):
            raise TypeError("Expected argument 'status_updated_at' to be a str")
        pulumi.set(__self__, "status_updated_at", status_updated_at)
        if updated_at and not isinstance(updated_at, str):
            raise TypeError("Expected argument 'updated_at' to be a str")
        pulumi.set(__self__, "updated_at", updated_at)

    @_builtins.property
    @pulumi.getter(name="accountId")
    def account_id(self) -> _builtins.str:
        """
        The tenant ID of the Azure account.
        """
        return pulumi.get(self, "account_id")

    @_builtins.property
    @pulumi.getter(name="actualBillConfig")
    def actual_bill_config(self) -> Optional['outputs.GetAzureUcConfigActualBillConfigResult']:
        """
        Configuration for the actual cost export.
        """
        return pulumi.get(self, "actual_bill_config")

    @_builtins.property
    @pulumi.getter(name="amortizedBillConfig")
    def amortized_bill_config(self) -> Optional['outputs.GetAzureUcConfigAmortizedBillConfigResult']:
        """
        Configuration for the amortized cost export.
        """
        return pulumi.get(self, "amortized_bill_config")

    @_builtins.property
    @pulumi.getter(name="clientId")
    def client_id(self) -> _builtins.str:
        """
        The client ID of the Azure account.
        """
        return pulumi.get(self, "client_id")

    @_builtins.property
    @pulumi.getter(name="cloudAccountId")
    def cloud_account_id(self) -> _builtins.int:
        """
        The Datadog cloud account ID for the Azure Usage Cost configuration you want to retrieve information about.
        """
        return pulumi.get(self, "cloud_account_id")

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> _builtins.str:
        """
        The timestamp when the Azure Usage Cost configuration was created.
        """
        return pulumi.get(self, "created_at")

    @_builtins.property
    @pulumi.getter(name="errorMessages")
    def error_messages(self) -> Sequence[_builtins.str]:
        """
        List of error messages if the Azure Usage Cost configuration encountered any issues during setup or data processing.
        """
        return pulumi.get(self, "error_messages")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The ID of this resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def scope(self) -> _builtins.str:
        """
        The scope of your observed subscription.
        """
        return pulumi.get(self, "scope")

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.str:
        """
        The current status of the Azure Usage Cost configuration.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter(name="statusUpdatedAt")
    def status_updated_at(self) -> _builtins.str:
        """
        The timestamp when the configuration status was last updated.
        """
        return pulumi.get(self, "status_updated_at")

    @_builtins.property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> _builtins.str:
        """
        The timestamp when the Azure Usage Cost configuration was last modified.
        """
        return pulumi.get(self, "updated_at")


class AwaitableGetAzureUcConfigResult(GetAzureUcConfigResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetAzureUcConfigResult(
            account_id=self.account_id,
            actual_bill_config=self.actual_bill_config,
            amortized_bill_config=self.amortized_bill_config,
            client_id=self.client_id,
            cloud_account_id=self.cloud_account_id,
            created_at=self.created_at,
            error_messages=self.error_messages,
            id=self.id,
            scope=self.scope,
            status=self.status,
            status_updated_at=self.status_updated_at,
            updated_at=self.updated_at)


def get_azure_uc_config(actual_bill_config: Optional[Union['GetAzureUcConfigActualBillConfigArgs', 'GetAzureUcConfigActualBillConfigArgsDict']] = None,
                        amortized_bill_config: Optional[Union['GetAzureUcConfigAmortizedBillConfigArgs', 'GetAzureUcConfigAmortizedBillConfigArgsDict']] = None,
                        cloud_account_id: Optional[_builtins.int] = None,
                        opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetAzureUcConfigResult:
    """
    Use this data source to retrieve information about a specific Datadog Azure Usage Cost configuration. This allows you to fetch details about an existing Cloud Cost Management configuration for Azure billing data access.


    :param Union['GetAzureUcConfigActualBillConfigArgs', 'GetAzureUcConfigActualBillConfigArgsDict'] actual_bill_config: Configuration for the actual cost export.
    :param Union['GetAzureUcConfigAmortizedBillConfigArgs', 'GetAzureUcConfigAmortizedBillConfigArgsDict'] amortized_bill_config: Configuration for the amortized cost export.
    :param _builtins.int cloud_account_id: The Datadog cloud account ID for the Azure Usage Cost configuration you want to retrieve information about.
    """
    __args__ = dict()
    __args__['actualBillConfig'] = actual_bill_config
    __args__['amortizedBillConfig'] = amortized_bill_config
    __args__['cloudAccountId'] = cloud_account_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('datadog:index/getAzureUcConfig:getAzureUcConfig', __args__, opts=opts, typ=GetAzureUcConfigResult).value

    return AwaitableGetAzureUcConfigResult(
        account_id=pulumi.get(__ret__, 'account_id'),
        actual_bill_config=pulumi.get(__ret__, 'actual_bill_config'),
        amortized_bill_config=pulumi.get(__ret__, 'amortized_bill_config'),
        client_id=pulumi.get(__ret__, 'client_id'),
        cloud_account_id=pulumi.get(__ret__, 'cloud_account_id'),
        created_at=pulumi.get(__ret__, 'created_at'),
        error_messages=pulumi.get(__ret__, 'error_messages'),
        id=pulumi.get(__ret__, 'id'),
        scope=pulumi.get(__ret__, 'scope'),
        status=pulumi.get(__ret__, 'status'),
        status_updated_at=pulumi.get(__ret__, 'status_updated_at'),
        updated_at=pulumi.get(__ret__, 'updated_at'))
def get_azure_uc_config_output(actual_bill_config: Optional[pulumi.Input[Optional[Union['GetAzureUcConfigActualBillConfigArgs', 'GetAzureUcConfigActualBillConfigArgsDict']]]] = None,
                               amortized_bill_config: Optional[pulumi.Input[Optional[Union['GetAzureUcConfigAmortizedBillConfigArgs', 'GetAzureUcConfigAmortizedBillConfigArgsDict']]]] = None,
                               cloud_account_id: Optional[pulumi.Input[_builtins.int]] = None,
                               opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetAzureUcConfigResult]:
    """
    Use this data source to retrieve information about a specific Datadog Azure Usage Cost configuration. This allows you to fetch details about an existing Cloud Cost Management configuration for Azure billing data access.


    :param Union['GetAzureUcConfigActualBillConfigArgs', 'GetAzureUcConfigActualBillConfigArgsDict'] actual_bill_config: Configuration for the actual cost export.
    :param Union['GetAzureUcConfigAmortizedBillConfigArgs', 'GetAzureUcConfigAmortizedBillConfigArgsDict'] amortized_bill_config: Configuration for the amortized cost export.
    :param _builtins.int cloud_account_id: The Datadog cloud account ID for the Azure Usage Cost configuration you want to retrieve information about.
    """
    __args__ = dict()
    __args__['actualBillConfig'] = actual_bill_config
    __args__['amortizedBillConfig'] = amortized_bill_config
    __args__['cloudAccountId'] = cloud_account_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('datadog:index/getAzureUcConfig:getAzureUcConfig', __args__, opts=opts, typ=GetAzureUcConfigResult)
    return __ret__.apply(lambda __response__: GetAzureUcConfigResult(
        account_id=pulumi.get(__response__, 'account_id'),
        actual_bill_config=pulumi.get(__response__, 'actual_bill_config'),
        amortized_bill_config=pulumi.get(__response__, 'amortized_bill_config'),
        client_id=pulumi.get(__response__, 'client_id'),
        cloud_account_id=pulumi.get(__response__, 'cloud_account_id'),
        created_at=pulumi.get(__response__, 'created_at'),
        error_messages=pulumi.get(__response__, 'error_messages'),
        id=pulumi.get(__response__, 'id'),
        scope=pulumi.get(__response__, 'scope'),
        status=pulumi.get(__response__, 'status'),
        status_updated_at=pulumi.get(__response__, 'status_updated_at'),
        updated_at=pulumi.get(__response__, 'updated_at')))
