# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetCustomAllocationRuleResult',
    'AwaitableGetCustomAllocationRuleResult',
    'get_custom_allocation_rule',
    'get_custom_allocation_rule_output',
]

@pulumi.output_type
class GetCustomAllocationRuleResult:
    """
    A collection of values returned by getCustomAllocationRule.
    """
    def __init__(__self__, costs_to_allocates=None, created=None, enabled=None, id=None, last_modified_user_uuid=None, order_id=None, providernames=None, rejected=None, rule_id=None, rule_name=None, strategy=None, type=None, updated=None, version=None):
        if costs_to_allocates and not isinstance(costs_to_allocates, list):
            raise TypeError("Expected argument 'costs_to_allocates' to be a list")
        pulumi.set(__self__, "costs_to_allocates", costs_to_allocates)
        if created and not isinstance(created, str):
            raise TypeError("Expected argument 'created' to be a str")
        pulumi.set(__self__, "created", created)
        if enabled and not isinstance(enabled, bool):
            raise TypeError("Expected argument 'enabled' to be a bool")
        pulumi.set(__self__, "enabled", enabled)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if last_modified_user_uuid and not isinstance(last_modified_user_uuid, str):
            raise TypeError("Expected argument 'last_modified_user_uuid' to be a str")
        pulumi.set(__self__, "last_modified_user_uuid", last_modified_user_uuid)
        if order_id and not isinstance(order_id, int):
            raise TypeError("Expected argument 'order_id' to be a int")
        pulumi.set(__self__, "order_id", order_id)
        if providernames and not isinstance(providernames, list):
            raise TypeError("Expected argument 'providernames' to be a list")
        pulumi.set(__self__, "providernames", providernames)
        if rejected and not isinstance(rejected, bool):
            raise TypeError("Expected argument 'rejected' to be a bool")
        pulumi.set(__self__, "rejected", rejected)
        if rule_id and not isinstance(rule_id, int):
            raise TypeError("Expected argument 'rule_id' to be a int")
        pulumi.set(__self__, "rule_id", rule_id)
        if rule_name and not isinstance(rule_name, str):
            raise TypeError("Expected argument 'rule_name' to be a str")
        pulumi.set(__self__, "rule_name", rule_name)
        if strategy and not isinstance(strategy, dict):
            raise TypeError("Expected argument 'strategy' to be a dict")
        pulumi.set(__self__, "strategy", strategy)
        if type and not isinstance(type, str):
            raise TypeError("Expected argument 'type' to be a str")
        pulumi.set(__self__, "type", type)
        if updated and not isinstance(updated, str):
            raise TypeError("Expected argument 'updated' to be a str")
        pulumi.set(__self__, "updated", updated)
        if version and not isinstance(version, str):
            raise TypeError("Expected argument 'version' to be a str")
        pulumi.set(__self__, "version", version)

    @_builtins.property
    @pulumi.getter(name="costsToAllocates")
    def costs_to_allocates(self) -> Optional[Sequence['outputs.GetCustomAllocationRuleCostsToAllocateResult']]:
        return pulumi.get(self, "costs_to_allocates")

    @_builtins.property
    @pulumi.getter
    def created(self) -> _builtins.str:
        """
        The timestamp (in ISO 8601 format) when the rule was created.
        """
        return pulumi.get(self, "created")

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> _builtins.bool:
        """
        Whether the custom allocation rule is enabled.
        """
        return pulumi.get(self, "enabled")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The ID of this resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="lastModifiedUserUuid")
    def last_modified_user_uuid(self) -> _builtins.str:
        """
        The UUID of the user who last modified the rule.
        """
        return pulumi.get(self, "last_modified_user_uuid")

    @_builtins.property
    @pulumi.getter(name="orderId")
    def order_id(self) -> _builtins.int:
        """
        The order of the rule in the list of custom allocation rules.
        """
        return pulumi.get(self, "order_id")

    @_builtins.property
    @pulumi.getter
    def providernames(self) -> Sequence[_builtins.str]:
        """
        List of cloud providers the rule applies to (e.g., `aws`, `azure`, `gcp`).
        """
        return pulumi.get(self, "providernames")

    @_builtins.property
    @pulumi.getter
    def rejected(self) -> _builtins.bool:
        """
        Whether the rule was rejected by Datadog due to runtime errors. This field can be updated well after the rule was created. If rejected this rule is treated as disabled until modified where the rejection status is reset.
        """
        return pulumi.get(self, "rejected")

    @_builtins.property
    @pulumi.getter(name="ruleId")
    def rule_id(self) -> Optional[_builtins.int]:
        """
        The ID of the custom allocation rule to retrieve.
        """
        return pulumi.get(self, "rule_id")

    @_builtins.property
    @pulumi.getter(name="ruleName")
    def rule_name(self) -> _builtins.str:
        """
        The unique name of the custom allocation rule.
        """
        return pulumi.get(self, "rule_name")

    @_builtins.property
    @pulumi.getter
    def strategy(self) -> Optional['outputs.GetCustomAllocationRuleStrategyResult']:
        return pulumi.get(self, "strategy")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        The type of the custom allocation rule. This is always `shared` currently.
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter
    def updated(self) -> _builtins.str:
        """
        The timestamp (in ISO 8601 format) when the rule was last updated.
        """
        return pulumi.get(self, "updated")

    @_builtins.property
    @pulumi.getter
    def version(self) -> _builtins.str:
        """
        The version number of the rule.
        """
        return pulumi.get(self, "version")


class AwaitableGetCustomAllocationRuleResult(GetCustomAllocationRuleResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetCustomAllocationRuleResult(
            costs_to_allocates=self.costs_to_allocates,
            created=self.created,
            enabled=self.enabled,
            id=self.id,
            last_modified_user_uuid=self.last_modified_user_uuid,
            order_id=self.order_id,
            providernames=self.providernames,
            rejected=self.rejected,
            rule_id=self.rule_id,
            rule_name=self.rule_name,
            strategy=self.strategy,
            type=self.type,
            updated=self.updated,
            version=self.version)


def get_custom_allocation_rule(costs_to_allocates: Optional[Sequence[Union['GetCustomAllocationRuleCostsToAllocateArgs', 'GetCustomAllocationRuleCostsToAllocateArgsDict']]] = None,
                               rule_id: Optional[_builtins.int] = None,
                               strategy: Optional[Union['GetCustomAllocationRuleStrategyArgs', 'GetCustomAllocationRuleStrategyArgsDict']] = None,
                               opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetCustomAllocationRuleResult:
    """
    Use this data source to retrieve information about an existing custom allocation rule.


    :param _builtins.int rule_id: The ID of the custom allocation rule to retrieve.
    """
    __args__ = dict()
    __args__['costsToAllocates'] = costs_to_allocates
    __args__['ruleId'] = rule_id
    __args__['strategy'] = strategy
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('datadog:index/getCustomAllocationRule:getCustomAllocationRule', __args__, opts=opts, typ=GetCustomAllocationRuleResult).value

    return AwaitableGetCustomAllocationRuleResult(
        costs_to_allocates=pulumi.get(__ret__, 'costs_to_allocates'),
        created=pulumi.get(__ret__, 'created'),
        enabled=pulumi.get(__ret__, 'enabled'),
        id=pulumi.get(__ret__, 'id'),
        last_modified_user_uuid=pulumi.get(__ret__, 'last_modified_user_uuid'),
        order_id=pulumi.get(__ret__, 'order_id'),
        providernames=pulumi.get(__ret__, 'providernames'),
        rejected=pulumi.get(__ret__, 'rejected'),
        rule_id=pulumi.get(__ret__, 'rule_id'),
        rule_name=pulumi.get(__ret__, 'rule_name'),
        strategy=pulumi.get(__ret__, 'strategy'),
        type=pulumi.get(__ret__, 'type'),
        updated=pulumi.get(__ret__, 'updated'),
        version=pulumi.get(__ret__, 'version'))
def get_custom_allocation_rule_output(costs_to_allocates: Optional[pulumi.Input[Optional[Sequence[Union['GetCustomAllocationRuleCostsToAllocateArgs', 'GetCustomAllocationRuleCostsToAllocateArgsDict']]]]] = None,
                                      rule_id: Optional[pulumi.Input[Optional[_builtins.int]]] = None,
                                      strategy: Optional[pulumi.Input[Optional[Union['GetCustomAllocationRuleStrategyArgs', 'GetCustomAllocationRuleStrategyArgsDict']]]] = None,
                                      opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetCustomAllocationRuleResult]:
    """
    Use this data source to retrieve information about an existing custom allocation rule.


    :param _builtins.int rule_id: The ID of the custom allocation rule to retrieve.
    """
    __args__ = dict()
    __args__['costsToAllocates'] = costs_to_allocates
    __args__['ruleId'] = rule_id
    __args__['strategy'] = strategy
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('datadog:index/getCustomAllocationRule:getCustomAllocationRule', __args__, opts=opts, typ=GetCustomAllocationRuleResult)
    return __ret__.apply(lambda __response__: GetCustomAllocationRuleResult(
        costs_to_allocates=pulumi.get(__response__, 'costs_to_allocates'),
        created=pulumi.get(__response__, 'created'),
        enabled=pulumi.get(__response__, 'enabled'),
        id=pulumi.get(__response__, 'id'),
        last_modified_user_uuid=pulumi.get(__response__, 'last_modified_user_uuid'),
        order_id=pulumi.get(__response__, 'order_id'),
        providernames=pulumi.get(__response__, 'providernames'),
        rejected=pulumi.get(__response__, 'rejected'),
        rule_id=pulumi.get(__response__, 'rule_id'),
        rule_name=pulumi.get(__response__, 'rule_name'),
        strategy=pulumi.get(__response__, 'strategy'),
        type=pulumi.get(__response__, 'type'),
        updated=pulumi.get(__response__, 'updated'),
        version=pulumi.get(__response__, 'version')))
