# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = [
    'GetGcpUcConfigResult',
    'AwaitableGetGcpUcConfigResult',
    'get_gcp_uc_config',
    'get_gcp_uc_config_output',
]

@pulumi.output_type
class GetGcpUcConfigResult:
    """
    A collection of values returned by getGcpUcConfig.
    """
    def __init__(__self__, account_id=None, bucket_name=None, cloud_account_id=None, created_at=None, dataset=None, error_messages=None, export_prefix=None, export_project_name=None, id=None, months=None, service_account=None, status=None, status_updated_at=None, updated_at=None):
        if account_id and not isinstance(account_id, str):
            raise TypeError("Expected argument 'account_id' to be a str")
        pulumi.set(__self__, "account_id", account_id)
        if bucket_name and not isinstance(bucket_name, str):
            raise TypeError("Expected argument 'bucket_name' to be a str")
        pulumi.set(__self__, "bucket_name", bucket_name)
        if cloud_account_id and not isinstance(cloud_account_id, int):
            raise TypeError("Expected argument 'cloud_account_id' to be a int")
        pulumi.set(__self__, "cloud_account_id", cloud_account_id)
        if created_at and not isinstance(created_at, str):
            raise TypeError("Expected argument 'created_at' to be a str")
        pulumi.set(__self__, "created_at", created_at)
        if dataset and not isinstance(dataset, str):
            raise TypeError("Expected argument 'dataset' to be a str")
        pulumi.set(__self__, "dataset", dataset)
        if error_messages and not isinstance(error_messages, list):
            raise TypeError("Expected argument 'error_messages' to be a list")
        pulumi.set(__self__, "error_messages", error_messages)
        if export_prefix and not isinstance(export_prefix, str):
            raise TypeError("Expected argument 'export_prefix' to be a str")
        pulumi.set(__self__, "export_prefix", export_prefix)
        if export_project_name and not isinstance(export_project_name, str):
            raise TypeError("Expected argument 'export_project_name' to be a str")
        pulumi.set(__self__, "export_project_name", export_project_name)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if months and not isinstance(months, int):
            raise TypeError("Expected argument 'months' to be a int")
        pulumi.set(__self__, "months", months)
        if service_account and not isinstance(service_account, str):
            raise TypeError("Expected argument 'service_account' to be a str")
        pulumi.set(__self__, "service_account", service_account)
        if status and not isinstance(status, str):
            raise TypeError("Expected argument 'status' to be a str")
        pulumi.set(__self__, "status", status)
        if status_updated_at and not isinstance(status_updated_at, str):
            raise TypeError("Expected argument 'status_updated_at' to be a str")
        pulumi.set(__self__, "status_updated_at", status_updated_at)
        if updated_at and not isinstance(updated_at, str):
            raise TypeError("Expected argument 'updated_at' to be a str")
        pulumi.set(__self__, "updated_at", updated_at)

    @_builtins.property
    @pulumi.getter(name="accountId")
    def account_id(self) -> _builtins.str:
        """
        The internal account identifier for this GCP Usage Cost configuration.
        """
        return pulumi.get(self, "account_id")

    @_builtins.property
    @pulumi.getter(name="bucketName")
    def bucket_name(self) -> _builtins.str:
        """
        The Google Cloud Storage bucket name where Usage Cost export files are stored.
        """
        return pulumi.get(self, "bucket_name")

    @_builtins.property
    @pulumi.getter(name="cloudAccountId")
    def cloud_account_id(self) -> _builtins.int:
        """
        The Datadog cloud account ID for the GCP Usage Cost configuration you want to retrieve information about.
        """
        return pulumi.get(self, "cloud_account_id")

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> _builtins.str:
        """
        The timestamp when the GCP Usage Cost configuration was created.
        """
        return pulumi.get(self, "created_at")

    @_builtins.property
    @pulumi.getter
    def dataset(self) -> _builtins.str:
        """
        The resolved BigQuery dataset name used for the Usage Cost export.
        """
        return pulumi.get(self, "dataset")

    @_builtins.property
    @pulumi.getter(name="errorMessages")
    def error_messages(self) -> Sequence[_builtins.str]:
        """
        List of error messages if the GCP Usage Cost configuration encountered any issues during setup or data processing.
        """
        return pulumi.get(self, "error_messages")

    @_builtins.property
    @pulumi.getter(name="exportPrefix")
    def export_prefix(self) -> _builtins.str:
        """
        The prefix path within the storage bucket where Usage Cost export files are organized.
        """
        return pulumi.get(self, "export_prefix")

    @_builtins.property
    @pulumi.getter(name="exportProjectName")
    def export_project_name(self) -> _builtins.str:
        """
        The Google Cloud Project ID where the Usage Cost export is configured.
        """
        return pulumi.get(self, "export_project_name")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The ID of this resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def months(self) -> _builtins.int:
        """
        The number of months of historical cost data available for analysis.
        """
        return pulumi.get(self, "months")

    @_builtins.property
    @pulumi.getter(name="serviceAccount")
    def service_account(self) -> _builtins.str:
        """
        The Google Cloud service account email that Datadog uses to access the Usage Cost export data.
        """
        return pulumi.get(self, "service_account")

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.str:
        """
        The current status of the GCP Usage Cost configuration (for example, active, error, or archived).
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter(name="statusUpdatedAt")
    def status_updated_at(self) -> _builtins.str:
        """
        The timestamp when the configuration status was last updated.
        """
        return pulumi.get(self, "status_updated_at")

    @_builtins.property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> _builtins.str:
        """
        The timestamp when the GCP Usage Cost configuration was last modified.
        """
        return pulumi.get(self, "updated_at")


class AwaitableGetGcpUcConfigResult(GetGcpUcConfigResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetGcpUcConfigResult(
            account_id=self.account_id,
            bucket_name=self.bucket_name,
            cloud_account_id=self.cloud_account_id,
            created_at=self.created_at,
            dataset=self.dataset,
            error_messages=self.error_messages,
            export_prefix=self.export_prefix,
            export_project_name=self.export_project_name,
            id=self.id,
            months=self.months,
            service_account=self.service_account,
            status=self.status,
            status_updated_at=self.status_updated_at,
            updated_at=self.updated_at)


def get_gcp_uc_config(cloud_account_id: Optional[_builtins.int] = None,
                      opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetGcpUcConfigResult:
    """
    Use this data source to retrieve information about a specific Datadog GCP Usage Cost configuration. This allows you to fetch details about an existing Cloud Cost Management configuration for GCP billing data access.


    :param _builtins.int cloud_account_id: The Datadog cloud account ID for the GCP Usage Cost configuration you want to retrieve information about.
    """
    __args__ = dict()
    __args__['cloudAccountId'] = cloud_account_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('datadog:index/getGcpUcConfig:getGcpUcConfig', __args__, opts=opts, typ=GetGcpUcConfigResult).value

    return AwaitableGetGcpUcConfigResult(
        account_id=pulumi.get(__ret__, 'account_id'),
        bucket_name=pulumi.get(__ret__, 'bucket_name'),
        cloud_account_id=pulumi.get(__ret__, 'cloud_account_id'),
        created_at=pulumi.get(__ret__, 'created_at'),
        dataset=pulumi.get(__ret__, 'dataset'),
        error_messages=pulumi.get(__ret__, 'error_messages'),
        export_prefix=pulumi.get(__ret__, 'export_prefix'),
        export_project_name=pulumi.get(__ret__, 'export_project_name'),
        id=pulumi.get(__ret__, 'id'),
        months=pulumi.get(__ret__, 'months'),
        service_account=pulumi.get(__ret__, 'service_account'),
        status=pulumi.get(__ret__, 'status'),
        status_updated_at=pulumi.get(__ret__, 'status_updated_at'),
        updated_at=pulumi.get(__ret__, 'updated_at'))
def get_gcp_uc_config_output(cloud_account_id: Optional[pulumi.Input[_builtins.int]] = None,
                             opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetGcpUcConfigResult]:
    """
    Use this data source to retrieve information about a specific Datadog GCP Usage Cost configuration. This allows you to fetch details about an existing Cloud Cost Management configuration for GCP billing data access.


    :param _builtins.int cloud_account_id: The Datadog cloud account ID for the GCP Usage Cost configuration you want to retrieve information about.
    """
    __args__ = dict()
    __args__['cloudAccountId'] = cloud_account_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('datadog:index/getGcpUcConfig:getGcpUcConfig', __args__, opts=opts, typ=GetGcpUcConfigResult)
    return __ret__.apply(lambda __response__: GetGcpUcConfigResult(
        account_id=pulumi.get(__response__, 'account_id'),
        bucket_name=pulumi.get(__response__, 'bucket_name'),
        cloud_account_id=pulumi.get(__response__, 'cloud_account_id'),
        created_at=pulumi.get(__response__, 'created_at'),
        dataset=pulumi.get(__response__, 'dataset'),
        error_messages=pulumi.get(__response__, 'error_messages'),
        export_prefix=pulumi.get(__response__, 'export_prefix'),
        export_project_name=pulumi.get(__response__, 'export_project_name'),
        id=pulumi.get(__response__, 'id'),
        months=pulumi.get(__response__, 'months'),
        service_account=pulumi.get(__response__, 'service_account'),
        status=pulumi.get(__response__, 'status'),
        status_updated_at=pulumi.get(__response__, 'status_updated_at'),
        updated_at=pulumi.get(__response__, 'updated_at')))
