# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetIncidentNotificationRuleResult',
    'AwaitableGetIncidentNotificationRuleResult',
    'get_incident_notification_rule',
    'get_incident_notification_rule_output',
]

@pulumi.output_type
class GetIncidentNotificationRuleResult:
    """
    A collection of values returned by getIncidentNotificationRule.
    """
    def __init__(__self__, conditions=None, created=None, enabled=None, handles=None, id=None, incident_type=None, modified=None, notification_template=None, renotify_ons=None, trigger=None, visibility=None):
        if conditions and not isinstance(conditions, list):
            raise TypeError("Expected argument 'conditions' to be a list")
        pulumi.set(__self__, "conditions", conditions)
        if created and not isinstance(created, str):
            raise TypeError("Expected argument 'created' to be a str")
        pulumi.set(__self__, "created", created)
        if enabled and not isinstance(enabled, bool):
            raise TypeError("Expected argument 'enabled' to be a bool")
        pulumi.set(__self__, "enabled", enabled)
        if handles and not isinstance(handles, list):
            raise TypeError("Expected argument 'handles' to be a list")
        pulumi.set(__self__, "handles", handles)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if incident_type and not isinstance(incident_type, str):
            raise TypeError("Expected argument 'incident_type' to be a str")
        pulumi.set(__self__, "incident_type", incident_type)
        if modified and not isinstance(modified, str):
            raise TypeError("Expected argument 'modified' to be a str")
        pulumi.set(__self__, "modified", modified)
        if notification_template and not isinstance(notification_template, str):
            raise TypeError("Expected argument 'notification_template' to be a str")
        pulumi.set(__self__, "notification_template", notification_template)
        if renotify_ons and not isinstance(renotify_ons, list):
            raise TypeError("Expected argument 'renotify_ons' to be a list")
        pulumi.set(__self__, "renotify_ons", renotify_ons)
        if trigger and not isinstance(trigger, str):
            raise TypeError("Expected argument 'trigger' to be a str")
        pulumi.set(__self__, "trigger", trigger)
        if visibility and not isinstance(visibility, str):
            raise TypeError("Expected argument 'visibility' to be a str")
        pulumi.set(__self__, "visibility", visibility)

    @_builtins.property
    @pulumi.getter
    def conditions(self) -> Optional[Sequence['outputs.GetIncidentNotificationRuleConditionResult']]:
        """
        The conditions that trigger this notification rule.
        """
        return pulumi.get(self, "conditions")

    @_builtins.property
    @pulumi.getter
    def created(self) -> _builtins.str:
        """
        Timestamp when the notification rule was created.
        """
        return pulumi.get(self, "created")

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> _builtins.bool:
        """
        Whether the notification rule is enabled.
        """
        return pulumi.get(self, "enabled")

    @_builtins.property
    @pulumi.getter
    def handles(self) -> Sequence[_builtins.str]:
        """
        The notification handles (targets) for this rule.
        """
        return pulumi.get(self, "handles")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The ID of the incident notification rule.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="incidentType")
    def incident_type(self) -> _builtins.str:
        """
        The ID of the incident type this notification rule is associated with.
        """
        return pulumi.get(self, "incident_type")

    @_builtins.property
    @pulumi.getter
    def modified(self) -> _builtins.str:
        """
        Timestamp when the notification rule was last modified.
        """
        return pulumi.get(self, "modified")

    @_builtins.property
    @pulumi.getter(name="notificationTemplate")
    def notification_template(self) -> _builtins.str:
        """
        The ID of the notification template used by this rule.
        """
        return pulumi.get(self, "notification_template")

    @_builtins.property
    @pulumi.getter(name="renotifyOns")
    def renotify_ons(self) -> Sequence[_builtins.str]:
        """
        List of incident fields that trigger re-notification when changed.
        """
        return pulumi.get(self, "renotify_ons")

    @_builtins.property
    @pulumi.getter
    def trigger(self) -> _builtins.str:
        """
        The trigger event for this notification rule.
        """
        return pulumi.get(self, "trigger")

    @_builtins.property
    @pulumi.getter
    def visibility(self) -> _builtins.str:
        """
        The visibility of the notification rule. Valid values are: all, organization, private.
        """
        return pulumi.get(self, "visibility")


class AwaitableGetIncidentNotificationRuleResult(GetIncidentNotificationRuleResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetIncidentNotificationRuleResult(
            conditions=self.conditions,
            created=self.created,
            enabled=self.enabled,
            handles=self.handles,
            id=self.id,
            incident_type=self.incident_type,
            modified=self.modified,
            notification_template=self.notification_template,
            renotify_ons=self.renotify_ons,
            trigger=self.trigger,
            visibility=self.visibility)


def get_incident_notification_rule(conditions: Optional[Sequence[Union['GetIncidentNotificationRuleConditionArgs', 'GetIncidentNotificationRuleConditionArgsDict']]] = None,
                                   id: Optional[_builtins.str] = None,
                                   opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetIncidentNotificationRuleResult:
    """
    Use this data source to retrieve information about an existing incident notification rule.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_datadog as datadog

    example = datadog.get_incident_notification_rule(id="00000000-0000-0000-0000-000000000000")
    ```


    :param Sequence[Union['GetIncidentNotificationRuleConditionArgs', 'GetIncidentNotificationRuleConditionArgsDict']] conditions: The conditions that trigger this notification rule.
    :param _builtins.str id: The ID of the incident notification rule.
    """
    __args__ = dict()
    __args__['conditions'] = conditions
    __args__['id'] = id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('datadog:index/getIncidentNotificationRule:getIncidentNotificationRule', __args__, opts=opts, typ=GetIncidentNotificationRuleResult).value

    return AwaitableGetIncidentNotificationRuleResult(
        conditions=pulumi.get(__ret__, 'conditions'),
        created=pulumi.get(__ret__, 'created'),
        enabled=pulumi.get(__ret__, 'enabled'),
        handles=pulumi.get(__ret__, 'handles'),
        id=pulumi.get(__ret__, 'id'),
        incident_type=pulumi.get(__ret__, 'incident_type'),
        modified=pulumi.get(__ret__, 'modified'),
        notification_template=pulumi.get(__ret__, 'notification_template'),
        renotify_ons=pulumi.get(__ret__, 'renotify_ons'),
        trigger=pulumi.get(__ret__, 'trigger'),
        visibility=pulumi.get(__ret__, 'visibility'))
def get_incident_notification_rule_output(conditions: Optional[pulumi.Input[Optional[Sequence[Union['GetIncidentNotificationRuleConditionArgs', 'GetIncidentNotificationRuleConditionArgsDict']]]]] = None,
                                          id: Optional[pulumi.Input[_builtins.str]] = None,
                                          opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetIncidentNotificationRuleResult]:
    """
    Use this data source to retrieve information about an existing incident notification rule.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_datadog as datadog

    example = datadog.get_incident_notification_rule(id="00000000-0000-0000-0000-000000000000")
    ```


    :param Sequence[Union['GetIncidentNotificationRuleConditionArgs', 'GetIncidentNotificationRuleConditionArgsDict']] conditions: The conditions that trigger this notification rule.
    :param _builtins.str id: The ID of the incident notification rule.
    """
    __args__ = dict()
    __args__['conditions'] = conditions
    __args__['id'] = id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('datadog:index/getIncidentNotificationRule:getIncidentNotificationRule', __args__, opts=opts, typ=GetIncidentNotificationRuleResult)
    return __ret__.apply(lambda __response__: GetIncidentNotificationRuleResult(
        conditions=pulumi.get(__response__, 'conditions'),
        created=pulumi.get(__response__, 'created'),
        enabled=pulumi.get(__response__, 'enabled'),
        handles=pulumi.get(__response__, 'handles'),
        id=pulumi.get(__response__, 'id'),
        incident_type=pulumi.get(__response__, 'incident_type'),
        modified=pulumi.get(__response__, 'modified'),
        notification_template=pulumi.get(__response__, 'notification_template'),
        renotify_ons=pulumi.get(__response__, 'renotify_ons'),
        trigger=pulumi.get(__response__, 'trigger'),
        visibility=pulumi.get(__response__, 'visibility')))
