# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs

__all__ = [
    'GetSecurityMonitoringRulesResult',
    'AwaitableGetSecurityMonitoringRulesResult',
    'get_security_monitoring_rules',
    'get_security_monitoring_rules_output',
]

@pulumi.output_type
class GetSecurityMonitoringRulesResult:
    """
    A collection of values returned by getSecurityMonitoringRules.
    """
    def __init__(__self__, default_only_filter=None, id=None, name_filter=None, rule_ids=None, rules=None, tags_filters=None, user_only_filter=None):
        if default_only_filter and not isinstance(default_only_filter, bool):
            raise TypeError("Expected argument 'default_only_filter' to be a bool")
        pulumi.set(__self__, "default_only_filter", default_only_filter)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if name_filter and not isinstance(name_filter, str):
            raise TypeError("Expected argument 'name_filter' to be a str")
        pulumi.set(__self__, "name_filter", name_filter)
        if rule_ids and not isinstance(rule_ids, list):
            raise TypeError("Expected argument 'rule_ids' to be a list")
        pulumi.set(__self__, "rule_ids", rule_ids)
        if rules and not isinstance(rules, list):
            raise TypeError("Expected argument 'rules' to be a list")
        pulumi.set(__self__, "rules", rules)
        if tags_filters and not isinstance(tags_filters, list):
            raise TypeError("Expected argument 'tags_filters' to be a list")
        pulumi.set(__self__, "tags_filters", tags_filters)
        if user_only_filter and not isinstance(user_only_filter, bool):
            raise TypeError("Expected argument 'user_only_filter' to be a bool")
        pulumi.set(__self__, "user_only_filter", user_only_filter)

    @_builtins.property
    @pulumi.getter(name="defaultOnlyFilter")
    def default_only_filter(self) -> Optional[_builtins.bool]:
        """
        Limit the search to default rules
        """
        return pulumi.get(self, "default_only_filter")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="nameFilter")
    def name_filter(self) -> Optional[_builtins.str]:
        """
        A rule name to limit the search
        """
        return pulumi.get(self, "name_filter")

    @_builtins.property
    @pulumi.getter(name="ruleIds")
    def rule_ids(self) -> Sequence[_builtins.str]:
        """
        List of IDs of the matched rules.
        """
        return pulumi.get(self, "rule_ids")

    @_builtins.property
    @pulumi.getter
    def rules(self) -> Sequence['outputs.GetSecurityMonitoringRulesRuleResult']:
        """
        List of rules.
        """
        return pulumi.get(self, "rules")

    @_builtins.property
    @pulumi.getter(name="tagsFilters")
    def tags_filters(self) -> Optional[Sequence[_builtins.str]]:
        """
        A list of tags to limit the search
        """
        return pulumi.get(self, "tags_filters")

    @_builtins.property
    @pulumi.getter(name="userOnlyFilter")
    def user_only_filter(self) -> Optional[_builtins.bool]:
        """
        Limit the search to user rules
        """
        return pulumi.get(self, "user_only_filter")


class AwaitableGetSecurityMonitoringRulesResult(GetSecurityMonitoringRulesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetSecurityMonitoringRulesResult(
            default_only_filter=self.default_only_filter,
            id=self.id,
            name_filter=self.name_filter,
            rule_ids=self.rule_ids,
            rules=self.rules,
            tags_filters=self.tags_filters,
            user_only_filter=self.user_only_filter)


def get_security_monitoring_rules(default_only_filter: Optional[_builtins.bool] = None,
                                  name_filter: Optional[_builtins.str] = None,
                                  tags_filters: Optional[Sequence[_builtins.str]] = None,
                                  user_only_filter: Optional[_builtins.bool] = None,
                                  opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetSecurityMonitoringRulesResult:
    """
    Use this data source to retrieve information about existing security monitoring rules for use in other resources.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_datadog as datadog

    test = datadog.get_security_monitoring_rules(name_filter="attack",
        tags_filters=["foo:bar"],
        default_only_filter=True)
    ```


    :param _builtins.bool default_only_filter: Limit the search to default rules
    :param _builtins.str name_filter: A rule name to limit the search
    :param Sequence[_builtins.str] tags_filters: A list of tags to limit the search
    :param _builtins.bool user_only_filter: Limit the search to user rules
    """
    __args__ = dict()
    __args__['defaultOnlyFilter'] = default_only_filter
    __args__['nameFilter'] = name_filter
    __args__['tagsFilters'] = tags_filters
    __args__['userOnlyFilter'] = user_only_filter
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('datadog:index/getSecurityMonitoringRules:getSecurityMonitoringRules', __args__, opts=opts, typ=GetSecurityMonitoringRulesResult).value

    return AwaitableGetSecurityMonitoringRulesResult(
        default_only_filter=pulumi.get(__ret__, 'default_only_filter'),
        id=pulumi.get(__ret__, 'id'),
        name_filter=pulumi.get(__ret__, 'name_filter'),
        rule_ids=pulumi.get(__ret__, 'rule_ids'),
        rules=pulumi.get(__ret__, 'rules'),
        tags_filters=pulumi.get(__ret__, 'tags_filters'),
        user_only_filter=pulumi.get(__ret__, 'user_only_filter'))
def get_security_monitoring_rules_output(default_only_filter: Optional[pulumi.Input[Optional[_builtins.bool]]] = None,
                                         name_filter: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                         tags_filters: Optional[pulumi.Input[Optional[Sequence[_builtins.str]]]] = None,
                                         user_only_filter: Optional[pulumi.Input[Optional[_builtins.bool]]] = None,
                                         opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetSecurityMonitoringRulesResult]:
    """
    Use this data source to retrieve information about existing security monitoring rules for use in other resources.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_datadog as datadog

    test = datadog.get_security_monitoring_rules(name_filter="attack",
        tags_filters=["foo:bar"],
        default_only_filter=True)
    ```


    :param _builtins.bool default_only_filter: Limit the search to default rules
    :param _builtins.str name_filter: A rule name to limit the search
    :param Sequence[_builtins.str] tags_filters: A list of tags to limit the search
    :param _builtins.bool user_only_filter: Limit the search to user rules
    """
    __args__ = dict()
    __args__['defaultOnlyFilter'] = default_only_filter
    __args__['nameFilter'] = name_filter
    __args__['tagsFilters'] = tags_filters
    __args__['userOnlyFilter'] = user_only_filter
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('datadog:index/getSecurityMonitoringRules:getSecurityMonitoringRules', __args__, opts=opts, typ=GetSecurityMonitoringRulesResult)
    return __ret__.apply(lambda __response__: GetSecurityMonitoringRulesResult(
        default_only_filter=pulumi.get(__response__, 'default_only_filter'),
        id=pulumi.get(__response__, 'id'),
        name_filter=pulumi.get(__response__, 'name_filter'),
        rule_ids=pulumi.get(__response__, 'rule_ids'),
        rules=pulumi.get(__response__, 'rules'),
        tags_filters=pulumi.get(__response__, 'tags_filters'),
        user_only_filter=pulumi.get(__response__, 'user_only_filter')))
