# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = [
    'GetServiceAccountResult',
    'AwaitableGetServiceAccountResult',
    'get_service_account',
    'get_service_account_output',
]

@pulumi.output_type
class GetServiceAccountResult:
    """
    A collection of values returned by getServiceAccount.
    """
    def __init__(__self__, disabled=None, email=None, exact_match=None, filter=None, filter_status=None, handle=None, icon=None, id=None, name=None, roles=None, status=None, title=None, verified=None):
        if disabled and not isinstance(disabled, bool):
            raise TypeError("Expected argument 'disabled' to be a bool")
        pulumi.set(__self__, "disabled", disabled)
        if email and not isinstance(email, str):
            raise TypeError("Expected argument 'email' to be a str")
        pulumi.set(__self__, "email", email)
        if exact_match and not isinstance(exact_match, bool):
            raise TypeError("Expected argument 'exact_match' to be a bool")
        pulumi.set(__self__, "exact_match", exact_match)
        if filter and not isinstance(filter, str):
            raise TypeError("Expected argument 'filter' to be a str")
        pulumi.set(__self__, "filter", filter)
        if filter_status and not isinstance(filter_status, str):
            raise TypeError("Expected argument 'filter_status' to be a str")
        pulumi.set(__self__, "filter_status", filter_status)
        if handle and not isinstance(handle, str):
            raise TypeError("Expected argument 'handle' to be a str")
        pulumi.set(__self__, "handle", handle)
        if icon and not isinstance(icon, str):
            raise TypeError("Expected argument 'icon' to be a str")
        pulumi.set(__self__, "icon", icon)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if roles and not isinstance(roles, list):
            raise TypeError("Expected argument 'roles' to be a list")
        pulumi.set(__self__, "roles", roles)
        if status and not isinstance(status, str):
            raise TypeError("Expected argument 'status' to be a str")
        pulumi.set(__self__, "status", status)
        if title and not isinstance(title, str):
            raise TypeError("Expected argument 'title' to be a str")
        pulumi.set(__self__, "title", title)
        if verified and not isinstance(verified, bool):
            raise TypeError("Expected argument 'verified' to be a bool")
        pulumi.set(__self__, "verified", verified)

    @_builtins.property
    @pulumi.getter
    def disabled(self) -> _builtins.bool:
        """
        Whether the user is disabled.
        """
        return pulumi.get(self, "disabled")

    @_builtins.property
    @pulumi.getter
    def email(self) -> _builtins.str:
        """
        Email of the user.
        """
        return pulumi.get(self, "email")

    @_builtins.property
    @pulumi.getter(name="exactMatch")
    def exact_match(self) -> Optional[_builtins.bool]:
        """
        When true, `filter` string is exact matched against the user's `email`, followed by `name` attribute.
        """
        return pulumi.get(self, "exact_match")

    @_builtins.property
    @pulumi.getter
    def filter(self) -> Optional[_builtins.str]:
        """
        Filter all users and service accounts by name, email, or role.
        """
        return pulumi.get(self, "filter")

    @_builtins.property
    @pulumi.getter(name="filterStatus")
    def filter_status(self) -> Optional[_builtins.str]:
        """
        Filter on status attribute. Comma separated list, with possible values `Active`, `Pending`, and `Disabled`.
        """
        return pulumi.get(self, "filter_status")

    @_builtins.property
    @pulumi.getter
    def handle(self) -> _builtins.str:
        """
        Handle of the user.
        """
        return pulumi.get(self, "handle")

    @_builtins.property
    @pulumi.getter
    def icon(self) -> _builtins.str:
        """
        URL of the user's icon.
        """
        return pulumi.get(self, "icon")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The service account's ID.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Name of the user.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def roles(self) -> Sequence[_builtins.str]:
        """
        Roles assigned to this service account.
        """
        return pulumi.get(self, "roles")

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.str:
        """
        Status of the user.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter
    def title(self) -> _builtins.str:
        """
        Title of the user.
        """
        return pulumi.get(self, "title")

    @_builtins.property
    @pulumi.getter
    def verified(self) -> _builtins.bool:
        """
        Whether the user is verified.
        """
        return pulumi.get(self, "verified")


class AwaitableGetServiceAccountResult(GetServiceAccountResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetServiceAccountResult(
            disabled=self.disabled,
            email=self.email,
            exact_match=self.exact_match,
            filter=self.filter,
            filter_status=self.filter_status,
            handle=self.handle,
            icon=self.icon,
            id=self.id,
            name=self.name,
            roles=self.roles,
            status=self.status,
            title=self.title,
            verified=self.verified)


def get_service_account(exact_match: Optional[_builtins.bool] = None,
                        filter: Optional[_builtins.str] = None,
                        filter_status: Optional[_builtins.str] = None,
                        id: Optional[_builtins.str] = None,
                        opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetServiceAccountResult:
    """
    Use this data source to retrieve information about an existing Datadog service account.


    :param _builtins.bool exact_match: When true, `filter` string is exact matched against the user's `email`, followed by `name` attribute.
    :param _builtins.str filter: Filter all users and service accounts by name, email, or role.
    :param _builtins.str filter_status: Filter on status attribute. Comma separated list, with possible values `Active`, `Pending`, and `Disabled`.
    :param _builtins.str id: The service account's ID.
    """
    __args__ = dict()
    __args__['exactMatch'] = exact_match
    __args__['filter'] = filter
    __args__['filterStatus'] = filter_status
    __args__['id'] = id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('datadog:index/getServiceAccount:getServiceAccount', __args__, opts=opts, typ=GetServiceAccountResult).value

    return AwaitableGetServiceAccountResult(
        disabled=pulumi.get(__ret__, 'disabled'),
        email=pulumi.get(__ret__, 'email'),
        exact_match=pulumi.get(__ret__, 'exact_match'),
        filter=pulumi.get(__ret__, 'filter'),
        filter_status=pulumi.get(__ret__, 'filter_status'),
        handle=pulumi.get(__ret__, 'handle'),
        icon=pulumi.get(__ret__, 'icon'),
        id=pulumi.get(__ret__, 'id'),
        name=pulumi.get(__ret__, 'name'),
        roles=pulumi.get(__ret__, 'roles'),
        status=pulumi.get(__ret__, 'status'),
        title=pulumi.get(__ret__, 'title'),
        verified=pulumi.get(__ret__, 'verified'))
def get_service_account_output(exact_match: Optional[pulumi.Input[Optional[_builtins.bool]]] = None,
                               filter: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                               filter_status: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                               id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                               opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetServiceAccountResult]:
    """
    Use this data source to retrieve information about an existing Datadog service account.


    :param _builtins.bool exact_match: When true, `filter` string is exact matched against the user's `email`, followed by `name` attribute.
    :param _builtins.str filter: Filter all users and service accounts by name, email, or role.
    :param _builtins.str filter_status: Filter on status attribute. Comma separated list, with possible values `Active`, `Pending`, and `Disabled`.
    :param _builtins.str id: The service account's ID.
    """
    __args__ = dict()
    __args__['exactMatch'] = exact_match
    __args__['filter'] = filter
    __args__['filterStatus'] = filter_status
    __args__['id'] = id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('datadog:index/getServiceAccount:getServiceAccount', __args__, opts=opts, typ=GetServiceAccountResult)
    return __ret__.apply(lambda __response__: GetServiceAccountResult(
        disabled=pulumi.get(__response__, 'disabled'),
        email=pulumi.get(__response__, 'email'),
        exact_match=pulumi.get(__response__, 'exact_match'),
        filter=pulumi.get(__response__, 'filter'),
        filter_status=pulumi.get(__response__, 'filter_status'),
        handle=pulumi.get(__response__, 'handle'),
        icon=pulumi.get(__response__, 'icon'),
        id=pulumi.get(__response__, 'id'),
        name=pulumi.get(__response__, 'name'),
        roles=pulumi.get(__response__, 'roles'),
        status=pulumi.get(__response__, 'status'),
        title=pulumi.get(__response__, 'title'),
        verified=pulumi.get(__response__, 'verified')))
