# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetTagPipelineRulesetResult',
    'AwaitableGetTagPipelineRulesetResult',
    'get_tag_pipeline_ruleset',
    'get_tag_pipeline_ruleset_output',
]

@pulumi.output_type
class GetTagPipelineRulesetResult:
    """
    A collection of values returned by getTagPipelineRuleset.
    """
    def __init__(__self__, enabled=None, id=None, name=None, position=None, rules=None, version=None):
        if enabled and not isinstance(enabled, bool):
            raise TypeError("Expected argument 'enabled' to be a bool")
        pulumi.set(__self__, "enabled", enabled)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if position and not isinstance(position, int):
            raise TypeError("Expected argument 'position' to be a int")
        pulumi.set(__self__, "position", position)
        if rules and not isinstance(rules, list):
            raise TypeError("Expected argument 'rules' to be a list")
        pulumi.set(__self__, "rules", rules)
        if version and not isinstance(version, int):
            raise TypeError("Expected argument 'version' to be a int")
        pulumi.set(__self__, "version", version)

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> _builtins.bool:
        """
        Whether the ruleset is enabled.
        """
        return pulumi.get(self, "enabled")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The ID of the ruleset.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name of the ruleset.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def position(self) -> _builtins.int:
        """
        The position of the ruleset in the pipeline.
        """
        return pulumi.get(self, "position")

    @_builtins.property
    @pulumi.getter
    def rules(self) -> Optional[Sequence['outputs.GetTagPipelineRulesetRuleResult']]:
        """
        The rules in the ruleset.
        """
        return pulumi.get(self, "rules")

    @_builtins.property
    @pulumi.getter
    def version(self) -> _builtins.int:
        """
        The version of the ruleset.
        """
        return pulumi.get(self, "version")


class AwaitableGetTagPipelineRulesetResult(GetTagPipelineRulesetResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetTagPipelineRulesetResult(
            enabled=self.enabled,
            id=self.id,
            name=self.name,
            position=self.position,
            rules=self.rules,
            version=self.version)


def get_tag_pipeline_ruleset(id: Optional[_builtins.str] = None,
                             rules: Optional[Sequence[Union['GetTagPipelineRulesetRuleArgs', 'GetTagPipelineRulesetRuleArgsDict']]] = None,
                             opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetTagPipelineRulesetResult:
    """
    Use this data source to retrieve information about an existing Datadog tag pipeline ruleset.


    :param _builtins.str id: The ID of the ruleset.
    :param Sequence[Union['GetTagPipelineRulesetRuleArgs', 'GetTagPipelineRulesetRuleArgsDict']] rules: The rules in the ruleset.
    """
    __args__ = dict()
    __args__['id'] = id
    __args__['rules'] = rules
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('datadog:index/getTagPipelineRuleset:getTagPipelineRuleset', __args__, opts=opts, typ=GetTagPipelineRulesetResult).value

    return AwaitableGetTagPipelineRulesetResult(
        enabled=pulumi.get(__ret__, 'enabled'),
        id=pulumi.get(__ret__, 'id'),
        name=pulumi.get(__ret__, 'name'),
        position=pulumi.get(__ret__, 'position'),
        rules=pulumi.get(__ret__, 'rules'),
        version=pulumi.get(__ret__, 'version'))
def get_tag_pipeline_ruleset_output(id: Optional[pulumi.Input[_builtins.str]] = None,
                                    rules: Optional[pulumi.Input[Optional[Sequence[Union['GetTagPipelineRulesetRuleArgs', 'GetTagPipelineRulesetRuleArgsDict']]]]] = None,
                                    opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetTagPipelineRulesetResult]:
    """
    Use this data source to retrieve information about an existing Datadog tag pipeline ruleset.


    :param _builtins.str id: The ID of the ruleset.
    :param Sequence[Union['GetTagPipelineRulesetRuleArgs', 'GetTagPipelineRulesetRuleArgsDict']] rules: The rules in the ruleset.
    """
    __args__ = dict()
    __args__['id'] = id
    __args__['rules'] = rules
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('datadog:index/getTagPipelineRuleset:getTagPipelineRuleset', __args__, opts=opts, typ=GetTagPipelineRulesetResult)
    return __ret__.apply(lambda __response__: GetTagPipelineRulesetResult(
        enabled=pulumi.get(__response__, 'enabled'),
        id=pulumi.get(__response__, 'id'),
        name=pulumi.get(__response__, 'name'),
        position=pulumi.get(__response__, 'position'),
        rules=pulumi.get(__response__, 'rules'),
        version=pulumi.get(__response__, 'version')))
