# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['IncidentNotificationRuleArgs', 'IncidentNotificationRule']

@pulumi.input_type
class IncidentNotificationRuleArgs:
    def __init__(__self__, *,
                 handles: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]],
                 incident_type: pulumi.Input[_builtins.str],
                 trigger: pulumi.Input[_builtins.str],
                 conditions: Optional[pulumi.Input[Sequence[pulumi.Input['IncidentNotificationRuleConditionArgs']]]] = None,
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 notification_template: Optional[pulumi.Input[_builtins.str]] = None,
                 renotify_ons: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 visibility: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a IncidentNotificationRule resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] handles: The notification handles (targets) for this rule. Examples: @team-email@company.com, @slack-channel.
        :param pulumi.Input[_builtins.str] incident_type: The ID of the incident type this notification rule is associated with.
        :param pulumi.Input[_builtins.str] trigger: The trigger event for this notification rule. Valid values are: incident*created*trigger, incident*saved*trigger.
        :param pulumi.Input[Sequence[pulumi.Input['IncidentNotificationRuleConditionArgs']]] conditions: The conditions that trigger this notification rule. At least one condition is required.
        :param pulumi.Input[_builtins.bool] enabled: Whether the notification rule is enabled. Defaults to `false`.
        :param pulumi.Input[_builtins.str] notification_template: The ID of the notification template to use for this rule.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] renotify_ons: List of incident fields that trigger re-notification when changed. Valid values are: status, severity, customer*impact, title, description, detected, root*cause, services, state.
        :param pulumi.Input[_builtins.str] visibility: The visibility of the notification rule. Valid values are: all, organization, private. Defaults to organization.
        """
        pulumi.set(__self__, "handles", handles)
        pulumi.set(__self__, "incident_type", incident_type)
        pulumi.set(__self__, "trigger", trigger)
        if conditions is not None:
            pulumi.set(__self__, "conditions", conditions)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if notification_template is not None:
            pulumi.set(__self__, "notification_template", notification_template)
        if renotify_ons is not None:
            pulumi.set(__self__, "renotify_ons", renotify_ons)
        if visibility is not None:
            pulumi.set(__self__, "visibility", visibility)

    @_builtins.property
    @pulumi.getter
    def handles(self) -> pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]:
        """
        The notification handles (targets) for this rule. Examples: @team-email@company.com, @slack-channel.
        """
        return pulumi.get(self, "handles")

    @handles.setter
    def handles(self, value: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]):
        pulumi.set(self, "handles", value)

    @_builtins.property
    @pulumi.getter(name="incidentType")
    def incident_type(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the incident type this notification rule is associated with.
        """
        return pulumi.get(self, "incident_type")

    @incident_type.setter
    def incident_type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "incident_type", value)

    @_builtins.property
    @pulumi.getter
    def trigger(self) -> pulumi.Input[_builtins.str]:
        """
        The trigger event for this notification rule. Valid values are: incident*created*trigger, incident*saved*trigger.
        """
        return pulumi.get(self, "trigger")

    @trigger.setter
    def trigger(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "trigger", value)

    @_builtins.property
    @pulumi.getter
    def conditions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['IncidentNotificationRuleConditionArgs']]]]:
        """
        The conditions that trigger this notification rule. At least one condition is required.
        """
        return pulumi.get(self, "conditions")

    @conditions.setter
    def conditions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['IncidentNotificationRuleConditionArgs']]]]):
        pulumi.set(self, "conditions", value)

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether the notification rule is enabled. Defaults to `false`.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enabled", value)

    @_builtins.property
    @pulumi.getter(name="notificationTemplate")
    def notification_template(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the notification template to use for this rule.
        """
        return pulumi.get(self, "notification_template")

    @notification_template.setter
    def notification_template(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "notification_template", value)

    @_builtins.property
    @pulumi.getter(name="renotifyOns")
    def renotify_ons(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of incident fields that trigger re-notification when changed. Valid values are: status, severity, customer*impact, title, description, detected, root*cause, services, state.
        """
        return pulumi.get(self, "renotify_ons")

    @renotify_ons.setter
    def renotify_ons(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "renotify_ons", value)

    @_builtins.property
    @pulumi.getter
    def visibility(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The visibility of the notification rule. Valid values are: all, organization, private. Defaults to organization.
        """
        return pulumi.get(self, "visibility")

    @visibility.setter
    def visibility(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "visibility", value)


@pulumi.input_type
class _IncidentNotificationRuleState:
    def __init__(__self__, *,
                 conditions: Optional[pulumi.Input[Sequence[pulumi.Input['IncidentNotificationRuleConditionArgs']]]] = None,
                 created: Optional[pulumi.Input[_builtins.str]] = None,
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 handles: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 incident_type: Optional[pulumi.Input[_builtins.str]] = None,
                 modified: Optional[pulumi.Input[_builtins.str]] = None,
                 notification_template: Optional[pulumi.Input[_builtins.str]] = None,
                 renotify_ons: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 trigger: Optional[pulumi.Input[_builtins.str]] = None,
                 visibility: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering IncidentNotificationRule resources.
        :param pulumi.Input[Sequence[pulumi.Input['IncidentNotificationRuleConditionArgs']]] conditions: The conditions that trigger this notification rule. At least one condition is required.
        :param pulumi.Input[_builtins.str] created: Timestamp when the notification rule was created.
        :param pulumi.Input[_builtins.bool] enabled: Whether the notification rule is enabled. Defaults to `false`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] handles: The notification handles (targets) for this rule. Examples: @team-email@company.com, @slack-channel.
        :param pulumi.Input[_builtins.str] incident_type: The ID of the incident type this notification rule is associated with.
        :param pulumi.Input[_builtins.str] modified: Timestamp when the notification rule was last modified.
        :param pulumi.Input[_builtins.str] notification_template: The ID of the notification template to use for this rule.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] renotify_ons: List of incident fields that trigger re-notification when changed. Valid values are: status, severity, customer*impact, title, description, detected, root*cause, services, state.
        :param pulumi.Input[_builtins.str] trigger: The trigger event for this notification rule. Valid values are: incident*created*trigger, incident*saved*trigger.
        :param pulumi.Input[_builtins.str] visibility: The visibility of the notification rule. Valid values are: all, organization, private. Defaults to organization.
        """
        if conditions is not None:
            pulumi.set(__self__, "conditions", conditions)
        if created is not None:
            pulumi.set(__self__, "created", created)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if handles is not None:
            pulumi.set(__self__, "handles", handles)
        if incident_type is not None:
            pulumi.set(__self__, "incident_type", incident_type)
        if modified is not None:
            pulumi.set(__self__, "modified", modified)
        if notification_template is not None:
            pulumi.set(__self__, "notification_template", notification_template)
        if renotify_ons is not None:
            pulumi.set(__self__, "renotify_ons", renotify_ons)
        if trigger is not None:
            pulumi.set(__self__, "trigger", trigger)
        if visibility is not None:
            pulumi.set(__self__, "visibility", visibility)

    @_builtins.property
    @pulumi.getter
    def conditions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['IncidentNotificationRuleConditionArgs']]]]:
        """
        The conditions that trigger this notification rule. At least one condition is required.
        """
        return pulumi.get(self, "conditions")

    @conditions.setter
    def conditions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['IncidentNotificationRuleConditionArgs']]]]):
        pulumi.set(self, "conditions", value)

    @_builtins.property
    @pulumi.getter
    def created(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Timestamp when the notification rule was created.
        """
        return pulumi.get(self, "created")

    @created.setter
    def created(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "created", value)

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether the notification rule is enabled. Defaults to `false`.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enabled", value)

    @_builtins.property
    @pulumi.getter
    def handles(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The notification handles (targets) for this rule. Examples: @team-email@company.com, @slack-channel.
        """
        return pulumi.get(self, "handles")

    @handles.setter
    def handles(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "handles", value)

    @_builtins.property
    @pulumi.getter(name="incidentType")
    def incident_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the incident type this notification rule is associated with.
        """
        return pulumi.get(self, "incident_type")

    @incident_type.setter
    def incident_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "incident_type", value)

    @_builtins.property
    @pulumi.getter
    def modified(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Timestamp when the notification rule was last modified.
        """
        return pulumi.get(self, "modified")

    @modified.setter
    def modified(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "modified", value)

    @_builtins.property
    @pulumi.getter(name="notificationTemplate")
    def notification_template(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the notification template to use for this rule.
        """
        return pulumi.get(self, "notification_template")

    @notification_template.setter
    def notification_template(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "notification_template", value)

    @_builtins.property
    @pulumi.getter(name="renotifyOns")
    def renotify_ons(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of incident fields that trigger re-notification when changed. Valid values are: status, severity, customer*impact, title, description, detected, root*cause, services, state.
        """
        return pulumi.get(self, "renotify_ons")

    @renotify_ons.setter
    def renotify_ons(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "renotify_ons", value)

    @_builtins.property
    @pulumi.getter
    def trigger(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The trigger event for this notification rule. Valid values are: incident*created*trigger, incident*saved*trigger.
        """
        return pulumi.get(self, "trigger")

    @trigger.setter
    def trigger(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "trigger", value)

    @_builtins.property
    @pulumi.getter
    def visibility(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The visibility of the notification rule. Valid values are: all, organization, private. Defaults to organization.
        """
        return pulumi.get(self, "visibility")

    @visibility.setter
    def visibility(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "visibility", value)


@pulumi.type_token("datadog:index/incidentNotificationRule:IncidentNotificationRule")
class IncidentNotificationRule(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 conditions: Optional[pulumi.Input[Sequence[pulumi.Input[Union['IncidentNotificationRuleConditionArgs', 'IncidentNotificationRuleConditionArgsDict']]]]] = None,
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 handles: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 incident_type: Optional[pulumi.Input[_builtins.str]] = None,
                 notification_template: Optional[pulumi.Input[_builtins.str]] = None,
                 renotify_ons: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 trigger: Optional[pulumi.Input[_builtins.str]] = None,
                 visibility: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Provides a Datadog incident notification rule resource. This can be used to create and manage Datadog incident notification rules.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_datadog as datadog

        example = datadog.IncidentType("example",
            name="My Incident Type",
            description="Incident type for critical production issues")
        example_incident_notification_template = datadog.IncidentNotificationTemplate("example",
            name="My Notification Template",
            subject="SEV-1 Incident: {{incident.title}}",
            content=\"\"\"An incident has been declared.

        Title: {{incident.title}}
        Severity: {{incident.severity}}
        Status: {{incident.status}}

        Please join the incident channel for updates.
        \"\"\",
            category="alert",
            incident_type=example.id)
        example_incident_notification_rule = datadog.IncidentNotificationRule("example",
            enabled=True,
            trigger="incident_created_trigger",
            visibility="organization",
            handles=[
                "@team-email@company.com",
                "@slack-channel-alerts",
                "@pagerduty-service",
            ],
            conditions=[
                {
                    "field": "severity",
                    "values": [
                        "SEV-1",
                        "SEV-2",
                    ],
                },
                {
                    "field": "services",
                    "values": [
                        "web-service",
                        "api-service",
                        "database-service",
                    ],
                },
            ],
            renotify_ons=[
                "status",
                "severity",
            ],
            incident_type=example.id,
            notification_template=example_incident_notification_template.id)
        ```

        ## Import

        The `pulumi import` command can be used, for example:

        ```sh
        $ pulumi import datadog:index/incidentNotificationRule:IncidentNotificationRule example "00000000-0000-0000-0000-000000000000"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['IncidentNotificationRuleConditionArgs', 'IncidentNotificationRuleConditionArgsDict']]]] conditions: The conditions that trigger this notification rule. At least one condition is required.
        :param pulumi.Input[_builtins.bool] enabled: Whether the notification rule is enabled. Defaults to `false`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] handles: The notification handles (targets) for this rule. Examples: @team-email@company.com, @slack-channel.
        :param pulumi.Input[_builtins.str] incident_type: The ID of the incident type this notification rule is associated with.
        :param pulumi.Input[_builtins.str] notification_template: The ID of the notification template to use for this rule.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] renotify_ons: List of incident fields that trigger re-notification when changed. Valid values are: status, severity, customer*impact, title, description, detected, root*cause, services, state.
        :param pulumi.Input[_builtins.str] trigger: The trigger event for this notification rule. Valid values are: incident*created*trigger, incident*saved*trigger.
        :param pulumi.Input[_builtins.str] visibility: The visibility of the notification rule. Valid values are: all, organization, private. Defaults to organization.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: IncidentNotificationRuleArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Datadog incident notification rule resource. This can be used to create and manage Datadog incident notification rules.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_datadog as datadog

        example = datadog.IncidentType("example",
            name="My Incident Type",
            description="Incident type for critical production issues")
        example_incident_notification_template = datadog.IncidentNotificationTemplate("example",
            name="My Notification Template",
            subject="SEV-1 Incident: {{incident.title}}",
            content=\"\"\"An incident has been declared.

        Title: {{incident.title}}
        Severity: {{incident.severity}}
        Status: {{incident.status}}

        Please join the incident channel for updates.
        \"\"\",
            category="alert",
            incident_type=example.id)
        example_incident_notification_rule = datadog.IncidentNotificationRule("example",
            enabled=True,
            trigger="incident_created_trigger",
            visibility="organization",
            handles=[
                "@team-email@company.com",
                "@slack-channel-alerts",
                "@pagerduty-service",
            ],
            conditions=[
                {
                    "field": "severity",
                    "values": [
                        "SEV-1",
                        "SEV-2",
                    ],
                },
                {
                    "field": "services",
                    "values": [
                        "web-service",
                        "api-service",
                        "database-service",
                    ],
                },
            ],
            renotify_ons=[
                "status",
                "severity",
            ],
            incident_type=example.id,
            notification_template=example_incident_notification_template.id)
        ```

        ## Import

        The `pulumi import` command can be used, for example:

        ```sh
        $ pulumi import datadog:index/incidentNotificationRule:IncidentNotificationRule example "00000000-0000-0000-0000-000000000000"
        ```

        :param str resource_name: The name of the resource.
        :param IncidentNotificationRuleArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(IncidentNotificationRuleArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 conditions: Optional[pulumi.Input[Sequence[pulumi.Input[Union['IncidentNotificationRuleConditionArgs', 'IncidentNotificationRuleConditionArgsDict']]]]] = None,
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 handles: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 incident_type: Optional[pulumi.Input[_builtins.str]] = None,
                 notification_template: Optional[pulumi.Input[_builtins.str]] = None,
                 renotify_ons: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 trigger: Optional[pulumi.Input[_builtins.str]] = None,
                 visibility: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = IncidentNotificationRuleArgs.__new__(IncidentNotificationRuleArgs)

            __props__.__dict__["conditions"] = conditions
            __props__.__dict__["enabled"] = enabled
            if handles is None and not opts.urn:
                raise TypeError("Missing required property 'handles'")
            __props__.__dict__["handles"] = handles
            if incident_type is None and not opts.urn:
                raise TypeError("Missing required property 'incident_type'")
            __props__.__dict__["incident_type"] = incident_type
            __props__.__dict__["notification_template"] = notification_template
            __props__.__dict__["renotify_ons"] = renotify_ons
            if trigger is None and not opts.urn:
                raise TypeError("Missing required property 'trigger'")
            __props__.__dict__["trigger"] = trigger
            __props__.__dict__["visibility"] = visibility
            __props__.__dict__["created"] = None
            __props__.__dict__["modified"] = None
        super(IncidentNotificationRule, __self__).__init__(
            'datadog:index/incidentNotificationRule:IncidentNotificationRule',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            conditions: Optional[pulumi.Input[Sequence[pulumi.Input[Union['IncidentNotificationRuleConditionArgs', 'IncidentNotificationRuleConditionArgsDict']]]]] = None,
            created: Optional[pulumi.Input[_builtins.str]] = None,
            enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            handles: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            incident_type: Optional[pulumi.Input[_builtins.str]] = None,
            modified: Optional[pulumi.Input[_builtins.str]] = None,
            notification_template: Optional[pulumi.Input[_builtins.str]] = None,
            renotify_ons: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            trigger: Optional[pulumi.Input[_builtins.str]] = None,
            visibility: Optional[pulumi.Input[_builtins.str]] = None) -> 'IncidentNotificationRule':
        """
        Get an existing IncidentNotificationRule resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['IncidentNotificationRuleConditionArgs', 'IncidentNotificationRuleConditionArgsDict']]]] conditions: The conditions that trigger this notification rule. At least one condition is required.
        :param pulumi.Input[_builtins.str] created: Timestamp when the notification rule was created.
        :param pulumi.Input[_builtins.bool] enabled: Whether the notification rule is enabled. Defaults to `false`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] handles: The notification handles (targets) for this rule. Examples: @team-email@company.com, @slack-channel.
        :param pulumi.Input[_builtins.str] incident_type: The ID of the incident type this notification rule is associated with.
        :param pulumi.Input[_builtins.str] modified: Timestamp when the notification rule was last modified.
        :param pulumi.Input[_builtins.str] notification_template: The ID of the notification template to use for this rule.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] renotify_ons: List of incident fields that trigger re-notification when changed. Valid values are: status, severity, customer*impact, title, description, detected, root*cause, services, state.
        :param pulumi.Input[_builtins.str] trigger: The trigger event for this notification rule. Valid values are: incident*created*trigger, incident*saved*trigger.
        :param pulumi.Input[_builtins.str] visibility: The visibility of the notification rule. Valid values are: all, organization, private. Defaults to organization.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _IncidentNotificationRuleState.__new__(_IncidentNotificationRuleState)

        __props__.__dict__["conditions"] = conditions
        __props__.__dict__["created"] = created
        __props__.__dict__["enabled"] = enabled
        __props__.__dict__["handles"] = handles
        __props__.__dict__["incident_type"] = incident_type
        __props__.__dict__["modified"] = modified
        __props__.__dict__["notification_template"] = notification_template
        __props__.__dict__["renotify_ons"] = renotify_ons
        __props__.__dict__["trigger"] = trigger
        __props__.__dict__["visibility"] = visibility
        return IncidentNotificationRule(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def conditions(self) -> pulumi.Output[Optional[Sequence['outputs.IncidentNotificationRuleCondition']]]:
        """
        The conditions that trigger this notification rule. At least one condition is required.
        """
        return pulumi.get(self, "conditions")

    @_builtins.property
    @pulumi.getter
    def created(self) -> pulumi.Output[_builtins.str]:
        """
        Timestamp when the notification rule was created.
        """
        return pulumi.get(self, "created")

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> pulumi.Output[_builtins.bool]:
        """
        Whether the notification rule is enabled. Defaults to `false`.
        """
        return pulumi.get(self, "enabled")

    @_builtins.property
    @pulumi.getter
    def handles(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        The notification handles (targets) for this rule. Examples: @team-email@company.com, @slack-channel.
        """
        return pulumi.get(self, "handles")

    @_builtins.property
    @pulumi.getter(name="incidentType")
    def incident_type(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the incident type this notification rule is associated with.
        """
        return pulumi.get(self, "incident_type")

    @_builtins.property
    @pulumi.getter
    def modified(self) -> pulumi.Output[_builtins.str]:
        """
        Timestamp when the notification rule was last modified.
        """
        return pulumi.get(self, "modified")

    @_builtins.property
    @pulumi.getter(name="notificationTemplate")
    def notification_template(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The ID of the notification template to use for this rule.
        """
        return pulumi.get(self, "notification_template")

    @_builtins.property
    @pulumi.getter(name="renotifyOns")
    def renotify_ons(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        List of incident fields that trigger re-notification when changed. Valid values are: status, severity, customer*impact, title, description, detected, root*cause, services, state.
        """
        return pulumi.get(self, "renotify_ons")

    @_builtins.property
    @pulumi.getter
    def trigger(self) -> pulumi.Output[_builtins.str]:
        """
        The trigger event for this notification rule. Valid values are: incident*created*trigger, incident*saved*trigger.
        """
        return pulumi.get(self, "trigger")

    @_builtins.property
    @pulumi.getter
    def visibility(self) -> pulumi.Output[_builtins.str]:
        """
        The visibility of the notification rule. Valid values are: all, organization, private. Defaults to organization.
        """
        return pulumi.get(self, "visibility")

