# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['IncidentTypeArgs', 'IncidentType']

@pulumi.input_type
class IncidentTypeArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[_builtins.str],
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 is_default: Optional[pulumi.Input[_builtins.bool]] = None):
        """
        The set of arguments for constructing a IncidentType resource.
        :param pulumi.Input[_builtins.str] name: Name of the incident type. Must be between 1 and 50 characters.
        :param pulumi.Input[_builtins.str] description: Description of the incident type. The description can have a maximum of 512 characters.
        :param pulumi.Input[_builtins.bool] is_default: Whether this incident type is the default type.
        """
        pulumi.set(__self__, "name", name)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if is_default is not None:
            pulumi.set(__self__, "is_default", is_default)

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Input[_builtins.str]:
        """
        Name of the incident type. Must be between 1 and 50 characters.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Description of the incident type. The description can have a maximum of 512 characters.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="isDefault")
    def is_default(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether this incident type is the default type.
        """
        return pulumi.get(self, "is_default")

    @is_default.setter
    def is_default(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "is_default", value)


@pulumi.input_type
class _IncidentTypeState:
    def __init__(__self__, *,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 is_default: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering IncidentType resources.
        :param pulumi.Input[_builtins.str] description: Description of the incident type. The description can have a maximum of 512 characters.
        :param pulumi.Input[_builtins.bool] is_default: Whether this incident type is the default type.
        :param pulumi.Input[_builtins.str] name: Name of the incident type. Must be between 1 and 50 characters.
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if is_default is not None:
            pulumi.set(__self__, "is_default", is_default)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Description of the incident type. The description can have a maximum of 512 characters.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="isDefault")
    def is_default(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether this incident type is the default type.
        """
        return pulumi.get(self, "is_default")

    @is_default.setter
    def is_default(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "is_default", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the incident type. Must be between 1 and 50 characters.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)


@pulumi.type_token("datadog:index/incidentType:IncidentType")
class IncidentType(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 is_default: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Provides a Datadog incident type resource. This can be used to create and manage Datadog incident types.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_datadog as datadog

        # Basic incident type
        example = datadog.IncidentType("example",
            name="Security Incident",
            description="Security-related incidents requiring immediate attention",
            is_default=False)
        ```

        ## Import

        The `pulumi import` command can be used, for example:

        ```sh
        $ pulumi import datadog:index/incidentType:IncidentType example "12345678-1234-1234-1234-1234567890ab"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] description: Description of the incident type. The description can have a maximum of 512 characters.
        :param pulumi.Input[_builtins.bool] is_default: Whether this incident type is the default type.
        :param pulumi.Input[_builtins.str] name: Name of the incident type. Must be between 1 and 50 characters.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: IncidentTypeArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Datadog incident type resource. This can be used to create and manage Datadog incident types.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_datadog as datadog

        # Basic incident type
        example = datadog.IncidentType("example",
            name="Security Incident",
            description="Security-related incidents requiring immediate attention",
            is_default=False)
        ```

        ## Import

        The `pulumi import` command can be used, for example:

        ```sh
        $ pulumi import datadog:index/incidentType:IncidentType example "12345678-1234-1234-1234-1234567890ab"
        ```

        :param str resource_name: The name of the resource.
        :param IncidentTypeArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(IncidentTypeArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 is_default: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = IncidentTypeArgs.__new__(IncidentTypeArgs)

            __props__.__dict__["description"] = description
            __props__.__dict__["is_default"] = is_default
            if name is None and not opts.urn:
                raise TypeError("Missing required property 'name'")
            __props__.__dict__["name"] = name
        super(IncidentType, __self__).__init__(
            'datadog:index/incidentType:IncidentType',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            is_default: Optional[pulumi.Input[_builtins.bool]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None) -> 'IncidentType':
        """
        Get an existing IncidentType resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] description: Description of the incident type. The description can have a maximum of 512 characters.
        :param pulumi.Input[_builtins.bool] is_default: Whether this incident type is the default type.
        :param pulumi.Input[_builtins.str] name: Name of the incident type. Must be between 1 and 50 characters.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _IncidentTypeState.__new__(_IncidentTypeState)

        __props__.__dict__["description"] = description
        __props__.__dict__["is_default"] = is_default
        __props__.__dict__["name"] = name
        return IncidentType(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Description of the incident type. The description can have a maximum of 512 characters.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="isDefault")
    def is_default(self) -> pulumi.Output[_builtins.bool]:
        """
        Whether this incident type is the default type.
        """
        return pulumi.get(self, "is_default")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Name of the incident type. Must be between 1 and 50 characters.
        """
        return pulumi.get(self, "name")

