# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['MetricTagConfigurationArgs', 'MetricTagConfiguration']

@pulumi.input_type
class MetricTagConfigurationArgs:
    def __init__(__self__, *,
                 metric_name: pulumi.Input[_builtins.str],
                 metric_type: pulumi.Input[_builtins.str],
                 tags: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]],
                 aggregations: Optional[pulumi.Input[Sequence[pulumi.Input['MetricTagConfigurationAggregationArgs']]]] = None,
                 exclude_tags_mode: Optional[pulumi.Input[_builtins.bool]] = None,
                 include_percentiles: Optional[pulumi.Input[_builtins.bool]] = None):
        """
        The set of arguments for constructing a MetricTagConfiguration resource.
        :param pulumi.Input[_builtins.str] metric_name: The metric name for this resource.
        :param pulumi.Input[_builtins.str] metric_type: The metric's type. This field can't be updated after creation. Valid values are `gauge`, `count`, `rate`, `distribution`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] tags: A list of tag keys that will be queryable for your metric.
        :param pulumi.Input[Sequence[pulumi.Input['MetricTagConfigurationAggregationArgs']]] aggregations: A list of queryable aggregation combinations for a count, rate, or gauge metric. By default, count and rate metrics require the (time: sum, space: sum) aggregation and gauge metrics require the (time: avg, space: avg) aggregation. Can only be applied to metrics that have a `metric_type` of count, rate, or gauge.
        :param pulumi.Input[_builtins.bool] exclude_tags_mode: Toggle to include/exclude tags as queryable for your metric. Can only be applied to metrics that have one or more tags configured. Defaults to `false`.
        :param pulumi.Input[_builtins.bool] include_percentiles: Toggle to include/exclude percentiles for a distribution metric. Defaults to false. Can only be applied to metrics that have a `metric_type` of distribution.
        """
        pulumi.set(__self__, "metric_name", metric_name)
        pulumi.set(__self__, "metric_type", metric_type)
        pulumi.set(__self__, "tags", tags)
        if aggregations is not None:
            pulumi.set(__self__, "aggregations", aggregations)
        if exclude_tags_mode is not None:
            pulumi.set(__self__, "exclude_tags_mode", exclude_tags_mode)
        if include_percentiles is not None:
            pulumi.set(__self__, "include_percentiles", include_percentiles)

    @_builtins.property
    @pulumi.getter(name="metricName")
    def metric_name(self) -> pulumi.Input[_builtins.str]:
        """
        The metric name for this resource.
        """
        return pulumi.get(self, "metric_name")

    @metric_name.setter
    def metric_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "metric_name", value)

    @_builtins.property
    @pulumi.getter(name="metricType")
    def metric_type(self) -> pulumi.Input[_builtins.str]:
        """
        The metric's type. This field can't be updated after creation. Valid values are `gauge`, `count`, `rate`, `distribution`.
        """
        return pulumi.get(self, "metric_type")

    @metric_type.setter
    def metric_type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "metric_type", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]:
        """
        A list of tag keys that will be queryable for your metric.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter
    def aggregations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['MetricTagConfigurationAggregationArgs']]]]:
        """
        A list of queryable aggregation combinations for a count, rate, or gauge metric. By default, count and rate metrics require the (time: sum, space: sum) aggregation and gauge metrics require the (time: avg, space: avg) aggregation. Can only be applied to metrics that have a `metric_type` of count, rate, or gauge.
        """
        return pulumi.get(self, "aggregations")

    @aggregations.setter
    def aggregations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['MetricTagConfigurationAggregationArgs']]]]):
        pulumi.set(self, "aggregations", value)

    @_builtins.property
    @pulumi.getter(name="excludeTagsMode")
    def exclude_tags_mode(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Toggle to include/exclude tags as queryable for your metric. Can only be applied to metrics that have one or more tags configured. Defaults to `false`.
        """
        return pulumi.get(self, "exclude_tags_mode")

    @exclude_tags_mode.setter
    def exclude_tags_mode(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "exclude_tags_mode", value)

    @_builtins.property
    @pulumi.getter(name="includePercentiles")
    def include_percentiles(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Toggle to include/exclude percentiles for a distribution metric. Defaults to false. Can only be applied to metrics that have a `metric_type` of distribution.
        """
        return pulumi.get(self, "include_percentiles")

    @include_percentiles.setter
    def include_percentiles(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "include_percentiles", value)


@pulumi.input_type
class _MetricTagConfigurationState:
    def __init__(__self__, *,
                 aggregations: Optional[pulumi.Input[Sequence[pulumi.Input['MetricTagConfigurationAggregationArgs']]]] = None,
                 exclude_tags_mode: Optional[pulumi.Input[_builtins.bool]] = None,
                 include_percentiles: Optional[pulumi.Input[_builtins.bool]] = None,
                 metric_name: Optional[pulumi.Input[_builtins.str]] = None,
                 metric_type: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None):
        """
        Input properties used for looking up and filtering MetricTagConfiguration resources.
        :param pulumi.Input[Sequence[pulumi.Input['MetricTagConfigurationAggregationArgs']]] aggregations: A list of queryable aggregation combinations for a count, rate, or gauge metric. By default, count and rate metrics require the (time: sum, space: sum) aggregation and gauge metrics require the (time: avg, space: avg) aggregation. Can only be applied to metrics that have a `metric_type` of count, rate, or gauge.
        :param pulumi.Input[_builtins.bool] exclude_tags_mode: Toggle to include/exclude tags as queryable for your metric. Can only be applied to metrics that have one or more tags configured. Defaults to `false`.
        :param pulumi.Input[_builtins.bool] include_percentiles: Toggle to include/exclude percentiles for a distribution metric. Defaults to false. Can only be applied to metrics that have a `metric_type` of distribution.
        :param pulumi.Input[_builtins.str] metric_name: The metric name for this resource.
        :param pulumi.Input[_builtins.str] metric_type: The metric's type. This field can't be updated after creation. Valid values are `gauge`, `count`, `rate`, `distribution`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] tags: A list of tag keys that will be queryable for your metric.
        """
        if aggregations is not None:
            pulumi.set(__self__, "aggregations", aggregations)
        if exclude_tags_mode is not None:
            pulumi.set(__self__, "exclude_tags_mode", exclude_tags_mode)
        if include_percentiles is not None:
            pulumi.set(__self__, "include_percentiles", include_percentiles)
        if metric_name is not None:
            pulumi.set(__self__, "metric_name", metric_name)
        if metric_type is not None:
            pulumi.set(__self__, "metric_type", metric_type)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter
    def aggregations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['MetricTagConfigurationAggregationArgs']]]]:
        """
        A list of queryable aggregation combinations for a count, rate, or gauge metric. By default, count and rate metrics require the (time: sum, space: sum) aggregation and gauge metrics require the (time: avg, space: avg) aggregation. Can only be applied to metrics that have a `metric_type` of count, rate, or gauge.
        """
        return pulumi.get(self, "aggregations")

    @aggregations.setter
    def aggregations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['MetricTagConfigurationAggregationArgs']]]]):
        pulumi.set(self, "aggregations", value)

    @_builtins.property
    @pulumi.getter(name="excludeTagsMode")
    def exclude_tags_mode(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Toggle to include/exclude tags as queryable for your metric. Can only be applied to metrics that have one or more tags configured. Defaults to `false`.
        """
        return pulumi.get(self, "exclude_tags_mode")

    @exclude_tags_mode.setter
    def exclude_tags_mode(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "exclude_tags_mode", value)

    @_builtins.property
    @pulumi.getter(name="includePercentiles")
    def include_percentiles(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Toggle to include/exclude percentiles for a distribution metric. Defaults to false. Can only be applied to metrics that have a `metric_type` of distribution.
        """
        return pulumi.get(self, "include_percentiles")

    @include_percentiles.setter
    def include_percentiles(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "include_percentiles", value)

    @_builtins.property
    @pulumi.getter(name="metricName")
    def metric_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The metric name for this resource.
        """
        return pulumi.get(self, "metric_name")

    @metric_name.setter
    def metric_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "metric_name", value)

    @_builtins.property
    @pulumi.getter(name="metricType")
    def metric_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The metric's type. This field can't be updated after creation. Valid values are `gauge`, `count`, `rate`, `distribution`.
        """
        return pulumi.get(self, "metric_type")

    @metric_type.setter
    def metric_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "metric_type", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        A list of tag keys that will be queryable for your metric.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.type_token("datadog:index/metricTagConfiguration:MetricTagConfiguration")
class MetricTagConfiguration(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 aggregations: Optional[pulumi.Input[Sequence[pulumi.Input[Union['MetricTagConfigurationAggregationArgs', 'MetricTagConfigurationAggregationArgsDict']]]]] = None,
                 exclude_tags_mode: Optional[pulumi.Input[_builtins.bool]] = None,
                 include_percentiles: Optional[pulumi.Input[_builtins.bool]] = None,
                 metric_name: Optional[pulumi.Input[_builtins.str]] = None,
                 metric_type: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        """
        Provides a Datadog metric tag configuration resource. This can be used to modify tag configurations for metrics.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_datadog as datadog

        # Manage a tag configuration for a Datadog distribution metric with/without percentiles
        example_dist_metric = datadog.MetricTagConfiguration("example_dist_metric",
            metric_name="example.terraform.dist.metric",
            metric_type="distribution",
            tags=[
                "sport",
                "datacenter",
            ],
            include_percentiles=False)
        # Manage tag configurations for a Datadog count or gauge metric
        example_count_metric = datadog.MetricTagConfiguration("example_count_metric",
            metric_name="example.terraform.count.metric",
            metric_type="count",
            tags=[
                "sport",
                "datacenter",
            ],
            exclude_tags_mode=False,
            aggregations=[
                {
                    "time": "avg",
                    "space": "min",
                },
                {
                    "time": "avg",
                    "space": "max",
                },
            ])
        ```

        ## Import

        The `pulumi import` command can be used, for example:

        ```sh
        $ pulumi import datadog:index/metricTagConfiguration:MetricTagConfiguration example_dist_metric example.terraform.dist.metric
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['MetricTagConfigurationAggregationArgs', 'MetricTagConfigurationAggregationArgsDict']]]] aggregations: A list of queryable aggregation combinations for a count, rate, or gauge metric. By default, count and rate metrics require the (time: sum, space: sum) aggregation and gauge metrics require the (time: avg, space: avg) aggregation. Can only be applied to metrics that have a `metric_type` of count, rate, or gauge.
        :param pulumi.Input[_builtins.bool] exclude_tags_mode: Toggle to include/exclude tags as queryable for your metric. Can only be applied to metrics that have one or more tags configured. Defaults to `false`.
        :param pulumi.Input[_builtins.bool] include_percentiles: Toggle to include/exclude percentiles for a distribution metric. Defaults to false. Can only be applied to metrics that have a `metric_type` of distribution.
        :param pulumi.Input[_builtins.str] metric_name: The metric name for this resource.
        :param pulumi.Input[_builtins.str] metric_type: The metric's type. This field can't be updated after creation. Valid values are `gauge`, `count`, `rate`, `distribution`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] tags: A list of tag keys that will be queryable for your metric.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: MetricTagConfigurationArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Datadog metric tag configuration resource. This can be used to modify tag configurations for metrics.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_datadog as datadog

        # Manage a tag configuration for a Datadog distribution metric with/without percentiles
        example_dist_metric = datadog.MetricTagConfiguration("example_dist_metric",
            metric_name="example.terraform.dist.metric",
            metric_type="distribution",
            tags=[
                "sport",
                "datacenter",
            ],
            include_percentiles=False)
        # Manage tag configurations for a Datadog count or gauge metric
        example_count_metric = datadog.MetricTagConfiguration("example_count_metric",
            metric_name="example.terraform.count.metric",
            metric_type="count",
            tags=[
                "sport",
                "datacenter",
            ],
            exclude_tags_mode=False,
            aggregations=[
                {
                    "time": "avg",
                    "space": "min",
                },
                {
                    "time": "avg",
                    "space": "max",
                },
            ])
        ```

        ## Import

        The `pulumi import` command can be used, for example:

        ```sh
        $ pulumi import datadog:index/metricTagConfiguration:MetricTagConfiguration example_dist_metric example.terraform.dist.metric
        ```

        :param str resource_name: The name of the resource.
        :param MetricTagConfigurationArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(MetricTagConfigurationArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 aggregations: Optional[pulumi.Input[Sequence[pulumi.Input[Union['MetricTagConfigurationAggregationArgs', 'MetricTagConfigurationAggregationArgsDict']]]]] = None,
                 exclude_tags_mode: Optional[pulumi.Input[_builtins.bool]] = None,
                 include_percentiles: Optional[pulumi.Input[_builtins.bool]] = None,
                 metric_name: Optional[pulumi.Input[_builtins.str]] = None,
                 metric_type: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = MetricTagConfigurationArgs.__new__(MetricTagConfigurationArgs)

            __props__.__dict__["aggregations"] = aggregations
            __props__.__dict__["exclude_tags_mode"] = exclude_tags_mode
            __props__.__dict__["include_percentiles"] = include_percentiles
            if metric_name is None and not opts.urn:
                raise TypeError("Missing required property 'metric_name'")
            __props__.__dict__["metric_name"] = metric_name
            if metric_type is None and not opts.urn:
                raise TypeError("Missing required property 'metric_type'")
            __props__.__dict__["metric_type"] = metric_type
            if tags is None and not opts.urn:
                raise TypeError("Missing required property 'tags'")
            __props__.__dict__["tags"] = tags
        super(MetricTagConfiguration, __self__).__init__(
            'datadog:index/metricTagConfiguration:MetricTagConfiguration',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            aggregations: Optional[pulumi.Input[Sequence[pulumi.Input[Union['MetricTagConfigurationAggregationArgs', 'MetricTagConfigurationAggregationArgsDict']]]]] = None,
            exclude_tags_mode: Optional[pulumi.Input[_builtins.bool]] = None,
            include_percentiles: Optional[pulumi.Input[_builtins.bool]] = None,
            metric_name: Optional[pulumi.Input[_builtins.str]] = None,
            metric_type: Optional[pulumi.Input[_builtins.str]] = None,
            tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None) -> 'MetricTagConfiguration':
        """
        Get an existing MetricTagConfiguration resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['MetricTagConfigurationAggregationArgs', 'MetricTagConfigurationAggregationArgsDict']]]] aggregations: A list of queryable aggregation combinations for a count, rate, or gauge metric. By default, count and rate metrics require the (time: sum, space: sum) aggregation and gauge metrics require the (time: avg, space: avg) aggregation. Can only be applied to metrics that have a `metric_type` of count, rate, or gauge.
        :param pulumi.Input[_builtins.bool] exclude_tags_mode: Toggle to include/exclude tags as queryable for your metric. Can only be applied to metrics that have one or more tags configured. Defaults to `false`.
        :param pulumi.Input[_builtins.bool] include_percentiles: Toggle to include/exclude percentiles for a distribution metric. Defaults to false. Can only be applied to metrics that have a `metric_type` of distribution.
        :param pulumi.Input[_builtins.str] metric_name: The metric name for this resource.
        :param pulumi.Input[_builtins.str] metric_type: The metric's type. This field can't be updated after creation. Valid values are `gauge`, `count`, `rate`, `distribution`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] tags: A list of tag keys that will be queryable for your metric.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _MetricTagConfigurationState.__new__(_MetricTagConfigurationState)

        __props__.__dict__["aggregations"] = aggregations
        __props__.__dict__["exclude_tags_mode"] = exclude_tags_mode
        __props__.__dict__["include_percentiles"] = include_percentiles
        __props__.__dict__["metric_name"] = metric_name
        __props__.__dict__["metric_type"] = metric_type
        __props__.__dict__["tags"] = tags
        return MetricTagConfiguration(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def aggregations(self) -> pulumi.Output[Sequence['outputs.MetricTagConfigurationAggregation']]:
        """
        A list of queryable aggregation combinations for a count, rate, or gauge metric. By default, count and rate metrics require the (time: sum, space: sum) aggregation and gauge metrics require the (time: avg, space: avg) aggregation. Can only be applied to metrics that have a `metric_type` of count, rate, or gauge.
        """
        return pulumi.get(self, "aggregations")

    @_builtins.property
    @pulumi.getter(name="excludeTagsMode")
    def exclude_tags_mode(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Toggle to include/exclude tags as queryable for your metric. Can only be applied to metrics that have one or more tags configured. Defaults to `false`.
        """
        return pulumi.get(self, "exclude_tags_mode")

    @_builtins.property
    @pulumi.getter(name="includePercentiles")
    def include_percentiles(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Toggle to include/exclude percentiles for a distribution metric. Defaults to false. Can only be applied to metrics that have a `metric_type` of distribution.
        """
        return pulumi.get(self, "include_percentiles")

    @_builtins.property
    @pulumi.getter(name="metricName")
    def metric_name(self) -> pulumi.Output[_builtins.str]:
        """
        The metric name for this resource.
        """
        return pulumi.get(self, "metric_name")

    @_builtins.property
    @pulumi.getter(name="metricType")
    def metric_type(self) -> pulumi.Output[_builtins.str]:
        """
        The metric's type. This field can't be updated after creation. Valid values are `gauge`, `count`, `rate`, `distribution`.
        """
        return pulumi.get(self, "metric_type")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        A list of tag keys that will be queryable for your metric.
        """
        return pulumi.get(self, "tags")

