# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['MonitorNotificationRuleArgs', 'MonitorNotificationRule']

@pulumi.input_type
class MonitorNotificationRuleArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[_builtins.str],
                 recipients: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]],
                 filter: Optional[pulumi.Input['MonitorNotificationRuleFilterArgs']] = None):
        """
        The set of arguments for constructing a MonitorNotificationRule resource.
        :param pulumi.Input[_builtins.str] name: The name of the monitor notification rule.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] recipients: List of recipients to notify.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "recipients", recipients)
        if filter is not None:
            pulumi.set(__self__, "filter", filter)

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the monitor notification rule.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def recipients(self) -> pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]:
        """
        List of recipients to notify.
        """
        return pulumi.get(self, "recipients")

    @recipients.setter
    def recipients(self, value: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]):
        pulumi.set(self, "recipients", value)

    @_builtins.property
    @pulumi.getter
    def filter(self) -> Optional[pulumi.Input['MonitorNotificationRuleFilterArgs']]:
        return pulumi.get(self, "filter")

    @filter.setter
    def filter(self, value: Optional[pulumi.Input['MonitorNotificationRuleFilterArgs']]):
        pulumi.set(self, "filter", value)


@pulumi.input_type
class _MonitorNotificationRuleState:
    def __init__(__self__, *,
                 filter: Optional[pulumi.Input['MonitorNotificationRuleFilterArgs']] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 recipients: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None):
        """
        Input properties used for looking up and filtering MonitorNotificationRule resources.
        :param pulumi.Input[_builtins.str] name: The name of the monitor notification rule.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] recipients: List of recipients to notify.
        """
        if filter is not None:
            pulumi.set(__self__, "filter", filter)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if recipients is not None:
            pulumi.set(__self__, "recipients", recipients)

    @_builtins.property
    @pulumi.getter
    def filter(self) -> Optional[pulumi.Input['MonitorNotificationRuleFilterArgs']]:
        return pulumi.get(self, "filter")

    @filter.setter
    def filter(self, value: Optional[pulumi.Input['MonitorNotificationRuleFilterArgs']]):
        pulumi.set(self, "filter", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the monitor notification rule.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def recipients(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of recipients to notify.
        """
        return pulumi.get(self, "recipients")

    @recipients.setter
    def recipients(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "recipients", value)


@pulumi.type_token("datadog:index/monitorNotificationRule:MonitorNotificationRule")
class MonitorNotificationRule(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 filter: Optional[pulumi.Input[Union['MonitorNotificationRuleFilterArgs', 'MonitorNotificationRuleFilterArgsDict']]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 recipients: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        """
        Provides a Datadog MonitorNotificationRule resource.

        ## Example Usage

        ## Import

        The `pulumi import` command can be used, for example:

        ```sh
        $ pulumi import datadog:index/monitorNotificationRule:MonitorNotificationRule new_list "00e000000-0000-1234-0000-000000000000"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] name: The name of the monitor notification rule.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] recipients: List of recipients to notify.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: MonitorNotificationRuleArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Datadog MonitorNotificationRule resource.

        ## Example Usage

        ## Import

        The `pulumi import` command can be used, for example:

        ```sh
        $ pulumi import datadog:index/monitorNotificationRule:MonitorNotificationRule new_list "00e000000-0000-1234-0000-000000000000"
        ```

        :param str resource_name: The name of the resource.
        :param MonitorNotificationRuleArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(MonitorNotificationRuleArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 filter: Optional[pulumi.Input[Union['MonitorNotificationRuleFilterArgs', 'MonitorNotificationRuleFilterArgsDict']]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 recipients: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = MonitorNotificationRuleArgs.__new__(MonitorNotificationRuleArgs)

            __props__.__dict__["filter"] = filter
            if name is None and not opts.urn:
                raise TypeError("Missing required property 'name'")
            __props__.__dict__["name"] = name
            if recipients is None and not opts.urn:
                raise TypeError("Missing required property 'recipients'")
            __props__.__dict__["recipients"] = recipients
        super(MonitorNotificationRule, __self__).__init__(
            'datadog:index/monitorNotificationRule:MonitorNotificationRule',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            filter: Optional[pulumi.Input[Union['MonitorNotificationRuleFilterArgs', 'MonitorNotificationRuleFilterArgsDict']]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            recipients: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None) -> 'MonitorNotificationRule':
        """
        Get an existing MonitorNotificationRule resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] name: The name of the monitor notification rule.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] recipients: List of recipients to notify.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _MonitorNotificationRuleState.__new__(_MonitorNotificationRuleState)

        __props__.__dict__["filter"] = filter
        __props__.__dict__["name"] = name
        __props__.__dict__["recipients"] = recipients
        return MonitorNotificationRule(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def filter(self) -> pulumi.Output[Optional['outputs.MonitorNotificationRuleFilter']]:
        return pulumi.get(self, "filter")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the monitor notification rule.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def recipients(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        List of recipients to notify.
        """
        return pulumi.get(self, "recipients")

