# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ObservabilityPipelineArgs', 'ObservabilityPipeline']

@pulumi.input_type
class ObservabilityPipelineArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[_builtins.str],
                 config: Optional[pulumi.Input['ObservabilityPipelineConfigArgs']] = None):
        """
        The set of arguments for constructing a ObservabilityPipeline resource.
        :param pulumi.Input[_builtins.str] name: The pipeline name.
        :param pulumi.Input['ObservabilityPipelineConfigArgs'] config: Configuration for the pipeline.
        """
        pulumi.set(__self__, "name", name)
        if config is not None:
            pulumi.set(__self__, "config", config)

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Input[_builtins.str]:
        """
        The pipeline name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def config(self) -> Optional[pulumi.Input['ObservabilityPipelineConfigArgs']]:
        """
        Configuration for the pipeline.
        """
        return pulumi.get(self, "config")

    @config.setter
    def config(self, value: Optional[pulumi.Input['ObservabilityPipelineConfigArgs']]):
        pulumi.set(self, "config", value)


@pulumi.input_type
class _ObservabilityPipelineState:
    def __init__(__self__, *,
                 config: Optional[pulumi.Input['ObservabilityPipelineConfigArgs']] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering ObservabilityPipeline resources.
        :param pulumi.Input['ObservabilityPipelineConfigArgs'] config: Configuration for the pipeline.
        :param pulumi.Input[_builtins.str] name: The pipeline name.
        """
        if config is not None:
            pulumi.set(__self__, "config", config)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter
    def config(self) -> Optional[pulumi.Input['ObservabilityPipelineConfigArgs']]:
        """
        Configuration for the pipeline.
        """
        return pulumi.get(self, "config")

    @config.setter
    def config(self, value: Optional[pulumi.Input['ObservabilityPipelineConfigArgs']]):
        pulumi.set(self, "config", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The pipeline name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)


@pulumi.type_token("datadog:index/observabilityPipeline:ObservabilityPipeline")
class ObservabilityPipeline(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 config: Optional[pulumi.Input[Union['ObservabilityPipelineConfigArgs', 'ObservabilityPipelineConfigArgsDict']]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Provides a Datadog Observability Pipeline resource. Observability Pipelines allows you to collect and process logs within your own infrastructure, and then route them to downstream integrations. This resource is in **Preview**. Reach out to Datadog support to enable it for your account.

        Datadog recommends using the `-parallelism=1` option to apply this resource.

        ## Example Usage

        ## Import

        The `pulumi import` command can be used, for example:

        ```sh
        $ pulumi import datadog:index/observabilityPipeline:ObservabilityPipeline example_pipeline 8beabbc4-1f4d-11f0-942b-da7ad0900001
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['ObservabilityPipelineConfigArgs', 'ObservabilityPipelineConfigArgsDict']] config: Configuration for the pipeline.
        :param pulumi.Input[_builtins.str] name: The pipeline name.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ObservabilityPipelineArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Datadog Observability Pipeline resource. Observability Pipelines allows you to collect and process logs within your own infrastructure, and then route them to downstream integrations. This resource is in **Preview**. Reach out to Datadog support to enable it for your account.

        Datadog recommends using the `-parallelism=1` option to apply this resource.

        ## Example Usage

        ## Import

        The `pulumi import` command can be used, for example:

        ```sh
        $ pulumi import datadog:index/observabilityPipeline:ObservabilityPipeline example_pipeline 8beabbc4-1f4d-11f0-942b-da7ad0900001
        ```

        :param str resource_name: The name of the resource.
        :param ObservabilityPipelineArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ObservabilityPipelineArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 config: Optional[pulumi.Input[Union['ObservabilityPipelineConfigArgs', 'ObservabilityPipelineConfigArgsDict']]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ObservabilityPipelineArgs.__new__(ObservabilityPipelineArgs)

            __props__.__dict__["config"] = config
            if name is None and not opts.urn:
                raise TypeError("Missing required property 'name'")
            __props__.__dict__["name"] = name
        super(ObservabilityPipeline, __self__).__init__(
            'datadog:index/observabilityPipeline:ObservabilityPipeline',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            config: Optional[pulumi.Input[Union['ObservabilityPipelineConfigArgs', 'ObservabilityPipelineConfigArgsDict']]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None) -> 'ObservabilityPipeline':
        """
        Get an existing ObservabilityPipeline resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['ObservabilityPipelineConfigArgs', 'ObservabilityPipelineConfigArgsDict']] config: Configuration for the pipeline.
        :param pulumi.Input[_builtins.str] name: The pipeline name.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ObservabilityPipelineState.__new__(_ObservabilityPipelineState)

        __props__.__dict__["config"] = config
        __props__.__dict__["name"] = name
        return ObservabilityPipeline(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def config(self) -> pulumi.Output[Optional['outputs.ObservabilityPipelineConfig']]:
        """
        Configuration for the pipeline.
        """
        return pulumi.get(self, "config")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The pipeline name.
        """
        return pulumi.get(self, "name")

