# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['OnCallScheduleArgs', 'OnCallSchedule']

@pulumi.input_type
class OnCallScheduleArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[_builtins.str],
                 time_zone: pulumi.Input[_builtins.str],
                 layers: Optional[pulumi.Input[Sequence[pulumi.Input['OnCallScheduleLayerArgs']]]] = None,
                 teams: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None):
        """
        The set of arguments for constructing a OnCallSchedule resource.
        :param pulumi.Input[_builtins.str] name: A human-readable name for the new schedule.
        :param pulumi.Input[_builtins.str] time_zone: The time zone in which the schedule is defined.
        :param pulumi.Input[Sequence[pulumi.Input['OnCallScheduleLayerArgs']]] layers: List of layers for the schedule.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] teams: A list of team ids associated with the schedule.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "time_zone", time_zone)
        if layers is not None:
            pulumi.set(__self__, "layers", layers)
        if teams is not None:
            pulumi.set(__self__, "teams", teams)

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Input[_builtins.str]:
        """
        A human-readable name for the new schedule.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="timeZone")
    def time_zone(self) -> pulumi.Input[_builtins.str]:
        """
        The time zone in which the schedule is defined.
        """
        return pulumi.get(self, "time_zone")

    @time_zone.setter
    def time_zone(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "time_zone", value)

    @_builtins.property
    @pulumi.getter
    def layers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['OnCallScheduleLayerArgs']]]]:
        """
        List of layers for the schedule.
        """
        return pulumi.get(self, "layers")

    @layers.setter
    def layers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['OnCallScheduleLayerArgs']]]]):
        pulumi.set(self, "layers", value)

    @_builtins.property
    @pulumi.getter
    def teams(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        A list of team ids associated with the schedule.
        """
        return pulumi.get(self, "teams")

    @teams.setter
    def teams(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "teams", value)


@pulumi.input_type
class _OnCallScheduleState:
    def __init__(__self__, *,
                 layers: Optional[pulumi.Input[Sequence[pulumi.Input['OnCallScheduleLayerArgs']]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 teams: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 time_zone: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering OnCallSchedule resources.
        :param pulumi.Input[Sequence[pulumi.Input['OnCallScheduleLayerArgs']]] layers: List of layers for the schedule.
        :param pulumi.Input[_builtins.str] name: A human-readable name for the new schedule.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] teams: A list of team ids associated with the schedule.
        :param pulumi.Input[_builtins.str] time_zone: The time zone in which the schedule is defined.
        """
        if layers is not None:
            pulumi.set(__self__, "layers", layers)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if teams is not None:
            pulumi.set(__self__, "teams", teams)
        if time_zone is not None:
            pulumi.set(__self__, "time_zone", time_zone)

    @_builtins.property
    @pulumi.getter
    def layers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['OnCallScheduleLayerArgs']]]]:
        """
        List of layers for the schedule.
        """
        return pulumi.get(self, "layers")

    @layers.setter
    def layers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['OnCallScheduleLayerArgs']]]]):
        pulumi.set(self, "layers", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A human-readable name for the new schedule.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def teams(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        A list of team ids associated with the schedule.
        """
        return pulumi.get(self, "teams")

    @teams.setter
    def teams(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "teams", value)

    @_builtins.property
    @pulumi.getter(name="timeZone")
    def time_zone(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The time zone in which the schedule is defined.
        """
        return pulumi.get(self, "time_zone")

    @time_zone.setter
    def time_zone(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "time_zone", value)


@pulumi.type_token("datadog:index/onCallSchedule:OnCallSchedule")
class OnCallSchedule(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 layers: Optional[pulumi.Input[Sequence[pulumi.Input[Union['OnCallScheduleLayerArgs', 'OnCallScheduleLayerArgsDict']]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 teams: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 time_zone: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Provides a Datadog On-Call schedule resource. This can be used to create and manage Datadog On-Call schedules.

        ## Example Usage

        ## Import

        The `pulumi import` command can be used, for example:

        Import an existing on_call_schedule

        ```sh
        $ pulumi import datadog:index/onCallSchedule:OnCallSchedule test "b03a07d5-49da-43e9-83b4-5d84969b588b"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['OnCallScheduleLayerArgs', 'OnCallScheduleLayerArgsDict']]]] layers: List of layers for the schedule.
        :param pulumi.Input[_builtins.str] name: A human-readable name for the new schedule.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] teams: A list of team ids associated with the schedule.
        :param pulumi.Input[_builtins.str] time_zone: The time zone in which the schedule is defined.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: OnCallScheduleArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Datadog On-Call schedule resource. This can be used to create and manage Datadog On-Call schedules.

        ## Example Usage

        ## Import

        The `pulumi import` command can be used, for example:

        Import an existing on_call_schedule

        ```sh
        $ pulumi import datadog:index/onCallSchedule:OnCallSchedule test "b03a07d5-49da-43e9-83b4-5d84969b588b"
        ```

        :param str resource_name: The name of the resource.
        :param OnCallScheduleArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(OnCallScheduleArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 layers: Optional[pulumi.Input[Sequence[pulumi.Input[Union['OnCallScheduleLayerArgs', 'OnCallScheduleLayerArgsDict']]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 teams: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 time_zone: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = OnCallScheduleArgs.__new__(OnCallScheduleArgs)

            __props__.__dict__["layers"] = layers
            if name is None and not opts.urn:
                raise TypeError("Missing required property 'name'")
            __props__.__dict__["name"] = name
            __props__.__dict__["teams"] = teams
            if time_zone is None and not opts.urn:
                raise TypeError("Missing required property 'time_zone'")
            __props__.__dict__["time_zone"] = time_zone
        super(OnCallSchedule, __self__).__init__(
            'datadog:index/onCallSchedule:OnCallSchedule',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            layers: Optional[pulumi.Input[Sequence[pulumi.Input[Union['OnCallScheduleLayerArgs', 'OnCallScheduleLayerArgsDict']]]]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            teams: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            time_zone: Optional[pulumi.Input[_builtins.str]] = None) -> 'OnCallSchedule':
        """
        Get an existing OnCallSchedule resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['OnCallScheduleLayerArgs', 'OnCallScheduleLayerArgsDict']]]] layers: List of layers for the schedule.
        :param pulumi.Input[_builtins.str] name: A human-readable name for the new schedule.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] teams: A list of team ids associated with the schedule.
        :param pulumi.Input[_builtins.str] time_zone: The time zone in which the schedule is defined.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _OnCallScheduleState.__new__(_OnCallScheduleState)

        __props__.__dict__["layers"] = layers
        __props__.__dict__["name"] = name
        __props__.__dict__["teams"] = teams
        __props__.__dict__["time_zone"] = time_zone
        return OnCallSchedule(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def layers(self) -> pulumi.Output[Optional[Sequence['outputs.OnCallScheduleLayer']]]:
        """
        List of layers for the schedule.
        """
        return pulumi.get(self, "layers")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        A human-readable name for the new schedule.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def teams(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        A list of team ids associated with the schedule.
        """
        return pulumi.get(self, "teams")

    @_builtins.property
    @pulumi.getter(name="timeZone")
    def time_zone(self) -> pulumi.Output[_builtins.str]:
        """
        The time zone in which the schedule is defined.
        """
        return pulumi.get(self, "time_zone")

