# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['OrgConnectionArgs', 'OrgConnection']

@pulumi.input_type
class OrgConnectionArgs:
    def __init__(__self__, *,
                 connection_types: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]],
                 sink_org_id: pulumi.Input[_builtins.str]):
        """
        The set of arguments for constructing a OrgConnection resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] connection_types: Set of connection types to enable for this connection (., metrics, logs).
        :param pulumi.Input[_builtins.str] sink_org_id: UUID of the sink (destination) organization. Must be a valid UUID.
        """
        pulumi.set(__self__, "connection_types", connection_types)
        pulumi.set(__self__, "sink_org_id", sink_org_id)

    @_builtins.property
    @pulumi.getter(name="connectionTypes")
    def connection_types(self) -> pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]:
        """
        Set of connection types to enable for this connection (., metrics, logs).
        """
        return pulumi.get(self, "connection_types")

    @connection_types.setter
    def connection_types(self, value: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]):
        pulumi.set(self, "connection_types", value)

    @_builtins.property
    @pulumi.getter(name="sinkOrgId")
    def sink_org_id(self) -> pulumi.Input[_builtins.str]:
        """
        UUID of the sink (destination) organization. Must be a valid UUID.
        """
        return pulumi.get(self, "sink_org_id")

    @sink_org_id.setter
    def sink_org_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "sink_org_id", value)


@pulumi.input_type
class _OrgConnectionState:
    def __init__(__self__, *,
                 connection_types: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 created_at: Optional[pulumi.Input[_builtins.str]] = None,
                 created_by: Optional[pulumi.Input[_builtins.str]] = None,
                 sink_org_id: Optional[pulumi.Input[_builtins.str]] = None,
                 sink_org_name: Optional[pulumi.Input[_builtins.str]] = None,
                 source_org_id: Optional[pulumi.Input[_builtins.str]] = None,
                 source_org_name: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering OrgConnection resources.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] connection_types: Set of connection types to enable for this connection (., metrics, logs).
        :param pulumi.Input[_builtins.str] created_at: Timestamp when the connection was created (RFC 3339).
        :param pulumi.Input[_builtins.str] created_by: Creator user ID (UUID).
        :param pulumi.Input[_builtins.str] sink_org_id: UUID of the sink (destination) organization. Must be a valid UUID.
        :param pulumi.Input[_builtins.str] sink_org_name: Name of the sink (destination) organization.
        :param pulumi.Input[_builtins.str] source_org_id: UUID of the source (current) organization.
        :param pulumi.Input[_builtins.str] source_org_name: Name of the source organization.
        """
        if connection_types is not None:
            pulumi.set(__self__, "connection_types", connection_types)
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if created_by is not None:
            pulumi.set(__self__, "created_by", created_by)
        if sink_org_id is not None:
            pulumi.set(__self__, "sink_org_id", sink_org_id)
        if sink_org_name is not None:
            pulumi.set(__self__, "sink_org_name", sink_org_name)
        if source_org_id is not None:
            pulumi.set(__self__, "source_org_id", source_org_id)
        if source_org_name is not None:
            pulumi.set(__self__, "source_org_name", source_org_name)

    @_builtins.property
    @pulumi.getter(name="connectionTypes")
    def connection_types(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Set of connection types to enable for this connection (., metrics, logs).
        """
        return pulumi.get(self, "connection_types")

    @connection_types.setter
    def connection_types(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "connection_types", value)

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Timestamp when the connection was created (RFC 3339).
        """
        return pulumi.get(self, "created_at")

    @created_at.setter
    def created_at(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "created_at", value)

    @_builtins.property
    @pulumi.getter(name="createdBy")
    def created_by(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Creator user ID (UUID).
        """
        return pulumi.get(self, "created_by")

    @created_by.setter
    def created_by(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "created_by", value)

    @_builtins.property
    @pulumi.getter(name="sinkOrgId")
    def sink_org_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        UUID of the sink (destination) organization. Must be a valid UUID.
        """
        return pulumi.get(self, "sink_org_id")

    @sink_org_id.setter
    def sink_org_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "sink_org_id", value)

    @_builtins.property
    @pulumi.getter(name="sinkOrgName")
    def sink_org_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the sink (destination) organization.
        """
        return pulumi.get(self, "sink_org_name")

    @sink_org_name.setter
    def sink_org_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "sink_org_name", value)

    @_builtins.property
    @pulumi.getter(name="sourceOrgId")
    def source_org_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        UUID of the source (current) organization.
        """
        return pulumi.get(self, "source_org_id")

    @source_org_id.setter
    def source_org_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "source_org_id", value)

    @_builtins.property
    @pulumi.getter(name="sourceOrgName")
    def source_org_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the source organization.
        """
        return pulumi.get(self, "source_org_name")

    @source_org_name.setter
    def source_org_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "source_org_name", value)


@pulumi.type_token("datadog:index/orgConnection:OrgConnection")
class OrgConnection(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 connection_types: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 sink_org_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Provides a Datadog Org Connection resource. Org Connections make data from a source org available in the destination org for selected connection data types (for example, logs or metrics). Org Connections can only be created from a source org to a specified destination org

        ## Example Usage

        ```python
        import pulumi
        import pulumi_datadog as datadog

        # Create new org connection resource
        foo = datadog.OrgConnection("foo",
            connection_types=[
                "metrics",
                "logs",
            ],
            sink_org_id="00000000-0000-0000-0000-000000000000")
        ```

        ## Import

        The `pulumi import` command can be used, for example:

        ```sh
        $ pulumi import datadog:index/orgConnection:OrgConnection foo "<org_connection_id>"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] connection_types: Set of connection types to enable for this connection (., metrics, logs).
        :param pulumi.Input[_builtins.str] sink_org_id: UUID of the sink (destination) organization. Must be a valid UUID.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: OrgConnectionArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Datadog Org Connection resource. Org Connections make data from a source org available in the destination org for selected connection data types (for example, logs or metrics). Org Connections can only be created from a source org to a specified destination org

        ## Example Usage

        ```python
        import pulumi
        import pulumi_datadog as datadog

        # Create new org connection resource
        foo = datadog.OrgConnection("foo",
            connection_types=[
                "metrics",
                "logs",
            ],
            sink_org_id="00000000-0000-0000-0000-000000000000")
        ```

        ## Import

        The `pulumi import` command can be used, for example:

        ```sh
        $ pulumi import datadog:index/orgConnection:OrgConnection foo "<org_connection_id>"
        ```

        :param str resource_name: The name of the resource.
        :param OrgConnectionArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(OrgConnectionArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 connection_types: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 sink_org_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = OrgConnectionArgs.__new__(OrgConnectionArgs)

            if connection_types is None and not opts.urn:
                raise TypeError("Missing required property 'connection_types'")
            __props__.__dict__["connection_types"] = connection_types
            if sink_org_id is None and not opts.urn:
                raise TypeError("Missing required property 'sink_org_id'")
            __props__.__dict__["sink_org_id"] = sink_org_id
            __props__.__dict__["created_at"] = None
            __props__.__dict__["created_by"] = None
            __props__.__dict__["sink_org_name"] = None
            __props__.__dict__["source_org_id"] = None
            __props__.__dict__["source_org_name"] = None
        super(OrgConnection, __self__).__init__(
            'datadog:index/orgConnection:OrgConnection',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            connection_types: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            created_at: Optional[pulumi.Input[_builtins.str]] = None,
            created_by: Optional[pulumi.Input[_builtins.str]] = None,
            sink_org_id: Optional[pulumi.Input[_builtins.str]] = None,
            sink_org_name: Optional[pulumi.Input[_builtins.str]] = None,
            source_org_id: Optional[pulumi.Input[_builtins.str]] = None,
            source_org_name: Optional[pulumi.Input[_builtins.str]] = None) -> 'OrgConnection':
        """
        Get an existing OrgConnection resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] connection_types: Set of connection types to enable for this connection (., metrics, logs).
        :param pulumi.Input[_builtins.str] created_at: Timestamp when the connection was created (RFC 3339).
        :param pulumi.Input[_builtins.str] created_by: Creator user ID (UUID).
        :param pulumi.Input[_builtins.str] sink_org_id: UUID of the sink (destination) organization. Must be a valid UUID.
        :param pulumi.Input[_builtins.str] sink_org_name: Name of the sink (destination) organization.
        :param pulumi.Input[_builtins.str] source_org_id: UUID of the source (current) organization.
        :param pulumi.Input[_builtins.str] source_org_name: Name of the source organization.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _OrgConnectionState.__new__(_OrgConnectionState)

        __props__.__dict__["connection_types"] = connection_types
        __props__.__dict__["created_at"] = created_at
        __props__.__dict__["created_by"] = created_by
        __props__.__dict__["sink_org_id"] = sink_org_id
        __props__.__dict__["sink_org_name"] = sink_org_name
        __props__.__dict__["source_org_id"] = source_org_id
        __props__.__dict__["source_org_name"] = source_org_name
        return OrgConnection(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="connectionTypes")
    def connection_types(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        Set of connection types to enable for this connection (., metrics, logs).
        """
        return pulumi.get(self, "connection_types")

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> pulumi.Output[_builtins.str]:
        """
        Timestamp when the connection was created (RFC 3339).
        """
        return pulumi.get(self, "created_at")

    @_builtins.property
    @pulumi.getter(name="createdBy")
    def created_by(self) -> pulumi.Output[_builtins.str]:
        """
        Creator user ID (UUID).
        """
        return pulumi.get(self, "created_by")

    @_builtins.property
    @pulumi.getter(name="sinkOrgId")
    def sink_org_id(self) -> pulumi.Output[_builtins.str]:
        """
        UUID of the sink (destination) organization. Must be a valid UUID.
        """
        return pulumi.get(self, "sink_org_id")

    @_builtins.property
    @pulumi.getter(name="sinkOrgName")
    def sink_org_name(self) -> pulumi.Output[_builtins.str]:
        """
        Name of the sink (destination) organization.
        """
        return pulumi.get(self, "sink_org_name")

    @_builtins.property
    @pulumi.getter(name="sourceOrgId")
    def source_org_id(self) -> pulumi.Output[_builtins.str]:
        """
        UUID of the source (current) organization.
        """
        return pulumi.get(self, "source_org_id")

    @_builtins.property
    @pulumi.getter(name="sourceOrgName")
    def source_org_name(self) -> pulumi.Output[_builtins.str]:
        """
        Name of the source organization.
        """
        return pulumi.get(self, "source_org_name")

