# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['RumApplicationArgs', 'RumApplication']

@pulumi.input_type
class RumApplicationArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[_builtins.str],
                 product_analytics_retention_state: Optional[pulumi.Input[_builtins.str]] = None,
                 rum_event_processing_state: Optional[pulumi.Input[_builtins.str]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a RumApplication resource.
        :param pulumi.Input[_builtins.str] name: Name of the RUM application.
        :param pulumi.Input[_builtins.str] product_analytics_retention_state: Controls the retention policy for Product Analytics data derived from RUM events. Valid values are `MAX`, `NONE`.
        :param pulumi.Input[_builtins.str] rum_event_processing_state: Configures which RUM events are processed and stored for the application. Valid values are `ALL`, `ERROR_FOCUSED_MODE`, `NONE`.
        :param pulumi.Input[_builtins.str] type: Type of the RUM application. Supported values are `browser`, `ios`, `android`, `react-native`, `flutter`. Defaults to `"browser"`.
        """
        pulumi.set(__self__, "name", name)
        if product_analytics_retention_state is not None:
            pulumi.set(__self__, "product_analytics_retention_state", product_analytics_retention_state)
        if rum_event_processing_state is not None:
            pulumi.set(__self__, "rum_event_processing_state", rum_event_processing_state)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Input[_builtins.str]:
        """
        Name of the RUM application.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="productAnalyticsRetentionState")
    def product_analytics_retention_state(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Controls the retention policy for Product Analytics data derived from RUM events. Valid values are `MAX`, `NONE`.
        """
        return pulumi.get(self, "product_analytics_retention_state")

    @product_analytics_retention_state.setter
    def product_analytics_retention_state(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "product_analytics_retention_state", value)

    @_builtins.property
    @pulumi.getter(name="rumEventProcessingState")
    def rum_event_processing_state(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Configures which RUM events are processed and stored for the application. Valid values are `ALL`, `ERROR_FOCUSED_MODE`, `NONE`.
        """
        return pulumi.get(self, "rum_event_processing_state")

    @rum_event_processing_state.setter
    def rum_event_processing_state(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "rum_event_processing_state", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Type of the RUM application. Supported values are `browser`, `ios`, `android`, `react-native`, `flutter`. Defaults to `"browser"`.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "type", value)


@pulumi.input_type
class _RumApplicationState:
    def __init__(__self__, *,
                 api_key_id: Optional[pulumi.Input[_builtins.int]] = None,
                 client_token: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 product_analytics_retention_state: Optional[pulumi.Input[_builtins.str]] = None,
                 rum_event_processing_state: Optional[pulumi.Input[_builtins.str]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering RumApplication resources.
        :param pulumi.Input[_builtins.int] api_key_id: ID of the API key associated with the application.
        :param pulumi.Input[_builtins.str] client_token: The client token.
        :param pulumi.Input[_builtins.str] name: Name of the RUM application.
        :param pulumi.Input[_builtins.str] product_analytics_retention_state: Controls the retention policy for Product Analytics data derived from RUM events. Valid values are `MAX`, `NONE`.
        :param pulumi.Input[_builtins.str] rum_event_processing_state: Configures which RUM events are processed and stored for the application. Valid values are `ALL`, `ERROR_FOCUSED_MODE`, `NONE`.
        :param pulumi.Input[_builtins.str] type: Type of the RUM application. Supported values are `browser`, `ios`, `android`, `react-native`, `flutter`. Defaults to `"browser"`.
        """
        if api_key_id is not None:
            pulumi.set(__self__, "api_key_id", api_key_id)
        if client_token is not None:
            pulumi.set(__self__, "client_token", client_token)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if product_analytics_retention_state is not None:
            pulumi.set(__self__, "product_analytics_retention_state", product_analytics_retention_state)
        if rum_event_processing_state is not None:
            pulumi.set(__self__, "rum_event_processing_state", rum_event_processing_state)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter(name="apiKeyId")
    def api_key_id(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        ID of the API key associated with the application.
        """
        return pulumi.get(self, "api_key_id")

    @api_key_id.setter
    def api_key_id(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "api_key_id", value)

    @_builtins.property
    @pulumi.getter(name="clientToken")
    def client_token(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The client token.
        """
        return pulumi.get(self, "client_token")

    @client_token.setter
    def client_token(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "client_token", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the RUM application.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="productAnalyticsRetentionState")
    def product_analytics_retention_state(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Controls the retention policy for Product Analytics data derived from RUM events. Valid values are `MAX`, `NONE`.
        """
        return pulumi.get(self, "product_analytics_retention_state")

    @product_analytics_retention_state.setter
    def product_analytics_retention_state(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "product_analytics_retention_state", value)

    @_builtins.property
    @pulumi.getter(name="rumEventProcessingState")
    def rum_event_processing_state(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Configures which RUM events are processed and stored for the application. Valid values are `ALL`, `ERROR_FOCUSED_MODE`, `NONE`.
        """
        return pulumi.get(self, "rum_event_processing_state")

    @rum_event_processing_state.setter
    def rum_event_processing_state(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "rum_event_processing_state", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Type of the RUM application. Supported values are `browser`, `ios`, `android`, `react-native`, `flutter`. Defaults to `"browser"`.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "type", value)


@pulumi.type_token("datadog:index/rumApplication:RumApplication")
class RumApplication(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 product_analytics_retention_state: Optional[pulumi.Input[_builtins.str]] = None,
                 rum_event_processing_state: Optional[pulumi.Input[_builtins.str]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Provides a Datadog RUM application resource. This can be used to create and manage Datadog RUM applications.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_datadog as datadog

        rum_application = datadog.RumApplication("rum_application",
            name="my-application",
            type="browser",
            rum_event_processing_state="ALL",
            product_analytics_retention_state="NONE")
        ```

        ## Import

        The `pulumi import` command can be used, for example:

        ```sh
        $ pulumi import datadog:index/rumApplication:RumApplication rum_application a1b2c3d4-a1b2-a1b2-a1b2-a1b2c3d4e5f6
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] name: Name of the RUM application.
        :param pulumi.Input[_builtins.str] product_analytics_retention_state: Controls the retention policy for Product Analytics data derived from RUM events. Valid values are `MAX`, `NONE`.
        :param pulumi.Input[_builtins.str] rum_event_processing_state: Configures which RUM events are processed and stored for the application. Valid values are `ALL`, `ERROR_FOCUSED_MODE`, `NONE`.
        :param pulumi.Input[_builtins.str] type: Type of the RUM application. Supported values are `browser`, `ios`, `android`, `react-native`, `flutter`. Defaults to `"browser"`.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: RumApplicationArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Datadog RUM application resource. This can be used to create and manage Datadog RUM applications.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_datadog as datadog

        rum_application = datadog.RumApplication("rum_application",
            name="my-application",
            type="browser",
            rum_event_processing_state="ALL",
            product_analytics_retention_state="NONE")
        ```

        ## Import

        The `pulumi import` command can be used, for example:

        ```sh
        $ pulumi import datadog:index/rumApplication:RumApplication rum_application a1b2c3d4-a1b2-a1b2-a1b2-a1b2c3d4e5f6
        ```

        :param str resource_name: The name of the resource.
        :param RumApplicationArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(RumApplicationArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 product_analytics_retention_state: Optional[pulumi.Input[_builtins.str]] = None,
                 rum_event_processing_state: Optional[pulumi.Input[_builtins.str]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = RumApplicationArgs.__new__(RumApplicationArgs)

            if name is None and not opts.urn:
                raise TypeError("Missing required property 'name'")
            __props__.__dict__["name"] = name
            __props__.__dict__["product_analytics_retention_state"] = product_analytics_retention_state
            __props__.__dict__["rum_event_processing_state"] = rum_event_processing_state
            __props__.__dict__["type"] = type
            __props__.__dict__["api_key_id"] = None
            __props__.__dict__["client_token"] = None
        super(RumApplication, __self__).__init__(
            'datadog:index/rumApplication:RumApplication',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            api_key_id: Optional[pulumi.Input[_builtins.int]] = None,
            client_token: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            product_analytics_retention_state: Optional[pulumi.Input[_builtins.str]] = None,
            rum_event_processing_state: Optional[pulumi.Input[_builtins.str]] = None,
            type: Optional[pulumi.Input[_builtins.str]] = None) -> 'RumApplication':
        """
        Get an existing RumApplication resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.int] api_key_id: ID of the API key associated with the application.
        :param pulumi.Input[_builtins.str] client_token: The client token.
        :param pulumi.Input[_builtins.str] name: Name of the RUM application.
        :param pulumi.Input[_builtins.str] product_analytics_retention_state: Controls the retention policy for Product Analytics data derived from RUM events. Valid values are `MAX`, `NONE`.
        :param pulumi.Input[_builtins.str] rum_event_processing_state: Configures which RUM events are processed and stored for the application. Valid values are `ALL`, `ERROR_FOCUSED_MODE`, `NONE`.
        :param pulumi.Input[_builtins.str] type: Type of the RUM application. Supported values are `browser`, `ios`, `android`, `react-native`, `flutter`. Defaults to `"browser"`.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _RumApplicationState.__new__(_RumApplicationState)

        __props__.__dict__["api_key_id"] = api_key_id
        __props__.__dict__["client_token"] = client_token
        __props__.__dict__["name"] = name
        __props__.__dict__["product_analytics_retention_state"] = product_analytics_retention_state
        __props__.__dict__["rum_event_processing_state"] = rum_event_processing_state
        __props__.__dict__["type"] = type
        return RumApplication(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="apiKeyId")
    def api_key_id(self) -> pulumi.Output[_builtins.int]:
        """
        ID of the API key associated with the application.
        """
        return pulumi.get(self, "api_key_id")

    @_builtins.property
    @pulumi.getter(name="clientToken")
    def client_token(self) -> pulumi.Output[_builtins.str]:
        """
        The client token.
        """
        return pulumi.get(self, "client_token")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Name of the RUM application.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="productAnalyticsRetentionState")
    def product_analytics_retention_state(self) -> pulumi.Output[_builtins.str]:
        """
        Controls the retention policy for Product Analytics data derived from RUM events. Valid values are `MAX`, `NONE`.
        """
        return pulumi.get(self, "product_analytics_retention_state")

    @_builtins.property
    @pulumi.getter(name="rumEventProcessingState")
    def rum_event_processing_state(self) -> pulumi.Output[_builtins.str]:
        """
        Configures which RUM events are processed and stored for the application. Valid values are `ALL`, `ERROR_FOCUSED_MODE`, `NONE`.
        """
        return pulumi.get(self, "rum_event_processing_state")

    @_builtins.property
    @pulumi.getter
    def type(self) -> pulumi.Output[_builtins.str]:
        """
        Type of the RUM application. Supported values are `browser`, `ios`, `android`, `react-native`, `flutter`. Defaults to `"browser"`.
        """
        return pulumi.get(self, "type")

