# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['SensitiveDataScannerGroupArgs', 'SensitiveDataScannerGroup']

@pulumi.input_type
class SensitiveDataScannerGroupArgs:
    def __init__(__self__, *,
                 filter: pulumi.Input['SensitiveDataScannerGroupFilterArgs'],
                 is_enabled: pulumi.Input[_builtins.bool],
                 name: pulumi.Input[_builtins.str],
                 product_lists: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]],
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 samplings: Optional[pulumi.Input[Sequence[pulumi.Input['SensitiveDataScannerGroupSamplingArgs']]]] = None):
        """
        The set of arguments for constructing a SensitiveDataScannerGroup resource.
        :param pulumi.Input['SensitiveDataScannerGroupFilterArgs'] filter: Filter object the scanning group applies.
        :param pulumi.Input[_builtins.bool] is_enabled: Whether or not the scanning group is enabled. If the group doesn't contain any rule or if all the rules in it are disabled, the group is force-disabled by our backend
        :param pulumi.Input[_builtins.str] name: Name of the Datadog scanning group.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] product_lists: List of products the scanning group applies. Valid values are `logs`, `rum`, `events`, `apm`.
        :param pulumi.Input[_builtins.str] description: Description of the Datadog scanning group.
        :param pulumi.Input[Sequence[pulumi.Input['SensitiveDataScannerGroupSamplingArgs']]] samplings: List of sampling configurations per product type for the scanning group.
        """
        pulumi.set(__self__, "filter", filter)
        pulumi.set(__self__, "is_enabled", is_enabled)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "product_lists", product_lists)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if samplings is not None:
            pulumi.set(__self__, "samplings", samplings)

    @_builtins.property
    @pulumi.getter
    def filter(self) -> pulumi.Input['SensitiveDataScannerGroupFilterArgs']:
        """
        Filter object the scanning group applies.
        """
        return pulumi.get(self, "filter")

    @filter.setter
    def filter(self, value: pulumi.Input['SensitiveDataScannerGroupFilterArgs']):
        pulumi.set(self, "filter", value)

    @_builtins.property
    @pulumi.getter(name="isEnabled")
    def is_enabled(self) -> pulumi.Input[_builtins.bool]:
        """
        Whether or not the scanning group is enabled. If the group doesn't contain any rule or if all the rules in it are disabled, the group is force-disabled by our backend
        """
        return pulumi.get(self, "is_enabled")

    @is_enabled.setter
    def is_enabled(self, value: pulumi.Input[_builtins.bool]):
        pulumi.set(self, "is_enabled", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Input[_builtins.str]:
        """
        Name of the Datadog scanning group.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="productLists")
    def product_lists(self) -> pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]:
        """
        List of products the scanning group applies. Valid values are `logs`, `rum`, `events`, `apm`.
        """
        return pulumi.get(self, "product_lists")

    @product_lists.setter
    def product_lists(self, value: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]):
        pulumi.set(self, "product_lists", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Description of the Datadog scanning group.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def samplings(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SensitiveDataScannerGroupSamplingArgs']]]]:
        """
        List of sampling configurations per product type for the scanning group.
        """
        return pulumi.get(self, "samplings")

    @samplings.setter
    def samplings(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SensitiveDataScannerGroupSamplingArgs']]]]):
        pulumi.set(self, "samplings", value)


@pulumi.input_type
class _SensitiveDataScannerGroupState:
    def __init__(__self__, *,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 filter: Optional[pulumi.Input['SensitiveDataScannerGroupFilterArgs']] = None,
                 is_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 product_lists: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 samplings: Optional[pulumi.Input[Sequence[pulumi.Input['SensitiveDataScannerGroupSamplingArgs']]]] = None):
        """
        Input properties used for looking up and filtering SensitiveDataScannerGroup resources.
        :param pulumi.Input[_builtins.str] description: Description of the Datadog scanning group.
        :param pulumi.Input['SensitiveDataScannerGroupFilterArgs'] filter: Filter object the scanning group applies.
        :param pulumi.Input[_builtins.bool] is_enabled: Whether or not the scanning group is enabled. If the group doesn't contain any rule or if all the rules in it are disabled, the group is force-disabled by our backend
        :param pulumi.Input[_builtins.str] name: Name of the Datadog scanning group.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] product_lists: List of products the scanning group applies. Valid values are `logs`, `rum`, `events`, `apm`.
        :param pulumi.Input[Sequence[pulumi.Input['SensitiveDataScannerGroupSamplingArgs']]] samplings: List of sampling configurations per product type for the scanning group.
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if filter is not None:
            pulumi.set(__self__, "filter", filter)
        if is_enabled is not None:
            pulumi.set(__self__, "is_enabled", is_enabled)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if product_lists is not None:
            pulumi.set(__self__, "product_lists", product_lists)
        if samplings is not None:
            pulumi.set(__self__, "samplings", samplings)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Description of the Datadog scanning group.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def filter(self) -> Optional[pulumi.Input['SensitiveDataScannerGroupFilterArgs']]:
        """
        Filter object the scanning group applies.
        """
        return pulumi.get(self, "filter")

    @filter.setter
    def filter(self, value: Optional[pulumi.Input['SensitiveDataScannerGroupFilterArgs']]):
        pulumi.set(self, "filter", value)

    @_builtins.property
    @pulumi.getter(name="isEnabled")
    def is_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether or not the scanning group is enabled. If the group doesn't contain any rule or if all the rules in it are disabled, the group is force-disabled by our backend
        """
        return pulumi.get(self, "is_enabled")

    @is_enabled.setter
    def is_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "is_enabled", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the Datadog scanning group.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="productLists")
    def product_lists(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of products the scanning group applies. Valid values are `logs`, `rum`, `events`, `apm`.
        """
        return pulumi.get(self, "product_lists")

    @product_lists.setter
    def product_lists(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "product_lists", value)

    @_builtins.property
    @pulumi.getter
    def samplings(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SensitiveDataScannerGroupSamplingArgs']]]]:
        """
        List of sampling configurations per product type for the scanning group.
        """
        return pulumi.get(self, "samplings")

    @samplings.setter
    def samplings(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SensitiveDataScannerGroupSamplingArgs']]]]):
        pulumi.set(self, "samplings", value)


@pulumi.type_token("datadog:index/sensitiveDataScannerGroup:SensitiveDataScannerGroup")
class SensitiveDataScannerGroup(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 filter: Optional[pulumi.Input[Union['SensitiveDataScannerGroupFilterArgs', 'SensitiveDataScannerGroupFilterArgsDict']]] = None,
                 is_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 product_lists: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 samplings: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SensitiveDataScannerGroupSamplingArgs', 'SensitiveDataScannerGroupSamplingArgsDict']]]]] = None,
                 __props__=None):
        """
        Provides a Sensitive Data Scanner group resource.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_datadog as datadog

        # Create new sensitive_data_scanner_group resource
        mygroup = datadog.SensitiveDataScannerGroup("mygroup",
            name="My new scanning group",
            description="A relevant description",
            filter={
                "query": "service:my-service",
            },
            is_enabled=True,
            product_lists=[
                "apm",
                "logs",
            ],
            samplings=[
                {
                    "product": "apm",
                    "rate": 100,
                },
                {
                    "product": "logs",
                    "rate": 10,
                },
            ])
        ```

        ## Import

        The `pulumi import` command can be used, for example:

        ```sh
        $ pulumi import datadog:index/sensitiveDataScannerGroup:SensitiveDataScannerGroup new_list "<group_id>"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] description: Description of the Datadog scanning group.
        :param pulumi.Input[Union['SensitiveDataScannerGroupFilterArgs', 'SensitiveDataScannerGroupFilterArgsDict']] filter: Filter object the scanning group applies.
        :param pulumi.Input[_builtins.bool] is_enabled: Whether or not the scanning group is enabled. If the group doesn't contain any rule or if all the rules in it are disabled, the group is force-disabled by our backend
        :param pulumi.Input[_builtins.str] name: Name of the Datadog scanning group.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] product_lists: List of products the scanning group applies. Valid values are `logs`, `rum`, `events`, `apm`.
        :param pulumi.Input[Sequence[pulumi.Input[Union['SensitiveDataScannerGroupSamplingArgs', 'SensitiveDataScannerGroupSamplingArgsDict']]]] samplings: List of sampling configurations per product type for the scanning group.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: SensitiveDataScannerGroupArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Sensitive Data Scanner group resource.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_datadog as datadog

        # Create new sensitive_data_scanner_group resource
        mygroup = datadog.SensitiveDataScannerGroup("mygroup",
            name="My new scanning group",
            description="A relevant description",
            filter={
                "query": "service:my-service",
            },
            is_enabled=True,
            product_lists=[
                "apm",
                "logs",
            ],
            samplings=[
                {
                    "product": "apm",
                    "rate": 100,
                },
                {
                    "product": "logs",
                    "rate": 10,
                },
            ])
        ```

        ## Import

        The `pulumi import` command can be used, for example:

        ```sh
        $ pulumi import datadog:index/sensitiveDataScannerGroup:SensitiveDataScannerGroup new_list "<group_id>"
        ```

        :param str resource_name: The name of the resource.
        :param SensitiveDataScannerGroupArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(SensitiveDataScannerGroupArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 filter: Optional[pulumi.Input[Union['SensitiveDataScannerGroupFilterArgs', 'SensitiveDataScannerGroupFilterArgsDict']]] = None,
                 is_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 product_lists: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 samplings: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SensitiveDataScannerGroupSamplingArgs', 'SensitiveDataScannerGroupSamplingArgsDict']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = SensitiveDataScannerGroupArgs.__new__(SensitiveDataScannerGroupArgs)

            __props__.__dict__["description"] = description
            if filter is None and not opts.urn:
                raise TypeError("Missing required property 'filter'")
            __props__.__dict__["filter"] = filter
            if is_enabled is None and not opts.urn:
                raise TypeError("Missing required property 'is_enabled'")
            __props__.__dict__["is_enabled"] = is_enabled
            if name is None and not opts.urn:
                raise TypeError("Missing required property 'name'")
            __props__.__dict__["name"] = name
            if product_lists is None and not opts.urn:
                raise TypeError("Missing required property 'product_lists'")
            __props__.__dict__["product_lists"] = product_lists
            __props__.__dict__["samplings"] = samplings
        super(SensitiveDataScannerGroup, __self__).__init__(
            'datadog:index/sensitiveDataScannerGroup:SensitiveDataScannerGroup',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            filter: Optional[pulumi.Input[Union['SensitiveDataScannerGroupFilterArgs', 'SensitiveDataScannerGroupFilterArgsDict']]] = None,
            is_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            product_lists: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            samplings: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SensitiveDataScannerGroupSamplingArgs', 'SensitiveDataScannerGroupSamplingArgsDict']]]]] = None) -> 'SensitiveDataScannerGroup':
        """
        Get an existing SensitiveDataScannerGroup resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] description: Description of the Datadog scanning group.
        :param pulumi.Input[Union['SensitiveDataScannerGroupFilterArgs', 'SensitiveDataScannerGroupFilterArgsDict']] filter: Filter object the scanning group applies.
        :param pulumi.Input[_builtins.bool] is_enabled: Whether or not the scanning group is enabled. If the group doesn't contain any rule or if all the rules in it are disabled, the group is force-disabled by our backend
        :param pulumi.Input[_builtins.str] name: Name of the Datadog scanning group.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] product_lists: List of products the scanning group applies. Valid values are `logs`, `rum`, `events`, `apm`.
        :param pulumi.Input[Sequence[pulumi.Input[Union['SensitiveDataScannerGroupSamplingArgs', 'SensitiveDataScannerGroupSamplingArgsDict']]]] samplings: List of sampling configurations per product type for the scanning group.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _SensitiveDataScannerGroupState.__new__(_SensitiveDataScannerGroupState)

        __props__.__dict__["description"] = description
        __props__.__dict__["filter"] = filter
        __props__.__dict__["is_enabled"] = is_enabled
        __props__.__dict__["name"] = name
        __props__.__dict__["product_lists"] = product_lists
        __props__.__dict__["samplings"] = samplings
        return SensitiveDataScannerGroup(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Description of the Datadog scanning group.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def filter(self) -> pulumi.Output['outputs.SensitiveDataScannerGroupFilter']:
        """
        Filter object the scanning group applies.
        """
        return pulumi.get(self, "filter")

    @_builtins.property
    @pulumi.getter(name="isEnabled")
    def is_enabled(self) -> pulumi.Output[_builtins.bool]:
        """
        Whether or not the scanning group is enabled. If the group doesn't contain any rule or if all the rules in it are disabled, the group is force-disabled by our backend
        """
        return pulumi.get(self, "is_enabled")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Name of the Datadog scanning group.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="productLists")
    def product_lists(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        List of products the scanning group applies. Valid values are `logs`, `rum`, `events`, `apm`.
        """
        return pulumi.get(self, "product_lists")

    @_builtins.property
    @pulumi.getter
    def samplings(self) -> pulumi.Output[Optional[Sequence['outputs.SensitiveDataScannerGroupSampling']]]:
        """
        List of sampling configurations per product type for the scanning group.
        """
        return pulumi.get(self, "samplings")

