# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['TagPipelineRulesetArgs', 'TagPipelineRuleset']

@pulumi.input_type
class TagPipelineRulesetArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[_builtins.str],
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 rules: Optional[pulumi.Input[Sequence[pulumi.Input['TagPipelineRulesetRuleArgs']]]] = None):
        """
        The set of arguments for constructing a TagPipelineRuleset resource.
        :param pulumi.Input[_builtins.str] name: The name of the ruleset.
        :param pulumi.Input[_builtins.bool] enabled: Whether the ruleset is enabled.
        :param pulumi.Input[Sequence[pulumi.Input['TagPipelineRulesetRuleArgs']]] rules: The rules in the ruleset.
        """
        pulumi.set(__self__, "name", name)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if rules is not None:
            pulumi.set(__self__, "rules", rules)

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the ruleset.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether the ruleset is enabled.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enabled", value)

    @_builtins.property
    @pulumi.getter
    def rules(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['TagPipelineRulesetRuleArgs']]]]:
        """
        The rules in the ruleset.
        """
        return pulumi.get(self, "rules")

    @rules.setter
    def rules(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['TagPipelineRulesetRuleArgs']]]]):
        pulumi.set(self, "rules", value)


@pulumi.input_type
class _TagPipelineRulesetState:
    def __init__(__self__, *,
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 position: Optional[pulumi.Input[_builtins.int]] = None,
                 rules: Optional[pulumi.Input[Sequence[pulumi.Input['TagPipelineRulesetRuleArgs']]]] = None,
                 version: Optional[pulumi.Input[_builtins.int]] = None):
        """
        Input properties used for looking up and filtering TagPipelineRuleset resources.
        :param pulumi.Input[_builtins.bool] enabled: Whether the ruleset is enabled.
        :param pulumi.Input[_builtins.str] name: The name of the ruleset.
        :param pulumi.Input[_builtins.int] position: The position of the ruleset in the pipeline.
        :param pulumi.Input[Sequence[pulumi.Input['TagPipelineRulesetRuleArgs']]] rules: The rules in the ruleset.
        :param pulumi.Input[_builtins.int] version: The version of the ruleset.
        """
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if position is not None:
            pulumi.set(__self__, "position", position)
        if rules is not None:
            pulumi.set(__self__, "rules", rules)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether the ruleset is enabled.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enabled", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the ruleset.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def position(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The position of the ruleset in the pipeline.
        """
        return pulumi.get(self, "position")

    @position.setter
    def position(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "position", value)

    @_builtins.property
    @pulumi.getter
    def rules(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['TagPipelineRulesetRuleArgs']]]]:
        """
        The rules in the ruleset.
        """
        return pulumi.get(self, "rules")

    @rules.setter
    def rules(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['TagPipelineRulesetRuleArgs']]]]):
        pulumi.set(self, "rules", value)

    @_builtins.property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The version of the ruleset.
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "version", value)


@pulumi.type_token("datadog:index/tagPipelineRuleset:TagPipelineRuleset")
class TagPipelineRuleset(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 rules: Optional[pulumi.Input[Sequence[pulumi.Input[Union['TagPipelineRulesetRuleArgs', 'TagPipelineRulesetRuleArgsDict']]]]] = None,
                 __props__=None):
        """
        Provides a Datadog Tag Pipeline Ruleset resource.

        ## Example Usage

        ## Import

        The `pulumi import` command can be used, for example:

        ```sh
        $ pulumi import datadog:index/tagPipelineRuleset:TagPipelineRuleset example "your-ruleset-id-here"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] enabled: Whether the ruleset is enabled.
        :param pulumi.Input[_builtins.str] name: The name of the ruleset.
        :param pulumi.Input[Sequence[pulumi.Input[Union['TagPipelineRulesetRuleArgs', 'TagPipelineRulesetRuleArgsDict']]]] rules: The rules in the ruleset.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: TagPipelineRulesetArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Datadog Tag Pipeline Ruleset resource.

        ## Example Usage

        ## Import

        The `pulumi import` command can be used, for example:

        ```sh
        $ pulumi import datadog:index/tagPipelineRuleset:TagPipelineRuleset example "your-ruleset-id-here"
        ```

        :param str resource_name: The name of the resource.
        :param TagPipelineRulesetArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(TagPipelineRulesetArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 rules: Optional[pulumi.Input[Sequence[pulumi.Input[Union['TagPipelineRulesetRuleArgs', 'TagPipelineRulesetRuleArgsDict']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = TagPipelineRulesetArgs.__new__(TagPipelineRulesetArgs)

            __props__.__dict__["enabled"] = enabled
            if name is None and not opts.urn:
                raise TypeError("Missing required property 'name'")
            __props__.__dict__["name"] = name
            __props__.__dict__["rules"] = rules
            __props__.__dict__["position"] = None
            __props__.__dict__["version"] = None
        super(TagPipelineRuleset, __self__).__init__(
            'datadog:index/tagPipelineRuleset:TagPipelineRuleset',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            position: Optional[pulumi.Input[_builtins.int]] = None,
            rules: Optional[pulumi.Input[Sequence[pulumi.Input[Union['TagPipelineRulesetRuleArgs', 'TagPipelineRulesetRuleArgsDict']]]]] = None,
            version: Optional[pulumi.Input[_builtins.int]] = None) -> 'TagPipelineRuleset':
        """
        Get an existing TagPipelineRuleset resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] enabled: Whether the ruleset is enabled.
        :param pulumi.Input[_builtins.str] name: The name of the ruleset.
        :param pulumi.Input[_builtins.int] position: The position of the ruleset in the pipeline.
        :param pulumi.Input[Sequence[pulumi.Input[Union['TagPipelineRulesetRuleArgs', 'TagPipelineRulesetRuleArgsDict']]]] rules: The rules in the ruleset.
        :param pulumi.Input[_builtins.int] version: The version of the ruleset.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _TagPipelineRulesetState.__new__(_TagPipelineRulesetState)

        __props__.__dict__["enabled"] = enabled
        __props__.__dict__["name"] = name
        __props__.__dict__["position"] = position
        __props__.__dict__["rules"] = rules
        __props__.__dict__["version"] = version
        return TagPipelineRuleset(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> pulumi.Output[_builtins.bool]:
        """
        Whether the ruleset is enabled.
        """
        return pulumi.get(self, "enabled")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the ruleset.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def position(self) -> pulumi.Output[_builtins.int]:
        """
        The position of the ruleset in the pipeline.
        """
        return pulumi.get(self, "position")

    @_builtins.property
    @pulumi.getter
    def rules(self) -> pulumi.Output[Optional[Sequence['outputs.TagPipelineRulesetRule']]]:
        """
        The rules in the ruleset.
        """
        return pulumi.get(self, "rules")

    @_builtins.property
    @pulumi.getter
    def version(self) -> pulumi.Output[_builtins.int]:
        """
        The version of the ruleset.
        """
        return pulumi.get(self, "version")

