# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['TagPipelineRulesetsArgs', 'TagPipelineRulesets']

@pulumi.input_type
class TagPipelineRulesetsArgs:
    def __init__(__self__, *,
                 ruleset_ids: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]):
        """
        The set of arguments for constructing a TagPipelineRulesets resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] ruleset_ids: The list of Tag Pipeline Ruleset IDs, in order. Rulesets are executed in the order specified in this list.
        """
        pulumi.set(__self__, "ruleset_ids", ruleset_ids)

    @_builtins.property
    @pulumi.getter(name="rulesetIds")
    def ruleset_ids(self) -> pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]:
        """
        The list of Tag Pipeline Ruleset IDs, in order. Rulesets are executed in the order specified in this list.
        """
        return pulumi.get(self, "ruleset_ids")

    @ruleset_ids.setter
    def ruleset_ids(self, value: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]):
        pulumi.set(self, "ruleset_ids", value)


@pulumi.input_type
class _TagPipelineRulesetsState:
    def __init__(__self__, *,
                 ruleset_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None):
        """
        Input properties used for looking up and filtering TagPipelineRulesets resources.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] ruleset_ids: The list of Tag Pipeline Ruleset IDs, in order. Rulesets are executed in the order specified in this list.
        """
        if ruleset_ids is not None:
            pulumi.set(__self__, "ruleset_ids", ruleset_ids)

    @_builtins.property
    @pulumi.getter(name="rulesetIds")
    def ruleset_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The list of Tag Pipeline Ruleset IDs, in order. Rulesets are executed in the order specified in this list.
        """
        return pulumi.get(self, "ruleset_ids")

    @ruleset_ids.setter
    def ruleset_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "ruleset_ids", value)


@pulumi.type_token("datadog:index/tagPipelineRulesets:TagPipelineRulesets")
class TagPipelineRulesets(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 ruleset_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        """
        Provides a Datadog Tag Pipeline Ruleset Order resource that can be used to manage the order of Tag Pipeline Rulesets.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_datadog as datadog

        # Create new tag_pipeline_ruleset_order resource
        my_rulesets = datadog.TagPipelineRulesets("my_rulesets", ruleset_ids=[
            "ruleset-id-1",
            "ruleset-id-2",
            "ruleset-id-3",
        ])
        ```

        ## Import

        The `pulumi import` command can be used, for example:

        ```sh
        $ pulumi import datadog:index/tagPipelineRulesets:TagPipelineRulesets my_rulesets order
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] ruleset_ids: The list of Tag Pipeline Ruleset IDs, in order. Rulesets are executed in the order specified in this list.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: TagPipelineRulesetsArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Datadog Tag Pipeline Ruleset Order resource that can be used to manage the order of Tag Pipeline Rulesets.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_datadog as datadog

        # Create new tag_pipeline_ruleset_order resource
        my_rulesets = datadog.TagPipelineRulesets("my_rulesets", ruleset_ids=[
            "ruleset-id-1",
            "ruleset-id-2",
            "ruleset-id-3",
        ])
        ```

        ## Import

        The `pulumi import` command can be used, for example:

        ```sh
        $ pulumi import datadog:index/tagPipelineRulesets:TagPipelineRulesets my_rulesets order
        ```

        :param str resource_name: The name of the resource.
        :param TagPipelineRulesetsArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(TagPipelineRulesetsArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 ruleset_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = TagPipelineRulesetsArgs.__new__(TagPipelineRulesetsArgs)

            if ruleset_ids is None and not opts.urn:
                raise TypeError("Missing required property 'ruleset_ids'")
            __props__.__dict__["ruleset_ids"] = ruleset_ids
        super(TagPipelineRulesets, __self__).__init__(
            'datadog:index/tagPipelineRulesets:TagPipelineRulesets',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            ruleset_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None) -> 'TagPipelineRulesets':
        """
        Get an existing TagPipelineRulesets resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] ruleset_ids: The list of Tag Pipeline Ruleset IDs, in order. Rulesets are executed in the order specified in this list.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _TagPipelineRulesetsState.__new__(_TagPipelineRulesetsState)

        __props__.__dict__["ruleset_ids"] = ruleset_ids
        return TagPipelineRulesets(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="rulesetIds")
    def ruleset_ids(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        The list of Tag Pipeline Ruleset IDs, in order. Rulesets are executed in the order specified in this list.
        """
        return pulumi.get(self, "ruleset_ids")

