# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['TeamMembershipArgs', 'TeamMembership']

@pulumi.input_type
class TeamMembershipArgs:
    def __init__(__self__, *,
                 team_id: pulumi.Input[_builtins.str],
                 user_id: pulumi.Input[_builtins.str],
                 role: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a TeamMembership resource.
        :param pulumi.Input[_builtins.str] team_id: ID of the team the team membership is associated with.
        :param pulumi.Input[_builtins.str] user_id: The ID of the user.
        :param pulumi.Input[_builtins.str] role: The user's role within the team. Valid values are `admin`.
        """
        pulumi.set(__self__, "team_id", team_id)
        pulumi.set(__self__, "user_id", user_id)
        if role is not None:
            pulumi.set(__self__, "role", role)

    @_builtins.property
    @pulumi.getter(name="teamId")
    def team_id(self) -> pulumi.Input[_builtins.str]:
        """
        ID of the team the team membership is associated with.
        """
        return pulumi.get(self, "team_id")

    @team_id.setter
    def team_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "team_id", value)

    @_builtins.property
    @pulumi.getter(name="userId")
    def user_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the user.
        """
        return pulumi.get(self, "user_id")

    @user_id.setter
    def user_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "user_id", value)

    @_builtins.property
    @pulumi.getter
    def role(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The user's role within the team. Valid values are `admin`.
        """
        return pulumi.get(self, "role")

    @role.setter
    def role(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "role", value)


@pulumi.input_type
class _TeamMembershipState:
    def __init__(__self__, *,
                 role: Optional[pulumi.Input[_builtins.str]] = None,
                 team_id: Optional[pulumi.Input[_builtins.str]] = None,
                 user_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering TeamMembership resources.
        :param pulumi.Input[_builtins.str] role: The user's role within the team. Valid values are `admin`.
        :param pulumi.Input[_builtins.str] team_id: ID of the team the team membership is associated with.
        :param pulumi.Input[_builtins.str] user_id: The ID of the user.
        """
        if role is not None:
            pulumi.set(__self__, "role", role)
        if team_id is not None:
            pulumi.set(__self__, "team_id", team_id)
        if user_id is not None:
            pulumi.set(__self__, "user_id", user_id)

    @_builtins.property
    @pulumi.getter
    def role(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The user's role within the team. Valid values are `admin`.
        """
        return pulumi.get(self, "role")

    @role.setter
    def role(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "role", value)

    @_builtins.property
    @pulumi.getter(name="teamId")
    def team_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ID of the team the team membership is associated with.
        """
        return pulumi.get(self, "team_id")

    @team_id.setter
    def team_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "team_id", value)

    @_builtins.property
    @pulumi.getter(name="userId")
    def user_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the user.
        """
        return pulumi.get(self, "user_id")

    @user_id.setter
    def user_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "user_id", value)


@pulumi.type_token("datadog:index/teamMembership:TeamMembership")
class TeamMembership(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 role: Optional[pulumi.Input[_builtins.str]] = None,
                 team_id: Optional[pulumi.Input[_builtins.str]] = None,
                 user_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Provides a Datadog TeamMembership resource. This can be used to create and manage Datadog team_membership.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_datadog as datadog

        foo = datadog.Team("foo",
            description="Example team",
            handle="example-team-updated",
            name="Example Team-updated")
        foo_user = datadog.User("foo", email="new@example.com")
        # Create new team_membership resource
        foo_team_membership = datadog.TeamMembership("foo",
            team_id=foo.id,
            user_id=foo_user.id,
            role="admin")
        ```

        ## Import

        The `pulumi import` command can be used, for example:

        This resource is imported using team_id and user_id seperated by `:`.

        ```sh
        $ pulumi import datadog:index/teamMembership:TeamMembership foo "${team_id}:${user_id}"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] role: The user's role within the team. Valid values are `admin`.
        :param pulumi.Input[_builtins.str] team_id: ID of the team the team membership is associated with.
        :param pulumi.Input[_builtins.str] user_id: The ID of the user.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: TeamMembershipArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Datadog TeamMembership resource. This can be used to create and manage Datadog team_membership.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_datadog as datadog

        foo = datadog.Team("foo",
            description="Example team",
            handle="example-team-updated",
            name="Example Team-updated")
        foo_user = datadog.User("foo", email="new@example.com")
        # Create new team_membership resource
        foo_team_membership = datadog.TeamMembership("foo",
            team_id=foo.id,
            user_id=foo_user.id,
            role="admin")
        ```

        ## Import

        The `pulumi import` command can be used, for example:

        This resource is imported using team_id and user_id seperated by `:`.

        ```sh
        $ pulumi import datadog:index/teamMembership:TeamMembership foo "${team_id}:${user_id}"
        ```

        :param str resource_name: The name of the resource.
        :param TeamMembershipArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(TeamMembershipArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 role: Optional[pulumi.Input[_builtins.str]] = None,
                 team_id: Optional[pulumi.Input[_builtins.str]] = None,
                 user_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = TeamMembershipArgs.__new__(TeamMembershipArgs)

            __props__.__dict__["role"] = role
            if team_id is None and not opts.urn:
                raise TypeError("Missing required property 'team_id'")
            __props__.__dict__["team_id"] = team_id
            if user_id is None and not opts.urn:
                raise TypeError("Missing required property 'user_id'")
            __props__.__dict__["user_id"] = user_id
        super(TeamMembership, __self__).__init__(
            'datadog:index/teamMembership:TeamMembership',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            role: Optional[pulumi.Input[_builtins.str]] = None,
            team_id: Optional[pulumi.Input[_builtins.str]] = None,
            user_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'TeamMembership':
        """
        Get an existing TeamMembership resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] role: The user's role within the team. Valid values are `admin`.
        :param pulumi.Input[_builtins.str] team_id: ID of the team the team membership is associated with.
        :param pulumi.Input[_builtins.str] user_id: The ID of the user.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _TeamMembershipState.__new__(_TeamMembershipState)

        __props__.__dict__["role"] = role
        __props__.__dict__["team_id"] = team_id
        __props__.__dict__["user_id"] = user_id
        return TeamMembership(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def role(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The user's role within the team. Valid values are `admin`.
        """
        return pulumi.get(self, "role")

    @_builtins.property
    @pulumi.getter(name="teamId")
    def team_id(self) -> pulumi.Output[_builtins.str]:
        """
        ID of the team the team membership is associated with.
        """
        return pulumi.get(self, "team_id")

    @_builtins.property
    @pulumi.getter(name="userId")
    def user_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the user.
        """
        return pulumi.get(self, "user_id")

