from __future__ import annotations

from typing import (
    Any,
    Callable,
    Optional,
    List,
    Tuple,
    Protocol,
    runtime_checkable,
    Union,
    Iterable,
    SupportsIndex,
)

__all__ = [
    "ContentType",
    "Comment",
    "Doctype",
    "DocumentEnd",
    "Element",
    "EndTag",
    "TextChunk",
    "HTMLRewriter",
    "HTMLRewriterOptions",
]

from enum import Enum

class ContentType(Enum):
    TEXT = 0
    HTML = 1

class Comment:
    @property
    def text(self) -> str: ...
    @text.setter
    def text(self, value: str) -> None: ...
    def remove(self) -> None: ...
    @property
    def removed(self) -> bool: ...
    def before(
        self, content: str, content_type: Optional[ContentType] = None
    ) -> None: ...
    def after(
        self, content: str, content_type: Optional[ContentType] = None
    ) -> None: ...

class Doctype:
    @property
    def name(self) -> Optional[str]: ...
    @property
    def public_id(self) -> Optional[str]: ...
    @property
    def system_id(self) -> Optional[str]: ...

class DocumentEnd:
    def append(
        self, content: str, content_type: Optional[ContentType] = None
    ) -> None: ...

class Element:
    @property
    def tag_name(self) -> str: ...
    @tag_name.setter
    def tag_name(self, value: str) -> None: ...
    @property
    def removed(self) -> bool: ...
    def remove(self) -> None: ...
    @property
    def namespace_uri(self) -> str: ...
    @property
    def attributes(self) -> List[Tuple[str, str]]: ...
    def get_attribute(self, name: str) -> Optional[str]: ...
    def has_attribute(self, name: str) -> bool: ...
    def set_attribute(self, name: str, value: str) -> None: ...
    def remove_attribute(self, name: str) -> None: ...
    def prepend(
        self, content: str, content_type: Optional[ContentType] = None
    ) -> None: ...
    def append(
        self, content: str, content_type: Optional[ContentType] = None
    ) -> None: ...
    def before(
        self, content: str, content_type: Optional[ContentType] = None
    ) -> None: ...
    def after(
        self, content: str, content_type: Optional[ContentType] = None
    ) -> None: ...
    def set_inner_content(
        self, content: str, content_type: Optional[ContentType] = ...
    ) -> None: ...
    def remove_and_keep_content(self) -> None: ...

class EndTag:
    @property
    def name(self) -> str: ...
    @name.setter
    def name(self, value: str) -> None: ...
    def before(
        self, content: str, content_type: Optional[ContentType] = ...
    ) -> None: ...
    def after(
        self, content: str, content_type: Optional[ContentType] = ...
    ) -> None: ...
    def remove(self) -> None: ...

class TextChunk:
    @property
    def text(self) -> str: ...
    @property
    def last_in_text_node(self) -> bool: ...
    def before(
        self, content: str, content_type: Optional[ContentType] = None
    ) -> None: ...
    def after(
        self, content: str, content_type: Optional[ContentType] = None
    ) -> None: ...
    def replace(
        self, content: str, content_type: Optional[ContentType] = None
    ) -> None: ...
    def remove(self) -> None: ...
    @property
    def removed(self) -> bool: ...

class HTMLRewriterOptions:
    enable_esi_tags: Optional[bool]
    def __init__(self, enable_esi_tags: Optional[bool] = None) -> None: ...

class HTMLRewriter:
    def __init__(
        self,
        output_sink: Callable[[Union[bytes, bytearray, Iterable[SupportsIndex]]], Any],
        options: Optional[HTMLRewriterOptions] = None,
    ) -> None: ...
    def on(self, selector: str, handlers: Any) -> None: ...
    def on_document(self, handlers: Any) -> None: ...
    def write(self, chunk: bytes) -> None: ...
    def end(self) -> None: ...
    @property
    def constructed(self) -> bool: ...

@runtime_checkable
class ElementHandler(Protocol):
    def element(self, e: Element) -> None: ...
    def comments(self, c: Comment) -> None: ...
    def text(self, t: TextChunk) -> None: ...

@runtime_checkable
class DocumentHandler(Protocol):
    def doctype(self, d: Doctype) -> None: ...
    def comments(self, c: Comment) -> None: ...
    def text(self, t: TextChunk) -> None: ...
    def end(self, e: DocumentEnd) -> None: ...
