# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ClusterArgs', 'Cluster']

@pulumi.input_type
class ClusterArgs:
    def __init__(__self__, *,
                 project_id: pulumi.Input[_builtins.str],
                 provider_instance_size_name: pulumi.Input[_builtins.str],
                 provider_name: pulumi.Input[_builtins.str],
                 accept_data_risks_and_force_replica_set_reconfig: Optional[pulumi.Input[_builtins.str]] = None,
                 advanced_configuration: Optional[pulumi.Input['ClusterAdvancedConfigurationArgs']] = None,
                 auto_scaling_compute_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 auto_scaling_compute_scale_down_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 auto_scaling_disk_gb_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 backing_provider_name: Optional[pulumi.Input[_builtins.str]] = None,
                 backup_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 bi_connector_config: Optional[pulumi.Input['ClusterBiConnectorConfigArgs']] = None,
                 cloud_backup: Optional[pulumi.Input[_builtins.bool]] = None,
                 cluster_type: Optional[pulumi.Input[_builtins.str]] = None,
                 disk_size_gb: Optional[pulumi.Input[_builtins.float]] = None,
                 encryption_at_rest_provider: Optional[pulumi.Input[_builtins.str]] = None,
                 labels: Optional[pulumi.Input[Sequence[pulumi.Input['ClusterLabelArgs']]]] = None,
                 mongo_db_major_version: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 num_shards: Optional[pulumi.Input[_builtins.int]] = None,
                 paused: Optional[pulumi.Input[_builtins.bool]] = None,
                 pinned_fcv: Optional[pulumi.Input['ClusterPinnedFcvArgs']] = None,
                 pit_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 provider_auto_scaling_compute_max_instance_size: Optional[pulumi.Input[_builtins.str]] = None,
                 provider_auto_scaling_compute_min_instance_size: Optional[pulumi.Input[_builtins.str]] = None,
                 provider_disk_iops: Optional[pulumi.Input[_builtins.int]] = None,
                 provider_disk_type_name: Optional[pulumi.Input[_builtins.str]] = None,
                 provider_encrypt_ebs_volume: Optional[pulumi.Input[_builtins.bool]] = None,
                 provider_region_name: Optional[pulumi.Input[_builtins.str]] = None,
                 provider_volume_type: Optional[pulumi.Input[_builtins.str]] = None,
                 redact_client_log_data: Optional[pulumi.Input[_builtins.bool]] = None,
                 replication_factor: Optional[pulumi.Input[_builtins.int]] = None,
                 replication_specs: Optional[pulumi.Input[Sequence[pulumi.Input['ClusterReplicationSpecArgs']]]] = None,
                 retain_backups_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input['ClusterTagArgs']]]] = None,
                 termination_protection_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 version_release_system: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a Cluster resource.
        :param pulumi.Input[_builtins.str] project_id: The unique ID for the project to create the cluster.
        :param pulumi.Input[_builtins.str] provider_instance_size_name: Atlas provides different instance sizes, each with a default storage capacity and RAM size. The instance size you select is used for all the data-bearing servers in your cluster. See [Create a Cluster](https://docs.atlas.mongodb.com/reference/api/clusters-create-one/) `providerSettings.instanceSizeName` for valid values and default resources.
        :param pulumi.Input[_builtins.str] provider_name: Cloud service provider on which the servers are provisioned.
               
               The possible values are:
               
               - `AWS` - Amazon AWS
               - `GCP` - Google Cloud Platform
               - `AZURE` - Microsoft Azure
               - `TENANT` - A multi-tenant deployment on one of the supported cloud service providers. Only valid when providerSettings.instanceSizeName is M0.
        :param pulumi.Input[_builtins.str] accept_data_risks_and_force_replica_set_reconfig: If reconfiguration is necessary to regain a primary due to a regional outage, submit this field alongside your topology reconfiguration to request a new regional outage resistant topology. Forced reconfigurations during an outage of the majority of electable nodes carry a risk of data loss if replicated writes (even majority committed writes) have not been replicated to the new primary node. MongoDB Atlas docs contain more information. To proceed with an operation which carries that risk, set `accept_data_risks_and_force_replica_set_reconfig` to the current date. Learn more about Reconfiguring a Replica Set during a regional outage [here](https://dochub.mongodb.org/core/regional-outage-reconfigure-replica-set).
        :param pulumi.Input[_builtins.bool] auto_scaling_compute_scale_down_enabled: Set to `true` to enable the cluster tier to scale down. This option is only available if `autoScaling.compute.enabled` is `true`.
               - If this option is enabled, you must specify a value for `providerSettings.autoScaling.compute.minInstanceSize`
        :param pulumi.Input[_builtins.str] backing_provider_name: Cloud service provider on which the server for a multi-tenant cluster is provisioned.
               
               This setting is only valid when providerSetting.providerName is TENANT and providerSetting.instanceSizeName is M0.
               
               The possible values are:
               
               - AWS - Amazon AWS
               - GCP - Google Cloud Platform
               - AZURE - Microsoft Azure
        :param pulumi.Input[_builtins.bool] backup_enabled: Legacy Backup - Set to true to enable Atlas legacy backups for the cluster.
               **Important** - MongoDB deprecated the Legacy Backup feature. Clusters that use Legacy Backup can continue to use it. MongoDB recommends using [Cloud Backups](https://docs.atlas.mongodb.com/backup/cloud-backup/overview/).
               * New Atlas clusters of any type do not support this parameter. These clusters must use Cloud Backup, `cloud_backup`, to enable Cloud Backup.  If you create a new Atlas cluster and set `backup_enabled` to true, the Provider will respond with an error.  This change doesn’t affect existing clusters that use legacy backups.
               * Setting this value to false to disable legacy backups for the cluster will let Atlas delete any stored snapshots. In order to preserve the legacy backups snapshots, disable the legacy backups and enable the cloud backups in the single **pulumi up** action.
               ```
               backup_enabled = "false"
               cloud_backup = "true"
               ```
               * The default value is false. M10 and above only.
        :param pulumi.Input['ClusterBiConnectorConfigArgs'] bi_connector_config: Specifies BI Connector for Atlas configuration on this cluster. BI Connector for Atlas is only available for M10+ clusters. See BI Connector below for more details.
        :param pulumi.Input[_builtins.str] cluster_type: Specifies the type of the cluster that you want to modify. You cannot convert a sharded cluster deployment to a replica set deployment.
               
               > **WHEN SHOULD YOU USE CLUSTERTYPE?**
               When you set replication_specs, when you are deploying Global Clusters or when you are deploying non-Global replica sets and sharded clusters.
               
               Accepted values include:
               - `REPLICASET` Replica set
               - `SHARDED` Sharded cluster
               - `GEOSHARDED` Global Cluster
        :param pulumi.Input[_builtins.float] disk_size_gb: Capacity, in gigabytes, of the host’s root volume. Increase this number to add capacity, up to a maximum possible value of 4096 (i.e., 4 TB). This value must be a positive integer.
               * The minimum disk size for dedicated clusters is 10GB for AWS and GCP. If you specify diskSizeGB with a lower disk size, Atlas defaults to the minimum disk size value.
               * Note: The maximum value for disk storage cannot exceed 50 times the maximum RAM for the selected cluster. If you require additional storage space beyond this limitation, consider upgrading your cluster to a higher tier.
               * Cannot be used with clusters with local NVMe SSDs
               * Cannot be used with Azure clusters
        :param pulumi.Input[_builtins.str] encryption_at_rest_provider: Possible values are AWS, GCP, AZURE or NONE.  Only needed if you desire to manage the keys, see [Encryption at Rest using Customer Key Management](https://docs.atlas.mongodb.com/security-aws-kms/) for complete documentation.  You must configure encryption at rest for the Atlas project before enabling it on any cluster in the project. For complete documentation on configuring Encryption at Rest, see Encryption at Rest using Customer Key Management. Requires M10 or greater. and for legacy backups, backup_enabled, to be false or omitted. **Note: Atlas encrypts all cluster storage and snapshot volumes, securing all cluster data on disk: a concept known as encryption at rest, by default**.
        :param pulumi.Input[Sequence[pulumi.Input['ClusterLabelArgs']]] labels: Set that contains key-value pairs between 1 to 255 characters in length for tagging and categorizing the cluster. See below. **DEPRECATED** Use `tags` instead.
        :param pulumi.Input[_builtins.str] mongo_db_major_version: Version of the cluster to deploy. Atlas supports all the MongoDB versions that have **not** reached [End of Live](https://www.mongodb.com/legal/support-policy/lifecycles) for M10+ clusters. If omitted, Atlas deploys the cluster with the default version. For more details, see [documentation](https://www.mongodb.com/docs/atlas/reference/faq/database/#which-versions-of-mongodb-do-service-clusters-use-). Atlas always deploys the cluster with the latest stable release of the specified version. See [Release Notes](https://www.mongodb.com/docs/upcoming/release-notes/) for latest Current Stable Release.
        :param pulumi.Input[_builtins.str] name: Name of the cluster as it appears in Atlas. Once the cluster is created, its name cannot be changed. **WARNING** Changing the name will result in destruction of the existing cluster and the creation of a new cluster.
        :param pulumi.Input[_builtins.int] num_shards: Selects whether the cluster is a replica set or a sharded cluster. If you use the replicationSpecs parameter, you must set num_shards.
        :param pulumi.Input['ClusterPinnedFcvArgs'] pinned_fcv: Pins the Feature Compatibility Version (FCV) to the current MongoDB version with a provided expiration date. To unpin the FCV the `pinned_fcv` attribute must be removed. This operation can take several minutes as the request processes through the MongoDB data plane. Once FCV is unpinned it will not be possible to downgrade the `mongo_db_major_version`. It is advised that updates to `pinned_fcv` are done isolated from other cluster changes. If a plan contains multiple changes, the FCV change will be applied first. If FCV is unpinned past the expiration date the `pinned_fcv` attribute must be removed. The following [knowledge hub article](https://kb.corp.mongodb.com/article/000021785/) and [FCV documentation](https://www.mongodb.com/docs/atlas/tutorial/major-version-change/#manage-feature-compatibility--fcv--during-upgrades) can be referenced for more details. See below.
        :param pulumi.Input[_builtins.bool] pit_enabled: Flag that indicates if the cluster uses Continuous Cloud Backup. If set to true, cloud_backup must also be set to true.
        :param pulumi.Input[_builtins.str] provider_auto_scaling_compute_max_instance_size: Maximum instance size to which your cluster can automatically scale (e.g., M40). Required if `autoScaling.compute.enabled` is `true`.
        :param pulumi.Input[_builtins.str] provider_auto_scaling_compute_min_instance_size: Minimum instance size to which your cluster can automatically scale (e.g., M10). Required if `autoScaling.compute.scaleDownEnabled` is `true`.
        :param pulumi.Input[_builtins.int] provider_disk_iops: The maximum input/output operations per second (IOPS) the system can perform. The possible values depend on the selected `provider_instance_size_name` and `disk_size_gb`.  This setting requires that `provider_instance_size_name` to be M30 or greater and cannot be used with clusters with local NVMe SSDs.  The default value for `provider_disk_iops` is the same as the cluster tier's Standard IOPS value, as viewable in the Atlas console.  It is used in cases where a higher number of IOPS is needed and possible.  If a value is submitted that is lower or equal to the default IOPS value for the cluster tier Atlas ignores the requested value and uses the default.  More details available under the providerSettings.diskIOPS parameter: [MongoDB API Clusters](https://docs.atlas.mongodb.com/reference/api/clusters-create-one/)
               * You do not need to configure IOPS for a STANDARD disk configuration but only for a PROVISIONED configuration.
        :param pulumi.Input[_builtins.str] provider_disk_type_name: Azure disk type of the server’s root volume. If omitted, Atlas uses the default disk type for the selected providerSettings.instanceSizeName.  Example disk types and associated storage sizes: P4 - 32GB, P6 - 64GB, P10 - 128GB, P15 - 256GB, P20 - 512GB, P30 - 1024GB, P40 - 2048GB, P50 - 4095GB.  More information and the most update to date disk types/storage sizes can be located at https://docs.atlas.mongodb.com/reference/api/clusters-create-one/.
        :param pulumi.Input[_builtins.bool] provider_encrypt_ebs_volume: **(Deprecated) The Flag is always true.** Flag that indicates whether the Amazon EBS encryption feature encrypts the host's root volume for both data at rest within the volume and for data moving between the volume and the cluster. Note: This setting is always enabled for clusters with local NVMe SSDs. **Atlas encrypts all cluster storage and snapshot volumes, securing all cluster data on disk: a concept known as encryption at rest, by default.**.
        :param pulumi.Input[_builtins.str] provider_region_name: Physical location of your MongoDB cluster. The region you choose can affect network latency for clients accessing your databases.  Requires the **Atlas region name**, see the reference list for [AWS](https://docs.atlas.mongodb.com/reference/amazon-aws/), [GCP](https://docs.atlas.mongodb.com/reference/google-gcp/), [Azure](https://docs.atlas.mongodb.com/reference/microsoft-azure/).
               Do not specify this field when creating a multi-region cluster using the replicationSpec document or a Global Cluster with the replicationSpecs array.
        :param pulumi.Input[_builtins.str] provider_volume_type: The type of the volume. The possible values are: `STANDARD` and `PROVISIONED`.  `PROVISIONED` is ONLY required if setting IOPS higher than the default instance IOPS.
               > **NOTE:** `STANDARD` is not available for NVME clusters.
        :param pulumi.Input[_builtins.bool] redact_client_log_data: Flag that enables or disables log redaction, see the [manual](https://www.mongodb.com/docs/manual/administration/monitoring/#log-redaction) for more information. Use this in conjunction with Encryption at Rest and TLS/SSL (Transport Encryption) to assist compliance with regulatory requirements. **Note**: Changing this setting on a cluster will trigger a rolling restart as soon as the cluster is updated. The log redaction field is updated via an Atlas API call after cluster creation. Consequently, there may be a brief period during resource creation when log redaction is not yet enabled. To ensure complete log redaction from the outset, use `AdvancedCluster`.
        :param pulumi.Input[_builtins.int] replication_factor: Number of replica set members. Each member keeps a copy of your databases, providing high availability and data redundancy. The possible values are 3, 5, or 7. The default value is 3.
        :param pulumi.Input[Sequence[pulumi.Input['ClusterReplicationSpecArgs']]] replication_specs: Configuration for cluster regions.  See Replication Spec below for more details.
        :param pulumi.Input[_builtins.bool] retain_backups_enabled: - (Optional) Set to true to retain backup snapshots for the deleted cluster. This parameter applies to the Delete operation and only affects M10 and above clusters. If you encounter the `CANNOT_DELETE_SNAPSHOT_WITH_BACKUP_COMPLIANCE_POLICY` error code, see how to delete a cluster with Backup Compliance Policy.
        :param pulumi.Input[Sequence[pulumi.Input['ClusterTagArgs']]] tags: Set that contains key-value pairs between 1 to 255 characters in length for tagging and categorizing the cluster. See below.
        :param pulumi.Input[_builtins.bool] termination_protection_enabled: Flag that indicates whether termination protection is enabled on the cluster. If set to true, MongoDB Cloud won't delete the cluster. If set to false, MongoDB Cloud will delete the cluster.
        :param pulumi.Input[_builtins.str] version_release_system: Release cadence that Atlas uses for this cluster. This parameter defaults to `LTS`. If you set this field to `CONTINUOUS`, you must omit the `mongo_db_major_version` field. Atlas accepts:
               - `CONTINUOUS`:  Atlas creates your cluster using the most recent MongoDB release. Atlas automatically updates your cluster to the latest major and rapid MongoDB releases as they become available.
               - `LTS`: Atlas creates your cluster using the latest patch release of the MongoDB version that you specify in the mongoDBMajorVersion field. Atlas automatically updates your cluster to subsequent patch releases of this MongoDB version. Atlas doesn't update your cluster to newer rapid or major MongoDB releases as they become available.
        """
        pulumi.set(__self__, "project_id", project_id)
        pulumi.set(__self__, "provider_instance_size_name", provider_instance_size_name)
        pulumi.set(__self__, "provider_name", provider_name)
        if accept_data_risks_and_force_replica_set_reconfig is not None:
            pulumi.set(__self__, "accept_data_risks_and_force_replica_set_reconfig", accept_data_risks_and_force_replica_set_reconfig)
        if advanced_configuration is not None:
            pulumi.set(__self__, "advanced_configuration", advanced_configuration)
        if auto_scaling_compute_enabled is not None:
            pulumi.set(__self__, "auto_scaling_compute_enabled", auto_scaling_compute_enabled)
        if auto_scaling_compute_scale_down_enabled is not None:
            pulumi.set(__self__, "auto_scaling_compute_scale_down_enabled", auto_scaling_compute_scale_down_enabled)
        if auto_scaling_disk_gb_enabled is not None:
            pulumi.set(__self__, "auto_scaling_disk_gb_enabled", auto_scaling_disk_gb_enabled)
        if backing_provider_name is not None:
            pulumi.set(__self__, "backing_provider_name", backing_provider_name)
        if backup_enabled is not None:
            pulumi.set(__self__, "backup_enabled", backup_enabled)
        if bi_connector_config is not None:
            pulumi.set(__self__, "bi_connector_config", bi_connector_config)
        if cloud_backup is not None:
            pulumi.set(__self__, "cloud_backup", cloud_backup)
        if cluster_type is not None:
            pulumi.set(__self__, "cluster_type", cluster_type)
        if disk_size_gb is not None:
            pulumi.set(__self__, "disk_size_gb", disk_size_gb)
        if encryption_at_rest_provider is not None:
            pulumi.set(__self__, "encryption_at_rest_provider", encryption_at_rest_provider)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if mongo_db_major_version is not None:
            pulumi.set(__self__, "mongo_db_major_version", mongo_db_major_version)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if num_shards is not None:
            pulumi.set(__self__, "num_shards", num_shards)
        if paused is not None:
            pulumi.set(__self__, "paused", paused)
        if pinned_fcv is not None:
            pulumi.set(__self__, "pinned_fcv", pinned_fcv)
        if pit_enabled is not None:
            pulumi.set(__self__, "pit_enabled", pit_enabled)
        if provider_auto_scaling_compute_max_instance_size is not None:
            pulumi.set(__self__, "provider_auto_scaling_compute_max_instance_size", provider_auto_scaling_compute_max_instance_size)
        if provider_auto_scaling_compute_min_instance_size is not None:
            pulumi.set(__self__, "provider_auto_scaling_compute_min_instance_size", provider_auto_scaling_compute_min_instance_size)
        if provider_disk_iops is not None:
            pulumi.set(__self__, "provider_disk_iops", provider_disk_iops)
        if provider_disk_type_name is not None:
            pulumi.set(__self__, "provider_disk_type_name", provider_disk_type_name)
        if provider_encrypt_ebs_volume is not None:
            warnings.warn("""All EBS volumes are encrypted by default, the option to disable encryption has been removed""", DeprecationWarning)
            pulumi.log.warn("""provider_encrypt_ebs_volume is deprecated: All EBS volumes are encrypted by default, the option to disable encryption has been removed""")
        if provider_encrypt_ebs_volume is not None:
            pulumi.set(__self__, "provider_encrypt_ebs_volume", provider_encrypt_ebs_volume)
        if provider_region_name is not None:
            pulumi.set(__self__, "provider_region_name", provider_region_name)
        if provider_volume_type is not None:
            pulumi.set(__self__, "provider_volume_type", provider_volume_type)
        if redact_client_log_data is not None:
            pulumi.set(__self__, "redact_client_log_data", redact_client_log_data)
        if replication_factor is not None:
            pulumi.set(__self__, "replication_factor", replication_factor)
        if replication_specs is not None:
            pulumi.set(__self__, "replication_specs", replication_specs)
        if retain_backups_enabled is not None:
            pulumi.set(__self__, "retain_backups_enabled", retain_backups_enabled)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if termination_protection_enabled is not None:
            pulumi.set(__self__, "termination_protection_enabled", termination_protection_enabled)
        if version_release_system is not None:
            pulumi.set(__self__, "version_release_system", version_release_system)

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Input[_builtins.str]:
        """
        The unique ID for the project to create the cluster.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "project_id", value)

    @_builtins.property
    @pulumi.getter(name="providerInstanceSizeName")
    def provider_instance_size_name(self) -> pulumi.Input[_builtins.str]:
        """
        Atlas provides different instance sizes, each with a default storage capacity and RAM size. The instance size you select is used for all the data-bearing servers in your cluster. See [Create a Cluster](https://docs.atlas.mongodb.com/reference/api/clusters-create-one/) `providerSettings.instanceSizeName` for valid values and default resources.
        """
        return pulumi.get(self, "provider_instance_size_name")

    @provider_instance_size_name.setter
    def provider_instance_size_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "provider_instance_size_name", value)

    @_builtins.property
    @pulumi.getter(name="providerName")
    def provider_name(self) -> pulumi.Input[_builtins.str]:
        """
        Cloud service provider on which the servers are provisioned.

        The possible values are:

        - `AWS` - Amazon AWS
        - `GCP` - Google Cloud Platform
        - `AZURE` - Microsoft Azure
        - `TENANT` - A multi-tenant deployment on one of the supported cloud service providers. Only valid when providerSettings.instanceSizeName is M0.
        """
        return pulumi.get(self, "provider_name")

    @provider_name.setter
    def provider_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "provider_name", value)

    @_builtins.property
    @pulumi.getter(name="acceptDataRisksAndForceReplicaSetReconfig")
    def accept_data_risks_and_force_replica_set_reconfig(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        If reconfiguration is necessary to regain a primary due to a regional outage, submit this field alongside your topology reconfiguration to request a new regional outage resistant topology. Forced reconfigurations during an outage of the majority of electable nodes carry a risk of data loss if replicated writes (even majority committed writes) have not been replicated to the new primary node. MongoDB Atlas docs contain more information. To proceed with an operation which carries that risk, set `accept_data_risks_and_force_replica_set_reconfig` to the current date. Learn more about Reconfiguring a Replica Set during a regional outage [here](https://dochub.mongodb.org/core/regional-outage-reconfigure-replica-set).
        """
        return pulumi.get(self, "accept_data_risks_and_force_replica_set_reconfig")

    @accept_data_risks_and_force_replica_set_reconfig.setter
    def accept_data_risks_and_force_replica_set_reconfig(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "accept_data_risks_and_force_replica_set_reconfig", value)

    @_builtins.property
    @pulumi.getter(name="advancedConfiguration")
    def advanced_configuration(self) -> Optional[pulumi.Input['ClusterAdvancedConfigurationArgs']]:
        return pulumi.get(self, "advanced_configuration")

    @advanced_configuration.setter
    def advanced_configuration(self, value: Optional[pulumi.Input['ClusterAdvancedConfigurationArgs']]):
        pulumi.set(self, "advanced_configuration", value)

    @_builtins.property
    @pulumi.getter(name="autoScalingComputeEnabled")
    def auto_scaling_compute_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        return pulumi.get(self, "auto_scaling_compute_enabled")

    @auto_scaling_compute_enabled.setter
    def auto_scaling_compute_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "auto_scaling_compute_enabled", value)

    @_builtins.property
    @pulumi.getter(name="autoScalingComputeScaleDownEnabled")
    def auto_scaling_compute_scale_down_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Set to `true` to enable the cluster tier to scale down. This option is only available if `autoScaling.compute.enabled` is `true`.
        - If this option is enabled, you must specify a value for `providerSettings.autoScaling.compute.minInstanceSize`
        """
        return pulumi.get(self, "auto_scaling_compute_scale_down_enabled")

    @auto_scaling_compute_scale_down_enabled.setter
    def auto_scaling_compute_scale_down_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "auto_scaling_compute_scale_down_enabled", value)

    @_builtins.property
    @pulumi.getter(name="autoScalingDiskGbEnabled")
    def auto_scaling_disk_gb_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        return pulumi.get(self, "auto_scaling_disk_gb_enabled")

    @auto_scaling_disk_gb_enabled.setter
    def auto_scaling_disk_gb_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "auto_scaling_disk_gb_enabled", value)

    @_builtins.property
    @pulumi.getter(name="backingProviderName")
    def backing_provider_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Cloud service provider on which the server for a multi-tenant cluster is provisioned.

        This setting is only valid when providerSetting.providerName is TENANT and providerSetting.instanceSizeName is M0.

        The possible values are:

        - AWS - Amazon AWS
        - GCP - Google Cloud Platform
        - AZURE - Microsoft Azure
        """
        return pulumi.get(self, "backing_provider_name")

    @backing_provider_name.setter
    def backing_provider_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "backing_provider_name", value)

    @_builtins.property
    @pulumi.getter(name="backupEnabled")
    def backup_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Legacy Backup - Set to true to enable Atlas legacy backups for the cluster.
        **Important** - MongoDB deprecated the Legacy Backup feature. Clusters that use Legacy Backup can continue to use it. MongoDB recommends using [Cloud Backups](https://docs.atlas.mongodb.com/backup/cloud-backup/overview/).
        * New Atlas clusters of any type do not support this parameter. These clusters must use Cloud Backup, `cloud_backup`, to enable Cloud Backup.  If you create a new Atlas cluster and set `backup_enabled` to true, the Provider will respond with an error.  This change doesn’t affect existing clusters that use legacy backups.
        * Setting this value to false to disable legacy backups for the cluster will let Atlas delete any stored snapshots. In order to preserve the legacy backups snapshots, disable the legacy backups and enable the cloud backups in the single **pulumi up** action.
        ```
        backup_enabled = "false"
        cloud_backup = "true"
        ```
        * The default value is false. M10 and above only.
        """
        return pulumi.get(self, "backup_enabled")

    @backup_enabled.setter
    def backup_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "backup_enabled", value)

    @_builtins.property
    @pulumi.getter(name="biConnectorConfig")
    def bi_connector_config(self) -> Optional[pulumi.Input['ClusterBiConnectorConfigArgs']]:
        """
        Specifies BI Connector for Atlas configuration on this cluster. BI Connector for Atlas is only available for M10+ clusters. See BI Connector below for more details.
        """
        return pulumi.get(self, "bi_connector_config")

    @bi_connector_config.setter
    def bi_connector_config(self, value: Optional[pulumi.Input['ClusterBiConnectorConfigArgs']]):
        pulumi.set(self, "bi_connector_config", value)

    @_builtins.property
    @pulumi.getter(name="cloudBackup")
    def cloud_backup(self) -> Optional[pulumi.Input[_builtins.bool]]:
        return pulumi.get(self, "cloud_backup")

    @cloud_backup.setter
    def cloud_backup(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "cloud_backup", value)

    @_builtins.property
    @pulumi.getter(name="clusterType")
    def cluster_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the type of the cluster that you want to modify. You cannot convert a sharded cluster deployment to a replica set deployment.

        > **WHEN SHOULD YOU USE CLUSTERTYPE?**
        When you set replication_specs, when you are deploying Global Clusters or when you are deploying non-Global replica sets and sharded clusters.

        Accepted values include:
        - `REPLICASET` Replica set
        - `SHARDED` Sharded cluster
        - `GEOSHARDED` Global Cluster
        """
        return pulumi.get(self, "cluster_type")

    @cluster_type.setter
    def cluster_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cluster_type", value)

    @_builtins.property
    @pulumi.getter(name="diskSizeGb")
    def disk_size_gb(self) -> Optional[pulumi.Input[_builtins.float]]:
        """
        Capacity, in gigabytes, of the host’s root volume. Increase this number to add capacity, up to a maximum possible value of 4096 (i.e., 4 TB). This value must be a positive integer.
        * The minimum disk size for dedicated clusters is 10GB for AWS and GCP. If you specify diskSizeGB with a lower disk size, Atlas defaults to the minimum disk size value.
        * Note: The maximum value for disk storage cannot exceed 50 times the maximum RAM for the selected cluster. If you require additional storage space beyond this limitation, consider upgrading your cluster to a higher tier.
        * Cannot be used with clusters with local NVMe SSDs
        * Cannot be used with Azure clusters
        """
        return pulumi.get(self, "disk_size_gb")

    @disk_size_gb.setter
    def disk_size_gb(self, value: Optional[pulumi.Input[_builtins.float]]):
        pulumi.set(self, "disk_size_gb", value)

    @_builtins.property
    @pulumi.getter(name="encryptionAtRestProvider")
    def encryption_at_rest_provider(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Possible values are AWS, GCP, AZURE or NONE.  Only needed if you desire to manage the keys, see [Encryption at Rest using Customer Key Management](https://docs.atlas.mongodb.com/security-aws-kms/) for complete documentation.  You must configure encryption at rest for the Atlas project before enabling it on any cluster in the project. For complete documentation on configuring Encryption at Rest, see Encryption at Rest using Customer Key Management. Requires M10 or greater. and for legacy backups, backup_enabled, to be false or omitted. **Note: Atlas encrypts all cluster storage and snapshot volumes, securing all cluster data on disk: a concept known as encryption at rest, by default**.
        """
        return pulumi.get(self, "encryption_at_rest_provider")

    @encryption_at_rest_provider.setter
    def encryption_at_rest_provider(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "encryption_at_rest_provider", value)

    @_builtins.property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ClusterLabelArgs']]]]:
        """
        Set that contains key-value pairs between 1 to 255 characters in length for tagging and categorizing the cluster. See below. **DEPRECATED** Use `tags` instead.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ClusterLabelArgs']]]]):
        pulumi.set(self, "labels", value)

    @_builtins.property
    @pulumi.getter(name="mongoDbMajorVersion")
    def mongo_db_major_version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Version of the cluster to deploy. Atlas supports all the MongoDB versions that have **not** reached [End of Live](https://www.mongodb.com/legal/support-policy/lifecycles) for M10+ clusters. If omitted, Atlas deploys the cluster with the default version. For more details, see [documentation](https://www.mongodb.com/docs/atlas/reference/faq/database/#which-versions-of-mongodb-do-service-clusters-use-). Atlas always deploys the cluster with the latest stable release of the specified version. See [Release Notes](https://www.mongodb.com/docs/upcoming/release-notes/) for latest Current Stable Release.
        """
        return pulumi.get(self, "mongo_db_major_version")

    @mongo_db_major_version.setter
    def mongo_db_major_version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "mongo_db_major_version", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the cluster as it appears in Atlas. Once the cluster is created, its name cannot be changed. **WARNING** Changing the name will result in destruction of the existing cluster and the creation of a new cluster.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="numShards")
    def num_shards(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Selects whether the cluster is a replica set or a sharded cluster. If you use the replicationSpecs parameter, you must set num_shards.
        """
        return pulumi.get(self, "num_shards")

    @num_shards.setter
    def num_shards(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "num_shards", value)

    @_builtins.property
    @pulumi.getter
    def paused(self) -> Optional[pulumi.Input[_builtins.bool]]:
        return pulumi.get(self, "paused")

    @paused.setter
    def paused(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "paused", value)

    @_builtins.property
    @pulumi.getter(name="pinnedFcv")
    def pinned_fcv(self) -> Optional[pulumi.Input['ClusterPinnedFcvArgs']]:
        """
        Pins the Feature Compatibility Version (FCV) to the current MongoDB version with a provided expiration date. To unpin the FCV the `pinned_fcv` attribute must be removed. This operation can take several minutes as the request processes through the MongoDB data plane. Once FCV is unpinned it will not be possible to downgrade the `mongo_db_major_version`. It is advised that updates to `pinned_fcv` are done isolated from other cluster changes. If a plan contains multiple changes, the FCV change will be applied first. If FCV is unpinned past the expiration date the `pinned_fcv` attribute must be removed. The following [knowledge hub article](https://kb.corp.mongodb.com/article/000021785/) and [FCV documentation](https://www.mongodb.com/docs/atlas/tutorial/major-version-change/#manage-feature-compatibility--fcv--during-upgrades) can be referenced for more details. See below.
        """
        return pulumi.get(self, "pinned_fcv")

    @pinned_fcv.setter
    def pinned_fcv(self, value: Optional[pulumi.Input['ClusterPinnedFcvArgs']]):
        pulumi.set(self, "pinned_fcv", value)

    @_builtins.property
    @pulumi.getter(name="pitEnabled")
    def pit_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Flag that indicates if the cluster uses Continuous Cloud Backup. If set to true, cloud_backup must also be set to true.
        """
        return pulumi.get(self, "pit_enabled")

    @pit_enabled.setter
    def pit_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "pit_enabled", value)

    @_builtins.property
    @pulumi.getter(name="providerAutoScalingComputeMaxInstanceSize")
    def provider_auto_scaling_compute_max_instance_size(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Maximum instance size to which your cluster can automatically scale (e.g., M40). Required if `autoScaling.compute.enabled` is `true`.
        """
        return pulumi.get(self, "provider_auto_scaling_compute_max_instance_size")

    @provider_auto_scaling_compute_max_instance_size.setter
    def provider_auto_scaling_compute_max_instance_size(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "provider_auto_scaling_compute_max_instance_size", value)

    @_builtins.property
    @pulumi.getter(name="providerAutoScalingComputeMinInstanceSize")
    def provider_auto_scaling_compute_min_instance_size(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Minimum instance size to which your cluster can automatically scale (e.g., M10). Required if `autoScaling.compute.scaleDownEnabled` is `true`.
        """
        return pulumi.get(self, "provider_auto_scaling_compute_min_instance_size")

    @provider_auto_scaling_compute_min_instance_size.setter
    def provider_auto_scaling_compute_min_instance_size(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "provider_auto_scaling_compute_min_instance_size", value)

    @_builtins.property
    @pulumi.getter(name="providerDiskIops")
    def provider_disk_iops(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The maximum input/output operations per second (IOPS) the system can perform. The possible values depend on the selected `provider_instance_size_name` and `disk_size_gb`.  This setting requires that `provider_instance_size_name` to be M30 or greater and cannot be used with clusters with local NVMe SSDs.  The default value for `provider_disk_iops` is the same as the cluster tier's Standard IOPS value, as viewable in the Atlas console.  It is used in cases where a higher number of IOPS is needed and possible.  If a value is submitted that is lower or equal to the default IOPS value for the cluster tier Atlas ignores the requested value and uses the default.  More details available under the providerSettings.diskIOPS parameter: [MongoDB API Clusters](https://docs.atlas.mongodb.com/reference/api/clusters-create-one/)
        * You do not need to configure IOPS for a STANDARD disk configuration but only for a PROVISIONED configuration.
        """
        return pulumi.get(self, "provider_disk_iops")

    @provider_disk_iops.setter
    def provider_disk_iops(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "provider_disk_iops", value)

    @_builtins.property
    @pulumi.getter(name="providerDiskTypeName")
    def provider_disk_type_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Azure disk type of the server’s root volume. If omitted, Atlas uses the default disk type for the selected providerSettings.instanceSizeName.  Example disk types and associated storage sizes: P4 - 32GB, P6 - 64GB, P10 - 128GB, P15 - 256GB, P20 - 512GB, P30 - 1024GB, P40 - 2048GB, P50 - 4095GB.  More information and the most update to date disk types/storage sizes can be located at https://docs.atlas.mongodb.com/reference/api/clusters-create-one/.
        """
        return pulumi.get(self, "provider_disk_type_name")

    @provider_disk_type_name.setter
    def provider_disk_type_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "provider_disk_type_name", value)

    @_builtins.property
    @pulumi.getter(name="providerEncryptEbsVolume")
    @_utilities.deprecated("""All EBS volumes are encrypted by default, the option to disable encryption has been removed""")
    def provider_encrypt_ebs_volume(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        **(Deprecated) The Flag is always true.** Flag that indicates whether the Amazon EBS encryption feature encrypts the host's root volume for both data at rest within the volume and for data moving between the volume and the cluster. Note: This setting is always enabled for clusters with local NVMe SSDs. **Atlas encrypts all cluster storage and snapshot volumes, securing all cluster data on disk: a concept known as encryption at rest, by default.**.
        """
        return pulumi.get(self, "provider_encrypt_ebs_volume")

    @provider_encrypt_ebs_volume.setter
    def provider_encrypt_ebs_volume(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "provider_encrypt_ebs_volume", value)

    @_builtins.property
    @pulumi.getter(name="providerRegionName")
    def provider_region_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Physical location of your MongoDB cluster. The region you choose can affect network latency for clients accessing your databases.  Requires the **Atlas region name**, see the reference list for [AWS](https://docs.atlas.mongodb.com/reference/amazon-aws/), [GCP](https://docs.atlas.mongodb.com/reference/google-gcp/), [Azure](https://docs.atlas.mongodb.com/reference/microsoft-azure/).
        Do not specify this field when creating a multi-region cluster using the replicationSpec document or a Global Cluster with the replicationSpecs array.
        """
        return pulumi.get(self, "provider_region_name")

    @provider_region_name.setter
    def provider_region_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "provider_region_name", value)

    @_builtins.property
    @pulumi.getter(name="providerVolumeType")
    def provider_volume_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type of the volume. The possible values are: `STANDARD` and `PROVISIONED`.  `PROVISIONED` is ONLY required if setting IOPS higher than the default instance IOPS.
        > **NOTE:** `STANDARD` is not available for NVME clusters.
        """
        return pulumi.get(self, "provider_volume_type")

    @provider_volume_type.setter
    def provider_volume_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "provider_volume_type", value)

    @_builtins.property
    @pulumi.getter(name="redactClientLogData")
    def redact_client_log_data(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Flag that enables or disables log redaction, see the [manual](https://www.mongodb.com/docs/manual/administration/monitoring/#log-redaction) for more information. Use this in conjunction with Encryption at Rest and TLS/SSL (Transport Encryption) to assist compliance with regulatory requirements. **Note**: Changing this setting on a cluster will trigger a rolling restart as soon as the cluster is updated. The log redaction field is updated via an Atlas API call after cluster creation. Consequently, there may be a brief period during resource creation when log redaction is not yet enabled. To ensure complete log redaction from the outset, use `AdvancedCluster`.
        """
        return pulumi.get(self, "redact_client_log_data")

    @redact_client_log_data.setter
    def redact_client_log_data(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "redact_client_log_data", value)

    @_builtins.property
    @pulumi.getter(name="replicationFactor")
    def replication_factor(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Number of replica set members. Each member keeps a copy of your databases, providing high availability and data redundancy. The possible values are 3, 5, or 7. The default value is 3.
        """
        return pulumi.get(self, "replication_factor")

    @replication_factor.setter
    def replication_factor(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "replication_factor", value)

    @_builtins.property
    @pulumi.getter(name="replicationSpecs")
    def replication_specs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ClusterReplicationSpecArgs']]]]:
        """
        Configuration for cluster regions.  See Replication Spec below for more details.
        """
        return pulumi.get(self, "replication_specs")

    @replication_specs.setter
    def replication_specs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ClusterReplicationSpecArgs']]]]):
        pulumi.set(self, "replication_specs", value)

    @_builtins.property
    @pulumi.getter(name="retainBackupsEnabled")
    def retain_backups_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        - (Optional) Set to true to retain backup snapshots for the deleted cluster. This parameter applies to the Delete operation and only affects M10 and above clusters. If you encounter the `CANNOT_DELETE_SNAPSHOT_WITH_BACKUP_COMPLIANCE_POLICY` error code, see how to delete a cluster with Backup Compliance Policy.
        """
        return pulumi.get(self, "retain_backups_enabled")

    @retain_backups_enabled.setter
    def retain_backups_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "retain_backups_enabled", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ClusterTagArgs']]]]:
        """
        Set that contains key-value pairs between 1 to 255 characters in length for tagging and categorizing the cluster. See below.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ClusterTagArgs']]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="terminationProtectionEnabled")
    def termination_protection_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Flag that indicates whether termination protection is enabled on the cluster. If set to true, MongoDB Cloud won't delete the cluster. If set to false, MongoDB Cloud will delete the cluster.
        """
        return pulumi.get(self, "termination_protection_enabled")

    @termination_protection_enabled.setter
    def termination_protection_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "termination_protection_enabled", value)

    @_builtins.property
    @pulumi.getter(name="versionReleaseSystem")
    def version_release_system(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Release cadence that Atlas uses for this cluster. This parameter defaults to `LTS`. If you set this field to `CONTINUOUS`, you must omit the `mongo_db_major_version` field. Atlas accepts:
        - `CONTINUOUS`:  Atlas creates your cluster using the most recent MongoDB release. Atlas automatically updates your cluster to the latest major and rapid MongoDB releases as they become available.
        - `LTS`: Atlas creates your cluster using the latest patch release of the MongoDB version that you specify in the mongoDBMajorVersion field. Atlas automatically updates your cluster to subsequent patch releases of this MongoDB version. Atlas doesn't update your cluster to newer rapid or major MongoDB releases as they become available.
        """
        return pulumi.get(self, "version_release_system")

    @version_release_system.setter
    def version_release_system(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "version_release_system", value)


@pulumi.input_type
class _ClusterState:
    def __init__(__self__, *,
                 accept_data_risks_and_force_replica_set_reconfig: Optional[pulumi.Input[_builtins.str]] = None,
                 advanced_configuration: Optional[pulumi.Input['ClusterAdvancedConfigurationArgs']] = None,
                 auto_scaling_compute_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 auto_scaling_compute_scale_down_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 auto_scaling_disk_gb_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 backing_provider_name: Optional[pulumi.Input[_builtins.str]] = None,
                 backup_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 bi_connector_config: Optional[pulumi.Input['ClusterBiConnectorConfigArgs']] = None,
                 cloud_backup: Optional[pulumi.Input[_builtins.bool]] = None,
                 cluster_id: Optional[pulumi.Input[_builtins.str]] = None,
                 cluster_type: Optional[pulumi.Input[_builtins.str]] = None,
                 connection_strings: Optional[pulumi.Input[Sequence[pulumi.Input['ClusterConnectionStringArgs']]]] = None,
                 container_id: Optional[pulumi.Input[_builtins.str]] = None,
                 disk_size_gb: Optional[pulumi.Input[_builtins.float]] = None,
                 encryption_at_rest_provider: Optional[pulumi.Input[_builtins.str]] = None,
                 labels: Optional[pulumi.Input[Sequence[pulumi.Input['ClusterLabelArgs']]]] = None,
                 mongo_db_major_version: Optional[pulumi.Input[_builtins.str]] = None,
                 mongo_db_version: Optional[pulumi.Input[_builtins.str]] = None,
                 mongo_uri: Optional[pulumi.Input[_builtins.str]] = None,
                 mongo_uri_updated: Optional[pulumi.Input[_builtins.str]] = None,
                 mongo_uri_with_options: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 num_shards: Optional[pulumi.Input[_builtins.int]] = None,
                 paused: Optional[pulumi.Input[_builtins.bool]] = None,
                 pinned_fcv: Optional[pulumi.Input['ClusterPinnedFcvArgs']] = None,
                 pit_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 provider_auto_scaling_compute_max_instance_size: Optional[pulumi.Input[_builtins.str]] = None,
                 provider_auto_scaling_compute_min_instance_size: Optional[pulumi.Input[_builtins.str]] = None,
                 provider_disk_iops: Optional[pulumi.Input[_builtins.int]] = None,
                 provider_disk_type_name: Optional[pulumi.Input[_builtins.str]] = None,
                 provider_encrypt_ebs_volume: Optional[pulumi.Input[_builtins.bool]] = None,
                 provider_encrypt_ebs_volume_flag: Optional[pulumi.Input[_builtins.bool]] = None,
                 provider_instance_size_name: Optional[pulumi.Input[_builtins.str]] = None,
                 provider_name: Optional[pulumi.Input[_builtins.str]] = None,
                 provider_region_name: Optional[pulumi.Input[_builtins.str]] = None,
                 provider_volume_type: Optional[pulumi.Input[_builtins.str]] = None,
                 redact_client_log_data: Optional[pulumi.Input[_builtins.bool]] = None,
                 replication_factor: Optional[pulumi.Input[_builtins.int]] = None,
                 replication_specs: Optional[pulumi.Input[Sequence[pulumi.Input['ClusterReplicationSpecArgs']]]] = None,
                 retain_backups_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 snapshot_backup_policies: Optional[pulumi.Input[Sequence[pulumi.Input['ClusterSnapshotBackupPolicyArgs']]]] = None,
                 srv_address: Optional[pulumi.Input[_builtins.str]] = None,
                 state_name: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input['ClusterTagArgs']]]] = None,
                 termination_protection_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 version_release_system: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering Cluster resources.
        :param pulumi.Input[_builtins.str] accept_data_risks_and_force_replica_set_reconfig: If reconfiguration is necessary to regain a primary due to a regional outage, submit this field alongside your topology reconfiguration to request a new regional outage resistant topology. Forced reconfigurations during an outage of the majority of electable nodes carry a risk of data loss if replicated writes (even majority committed writes) have not been replicated to the new primary node. MongoDB Atlas docs contain more information. To proceed with an operation which carries that risk, set `accept_data_risks_and_force_replica_set_reconfig` to the current date. Learn more about Reconfiguring a Replica Set during a regional outage [here](https://dochub.mongodb.org/core/regional-outage-reconfigure-replica-set).
        :param pulumi.Input[_builtins.bool] auto_scaling_compute_scale_down_enabled: Set to `true` to enable the cluster tier to scale down. This option is only available if `autoScaling.compute.enabled` is `true`.
               - If this option is enabled, you must specify a value for `providerSettings.autoScaling.compute.minInstanceSize`
        :param pulumi.Input[_builtins.str] backing_provider_name: Cloud service provider on which the server for a multi-tenant cluster is provisioned.
               
               This setting is only valid when providerSetting.providerName is TENANT and providerSetting.instanceSizeName is M0.
               
               The possible values are:
               
               - AWS - Amazon AWS
               - GCP - Google Cloud Platform
               - AZURE - Microsoft Azure
        :param pulumi.Input[_builtins.bool] backup_enabled: Legacy Backup - Set to true to enable Atlas legacy backups for the cluster.
               **Important** - MongoDB deprecated the Legacy Backup feature. Clusters that use Legacy Backup can continue to use it. MongoDB recommends using [Cloud Backups](https://docs.atlas.mongodb.com/backup/cloud-backup/overview/).
               * New Atlas clusters of any type do not support this parameter. These clusters must use Cloud Backup, `cloud_backup`, to enable Cloud Backup.  If you create a new Atlas cluster and set `backup_enabled` to true, the Provider will respond with an error.  This change doesn’t affect existing clusters that use legacy backups.
               * Setting this value to false to disable legacy backups for the cluster will let Atlas delete any stored snapshots. In order to preserve the legacy backups snapshots, disable the legacy backups and enable the cloud backups in the single **pulumi up** action.
               ```
               backup_enabled = "false"
               cloud_backup = "true"
               ```
               * The default value is false. M10 and above only.
        :param pulumi.Input['ClusterBiConnectorConfigArgs'] bi_connector_config: Specifies BI Connector for Atlas configuration on this cluster. BI Connector for Atlas is only available for M10+ clusters. See BI Connector below for more details.
        :param pulumi.Input[_builtins.str] cluster_id: The cluster ID.
        :param pulumi.Input[_builtins.str] cluster_type: Specifies the type of the cluster that you want to modify. You cannot convert a sharded cluster deployment to a replica set deployment.
               
               > **WHEN SHOULD YOU USE CLUSTERTYPE?**
               When you set replication_specs, when you are deploying Global Clusters or when you are deploying non-Global replica sets and sharded clusters.
               
               Accepted values include:
               - `REPLICASET` Replica set
               - `SHARDED` Sharded cluster
               - `GEOSHARDED` Global Cluster
        :param pulumi.Input[Sequence[pulumi.Input['ClusterConnectionStringArgs']]] connection_strings: Set of connection strings that your applications use to connect to this cluster. More information in [Connection-strings](https://docs.mongodb.com/manual/reference/connection-string/). Use the parameters in this object to connect your applications to this cluster. To learn more about the formats of connection strings, see [Connection String Options](https://docs.atlas.mongodb.com/reference/faq/connection-changes/). NOTE: Atlas returns the contents of this object after the cluster is operational, not while it builds the cluster.
        :param pulumi.Input[_builtins.str] container_id: The Container ID is the id of the container created when the first cluster in the region (AWS/Azure) or project (GCP) was created.
        :param pulumi.Input[_builtins.float] disk_size_gb: Capacity, in gigabytes, of the host’s root volume. Increase this number to add capacity, up to a maximum possible value of 4096 (i.e., 4 TB). This value must be a positive integer.
               * The minimum disk size for dedicated clusters is 10GB for AWS and GCP. If you specify diskSizeGB with a lower disk size, Atlas defaults to the minimum disk size value.
               * Note: The maximum value for disk storage cannot exceed 50 times the maximum RAM for the selected cluster. If you require additional storage space beyond this limitation, consider upgrading your cluster to a higher tier.
               * Cannot be used with clusters with local NVMe SSDs
               * Cannot be used with Azure clusters
        :param pulumi.Input[_builtins.str] encryption_at_rest_provider: Possible values are AWS, GCP, AZURE or NONE.  Only needed if you desire to manage the keys, see [Encryption at Rest using Customer Key Management](https://docs.atlas.mongodb.com/security-aws-kms/) for complete documentation.  You must configure encryption at rest for the Atlas project before enabling it on any cluster in the project. For complete documentation on configuring Encryption at Rest, see Encryption at Rest using Customer Key Management. Requires M10 or greater. and for legacy backups, backup_enabled, to be false or omitted. **Note: Atlas encrypts all cluster storage and snapshot volumes, securing all cluster data on disk: a concept known as encryption at rest, by default**.
        :param pulumi.Input[Sequence[pulumi.Input['ClusterLabelArgs']]] labels: Set that contains key-value pairs between 1 to 255 characters in length for tagging and categorizing the cluster. See below. **DEPRECATED** Use `tags` instead.
        :param pulumi.Input[_builtins.str] mongo_db_major_version: Version of the cluster to deploy. Atlas supports all the MongoDB versions that have **not** reached [End of Live](https://www.mongodb.com/legal/support-policy/lifecycles) for M10+ clusters. If omitted, Atlas deploys the cluster with the default version. For more details, see [documentation](https://www.mongodb.com/docs/atlas/reference/faq/database/#which-versions-of-mongodb-do-service-clusters-use-). Atlas always deploys the cluster with the latest stable release of the specified version. See [Release Notes](https://www.mongodb.com/docs/upcoming/release-notes/) for latest Current Stable Release.
        :param pulumi.Input[_builtins.str] mongo_db_version: Version of MongoDB the cluster runs, in `major-version`.`minor-version` format.
        :param pulumi.Input[_builtins.str] mongo_uri: Base connection string for the cluster. Atlas only displays this field after the cluster is operational, not while it builds the cluster.
        :param pulumi.Input[_builtins.str] mongo_uri_updated: Lists when the connection string was last updated. The connection string changes, for example, if you change a replica set to a sharded cluster.
        :param pulumi.Input[_builtins.str] mongo_uri_with_options: connection string for connecting to the Atlas cluster. Includes the replicaSet, ssl, and authSource query parameters in the connection string with values appropriate for the cluster.
        :param pulumi.Input[_builtins.str] name: Name of the cluster as it appears in Atlas. Once the cluster is created, its name cannot be changed. **WARNING** Changing the name will result in destruction of the existing cluster and the creation of a new cluster.
        :param pulumi.Input[_builtins.int] num_shards: Selects whether the cluster is a replica set or a sharded cluster. If you use the replicationSpecs parameter, you must set num_shards.
        :param pulumi.Input['ClusterPinnedFcvArgs'] pinned_fcv: Pins the Feature Compatibility Version (FCV) to the current MongoDB version with a provided expiration date. To unpin the FCV the `pinned_fcv` attribute must be removed. This operation can take several minutes as the request processes through the MongoDB data plane. Once FCV is unpinned it will not be possible to downgrade the `mongo_db_major_version`. It is advised that updates to `pinned_fcv` are done isolated from other cluster changes. If a plan contains multiple changes, the FCV change will be applied first. If FCV is unpinned past the expiration date the `pinned_fcv` attribute must be removed. The following [knowledge hub article](https://kb.corp.mongodb.com/article/000021785/) and [FCV documentation](https://www.mongodb.com/docs/atlas/tutorial/major-version-change/#manage-feature-compatibility--fcv--during-upgrades) can be referenced for more details. See below.
        :param pulumi.Input[_builtins.bool] pit_enabled: Flag that indicates if the cluster uses Continuous Cloud Backup. If set to true, cloud_backup must also be set to true.
        :param pulumi.Input[_builtins.str] project_id: The unique ID for the project to create the cluster.
        :param pulumi.Input[_builtins.str] provider_auto_scaling_compute_max_instance_size: Maximum instance size to which your cluster can automatically scale (e.g., M40). Required if `autoScaling.compute.enabled` is `true`.
        :param pulumi.Input[_builtins.str] provider_auto_scaling_compute_min_instance_size: Minimum instance size to which your cluster can automatically scale (e.g., M10). Required if `autoScaling.compute.scaleDownEnabled` is `true`.
        :param pulumi.Input[_builtins.int] provider_disk_iops: The maximum input/output operations per second (IOPS) the system can perform. The possible values depend on the selected `provider_instance_size_name` and `disk_size_gb`.  This setting requires that `provider_instance_size_name` to be M30 or greater and cannot be used with clusters with local NVMe SSDs.  The default value for `provider_disk_iops` is the same as the cluster tier's Standard IOPS value, as viewable in the Atlas console.  It is used in cases where a higher number of IOPS is needed and possible.  If a value is submitted that is lower or equal to the default IOPS value for the cluster tier Atlas ignores the requested value and uses the default.  More details available under the providerSettings.diskIOPS parameter: [MongoDB API Clusters](https://docs.atlas.mongodb.com/reference/api/clusters-create-one/)
               * You do not need to configure IOPS for a STANDARD disk configuration but only for a PROVISIONED configuration.
        :param pulumi.Input[_builtins.str] provider_disk_type_name: Azure disk type of the server’s root volume. If omitted, Atlas uses the default disk type for the selected providerSettings.instanceSizeName.  Example disk types and associated storage sizes: P4 - 32GB, P6 - 64GB, P10 - 128GB, P15 - 256GB, P20 - 512GB, P30 - 1024GB, P40 - 2048GB, P50 - 4095GB.  More information and the most update to date disk types/storage sizes can be located at https://docs.atlas.mongodb.com/reference/api/clusters-create-one/.
        :param pulumi.Input[_builtins.bool] provider_encrypt_ebs_volume: **(Deprecated) The Flag is always true.** Flag that indicates whether the Amazon EBS encryption feature encrypts the host's root volume for both data at rest within the volume and for data moving between the volume and the cluster. Note: This setting is always enabled for clusters with local NVMe SSDs. **Atlas encrypts all cluster storage and snapshot volumes, securing all cluster data on disk: a concept known as encryption at rest, by default.**.
        :param pulumi.Input[_builtins.str] provider_instance_size_name: Atlas provides different instance sizes, each with a default storage capacity and RAM size. The instance size you select is used for all the data-bearing servers in your cluster. See [Create a Cluster](https://docs.atlas.mongodb.com/reference/api/clusters-create-one/) `providerSettings.instanceSizeName` for valid values and default resources.
        :param pulumi.Input[_builtins.str] provider_name: Cloud service provider on which the servers are provisioned.
               
               The possible values are:
               
               - `AWS` - Amazon AWS
               - `GCP` - Google Cloud Platform
               - `AZURE` - Microsoft Azure
               - `TENANT` - A multi-tenant deployment on one of the supported cloud service providers. Only valid when providerSettings.instanceSizeName is M0.
        :param pulumi.Input[_builtins.str] provider_region_name: Physical location of your MongoDB cluster. The region you choose can affect network latency for clients accessing your databases.  Requires the **Atlas region name**, see the reference list for [AWS](https://docs.atlas.mongodb.com/reference/amazon-aws/), [GCP](https://docs.atlas.mongodb.com/reference/google-gcp/), [Azure](https://docs.atlas.mongodb.com/reference/microsoft-azure/).
               Do not specify this field when creating a multi-region cluster using the replicationSpec document or a Global Cluster with the replicationSpecs array.
        :param pulumi.Input[_builtins.str] provider_volume_type: The type of the volume. The possible values are: `STANDARD` and `PROVISIONED`.  `PROVISIONED` is ONLY required if setting IOPS higher than the default instance IOPS.
               > **NOTE:** `STANDARD` is not available for NVME clusters.
        :param pulumi.Input[_builtins.bool] redact_client_log_data: Flag that enables or disables log redaction, see the [manual](https://www.mongodb.com/docs/manual/administration/monitoring/#log-redaction) for more information. Use this in conjunction with Encryption at Rest and TLS/SSL (Transport Encryption) to assist compliance with regulatory requirements. **Note**: Changing this setting on a cluster will trigger a rolling restart as soon as the cluster is updated. The log redaction field is updated via an Atlas API call after cluster creation. Consequently, there may be a brief period during resource creation when log redaction is not yet enabled. To ensure complete log redaction from the outset, use `AdvancedCluster`.
        :param pulumi.Input[_builtins.int] replication_factor: Number of replica set members. Each member keeps a copy of your databases, providing high availability and data redundancy. The possible values are 3, 5, or 7. The default value is 3.
        :param pulumi.Input[Sequence[pulumi.Input['ClusterReplicationSpecArgs']]] replication_specs: Configuration for cluster regions.  See Replication Spec below for more details.
        :param pulumi.Input[_builtins.bool] retain_backups_enabled: - (Optional) Set to true to retain backup snapshots for the deleted cluster. This parameter applies to the Delete operation and only affects M10 and above clusters. If you encounter the `CANNOT_DELETE_SNAPSHOT_WITH_BACKUP_COMPLIANCE_POLICY` error code, see how to delete a cluster with Backup Compliance Policy.
        :param pulumi.Input[Sequence[pulumi.Input['ClusterSnapshotBackupPolicyArgs']]] snapshot_backup_policies: current snapshot schedule and retention settings for the cluster.
        :param pulumi.Input[_builtins.str] srv_address: Connection string for connecting to the Atlas cluster. The +srv modifier forces the connection to use TLS/SSL. See the mongoURI for additional options.
        :param pulumi.Input[_builtins.str] state_name: Current state of the cluster. The possible states are:
               - IDLE
               - CREATING
               - UPDATING
               - DELETING
               - DELETED
               - REPAIRING
        :param pulumi.Input[Sequence[pulumi.Input['ClusterTagArgs']]] tags: Set that contains key-value pairs between 1 to 255 characters in length for tagging and categorizing the cluster. See below.
        :param pulumi.Input[_builtins.bool] termination_protection_enabled: Flag that indicates whether termination protection is enabled on the cluster. If set to true, MongoDB Cloud won't delete the cluster. If set to false, MongoDB Cloud will delete the cluster.
        :param pulumi.Input[_builtins.str] version_release_system: Release cadence that Atlas uses for this cluster. This parameter defaults to `LTS`. If you set this field to `CONTINUOUS`, you must omit the `mongo_db_major_version` field. Atlas accepts:
               - `CONTINUOUS`:  Atlas creates your cluster using the most recent MongoDB release. Atlas automatically updates your cluster to the latest major and rapid MongoDB releases as they become available.
               - `LTS`: Atlas creates your cluster using the latest patch release of the MongoDB version that you specify in the mongoDBMajorVersion field. Atlas automatically updates your cluster to subsequent patch releases of this MongoDB version. Atlas doesn't update your cluster to newer rapid or major MongoDB releases as they become available.
        """
        if accept_data_risks_and_force_replica_set_reconfig is not None:
            pulumi.set(__self__, "accept_data_risks_and_force_replica_set_reconfig", accept_data_risks_and_force_replica_set_reconfig)
        if advanced_configuration is not None:
            pulumi.set(__self__, "advanced_configuration", advanced_configuration)
        if auto_scaling_compute_enabled is not None:
            pulumi.set(__self__, "auto_scaling_compute_enabled", auto_scaling_compute_enabled)
        if auto_scaling_compute_scale_down_enabled is not None:
            pulumi.set(__self__, "auto_scaling_compute_scale_down_enabled", auto_scaling_compute_scale_down_enabled)
        if auto_scaling_disk_gb_enabled is not None:
            pulumi.set(__self__, "auto_scaling_disk_gb_enabled", auto_scaling_disk_gb_enabled)
        if backing_provider_name is not None:
            pulumi.set(__self__, "backing_provider_name", backing_provider_name)
        if backup_enabled is not None:
            pulumi.set(__self__, "backup_enabled", backup_enabled)
        if bi_connector_config is not None:
            pulumi.set(__self__, "bi_connector_config", bi_connector_config)
        if cloud_backup is not None:
            pulumi.set(__self__, "cloud_backup", cloud_backup)
        if cluster_id is not None:
            pulumi.set(__self__, "cluster_id", cluster_id)
        if cluster_type is not None:
            pulumi.set(__self__, "cluster_type", cluster_type)
        if connection_strings is not None:
            pulumi.set(__self__, "connection_strings", connection_strings)
        if container_id is not None:
            pulumi.set(__self__, "container_id", container_id)
        if disk_size_gb is not None:
            pulumi.set(__self__, "disk_size_gb", disk_size_gb)
        if encryption_at_rest_provider is not None:
            pulumi.set(__self__, "encryption_at_rest_provider", encryption_at_rest_provider)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if mongo_db_major_version is not None:
            pulumi.set(__self__, "mongo_db_major_version", mongo_db_major_version)
        if mongo_db_version is not None:
            pulumi.set(__self__, "mongo_db_version", mongo_db_version)
        if mongo_uri is not None:
            pulumi.set(__self__, "mongo_uri", mongo_uri)
        if mongo_uri_updated is not None:
            pulumi.set(__self__, "mongo_uri_updated", mongo_uri_updated)
        if mongo_uri_with_options is not None:
            pulumi.set(__self__, "mongo_uri_with_options", mongo_uri_with_options)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if num_shards is not None:
            pulumi.set(__self__, "num_shards", num_shards)
        if paused is not None:
            pulumi.set(__self__, "paused", paused)
        if pinned_fcv is not None:
            pulumi.set(__self__, "pinned_fcv", pinned_fcv)
        if pit_enabled is not None:
            pulumi.set(__self__, "pit_enabled", pit_enabled)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)
        if provider_auto_scaling_compute_max_instance_size is not None:
            pulumi.set(__self__, "provider_auto_scaling_compute_max_instance_size", provider_auto_scaling_compute_max_instance_size)
        if provider_auto_scaling_compute_min_instance_size is not None:
            pulumi.set(__self__, "provider_auto_scaling_compute_min_instance_size", provider_auto_scaling_compute_min_instance_size)
        if provider_disk_iops is not None:
            pulumi.set(__self__, "provider_disk_iops", provider_disk_iops)
        if provider_disk_type_name is not None:
            pulumi.set(__self__, "provider_disk_type_name", provider_disk_type_name)
        if provider_encrypt_ebs_volume is not None:
            warnings.warn("""All EBS volumes are encrypted by default, the option to disable encryption has been removed""", DeprecationWarning)
            pulumi.log.warn("""provider_encrypt_ebs_volume is deprecated: All EBS volumes are encrypted by default, the option to disable encryption has been removed""")
        if provider_encrypt_ebs_volume is not None:
            pulumi.set(__self__, "provider_encrypt_ebs_volume", provider_encrypt_ebs_volume)
        if provider_encrypt_ebs_volume_flag is not None:
            pulumi.set(__self__, "provider_encrypt_ebs_volume_flag", provider_encrypt_ebs_volume_flag)
        if provider_instance_size_name is not None:
            pulumi.set(__self__, "provider_instance_size_name", provider_instance_size_name)
        if provider_name is not None:
            pulumi.set(__self__, "provider_name", provider_name)
        if provider_region_name is not None:
            pulumi.set(__self__, "provider_region_name", provider_region_name)
        if provider_volume_type is not None:
            pulumi.set(__self__, "provider_volume_type", provider_volume_type)
        if redact_client_log_data is not None:
            pulumi.set(__self__, "redact_client_log_data", redact_client_log_data)
        if replication_factor is not None:
            pulumi.set(__self__, "replication_factor", replication_factor)
        if replication_specs is not None:
            pulumi.set(__self__, "replication_specs", replication_specs)
        if retain_backups_enabled is not None:
            pulumi.set(__self__, "retain_backups_enabled", retain_backups_enabled)
        if snapshot_backup_policies is not None:
            pulumi.set(__self__, "snapshot_backup_policies", snapshot_backup_policies)
        if srv_address is not None:
            pulumi.set(__self__, "srv_address", srv_address)
        if state_name is not None:
            pulumi.set(__self__, "state_name", state_name)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if termination_protection_enabled is not None:
            pulumi.set(__self__, "termination_protection_enabled", termination_protection_enabled)
        if version_release_system is not None:
            pulumi.set(__self__, "version_release_system", version_release_system)

    @_builtins.property
    @pulumi.getter(name="acceptDataRisksAndForceReplicaSetReconfig")
    def accept_data_risks_and_force_replica_set_reconfig(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        If reconfiguration is necessary to regain a primary due to a regional outage, submit this field alongside your topology reconfiguration to request a new regional outage resistant topology. Forced reconfigurations during an outage of the majority of electable nodes carry a risk of data loss if replicated writes (even majority committed writes) have not been replicated to the new primary node. MongoDB Atlas docs contain more information. To proceed with an operation which carries that risk, set `accept_data_risks_and_force_replica_set_reconfig` to the current date. Learn more about Reconfiguring a Replica Set during a regional outage [here](https://dochub.mongodb.org/core/regional-outage-reconfigure-replica-set).
        """
        return pulumi.get(self, "accept_data_risks_and_force_replica_set_reconfig")

    @accept_data_risks_and_force_replica_set_reconfig.setter
    def accept_data_risks_and_force_replica_set_reconfig(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "accept_data_risks_and_force_replica_set_reconfig", value)

    @_builtins.property
    @pulumi.getter(name="advancedConfiguration")
    def advanced_configuration(self) -> Optional[pulumi.Input['ClusterAdvancedConfigurationArgs']]:
        return pulumi.get(self, "advanced_configuration")

    @advanced_configuration.setter
    def advanced_configuration(self, value: Optional[pulumi.Input['ClusterAdvancedConfigurationArgs']]):
        pulumi.set(self, "advanced_configuration", value)

    @_builtins.property
    @pulumi.getter(name="autoScalingComputeEnabled")
    def auto_scaling_compute_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        return pulumi.get(self, "auto_scaling_compute_enabled")

    @auto_scaling_compute_enabled.setter
    def auto_scaling_compute_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "auto_scaling_compute_enabled", value)

    @_builtins.property
    @pulumi.getter(name="autoScalingComputeScaleDownEnabled")
    def auto_scaling_compute_scale_down_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Set to `true` to enable the cluster tier to scale down. This option is only available if `autoScaling.compute.enabled` is `true`.
        - If this option is enabled, you must specify a value for `providerSettings.autoScaling.compute.minInstanceSize`
        """
        return pulumi.get(self, "auto_scaling_compute_scale_down_enabled")

    @auto_scaling_compute_scale_down_enabled.setter
    def auto_scaling_compute_scale_down_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "auto_scaling_compute_scale_down_enabled", value)

    @_builtins.property
    @pulumi.getter(name="autoScalingDiskGbEnabled")
    def auto_scaling_disk_gb_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        return pulumi.get(self, "auto_scaling_disk_gb_enabled")

    @auto_scaling_disk_gb_enabled.setter
    def auto_scaling_disk_gb_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "auto_scaling_disk_gb_enabled", value)

    @_builtins.property
    @pulumi.getter(name="backingProviderName")
    def backing_provider_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Cloud service provider on which the server for a multi-tenant cluster is provisioned.

        This setting is only valid when providerSetting.providerName is TENANT and providerSetting.instanceSizeName is M0.

        The possible values are:

        - AWS - Amazon AWS
        - GCP - Google Cloud Platform
        - AZURE - Microsoft Azure
        """
        return pulumi.get(self, "backing_provider_name")

    @backing_provider_name.setter
    def backing_provider_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "backing_provider_name", value)

    @_builtins.property
    @pulumi.getter(name="backupEnabled")
    def backup_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Legacy Backup - Set to true to enable Atlas legacy backups for the cluster.
        **Important** - MongoDB deprecated the Legacy Backup feature. Clusters that use Legacy Backup can continue to use it. MongoDB recommends using [Cloud Backups](https://docs.atlas.mongodb.com/backup/cloud-backup/overview/).
        * New Atlas clusters of any type do not support this parameter. These clusters must use Cloud Backup, `cloud_backup`, to enable Cloud Backup.  If you create a new Atlas cluster and set `backup_enabled` to true, the Provider will respond with an error.  This change doesn’t affect existing clusters that use legacy backups.
        * Setting this value to false to disable legacy backups for the cluster will let Atlas delete any stored snapshots. In order to preserve the legacy backups snapshots, disable the legacy backups and enable the cloud backups in the single **pulumi up** action.
        ```
        backup_enabled = "false"
        cloud_backup = "true"
        ```
        * The default value is false. M10 and above only.
        """
        return pulumi.get(self, "backup_enabled")

    @backup_enabled.setter
    def backup_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "backup_enabled", value)

    @_builtins.property
    @pulumi.getter(name="biConnectorConfig")
    def bi_connector_config(self) -> Optional[pulumi.Input['ClusterBiConnectorConfigArgs']]:
        """
        Specifies BI Connector for Atlas configuration on this cluster. BI Connector for Atlas is only available for M10+ clusters. See BI Connector below for more details.
        """
        return pulumi.get(self, "bi_connector_config")

    @bi_connector_config.setter
    def bi_connector_config(self, value: Optional[pulumi.Input['ClusterBiConnectorConfigArgs']]):
        pulumi.set(self, "bi_connector_config", value)

    @_builtins.property
    @pulumi.getter(name="cloudBackup")
    def cloud_backup(self) -> Optional[pulumi.Input[_builtins.bool]]:
        return pulumi.get(self, "cloud_backup")

    @cloud_backup.setter
    def cloud_backup(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "cloud_backup", value)

    @_builtins.property
    @pulumi.getter(name="clusterId")
    def cluster_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The cluster ID.
        """
        return pulumi.get(self, "cluster_id")

    @cluster_id.setter
    def cluster_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cluster_id", value)

    @_builtins.property
    @pulumi.getter(name="clusterType")
    def cluster_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the type of the cluster that you want to modify. You cannot convert a sharded cluster deployment to a replica set deployment.

        > **WHEN SHOULD YOU USE CLUSTERTYPE?**
        When you set replication_specs, when you are deploying Global Clusters or when you are deploying non-Global replica sets and sharded clusters.

        Accepted values include:
        - `REPLICASET` Replica set
        - `SHARDED` Sharded cluster
        - `GEOSHARDED` Global Cluster
        """
        return pulumi.get(self, "cluster_type")

    @cluster_type.setter
    def cluster_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cluster_type", value)

    @_builtins.property
    @pulumi.getter(name="connectionStrings")
    def connection_strings(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ClusterConnectionStringArgs']]]]:
        """
        Set of connection strings that your applications use to connect to this cluster. More information in [Connection-strings](https://docs.mongodb.com/manual/reference/connection-string/). Use the parameters in this object to connect your applications to this cluster. To learn more about the formats of connection strings, see [Connection String Options](https://docs.atlas.mongodb.com/reference/faq/connection-changes/). NOTE: Atlas returns the contents of this object after the cluster is operational, not while it builds the cluster.
        """
        return pulumi.get(self, "connection_strings")

    @connection_strings.setter
    def connection_strings(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ClusterConnectionStringArgs']]]]):
        pulumi.set(self, "connection_strings", value)

    @_builtins.property
    @pulumi.getter(name="containerId")
    def container_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Container ID is the id of the container created when the first cluster in the region (AWS/Azure) or project (GCP) was created.
        """
        return pulumi.get(self, "container_id")

    @container_id.setter
    def container_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "container_id", value)

    @_builtins.property
    @pulumi.getter(name="diskSizeGb")
    def disk_size_gb(self) -> Optional[pulumi.Input[_builtins.float]]:
        """
        Capacity, in gigabytes, of the host’s root volume. Increase this number to add capacity, up to a maximum possible value of 4096 (i.e., 4 TB). This value must be a positive integer.
        * The minimum disk size for dedicated clusters is 10GB for AWS and GCP. If you specify diskSizeGB with a lower disk size, Atlas defaults to the minimum disk size value.
        * Note: The maximum value for disk storage cannot exceed 50 times the maximum RAM for the selected cluster. If you require additional storage space beyond this limitation, consider upgrading your cluster to a higher tier.
        * Cannot be used with clusters with local NVMe SSDs
        * Cannot be used with Azure clusters
        """
        return pulumi.get(self, "disk_size_gb")

    @disk_size_gb.setter
    def disk_size_gb(self, value: Optional[pulumi.Input[_builtins.float]]):
        pulumi.set(self, "disk_size_gb", value)

    @_builtins.property
    @pulumi.getter(name="encryptionAtRestProvider")
    def encryption_at_rest_provider(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Possible values are AWS, GCP, AZURE or NONE.  Only needed if you desire to manage the keys, see [Encryption at Rest using Customer Key Management](https://docs.atlas.mongodb.com/security-aws-kms/) for complete documentation.  You must configure encryption at rest for the Atlas project before enabling it on any cluster in the project. For complete documentation on configuring Encryption at Rest, see Encryption at Rest using Customer Key Management. Requires M10 or greater. and for legacy backups, backup_enabled, to be false or omitted. **Note: Atlas encrypts all cluster storage and snapshot volumes, securing all cluster data on disk: a concept known as encryption at rest, by default**.
        """
        return pulumi.get(self, "encryption_at_rest_provider")

    @encryption_at_rest_provider.setter
    def encryption_at_rest_provider(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "encryption_at_rest_provider", value)

    @_builtins.property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ClusterLabelArgs']]]]:
        """
        Set that contains key-value pairs between 1 to 255 characters in length for tagging and categorizing the cluster. See below. **DEPRECATED** Use `tags` instead.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ClusterLabelArgs']]]]):
        pulumi.set(self, "labels", value)

    @_builtins.property
    @pulumi.getter(name="mongoDbMajorVersion")
    def mongo_db_major_version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Version of the cluster to deploy. Atlas supports all the MongoDB versions that have **not** reached [End of Live](https://www.mongodb.com/legal/support-policy/lifecycles) for M10+ clusters. If omitted, Atlas deploys the cluster with the default version. For more details, see [documentation](https://www.mongodb.com/docs/atlas/reference/faq/database/#which-versions-of-mongodb-do-service-clusters-use-). Atlas always deploys the cluster with the latest stable release of the specified version. See [Release Notes](https://www.mongodb.com/docs/upcoming/release-notes/) for latest Current Stable Release.
        """
        return pulumi.get(self, "mongo_db_major_version")

    @mongo_db_major_version.setter
    def mongo_db_major_version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "mongo_db_major_version", value)

    @_builtins.property
    @pulumi.getter(name="mongoDbVersion")
    def mongo_db_version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Version of MongoDB the cluster runs, in `major-version`.`minor-version` format.
        """
        return pulumi.get(self, "mongo_db_version")

    @mongo_db_version.setter
    def mongo_db_version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "mongo_db_version", value)

    @_builtins.property
    @pulumi.getter(name="mongoUri")
    def mongo_uri(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Base connection string for the cluster. Atlas only displays this field after the cluster is operational, not while it builds the cluster.
        """
        return pulumi.get(self, "mongo_uri")

    @mongo_uri.setter
    def mongo_uri(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "mongo_uri", value)

    @_builtins.property
    @pulumi.getter(name="mongoUriUpdated")
    def mongo_uri_updated(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Lists when the connection string was last updated. The connection string changes, for example, if you change a replica set to a sharded cluster.
        """
        return pulumi.get(self, "mongo_uri_updated")

    @mongo_uri_updated.setter
    def mongo_uri_updated(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "mongo_uri_updated", value)

    @_builtins.property
    @pulumi.getter(name="mongoUriWithOptions")
    def mongo_uri_with_options(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        connection string for connecting to the Atlas cluster. Includes the replicaSet, ssl, and authSource query parameters in the connection string with values appropriate for the cluster.
        """
        return pulumi.get(self, "mongo_uri_with_options")

    @mongo_uri_with_options.setter
    def mongo_uri_with_options(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "mongo_uri_with_options", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the cluster as it appears in Atlas. Once the cluster is created, its name cannot be changed. **WARNING** Changing the name will result in destruction of the existing cluster and the creation of a new cluster.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="numShards")
    def num_shards(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Selects whether the cluster is a replica set or a sharded cluster. If you use the replicationSpecs parameter, you must set num_shards.
        """
        return pulumi.get(self, "num_shards")

    @num_shards.setter
    def num_shards(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "num_shards", value)

    @_builtins.property
    @pulumi.getter
    def paused(self) -> Optional[pulumi.Input[_builtins.bool]]:
        return pulumi.get(self, "paused")

    @paused.setter
    def paused(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "paused", value)

    @_builtins.property
    @pulumi.getter(name="pinnedFcv")
    def pinned_fcv(self) -> Optional[pulumi.Input['ClusterPinnedFcvArgs']]:
        """
        Pins the Feature Compatibility Version (FCV) to the current MongoDB version with a provided expiration date. To unpin the FCV the `pinned_fcv` attribute must be removed. This operation can take several minutes as the request processes through the MongoDB data plane. Once FCV is unpinned it will not be possible to downgrade the `mongo_db_major_version`. It is advised that updates to `pinned_fcv` are done isolated from other cluster changes. If a plan contains multiple changes, the FCV change will be applied first. If FCV is unpinned past the expiration date the `pinned_fcv` attribute must be removed. The following [knowledge hub article](https://kb.corp.mongodb.com/article/000021785/) and [FCV documentation](https://www.mongodb.com/docs/atlas/tutorial/major-version-change/#manage-feature-compatibility--fcv--during-upgrades) can be referenced for more details. See below.
        """
        return pulumi.get(self, "pinned_fcv")

    @pinned_fcv.setter
    def pinned_fcv(self, value: Optional[pulumi.Input['ClusterPinnedFcvArgs']]):
        pulumi.set(self, "pinned_fcv", value)

    @_builtins.property
    @pulumi.getter(name="pitEnabled")
    def pit_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Flag that indicates if the cluster uses Continuous Cloud Backup. If set to true, cloud_backup must also be set to true.
        """
        return pulumi.get(self, "pit_enabled")

    @pit_enabled.setter
    def pit_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "pit_enabled", value)

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The unique ID for the project to create the cluster.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project_id", value)

    @_builtins.property
    @pulumi.getter(name="providerAutoScalingComputeMaxInstanceSize")
    def provider_auto_scaling_compute_max_instance_size(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Maximum instance size to which your cluster can automatically scale (e.g., M40). Required if `autoScaling.compute.enabled` is `true`.
        """
        return pulumi.get(self, "provider_auto_scaling_compute_max_instance_size")

    @provider_auto_scaling_compute_max_instance_size.setter
    def provider_auto_scaling_compute_max_instance_size(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "provider_auto_scaling_compute_max_instance_size", value)

    @_builtins.property
    @pulumi.getter(name="providerAutoScalingComputeMinInstanceSize")
    def provider_auto_scaling_compute_min_instance_size(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Minimum instance size to which your cluster can automatically scale (e.g., M10). Required if `autoScaling.compute.scaleDownEnabled` is `true`.
        """
        return pulumi.get(self, "provider_auto_scaling_compute_min_instance_size")

    @provider_auto_scaling_compute_min_instance_size.setter
    def provider_auto_scaling_compute_min_instance_size(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "provider_auto_scaling_compute_min_instance_size", value)

    @_builtins.property
    @pulumi.getter(name="providerDiskIops")
    def provider_disk_iops(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The maximum input/output operations per second (IOPS) the system can perform. The possible values depend on the selected `provider_instance_size_name` and `disk_size_gb`.  This setting requires that `provider_instance_size_name` to be M30 or greater and cannot be used with clusters with local NVMe SSDs.  The default value for `provider_disk_iops` is the same as the cluster tier's Standard IOPS value, as viewable in the Atlas console.  It is used in cases where a higher number of IOPS is needed and possible.  If a value is submitted that is lower or equal to the default IOPS value for the cluster tier Atlas ignores the requested value and uses the default.  More details available under the providerSettings.diskIOPS parameter: [MongoDB API Clusters](https://docs.atlas.mongodb.com/reference/api/clusters-create-one/)
        * You do not need to configure IOPS for a STANDARD disk configuration but only for a PROVISIONED configuration.
        """
        return pulumi.get(self, "provider_disk_iops")

    @provider_disk_iops.setter
    def provider_disk_iops(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "provider_disk_iops", value)

    @_builtins.property
    @pulumi.getter(name="providerDiskTypeName")
    def provider_disk_type_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Azure disk type of the server’s root volume. If omitted, Atlas uses the default disk type for the selected providerSettings.instanceSizeName.  Example disk types and associated storage sizes: P4 - 32GB, P6 - 64GB, P10 - 128GB, P15 - 256GB, P20 - 512GB, P30 - 1024GB, P40 - 2048GB, P50 - 4095GB.  More information and the most update to date disk types/storage sizes can be located at https://docs.atlas.mongodb.com/reference/api/clusters-create-one/.
        """
        return pulumi.get(self, "provider_disk_type_name")

    @provider_disk_type_name.setter
    def provider_disk_type_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "provider_disk_type_name", value)

    @_builtins.property
    @pulumi.getter(name="providerEncryptEbsVolume")
    @_utilities.deprecated("""All EBS volumes are encrypted by default, the option to disable encryption has been removed""")
    def provider_encrypt_ebs_volume(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        **(Deprecated) The Flag is always true.** Flag that indicates whether the Amazon EBS encryption feature encrypts the host's root volume for both data at rest within the volume and for data moving between the volume and the cluster. Note: This setting is always enabled for clusters with local NVMe SSDs. **Atlas encrypts all cluster storage and snapshot volumes, securing all cluster data on disk: a concept known as encryption at rest, by default.**.
        """
        return pulumi.get(self, "provider_encrypt_ebs_volume")

    @provider_encrypt_ebs_volume.setter
    def provider_encrypt_ebs_volume(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "provider_encrypt_ebs_volume", value)

    @_builtins.property
    @pulumi.getter(name="providerEncryptEbsVolumeFlag")
    def provider_encrypt_ebs_volume_flag(self) -> Optional[pulumi.Input[_builtins.bool]]:
        return pulumi.get(self, "provider_encrypt_ebs_volume_flag")

    @provider_encrypt_ebs_volume_flag.setter
    def provider_encrypt_ebs_volume_flag(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "provider_encrypt_ebs_volume_flag", value)

    @_builtins.property
    @pulumi.getter(name="providerInstanceSizeName")
    def provider_instance_size_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Atlas provides different instance sizes, each with a default storage capacity and RAM size. The instance size you select is used for all the data-bearing servers in your cluster. See [Create a Cluster](https://docs.atlas.mongodb.com/reference/api/clusters-create-one/) `providerSettings.instanceSizeName` for valid values and default resources.
        """
        return pulumi.get(self, "provider_instance_size_name")

    @provider_instance_size_name.setter
    def provider_instance_size_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "provider_instance_size_name", value)

    @_builtins.property
    @pulumi.getter(name="providerName")
    def provider_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Cloud service provider on which the servers are provisioned.

        The possible values are:

        - `AWS` - Amazon AWS
        - `GCP` - Google Cloud Platform
        - `AZURE` - Microsoft Azure
        - `TENANT` - A multi-tenant deployment on one of the supported cloud service providers. Only valid when providerSettings.instanceSizeName is M0.
        """
        return pulumi.get(self, "provider_name")

    @provider_name.setter
    def provider_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "provider_name", value)

    @_builtins.property
    @pulumi.getter(name="providerRegionName")
    def provider_region_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Physical location of your MongoDB cluster. The region you choose can affect network latency for clients accessing your databases.  Requires the **Atlas region name**, see the reference list for [AWS](https://docs.atlas.mongodb.com/reference/amazon-aws/), [GCP](https://docs.atlas.mongodb.com/reference/google-gcp/), [Azure](https://docs.atlas.mongodb.com/reference/microsoft-azure/).
        Do not specify this field when creating a multi-region cluster using the replicationSpec document or a Global Cluster with the replicationSpecs array.
        """
        return pulumi.get(self, "provider_region_name")

    @provider_region_name.setter
    def provider_region_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "provider_region_name", value)

    @_builtins.property
    @pulumi.getter(name="providerVolumeType")
    def provider_volume_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type of the volume. The possible values are: `STANDARD` and `PROVISIONED`.  `PROVISIONED` is ONLY required if setting IOPS higher than the default instance IOPS.
        > **NOTE:** `STANDARD` is not available for NVME clusters.
        """
        return pulumi.get(self, "provider_volume_type")

    @provider_volume_type.setter
    def provider_volume_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "provider_volume_type", value)

    @_builtins.property
    @pulumi.getter(name="redactClientLogData")
    def redact_client_log_data(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Flag that enables or disables log redaction, see the [manual](https://www.mongodb.com/docs/manual/administration/monitoring/#log-redaction) for more information. Use this in conjunction with Encryption at Rest and TLS/SSL (Transport Encryption) to assist compliance with regulatory requirements. **Note**: Changing this setting on a cluster will trigger a rolling restart as soon as the cluster is updated. The log redaction field is updated via an Atlas API call after cluster creation. Consequently, there may be a brief period during resource creation when log redaction is not yet enabled. To ensure complete log redaction from the outset, use `AdvancedCluster`.
        """
        return pulumi.get(self, "redact_client_log_data")

    @redact_client_log_data.setter
    def redact_client_log_data(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "redact_client_log_data", value)

    @_builtins.property
    @pulumi.getter(name="replicationFactor")
    def replication_factor(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Number of replica set members. Each member keeps a copy of your databases, providing high availability and data redundancy. The possible values are 3, 5, or 7. The default value is 3.
        """
        return pulumi.get(self, "replication_factor")

    @replication_factor.setter
    def replication_factor(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "replication_factor", value)

    @_builtins.property
    @pulumi.getter(name="replicationSpecs")
    def replication_specs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ClusterReplicationSpecArgs']]]]:
        """
        Configuration for cluster regions.  See Replication Spec below for more details.
        """
        return pulumi.get(self, "replication_specs")

    @replication_specs.setter
    def replication_specs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ClusterReplicationSpecArgs']]]]):
        pulumi.set(self, "replication_specs", value)

    @_builtins.property
    @pulumi.getter(name="retainBackupsEnabled")
    def retain_backups_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        - (Optional) Set to true to retain backup snapshots for the deleted cluster. This parameter applies to the Delete operation and only affects M10 and above clusters. If you encounter the `CANNOT_DELETE_SNAPSHOT_WITH_BACKUP_COMPLIANCE_POLICY` error code, see how to delete a cluster with Backup Compliance Policy.
        """
        return pulumi.get(self, "retain_backups_enabled")

    @retain_backups_enabled.setter
    def retain_backups_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "retain_backups_enabled", value)

    @_builtins.property
    @pulumi.getter(name="snapshotBackupPolicies")
    def snapshot_backup_policies(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ClusterSnapshotBackupPolicyArgs']]]]:
        """
        current snapshot schedule and retention settings for the cluster.
        """
        return pulumi.get(self, "snapshot_backup_policies")

    @snapshot_backup_policies.setter
    def snapshot_backup_policies(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ClusterSnapshotBackupPolicyArgs']]]]):
        pulumi.set(self, "snapshot_backup_policies", value)

    @_builtins.property
    @pulumi.getter(name="srvAddress")
    def srv_address(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Connection string for connecting to the Atlas cluster. The +srv modifier forces the connection to use TLS/SSL. See the mongoURI for additional options.
        """
        return pulumi.get(self, "srv_address")

    @srv_address.setter
    def srv_address(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "srv_address", value)

    @_builtins.property
    @pulumi.getter(name="stateName")
    def state_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Current state of the cluster. The possible states are:
        - IDLE
        - CREATING
        - UPDATING
        - DELETING
        - DELETED
        - REPAIRING
        """
        return pulumi.get(self, "state_name")

    @state_name.setter
    def state_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "state_name", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ClusterTagArgs']]]]:
        """
        Set that contains key-value pairs between 1 to 255 characters in length for tagging and categorizing the cluster. See below.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ClusterTagArgs']]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="terminationProtectionEnabled")
    def termination_protection_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Flag that indicates whether termination protection is enabled on the cluster. If set to true, MongoDB Cloud won't delete the cluster. If set to false, MongoDB Cloud will delete the cluster.
        """
        return pulumi.get(self, "termination_protection_enabled")

    @termination_protection_enabled.setter
    def termination_protection_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "termination_protection_enabled", value)

    @_builtins.property
    @pulumi.getter(name="versionReleaseSystem")
    def version_release_system(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Release cadence that Atlas uses for this cluster. This parameter defaults to `LTS`. If you set this field to `CONTINUOUS`, you must omit the `mongo_db_major_version` field. Atlas accepts:
        - `CONTINUOUS`:  Atlas creates your cluster using the most recent MongoDB release. Atlas automatically updates your cluster to the latest major and rapid MongoDB releases as they become available.
        - `LTS`: Atlas creates your cluster using the latest patch release of the MongoDB version that you specify in the mongoDBMajorVersion field. Atlas automatically updates your cluster to subsequent patch releases of this MongoDB version. Atlas doesn't update your cluster to newer rapid or major MongoDB releases as they become available.
        """
        return pulumi.get(self, "version_release_system")

    @version_release_system.setter
    def version_release_system(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "version_release_system", value)


@pulumi.type_token("mongodbatlas:index/cluster:Cluster")
class Cluster(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 accept_data_risks_and_force_replica_set_reconfig: Optional[pulumi.Input[_builtins.str]] = None,
                 advanced_configuration: Optional[pulumi.Input[Union['ClusterAdvancedConfigurationArgs', 'ClusterAdvancedConfigurationArgsDict']]] = None,
                 auto_scaling_compute_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 auto_scaling_compute_scale_down_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 auto_scaling_disk_gb_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 backing_provider_name: Optional[pulumi.Input[_builtins.str]] = None,
                 backup_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 bi_connector_config: Optional[pulumi.Input[Union['ClusterBiConnectorConfigArgs', 'ClusterBiConnectorConfigArgsDict']]] = None,
                 cloud_backup: Optional[pulumi.Input[_builtins.bool]] = None,
                 cluster_type: Optional[pulumi.Input[_builtins.str]] = None,
                 disk_size_gb: Optional[pulumi.Input[_builtins.float]] = None,
                 encryption_at_rest_provider: Optional[pulumi.Input[_builtins.str]] = None,
                 labels: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ClusterLabelArgs', 'ClusterLabelArgsDict']]]]] = None,
                 mongo_db_major_version: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 num_shards: Optional[pulumi.Input[_builtins.int]] = None,
                 paused: Optional[pulumi.Input[_builtins.bool]] = None,
                 pinned_fcv: Optional[pulumi.Input[Union['ClusterPinnedFcvArgs', 'ClusterPinnedFcvArgsDict']]] = None,
                 pit_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 provider_auto_scaling_compute_max_instance_size: Optional[pulumi.Input[_builtins.str]] = None,
                 provider_auto_scaling_compute_min_instance_size: Optional[pulumi.Input[_builtins.str]] = None,
                 provider_disk_iops: Optional[pulumi.Input[_builtins.int]] = None,
                 provider_disk_type_name: Optional[pulumi.Input[_builtins.str]] = None,
                 provider_encrypt_ebs_volume: Optional[pulumi.Input[_builtins.bool]] = None,
                 provider_instance_size_name: Optional[pulumi.Input[_builtins.str]] = None,
                 provider_name: Optional[pulumi.Input[_builtins.str]] = None,
                 provider_region_name: Optional[pulumi.Input[_builtins.str]] = None,
                 provider_volume_type: Optional[pulumi.Input[_builtins.str]] = None,
                 redact_client_log_data: Optional[pulumi.Input[_builtins.bool]] = None,
                 replication_factor: Optional[pulumi.Input[_builtins.int]] = None,
                 replication_specs: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ClusterReplicationSpecArgs', 'ClusterReplicationSpecArgsDict']]]]] = None,
                 retain_backups_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ClusterTagArgs', 'ClusterTagArgsDict']]]]] = None,
                 termination_protection_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 version_release_system: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        ## Example Usage

        ### Example AWS cluster

        ```python
        import pulumi
        import pulumi_mongodbatlas as mongodbatlas

        cluster_test = mongodbatlas.Cluster("cluster-test",
            project_id="<YOUR-PROJECT-ID>",
            name="cluster-test",
            cluster_type="REPLICASET",
            replication_specs=[{
                "num_shards": 1,
                "regions_configs": [{
                    "region_name": "US_EAST_1",
                    "electable_nodes": 3,
                    "priority": 7,
                    "read_only_nodes": 0,
                }],
            }],
            cloud_backup=True,
            auto_scaling_disk_gb_enabled=True,
            mongo_db_major_version="7.0",
            provider_name="AWS",
            provider_instance_size_name="M40")
        ```

        ### Example Azure cluster.

        ```python
        import pulumi
        import pulumi_mongodbatlas as mongodbatlas

        test = mongodbatlas.Cluster("test",
            project_id="<YOUR-PROJECT-ID>",
            name="test",
            cluster_type="REPLICASET",
            replication_specs=[{
                "num_shards": 1,
                "regions_configs": [{
                    "region_name": "US_EAST",
                    "electable_nodes": 3,
                    "priority": 7,
                    "read_only_nodes": 0,
                }],
            }],
            cloud_backup=True,
            auto_scaling_disk_gb_enabled=True,
            mongo_db_major_version="7.0",
            provider_name="AZURE",
            provider_disk_type_name="P6",
            provider_instance_size_name="M30")
        ```

        ### Example GCP cluster

        ```python
        import pulumi
        import pulumi_mongodbatlas as mongodbatlas

        test = mongodbatlas.Cluster("test",
            project_id="<YOUR-PROJECT-ID>",
            name="test",
            cluster_type="REPLICASET",
            replication_specs=[{
                "num_shards": 1,
                "regions_configs": [{
                    "region_name": "EASTERN_US",
                    "electable_nodes": 3,
                    "priority": 7,
                    "read_only_nodes": 0,
                }],
            }],
            cloud_backup=True,
            auto_scaling_disk_gb_enabled=True,
            mongo_db_major_version="7.0",
            provider_name="GCP",
            provider_instance_size_name="M30")
        ```

        ### Example Multi Region cluster

        ```python
        import pulumi
        import pulumi_mongodbatlas as mongodbatlas

        cluster_test = mongodbatlas.Cluster("cluster-test",
            project_id="<YOUR-PROJECT-ID>",
            name="cluster-test-multi-region",
            num_shards=1,
            cloud_backup=True,
            cluster_type="REPLICASET",
            provider_name="AWS",
            provider_instance_size_name="M10",
            replication_specs=[{
                "num_shards": 1,
                "regions_configs": [
                    {
                        "region_name": "US_EAST_1",
                        "electable_nodes": 3,
                        "priority": 7,
                        "read_only_nodes": 0,
                    },
                    {
                        "region_name": "US_EAST_2",
                        "electable_nodes": 2,
                        "priority": 6,
                        "read_only_nodes": 0,
                    },
                    {
                        "region_name": "US_WEST_1",
                        "electable_nodes": 2,
                        "priority": 5,
                        "read_only_nodes": 2,
                    },
                ],
            }])
        ```

        ### Example Global cluster

        ```python
        import pulumi
        import pulumi_mongodbatlas as mongodbatlas

        cluster_test = mongodbatlas.Cluster("cluster-test",
            project_id="<YOUR-PROJECT-ID>",
            name="cluster-test-global",
            num_shards=1,
            cloud_backup=True,
            cluster_type="GEOSHARDED",
            provider_name="AWS",
            provider_instance_size_name="M30",
            replication_specs=[
                {
                    "zone_name": "Zone 1",
                    "num_shards": 2,
                    "regions_configs": [{
                        "region_name": "US_EAST_1",
                        "electable_nodes": 3,
                        "priority": 7,
                        "read_only_nodes": 0,
                    }],
                },
                {
                    "zone_name": "Zone 2",
                    "num_shards": 2,
                    "regions_configs": [{
                        "region_name": "EU_CENTRAL_1",
                        "electable_nodes": 3,
                        "priority": 7,
                        "read_only_nodes": 0,
                    }],
                },
            ])
        ```
        ### Example AWS Free Tier cluster
        ```python
        import pulumi
        import pulumi_mongodbatlas as mongodbatlas

        cluster_test = mongodbatlas.Cluster("cluster-test",
            project_id="<YOUR-PROJECT-ID>",
            name="cluster-test-global",
            provider_name="TENANT",
            backing_provider_name="AWS",
            provider_region_name="US_EAST_1",
            provider_instance_size_name="M0")
        ```
        ### Example - Return a Connection String
        Standard
        ```python
        import pulumi

        pulumi.export("standard", cluster_test["connectionStrings"][0]["standard"])
        ```
        Standard srv
        ```python
        import pulumi

        pulumi.export("standardSrv", cluster_test["connectionStrings"][0]["standardSrv"])
        ```
        Private with Network peering and Custom DNS AWS enabled
        ```python
        import pulumi

        pulumi.export("private", cluster_test["connectionStrings"][0]["private"])
        ```
        Private srv with Network peering and Custom DNS AWS enabled
        ```python
        import pulumi

        pulumi.export("privateSrv", cluster_test["connectionStrings"][0]["privateSrv"])
        ```

        By endpoint_service_id
        ## Import

        Clusters can be imported using project ID and cluster name, in the format `PROJECTID-CLUSTERNAME`, e.g.

        ```sh
        $ pulumi import mongodbatlas:index/cluster:Cluster my_cluster 1112222b3bf99403840e8934-Cluster0
        ```
        See detailed information for arguments and attributes: [MongoDB API Clusters](https://docs.atlas.mongodb.com/reference/api/clusters-create-one/)

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] accept_data_risks_and_force_replica_set_reconfig: If reconfiguration is necessary to regain a primary due to a regional outage, submit this field alongside your topology reconfiguration to request a new regional outage resistant topology. Forced reconfigurations during an outage of the majority of electable nodes carry a risk of data loss if replicated writes (even majority committed writes) have not been replicated to the new primary node. MongoDB Atlas docs contain more information. To proceed with an operation which carries that risk, set `accept_data_risks_and_force_replica_set_reconfig` to the current date. Learn more about Reconfiguring a Replica Set during a regional outage [here](https://dochub.mongodb.org/core/regional-outage-reconfigure-replica-set).
        :param pulumi.Input[_builtins.bool] auto_scaling_compute_scale_down_enabled: Set to `true` to enable the cluster tier to scale down. This option is only available if `autoScaling.compute.enabled` is `true`.
               - If this option is enabled, you must specify a value for `providerSettings.autoScaling.compute.minInstanceSize`
        :param pulumi.Input[_builtins.str] backing_provider_name: Cloud service provider on which the server for a multi-tenant cluster is provisioned.
               
               This setting is only valid when providerSetting.providerName is TENANT and providerSetting.instanceSizeName is M0.
               
               The possible values are:
               
               - AWS - Amazon AWS
               - GCP - Google Cloud Platform
               - AZURE - Microsoft Azure
        :param pulumi.Input[_builtins.bool] backup_enabled: Legacy Backup - Set to true to enable Atlas legacy backups for the cluster.
               **Important** - MongoDB deprecated the Legacy Backup feature. Clusters that use Legacy Backup can continue to use it. MongoDB recommends using [Cloud Backups](https://docs.atlas.mongodb.com/backup/cloud-backup/overview/).
               * New Atlas clusters of any type do not support this parameter. These clusters must use Cloud Backup, `cloud_backup`, to enable Cloud Backup.  If you create a new Atlas cluster and set `backup_enabled` to true, the Provider will respond with an error.  This change doesn’t affect existing clusters that use legacy backups.
               * Setting this value to false to disable legacy backups for the cluster will let Atlas delete any stored snapshots. In order to preserve the legacy backups snapshots, disable the legacy backups and enable the cloud backups in the single **pulumi up** action.
               ```
               backup_enabled = "false"
               cloud_backup = "true"
               ```
               * The default value is false. M10 and above only.
        :param pulumi.Input[Union['ClusterBiConnectorConfigArgs', 'ClusterBiConnectorConfigArgsDict']] bi_connector_config: Specifies BI Connector for Atlas configuration on this cluster. BI Connector for Atlas is only available for M10+ clusters. See BI Connector below for more details.
        :param pulumi.Input[_builtins.str] cluster_type: Specifies the type of the cluster that you want to modify. You cannot convert a sharded cluster deployment to a replica set deployment.
               
               > **WHEN SHOULD YOU USE CLUSTERTYPE?**
               When you set replication_specs, when you are deploying Global Clusters or when you are deploying non-Global replica sets and sharded clusters.
               
               Accepted values include:
               - `REPLICASET` Replica set
               - `SHARDED` Sharded cluster
               - `GEOSHARDED` Global Cluster
        :param pulumi.Input[_builtins.float] disk_size_gb: Capacity, in gigabytes, of the host’s root volume. Increase this number to add capacity, up to a maximum possible value of 4096 (i.e., 4 TB). This value must be a positive integer.
               * The minimum disk size for dedicated clusters is 10GB for AWS and GCP. If you specify diskSizeGB with a lower disk size, Atlas defaults to the minimum disk size value.
               * Note: The maximum value for disk storage cannot exceed 50 times the maximum RAM for the selected cluster. If you require additional storage space beyond this limitation, consider upgrading your cluster to a higher tier.
               * Cannot be used with clusters with local NVMe SSDs
               * Cannot be used with Azure clusters
        :param pulumi.Input[_builtins.str] encryption_at_rest_provider: Possible values are AWS, GCP, AZURE or NONE.  Only needed if you desire to manage the keys, see [Encryption at Rest using Customer Key Management](https://docs.atlas.mongodb.com/security-aws-kms/) for complete documentation.  You must configure encryption at rest for the Atlas project before enabling it on any cluster in the project. For complete documentation on configuring Encryption at Rest, see Encryption at Rest using Customer Key Management. Requires M10 or greater. and for legacy backups, backup_enabled, to be false or omitted. **Note: Atlas encrypts all cluster storage and snapshot volumes, securing all cluster data on disk: a concept known as encryption at rest, by default**.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ClusterLabelArgs', 'ClusterLabelArgsDict']]]] labels: Set that contains key-value pairs between 1 to 255 characters in length for tagging and categorizing the cluster. See below. **DEPRECATED** Use `tags` instead.
        :param pulumi.Input[_builtins.str] mongo_db_major_version: Version of the cluster to deploy. Atlas supports all the MongoDB versions that have **not** reached [End of Live](https://www.mongodb.com/legal/support-policy/lifecycles) for M10+ clusters. If omitted, Atlas deploys the cluster with the default version. For more details, see [documentation](https://www.mongodb.com/docs/atlas/reference/faq/database/#which-versions-of-mongodb-do-service-clusters-use-). Atlas always deploys the cluster with the latest stable release of the specified version. See [Release Notes](https://www.mongodb.com/docs/upcoming/release-notes/) for latest Current Stable Release.
        :param pulumi.Input[_builtins.str] name: Name of the cluster as it appears in Atlas. Once the cluster is created, its name cannot be changed. **WARNING** Changing the name will result in destruction of the existing cluster and the creation of a new cluster.
        :param pulumi.Input[_builtins.int] num_shards: Selects whether the cluster is a replica set or a sharded cluster. If you use the replicationSpecs parameter, you must set num_shards.
        :param pulumi.Input[Union['ClusterPinnedFcvArgs', 'ClusterPinnedFcvArgsDict']] pinned_fcv: Pins the Feature Compatibility Version (FCV) to the current MongoDB version with a provided expiration date. To unpin the FCV the `pinned_fcv` attribute must be removed. This operation can take several minutes as the request processes through the MongoDB data plane. Once FCV is unpinned it will not be possible to downgrade the `mongo_db_major_version`. It is advised that updates to `pinned_fcv` are done isolated from other cluster changes. If a plan contains multiple changes, the FCV change will be applied first. If FCV is unpinned past the expiration date the `pinned_fcv` attribute must be removed. The following [knowledge hub article](https://kb.corp.mongodb.com/article/000021785/) and [FCV documentation](https://www.mongodb.com/docs/atlas/tutorial/major-version-change/#manage-feature-compatibility--fcv--during-upgrades) can be referenced for more details. See below.
        :param pulumi.Input[_builtins.bool] pit_enabled: Flag that indicates if the cluster uses Continuous Cloud Backup. If set to true, cloud_backup must also be set to true.
        :param pulumi.Input[_builtins.str] project_id: The unique ID for the project to create the cluster.
        :param pulumi.Input[_builtins.str] provider_auto_scaling_compute_max_instance_size: Maximum instance size to which your cluster can automatically scale (e.g., M40). Required if `autoScaling.compute.enabled` is `true`.
        :param pulumi.Input[_builtins.str] provider_auto_scaling_compute_min_instance_size: Minimum instance size to which your cluster can automatically scale (e.g., M10). Required if `autoScaling.compute.scaleDownEnabled` is `true`.
        :param pulumi.Input[_builtins.int] provider_disk_iops: The maximum input/output operations per second (IOPS) the system can perform. The possible values depend on the selected `provider_instance_size_name` and `disk_size_gb`.  This setting requires that `provider_instance_size_name` to be M30 or greater and cannot be used with clusters with local NVMe SSDs.  The default value for `provider_disk_iops` is the same as the cluster tier's Standard IOPS value, as viewable in the Atlas console.  It is used in cases where a higher number of IOPS is needed and possible.  If a value is submitted that is lower or equal to the default IOPS value for the cluster tier Atlas ignores the requested value and uses the default.  More details available under the providerSettings.diskIOPS parameter: [MongoDB API Clusters](https://docs.atlas.mongodb.com/reference/api/clusters-create-one/)
               * You do not need to configure IOPS for a STANDARD disk configuration but only for a PROVISIONED configuration.
        :param pulumi.Input[_builtins.str] provider_disk_type_name: Azure disk type of the server’s root volume. If omitted, Atlas uses the default disk type for the selected providerSettings.instanceSizeName.  Example disk types and associated storage sizes: P4 - 32GB, P6 - 64GB, P10 - 128GB, P15 - 256GB, P20 - 512GB, P30 - 1024GB, P40 - 2048GB, P50 - 4095GB.  More information and the most update to date disk types/storage sizes can be located at https://docs.atlas.mongodb.com/reference/api/clusters-create-one/.
        :param pulumi.Input[_builtins.bool] provider_encrypt_ebs_volume: **(Deprecated) The Flag is always true.** Flag that indicates whether the Amazon EBS encryption feature encrypts the host's root volume for both data at rest within the volume and for data moving between the volume and the cluster. Note: This setting is always enabled for clusters with local NVMe SSDs. **Atlas encrypts all cluster storage and snapshot volumes, securing all cluster data on disk: a concept known as encryption at rest, by default.**.
        :param pulumi.Input[_builtins.str] provider_instance_size_name: Atlas provides different instance sizes, each with a default storage capacity and RAM size. The instance size you select is used for all the data-bearing servers in your cluster. See [Create a Cluster](https://docs.atlas.mongodb.com/reference/api/clusters-create-one/) `providerSettings.instanceSizeName` for valid values and default resources.
        :param pulumi.Input[_builtins.str] provider_name: Cloud service provider on which the servers are provisioned.
               
               The possible values are:
               
               - `AWS` - Amazon AWS
               - `GCP` - Google Cloud Platform
               - `AZURE` - Microsoft Azure
               - `TENANT` - A multi-tenant deployment on one of the supported cloud service providers. Only valid when providerSettings.instanceSizeName is M0.
        :param pulumi.Input[_builtins.str] provider_region_name: Physical location of your MongoDB cluster. The region you choose can affect network latency for clients accessing your databases.  Requires the **Atlas region name**, see the reference list for [AWS](https://docs.atlas.mongodb.com/reference/amazon-aws/), [GCP](https://docs.atlas.mongodb.com/reference/google-gcp/), [Azure](https://docs.atlas.mongodb.com/reference/microsoft-azure/).
               Do not specify this field when creating a multi-region cluster using the replicationSpec document or a Global Cluster with the replicationSpecs array.
        :param pulumi.Input[_builtins.str] provider_volume_type: The type of the volume. The possible values are: `STANDARD` and `PROVISIONED`.  `PROVISIONED` is ONLY required if setting IOPS higher than the default instance IOPS.
               > **NOTE:** `STANDARD` is not available for NVME clusters.
        :param pulumi.Input[_builtins.bool] redact_client_log_data: Flag that enables or disables log redaction, see the [manual](https://www.mongodb.com/docs/manual/administration/monitoring/#log-redaction) for more information. Use this in conjunction with Encryption at Rest and TLS/SSL (Transport Encryption) to assist compliance with regulatory requirements. **Note**: Changing this setting on a cluster will trigger a rolling restart as soon as the cluster is updated. The log redaction field is updated via an Atlas API call after cluster creation. Consequently, there may be a brief period during resource creation when log redaction is not yet enabled. To ensure complete log redaction from the outset, use `AdvancedCluster`.
        :param pulumi.Input[_builtins.int] replication_factor: Number of replica set members. Each member keeps a copy of your databases, providing high availability and data redundancy. The possible values are 3, 5, or 7. The default value is 3.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ClusterReplicationSpecArgs', 'ClusterReplicationSpecArgsDict']]]] replication_specs: Configuration for cluster regions.  See Replication Spec below for more details.
        :param pulumi.Input[_builtins.bool] retain_backups_enabled: - (Optional) Set to true to retain backup snapshots for the deleted cluster. This parameter applies to the Delete operation and only affects M10 and above clusters. If you encounter the `CANNOT_DELETE_SNAPSHOT_WITH_BACKUP_COMPLIANCE_POLICY` error code, see how to delete a cluster with Backup Compliance Policy.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ClusterTagArgs', 'ClusterTagArgsDict']]]] tags: Set that contains key-value pairs between 1 to 255 characters in length for tagging and categorizing the cluster. See below.
        :param pulumi.Input[_builtins.bool] termination_protection_enabled: Flag that indicates whether termination protection is enabled on the cluster. If set to true, MongoDB Cloud won't delete the cluster. If set to false, MongoDB Cloud will delete the cluster.
        :param pulumi.Input[_builtins.str] version_release_system: Release cadence that Atlas uses for this cluster. This parameter defaults to `LTS`. If you set this field to `CONTINUOUS`, you must omit the `mongo_db_major_version` field. Atlas accepts:
               - `CONTINUOUS`:  Atlas creates your cluster using the most recent MongoDB release. Atlas automatically updates your cluster to the latest major and rapid MongoDB releases as they become available.
               - `LTS`: Atlas creates your cluster using the latest patch release of the MongoDB version that you specify in the mongoDBMajorVersion field. Atlas automatically updates your cluster to subsequent patch releases of this MongoDB version. Atlas doesn't update your cluster to newer rapid or major MongoDB releases as they become available.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ClusterArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ### Example AWS cluster

        ```python
        import pulumi
        import pulumi_mongodbatlas as mongodbatlas

        cluster_test = mongodbatlas.Cluster("cluster-test",
            project_id="<YOUR-PROJECT-ID>",
            name="cluster-test",
            cluster_type="REPLICASET",
            replication_specs=[{
                "num_shards": 1,
                "regions_configs": [{
                    "region_name": "US_EAST_1",
                    "electable_nodes": 3,
                    "priority": 7,
                    "read_only_nodes": 0,
                }],
            }],
            cloud_backup=True,
            auto_scaling_disk_gb_enabled=True,
            mongo_db_major_version="7.0",
            provider_name="AWS",
            provider_instance_size_name="M40")
        ```

        ### Example Azure cluster.

        ```python
        import pulumi
        import pulumi_mongodbatlas as mongodbatlas

        test = mongodbatlas.Cluster("test",
            project_id="<YOUR-PROJECT-ID>",
            name="test",
            cluster_type="REPLICASET",
            replication_specs=[{
                "num_shards": 1,
                "regions_configs": [{
                    "region_name": "US_EAST",
                    "electable_nodes": 3,
                    "priority": 7,
                    "read_only_nodes": 0,
                }],
            }],
            cloud_backup=True,
            auto_scaling_disk_gb_enabled=True,
            mongo_db_major_version="7.0",
            provider_name="AZURE",
            provider_disk_type_name="P6",
            provider_instance_size_name="M30")
        ```

        ### Example GCP cluster

        ```python
        import pulumi
        import pulumi_mongodbatlas as mongodbatlas

        test = mongodbatlas.Cluster("test",
            project_id="<YOUR-PROJECT-ID>",
            name="test",
            cluster_type="REPLICASET",
            replication_specs=[{
                "num_shards": 1,
                "regions_configs": [{
                    "region_name": "EASTERN_US",
                    "electable_nodes": 3,
                    "priority": 7,
                    "read_only_nodes": 0,
                }],
            }],
            cloud_backup=True,
            auto_scaling_disk_gb_enabled=True,
            mongo_db_major_version="7.0",
            provider_name="GCP",
            provider_instance_size_name="M30")
        ```

        ### Example Multi Region cluster

        ```python
        import pulumi
        import pulumi_mongodbatlas as mongodbatlas

        cluster_test = mongodbatlas.Cluster("cluster-test",
            project_id="<YOUR-PROJECT-ID>",
            name="cluster-test-multi-region",
            num_shards=1,
            cloud_backup=True,
            cluster_type="REPLICASET",
            provider_name="AWS",
            provider_instance_size_name="M10",
            replication_specs=[{
                "num_shards": 1,
                "regions_configs": [
                    {
                        "region_name": "US_EAST_1",
                        "electable_nodes": 3,
                        "priority": 7,
                        "read_only_nodes": 0,
                    },
                    {
                        "region_name": "US_EAST_2",
                        "electable_nodes": 2,
                        "priority": 6,
                        "read_only_nodes": 0,
                    },
                    {
                        "region_name": "US_WEST_1",
                        "electable_nodes": 2,
                        "priority": 5,
                        "read_only_nodes": 2,
                    },
                ],
            }])
        ```

        ### Example Global cluster

        ```python
        import pulumi
        import pulumi_mongodbatlas as mongodbatlas

        cluster_test = mongodbatlas.Cluster("cluster-test",
            project_id="<YOUR-PROJECT-ID>",
            name="cluster-test-global",
            num_shards=1,
            cloud_backup=True,
            cluster_type="GEOSHARDED",
            provider_name="AWS",
            provider_instance_size_name="M30",
            replication_specs=[
                {
                    "zone_name": "Zone 1",
                    "num_shards": 2,
                    "regions_configs": [{
                        "region_name": "US_EAST_1",
                        "electable_nodes": 3,
                        "priority": 7,
                        "read_only_nodes": 0,
                    }],
                },
                {
                    "zone_name": "Zone 2",
                    "num_shards": 2,
                    "regions_configs": [{
                        "region_name": "EU_CENTRAL_1",
                        "electable_nodes": 3,
                        "priority": 7,
                        "read_only_nodes": 0,
                    }],
                },
            ])
        ```
        ### Example AWS Free Tier cluster
        ```python
        import pulumi
        import pulumi_mongodbatlas as mongodbatlas

        cluster_test = mongodbatlas.Cluster("cluster-test",
            project_id="<YOUR-PROJECT-ID>",
            name="cluster-test-global",
            provider_name="TENANT",
            backing_provider_name="AWS",
            provider_region_name="US_EAST_1",
            provider_instance_size_name="M0")
        ```
        ### Example - Return a Connection String
        Standard
        ```python
        import pulumi

        pulumi.export("standard", cluster_test["connectionStrings"][0]["standard"])
        ```
        Standard srv
        ```python
        import pulumi

        pulumi.export("standardSrv", cluster_test["connectionStrings"][0]["standardSrv"])
        ```
        Private with Network peering and Custom DNS AWS enabled
        ```python
        import pulumi

        pulumi.export("private", cluster_test["connectionStrings"][0]["private"])
        ```
        Private srv with Network peering and Custom DNS AWS enabled
        ```python
        import pulumi

        pulumi.export("privateSrv", cluster_test["connectionStrings"][0]["privateSrv"])
        ```

        By endpoint_service_id
        ## Import

        Clusters can be imported using project ID and cluster name, in the format `PROJECTID-CLUSTERNAME`, e.g.

        ```sh
        $ pulumi import mongodbatlas:index/cluster:Cluster my_cluster 1112222b3bf99403840e8934-Cluster0
        ```
        See detailed information for arguments and attributes: [MongoDB API Clusters](https://docs.atlas.mongodb.com/reference/api/clusters-create-one/)

        :param str resource_name: The name of the resource.
        :param ClusterArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ClusterArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 accept_data_risks_and_force_replica_set_reconfig: Optional[pulumi.Input[_builtins.str]] = None,
                 advanced_configuration: Optional[pulumi.Input[Union['ClusterAdvancedConfigurationArgs', 'ClusterAdvancedConfigurationArgsDict']]] = None,
                 auto_scaling_compute_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 auto_scaling_compute_scale_down_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 auto_scaling_disk_gb_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 backing_provider_name: Optional[pulumi.Input[_builtins.str]] = None,
                 backup_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 bi_connector_config: Optional[pulumi.Input[Union['ClusterBiConnectorConfigArgs', 'ClusterBiConnectorConfigArgsDict']]] = None,
                 cloud_backup: Optional[pulumi.Input[_builtins.bool]] = None,
                 cluster_type: Optional[pulumi.Input[_builtins.str]] = None,
                 disk_size_gb: Optional[pulumi.Input[_builtins.float]] = None,
                 encryption_at_rest_provider: Optional[pulumi.Input[_builtins.str]] = None,
                 labels: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ClusterLabelArgs', 'ClusterLabelArgsDict']]]]] = None,
                 mongo_db_major_version: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 num_shards: Optional[pulumi.Input[_builtins.int]] = None,
                 paused: Optional[pulumi.Input[_builtins.bool]] = None,
                 pinned_fcv: Optional[pulumi.Input[Union['ClusterPinnedFcvArgs', 'ClusterPinnedFcvArgsDict']]] = None,
                 pit_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 provider_auto_scaling_compute_max_instance_size: Optional[pulumi.Input[_builtins.str]] = None,
                 provider_auto_scaling_compute_min_instance_size: Optional[pulumi.Input[_builtins.str]] = None,
                 provider_disk_iops: Optional[pulumi.Input[_builtins.int]] = None,
                 provider_disk_type_name: Optional[pulumi.Input[_builtins.str]] = None,
                 provider_encrypt_ebs_volume: Optional[pulumi.Input[_builtins.bool]] = None,
                 provider_instance_size_name: Optional[pulumi.Input[_builtins.str]] = None,
                 provider_name: Optional[pulumi.Input[_builtins.str]] = None,
                 provider_region_name: Optional[pulumi.Input[_builtins.str]] = None,
                 provider_volume_type: Optional[pulumi.Input[_builtins.str]] = None,
                 redact_client_log_data: Optional[pulumi.Input[_builtins.bool]] = None,
                 replication_factor: Optional[pulumi.Input[_builtins.int]] = None,
                 replication_specs: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ClusterReplicationSpecArgs', 'ClusterReplicationSpecArgsDict']]]]] = None,
                 retain_backups_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ClusterTagArgs', 'ClusterTagArgsDict']]]]] = None,
                 termination_protection_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 version_release_system: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ClusterArgs.__new__(ClusterArgs)

            __props__.__dict__["accept_data_risks_and_force_replica_set_reconfig"] = accept_data_risks_and_force_replica_set_reconfig
            __props__.__dict__["advanced_configuration"] = advanced_configuration
            __props__.__dict__["auto_scaling_compute_enabled"] = auto_scaling_compute_enabled
            __props__.__dict__["auto_scaling_compute_scale_down_enabled"] = auto_scaling_compute_scale_down_enabled
            __props__.__dict__["auto_scaling_disk_gb_enabled"] = auto_scaling_disk_gb_enabled
            __props__.__dict__["backing_provider_name"] = backing_provider_name
            __props__.__dict__["backup_enabled"] = backup_enabled
            __props__.__dict__["bi_connector_config"] = bi_connector_config
            __props__.__dict__["cloud_backup"] = cloud_backup
            __props__.__dict__["cluster_type"] = cluster_type
            __props__.__dict__["disk_size_gb"] = disk_size_gb
            __props__.__dict__["encryption_at_rest_provider"] = encryption_at_rest_provider
            __props__.__dict__["labels"] = labels
            __props__.__dict__["mongo_db_major_version"] = mongo_db_major_version
            __props__.__dict__["name"] = name
            __props__.__dict__["num_shards"] = num_shards
            __props__.__dict__["paused"] = paused
            __props__.__dict__["pinned_fcv"] = pinned_fcv
            __props__.__dict__["pit_enabled"] = pit_enabled
            if project_id is None and not opts.urn:
                raise TypeError("Missing required property 'project_id'")
            __props__.__dict__["project_id"] = project_id
            __props__.__dict__["provider_auto_scaling_compute_max_instance_size"] = provider_auto_scaling_compute_max_instance_size
            __props__.__dict__["provider_auto_scaling_compute_min_instance_size"] = provider_auto_scaling_compute_min_instance_size
            __props__.__dict__["provider_disk_iops"] = provider_disk_iops
            __props__.__dict__["provider_disk_type_name"] = provider_disk_type_name
            __props__.__dict__["provider_encrypt_ebs_volume"] = provider_encrypt_ebs_volume
            if provider_instance_size_name is None and not opts.urn:
                raise TypeError("Missing required property 'provider_instance_size_name'")
            __props__.__dict__["provider_instance_size_name"] = provider_instance_size_name
            if provider_name is None and not opts.urn:
                raise TypeError("Missing required property 'provider_name'")
            __props__.__dict__["provider_name"] = provider_name
            __props__.__dict__["provider_region_name"] = provider_region_name
            __props__.__dict__["provider_volume_type"] = provider_volume_type
            __props__.__dict__["redact_client_log_data"] = redact_client_log_data
            __props__.__dict__["replication_factor"] = replication_factor
            __props__.__dict__["replication_specs"] = replication_specs
            __props__.__dict__["retain_backups_enabled"] = retain_backups_enabled
            __props__.__dict__["tags"] = tags
            __props__.__dict__["termination_protection_enabled"] = termination_protection_enabled
            __props__.__dict__["version_release_system"] = version_release_system
            __props__.__dict__["cluster_id"] = None
            __props__.__dict__["connection_strings"] = None
            __props__.__dict__["container_id"] = None
            __props__.__dict__["mongo_db_version"] = None
            __props__.__dict__["mongo_uri"] = None
            __props__.__dict__["mongo_uri_updated"] = None
            __props__.__dict__["mongo_uri_with_options"] = None
            __props__.__dict__["provider_encrypt_ebs_volume_flag"] = None
            __props__.__dict__["snapshot_backup_policies"] = None
            __props__.__dict__["srv_address"] = None
            __props__.__dict__["state_name"] = None
        super(Cluster, __self__).__init__(
            'mongodbatlas:index/cluster:Cluster',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            accept_data_risks_and_force_replica_set_reconfig: Optional[pulumi.Input[_builtins.str]] = None,
            advanced_configuration: Optional[pulumi.Input[Union['ClusterAdvancedConfigurationArgs', 'ClusterAdvancedConfigurationArgsDict']]] = None,
            auto_scaling_compute_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            auto_scaling_compute_scale_down_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            auto_scaling_disk_gb_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            backing_provider_name: Optional[pulumi.Input[_builtins.str]] = None,
            backup_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            bi_connector_config: Optional[pulumi.Input[Union['ClusterBiConnectorConfigArgs', 'ClusterBiConnectorConfigArgsDict']]] = None,
            cloud_backup: Optional[pulumi.Input[_builtins.bool]] = None,
            cluster_id: Optional[pulumi.Input[_builtins.str]] = None,
            cluster_type: Optional[pulumi.Input[_builtins.str]] = None,
            connection_strings: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ClusterConnectionStringArgs', 'ClusterConnectionStringArgsDict']]]]] = None,
            container_id: Optional[pulumi.Input[_builtins.str]] = None,
            disk_size_gb: Optional[pulumi.Input[_builtins.float]] = None,
            encryption_at_rest_provider: Optional[pulumi.Input[_builtins.str]] = None,
            labels: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ClusterLabelArgs', 'ClusterLabelArgsDict']]]]] = None,
            mongo_db_major_version: Optional[pulumi.Input[_builtins.str]] = None,
            mongo_db_version: Optional[pulumi.Input[_builtins.str]] = None,
            mongo_uri: Optional[pulumi.Input[_builtins.str]] = None,
            mongo_uri_updated: Optional[pulumi.Input[_builtins.str]] = None,
            mongo_uri_with_options: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            num_shards: Optional[pulumi.Input[_builtins.int]] = None,
            paused: Optional[pulumi.Input[_builtins.bool]] = None,
            pinned_fcv: Optional[pulumi.Input[Union['ClusterPinnedFcvArgs', 'ClusterPinnedFcvArgsDict']]] = None,
            pit_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            project_id: Optional[pulumi.Input[_builtins.str]] = None,
            provider_auto_scaling_compute_max_instance_size: Optional[pulumi.Input[_builtins.str]] = None,
            provider_auto_scaling_compute_min_instance_size: Optional[pulumi.Input[_builtins.str]] = None,
            provider_disk_iops: Optional[pulumi.Input[_builtins.int]] = None,
            provider_disk_type_name: Optional[pulumi.Input[_builtins.str]] = None,
            provider_encrypt_ebs_volume: Optional[pulumi.Input[_builtins.bool]] = None,
            provider_encrypt_ebs_volume_flag: Optional[pulumi.Input[_builtins.bool]] = None,
            provider_instance_size_name: Optional[pulumi.Input[_builtins.str]] = None,
            provider_name: Optional[pulumi.Input[_builtins.str]] = None,
            provider_region_name: Optional[pulumi.Input[_builtins.str]] = None,
            provider_volume_type: Optional[pulumi.Input[_builtins.str]] = None,
            redact_client_log_data: Optional[pulumi.Input[_builtins.bool]] = None,
            replication_factor: Optional[pulumi.Input[_builtins.int]] = None,
            replication_specs: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ClusterReplicationSpecArgs', 'ClusterReplicationSpecArgsDict']]]]] = None,
            retain_backups_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            snapshot_backup_policies: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ClusterSnapshotBackupPolicyArgs', 'ClusterSnapshotBackupPolicyArgsDict']]]]] = None,
            srv_address: Optional[pulumi.Input[_builtins.str]] = None,
            state_name: Optional[pulumi.Input[_builtins.str]] = None,
            tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ClusterTagArgs', 'ClusterTagArgsDict']]]]] = None,
            termination_protection_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            version_release_system: Optional[pulumi.Input[_builtins.str]] = None) -> 'Cluster':
        """
        Get an existing Cluster resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] accept_data_risks_and_force_replica_set_reconfig: If reconfiguration is necessary to regain a primary due to a regional outage, submit this field alongside your topology reconfiguration to request a new regional outage resistant topology. Forced reconfigurations during an outage of the majority of electable nodes carry a risk of data loss if replicated writes (even majority committed writes) have not been replicated to the new primary node. MongoDB Atlas docs contain more information. To proceed with an operation which carries that risk, set `accept_data_risks_and_force_replica_set_reconfig` to the current date. Learn more about Reconfiguring a Replica Set during a regional outage [here](https://dochub.mongodb.org/core/regional-outage-reconfigure-replica-set).
        :param pulumi.Input[_builtins.bool] auto_scaling_compute_scale_down_enabled: Set to `true` to enable the cluster tier to scale down. This option is only available if `autoScaling.compute.enabled` is `true`.
               - If this option is enabled, you must specify a value for `providerSettings.autoScaling.compute.minInstanceSize`
        :param pulumi.Input[_builtins.str] backing_provider_name: Cloud service provider on which the server for a multi-tenant cluster is provisioned.
               
               This setting is only valid when providerSetting.providerName is TENANT and providerSetting.instanceSizeName is M0.
               
               The possible values are:
               
               - AWS - Amazon AWS
               - GCP - Google Cloud Platform
               - AZURE - Microsoft Azure
        :param pulumi.Input[_builtins.bool] backup_enabled: Legacy Backup - Set to true to enable Atlas legacy backups for the cluster.
               **Important** - MongoDB deprecated the Legacy Backup feature. Clusters that use Legacy Backup can continue to use it. MongoDB recommends using [Cloud Backups](https://docs.atlas.mongodb.com/backup/cloud-backup/overview/).
               * New Atlas clusters of any type do not support this parameter. These clusters must use Cloud Backup, `cloud_backup`, to enable Cloud Backup.  If you create a new Atlas cluster and set `backup_enabled` to true, the Provider will respond with an error.  This change doesn’t affect existing clusters that use legacy backups.
               * Setting this value to false to disable legacy backups for the cluster will let Atlas delete any stored snapshots. In order to preserve the legacy backups snapshots, disable the legacy backups and enable the cloud backups in the single **pulumi up** action.
               ```
               backup_enabled = "false"
               cloud_backup = "true"
               ```
               * The default value is false. M10 and above only.
        :param pulumi.Input[Union['ClusterBiConnectorConfigArgs', 'ClusterBiConnectorConfigArgsDict']] bi_connector_config: Specifies BI Connector for Atlas configuration on this cluster. BI Connector for Atlas is only available for M10+ clusters. See BI Connector below for more details.
        :param pulumi.Input[_builtins.str] cluster_id: The cluster ID.
        :param pulumi.Input[_builtins.str] cluster_type: Specifies the type of the cluster that you want to modify. You cannot convert a sharded cluster deployment to a replica set deployment.
               
               > **WHEN SHOULD YOU USE CLUSTERTYPE?**
               When you set replication_specs, when you are deploying Global Clusters or when you are deploying non-Global replica sets and sharded clusters.
               
               Accepted values include:
               - `REPLICASET` Replica set
               - `SHARDED` Sharded cluster
               - `GEOSHARDED` Global Cluster
        :param pulumi.Input[Sequence[pulumi.Input[Union['ClusterConnectionStringArgs', 'ClusterConnectionStringArgsDict']]]] connection_strings: Set of connection strings that your applications use to connect to this cluster. More information in [Connection-strings](https://docs.mongodb.com/manual/reference/connection-string/). Use the parameters in this object to connect your applications to this cluster. To learn more about the formats of connection strings, see [Connection String Options](https://docs.atlas.mongodb.com/reference/faq/connection-changes/). NOTE: Atlas returns the contents of this object after the cluster is operational, not while it builds the cluster.
        :param pulumi.Input[_builtins.str] container_id: The Container ID is the id of the container created when the first cluster in the region (AWS/Azure) or project (GCP) was created.
        :param pulumi.Input[_builtins.float] disk_size_gb: Capacity, in gigabytes, of the host’s root volume. Increase this number to add capacity, up to a maximum possible value of 4096 (i.e., 4 TB). This value must be a positive integer.
               * The minimum disk size for dedicated clusters is 10GB for AWS and GCP. If you specify diskSizeGB with a lower disk size, Atlas defaults to the minimum disk size value.
               * Note: The maximum value for disk storage cannot exceed 50 times the maximum RAM for the selected cluster. If you require additional storage space beyond this limitation, consider upgrading your cluster to a higher tier.
               * Cannot be used with clusters with local NVMe SSDs
               * Cannot be used with Azure clusters
        :param pulumi.Input[_builtins.str] encryption_at_rest_provider: Possible values are AWS, GCP, AZURE or NONE.  Only needed if you desire to manage the keys, see [Encryption at Rest using Customer Key Management](https://docs.atlas.mongodb.com/security-aws-kms/) for complete documentation.  You must configure encryption at rest for the Atlas project before enabling it on any cluster in the project. For complete documentation on configuring Encryption at Rest, see Encryption at Rest using Customer Key Management. Requires M10 or greater. and for legacy backups, backup_enabled, to be false or omitted. **Note: Atlas encrypts all cluster storage and snapshot volumes, securing all cluster data on disk: a concept known as encryption at rest, by default**.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ClusterLabelArgs', 'ClusterLabelArgsDict']]]] labels: Set that contains key-value pairs between 1 to 255 characters in length for tagging and categorizing the cluster. See below. **DEPRECATED** Use `tags` instead.
        :param pulumi.Input[_builtins.str] mongo_db_major_version: Version of the cluster to deploy. Atlas supports all the MongoDB versions that have **not** reached [End of Live](https://www.mongodb.com/legal/support-policy/lifecycles) for M10+ clusters. If omitted, Atlas deploys the cluster with the default version. For more details, see [documentation](https://www.mongodb.com/docs/atlas/reference/faq/database/#which-versions-of-mongodb-do-service-clusters-use-). Atlas always deploys the cluster with the latest stable release of the specified version. See [Release Notes](https://www.mongodb.com/docs/upcoming/release-notes/) for latest Current Stable Release.
        :param pulumi.Input[_builtins.str] mongo_db_version: Version of MongoDB the cluster runs, in `major-version`.`minor-version` format.
        :param pulumi.Input[_builtins.str] mongo_uri: Base connection string for the cluster. Atlas only displays this field after the cluster is operational, not while it builds the cluster.
        :param pulumi.Input[_builtins.str] mongo_uri_updated: Lists when the connection string was last updated. The connection string changes, for example, if you change a replica set to a sharded cluster.
        :param pulumi.Input[_builtins.str] mongo_uri_with_options: connection string for connecting to the Atlas cluster. Includes the replicaSet, ssl, and authSource query parameters in the connection string with values appropriate for the cluster.
        :param pulumi.Input[_builtins.str] name: Name of the cluster as it appears in Atlas. Once the cluster is created, its name cannot be changed. **WARNING** Changing the name will result in destruction of the existing cluster and the creation of a new cluster.
        :param pulumi.Input[_builtins.int] num_shards: Selects whether the cluster is a replica set or a sharded cluster. If you use the replicationSpecs parameter, you must set num_shards.
        :param pulumi.Input[Union['ClusterPinnedFcvArgs', 'ClusterPinnedFcvArgsDict']] pinned_fcv: Pins the Feature Compatibility Version (FCV) to the current MongoDB version with a provided expiration date. To unpin the FCV the `pinned_fcv` attribute must be removed. This operation can take several minutes as the request processes through the MongoDB data plane. Once FCV is unpinned it will not be possible to downgrade the `mongo_db_major_version`. It is advised that updates to `pinned_fcv` are done isolated from other cluster changes. If a plan contains multiple changes, the FCV change will be applied first. If FCV is unpinned past the expiration date the `pinned_fcv` attribute must be removed. The following [knowledge hub article](https://kb.corp.mongodb.com/article/000021785/) and [FCV documentation](https://www.mongodb.com/docs/atlas/tutorial/major-version-change/#manage-feature-compatibility--fcv--during-upgrades) can be referenced for more details. See below.
        :param pulumi.Input[_builtins.bool] pit_enabled: Flag that indicates if the cluster uses Continuous Cloud Backup. If set to true, cloud_backup must also be set to true.
        :param pulumi.Input[_builtins.str] project_id: The unique ID for the project to create the cluster.
        :param pulumi.Input[_builtins.str] provider_auto_scaling_compute_max_instance_size: Maximum instance size to which your cluster can automatically scale (e.g., M40). Required if `autoScaling.compute.enabled` is `true`.
        :param pulumi.Input[_builtins.str] provider_auto_scaling_compute_min_instance_size: Minimum instance size to which your cluster can automatically scale (e.g., M10). Required if `autoScaling.compute.scaleDownEnabled` is `true`.
        :param pulumi.Input[_builtins.int] provider_disk_iops: The maximum input/output operations per second (IOPS) the system can perform. The possible values depend on the selected `provider_instance_size_name` and `disk_size_gb`.  This setting requires that `provider_instance_size_name` to be M30 or greater and cannot be used with clusters with local NVMe SSDs.  The default value for `provider_disk_iops` is the same as the cluster tier's Standard IOPS value, as viewable in the Atlas console.  It is used in cases where a higher number of IOPS is needed and possible.  If a value is submitted that is lower or equal to the default IOPS value for the cluster tier Atlas ignores the requested value and uses the default.  More details available under the providerSettings.diskIOPS parameter: [MongoDB API Clusters](https://docs.atlas.mongodb.com/reference/api/clusters-create-one/)
               * You do not need to configure IOPS for a STANDARD disk configuration but only for a PROVISIONED configuration.
        :param pulumi.Input[_builtins.str] provider_disk_type_name: Azure disk type of the server’s root volume. If omitted, Atlas uses the default disk type for the selected providerSettings.instanceSizeName.  Example disk types and associated storage sizes: P4 - 32GB, P6 - 64GB, P10 - 128GB, P15 - 256GB, P20 - 512GB, P30 - 1024GB, P40 - 2048GB, P50 - 4095GB.  More information and the most update to date disk types/storage sizes can be located at https://docs.atlas.mongodb.com/reference/api/clusters-create-one/.
        :param pulumi.Input[_builtins.bool] provider_encrypt_ebs_volume: **(Deprecated) The Flag is always true.** Flag that indicates whether the Amazon EBS encryption feature encrypts the host's root volume for both data at rest within the volume and for data moving between the volume and the cluster. Note: This setting is always enabled for clusters with local NVMe SSDs. **Atlas encrypts all cluster storage and snapshot volumes, securing all cluster data on disk: a concept known as encryption at rest, by default.**.
        :param pulumi.Input[_builtins.str] provider_instance_size_name: Atlas provides different instance sizes, each with a default storage capacity and RAM size. The instance size you select is used for all the data-bearing servers in your cluster. See [Create a Cluster](https://docs.atlas.mongodb.com/reference/api/clusters-create-one/) `providerSettings.instanceSizeName` for valid values and default resources.
        :param pulumi.Input[_builtins.str] provider_name: Cloud service provider on which the servers are provisioned.
               
               The possible values are:
               
               - `AWS` - Amazon AWS
               - `GCP` - Google Cloud Platform
               - `AZURE` - Microsoft Azure
               - `TENANT` - A multi-tenant deployment on one of the supported cloud service providers. Only valid when providerSettings.instanceSizeName is M0.
        :param pulumi.Input[_builtins.str] provider_region_name: Physical location of your MongoDB cluster. The region you choose can affect network latency for clients accessing your databases.  Requires the **Atlas region name**, see the reference list for [AWS](https://docs.atlas.mongodb.com/reference/amazon-aws/), [GCP](https://docs.atlas.mongodb.com/reference/google-gcp/), [Azure](https://docs.atlas.mongodb.com/reference/microsoft-azure/).
               Do not specify this field when creating a multi-region cluster using the replicationSpec document or a Global Cluster with the replicationSpecs array.
        :param pulumi.Input[_builtins.str] provider_volume_type: The type of the volume. The possible values are: `STANDARD` and `PROVISIONED`.  `PROVISIONED` is ONLY required if setting IOPS higher than the default instance IOPS.
               > **NOTE:** `STANDARD` is not available for NVME clusters.
        :param pulumi.Input[_builtins.bool] redact_client_log_data: Flag that enables or disables log redaction, see the [manual](https://www.mongodb.com/docs/manual/administration/monitoring/#log-redaction) for more information. Use this in conjunction with Encryption at Rest and TLS/SSL (Transport Encryption) to assist compliance with regulatory requirements. **Note**: Changing this setting on a cluster will trigger a rolling restart as soon as the cluster is updated. The log redaction field is updated via an Atlas API call after cluster creation. Consequently, there may be a brief period during resource creation when log redaction is not yet enabled. To ensure complete log redaction from the outset, use `AdvancedCluster`.
        :param pulumi.Input[_builtins.int] replication_factor: Number of replica set members. Each member keeps a copy of your databases, providing high availability and data redundancy. The possible values are 3, 5, or 7. The default value is 3.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ClusterReplicationSpecArgs', 'ClusterReplicationSpecArgsDict']]]] replication_specs: Configuration for cluster regions.  See Replication Spec below for more details.
        :param pulumi.Input[_builtins.bool] retain_backups_enabled: - (Optional) Set to true to retain backup snapshots for the deleted cluster. This parameter applies to the Delete operation and only affects M10 and above clusters. If you encounter the `CANNOT_DELETE_SNAPSHOT_WITH_BACKUP_COMPLIANCE_POLICY` error code, see how to delete a cluster with Backup Compliance Policy.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ClusterSnapshotBackupPolicyArgs', 'ClusterSnapshotBackupPolicyArgsDict']]]] snapshot_backup_policies: current snapshot schedule and retention settings for the cluster.
        :param pulumi.Input[_builtins.str] srv_address: Connection string for connecting to the Atlas cluster. The +srv modifier forces the connection to use TLS/SSL. See the mongoURI for additional options.
        :param pulumi.Input[_builtins.str] state_name: Current state of the cluster. The possible states are:
               - IDLE
               - CREATING
               - UPDATING
               - DELETING
               - DELETED
               - REPAIRING
        :param pulumi.Input[Sequence[pulumi.Input[Union['ClusterTagArgs', 'ClusterTagArgsDict']]]] tags: Set that contains key-value pairs between 1 to 255 characters in length for tagging and categorizing the cluster. See below.
        :param pulumi.Input[_builtins.bool] termination_protection_enabled: Flag that indicates whether termination protection is enabled on the cluster. If set to true, MongoDB Cloud won't delete the cluster. If set to false, MongoDB Cloud will delete the cluster.
        :param pulumi.Input[_builtins.str] version_release_system: Release cadence that Atlas uses for this cluster. This parameter defaults to `LTS`. If you set this field to `CONTINUOUS`, you must omit the `mongo_db_major_version` field. Atlas accepts:
               - `CONTINUOUS`:  Atlas creates your cluster using the most recent MongoDB release. Atlas automatically updates your cluster to the latest major and rapid MongoDB releases as they become available.
               - `LTS`: Atlas creates your cluster using the latest patch release of the MongoDB version that you specify in the mongoDBMajorVersion field. Atlas automatically updates your cluster to subsequent patch releases of this MongoDB version. Atlas doesn't update your cluster to newer rapid or major MongoDB releases as they become available.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ClusterState.__new__(_ClusterState)

        __props__.__dict__["accept_data_risks_and_force_replica_set_reconfig"] = accept_data_risks_and_force_replica_set_reconfig
        __props__.__dict__["advanced_configuration"] = advanced_configuration
        __props__.__dict__["auto_scaling_compute_enabled"] = auto_scaling_compute_enabled
        __props__.__dict__["auto_scaling_compute_scale_down_enabled"] = auto_scaling_compute_scale_down_enabled
        __props__.__dict__["auto_scaling_disk_gb_enabled"] = auto_scaling_disk_gb_enabled
        __props__.__dict__["backing_provider_name"] = backing_provider_name
        __props__.__dict__["backup_enabled"] = backup_enabled
        __props__.__dict__["bi_connector_config"] = bi_connector_config
        __props__.__dict__["cloud_backup"] = cloud_backup
        __props__.__dict__["cluster_id"] = cluster_id
        __props__.__dict__["cluster_type"] = cluster_type
        __props__.__dict__["connection_strings"] = connection_strings
        __props__.__dict__["container_id"] = container_id
        __props__.__dict__["disk_size_gb"] = disk_size_gb
        __props__.__dict__["encryption_at_rest_provider"] = encryption_at_rest_provider
        __props__.__dict__["labels"] = labels
        __props__.__dict__["mongo_db_major_version"] = mongo_db_major_version
        __props__.__dict__["mongo_db_version"] = mongo_db_version
        __props__.__dict__["mongo_uri"] = mongo_uri
        __props__.__dict__["mongo_uri_updated"] = mongo_uri_updated
        __props__.__dict__["mongo_uri_with_options"] = mongo_uri_with_options
        __props__.__dict__["name"] = name
        __props__.__dict__["num_shards"] = num_shards
        __props__.__dict__["paused"] = paused
        __props__.__dict__["pinned_fcv"] = pinned_fcv
        __props__.__dict__["pit_enabled"] = pit_enabled
        __props__.__dict__["project_id"] = project_id
        __props__.__dict__["provider_auto_scaling_compute_max_instance_size"] = provider_auto_scaling_compute_max_instance_size
        __props__.__dict__["provider_auto_scaling_compute_min_instance_size"] = provider_auto_scaling_compute_min_instance_size
        __props__.__dict__["provider_disk_iops"] = provider_disk_iops
        __props__.__dict__["provider_disk_type_name"] = provider_disk_type_name
        __props__.__dict__["provider_encrypt_ebs_volume"] = provider_encrypt_ebs_volume
        __props__.__dict__["provider_encrypt_ebs_volume_flag"] = provider_encrypt_ebs_volume_flag
        __props__.__dict__["provider_instance_size_name"] = provider_instance_size_name
        __props__.__dict__["provider_name"] = provider_name
        __props__.__dict__["provider_region_name"] = provider_region_name
        __props__.__dict__["provider_volume_type"] = provider_volume_type
        __props__.__dict__["redact_client_log_data"] = redact_client_log_data
        __props__.__dict__["replication_factor"] = replication_factor
        __props__.__dict__["replication_specs"] = replication_specs
        __props__.__dict__["retain_backups_enabled"] = retain_backups_enabled
        __props__.__dict__["snapshot_backup_policies"] = snapshot_backup_policies
        __props__.__dict__["srv_address"] = srv_address
        __props__.__dict__["state_name"] = state_name
        __props__.__dict__["tags"] = tags
        __props__.__dict__["termination_protection_enabled"] = termination_protection_enabled
        __props__.__dict__["version_release_system"] = version_release_system
        return Cluster(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="acceptDataRisksAndForceReplicaSetReconfig")
    def accept_data_risks_and_force_replica_set_reconfig(self) -> pulumi.Output[_builtins.str]:
        """
        If reconfiguration is necessary to regain a primary due to a regional outage, submit this field alongside your topology reconfiguration to request a new regional outage resistant topology. Forced reconfigurations during an outage of the majority of electable nodes carry a risk of data loss if replicated writes (even majority committed writes) have not been replicated to the new primary node. MongoDB Atlas docs contain more information. To proceed with an operation which carries that risk, set `accept_data_risks_and_force_replica_set_reconfig` to the current date. Learn more about Reconfiguring a Replica Set during a regional outage [here](https://dochub.mongodb.org/core/regional-outage-reconfigure-replica-set).
        """
        return pulumi.get(self, "accept_data_risks_and_force_replica_set_reconfig")

    @_builtins.property
    @pulumi.getter(name="advancedConfiguration")
    def advanced_configuration(self) -> pulumi.Output['outputs.ClusterAdvancedConfiguration']:
        return pulumi.get(self, "advanced_configuration")

    @_builtins.property
    @pulumi.getter(name="autoScalingComputeEnabled")
    def auto_scaling_compute_enabled(self) -> pulumi.Output[_builtins.bool]:
        return pulumi.get(self, "auto_scaling_compute_enabled")

    @_builtins.property
    @pulumi.getter(name="autoScalingComputeScaleDownEnabled")
    def auto_scaling_compute_scale_down_enabled(self) -> pulumi.Output[_builtins.bool]:
        """
        Set to `true` to enable the cluster tier to scale down. This option is only available if `autoScaling.compute.enabled` is `true`.
        - If this option is enabled, you must specify a value for `providerSettings.autoScaling.compute.minInstanceSize`
        """
        return pulumi.get(self, "auto_scaling_compute_scale_down_enabled")

    @_builtins.property
    @pulumi.getter(name="autoScalingDiskGbEnabled")
    def auto_scaling_disk_gb_enabled(self) -> pulumi.Output[_builtins.bool]:
        return pulumi.get(self, "auto_scaling_disk_gb_enabled")

    @_builtins.property
    @pulumi.getter(name="backingProviderName")
    def backing_provider_name(self) -> pulumi.Output[_builtins.str]:
        """
        Cloud service provider on which the server for a multi-tenant cluster is provisioned.

        This setting is only valid when providerSetting.providerName is TENANT and providerSetting.instanceSizeName is M0.

        The possible values are:

        - AWS - Amazon AWS
        - GCP - Google Cloud Platform
        - AZURE - Microsoft Azure
        """
        return pulumi.get(self, "backing_provider_name")

    @_builtins.property
    @pulumi.getter(name="backupEnabled")
    def backup_enabled(self) -> pulumi.Output[_builtins.bool]:
        """
        Legacy Backup - Set to true to enable Atlas legacy backups for the cluster.
        **Important** - MongoDB deprecated the Legacy Backup feature. Clusters that use Legacy Backup can continue to use it. MongoDB recommends using [Cloud Backups](https://docs.atlas.mongodb.com/backup/cloud-backup/overview/).
        * New Atlas clusters of any type do not support this parameter. These clusters must use Cloud Backup, `cloud_backup`, to enable Cloud Backup.  If you create a new Atlas cluster and set `backup_enabled` to true, the Provider will respond with an error.  This change doesn’t affect existing clusters that use legacy backups.
        * Setting this value to false to disable legacy backups for the cluster will let Atlas delete any stored snapshots. In order to preserve the legacy backups snapshots, disable the legacy backups and enable the cloud backups in the single **pulumi up** action.
        ```
        backup_enabled = "false"
        cloud_backup = "true"
        ```
        * The default value is false. M10 and above only.
        """
        return pulumi.get(self, "backup_enabled")

    @_builtins.property
    @pulumi.getter(name="biConnectorConfig")
    def bi_connector_config(self) -> pulumi.Output['outputs.ClusterBiConnectorConfig']:
        """
        Specifies BI Connector for Atlas configuration on this cluster. BI Connector for Atlas is only available for M10+ clusters. See BI Connector below for more details.
        """
        return pulumi.get(self, "bi_connector_config")

    @_builtins.property
    @pulumi.getter(name="cloudBackup")
    def cloud_backup(self) -> pulumi.Output[_builtins.bool]:
        return pulumi.get(self, "cloud_backup")

    @_builtins.property
    @pulumi.getter(name="clusterId")
    def cluster_id(self) -> pulumi.Output[_builtins.str]:
        """
        The cluster ID.
        """
        return pulumi.get(self, "cluster_id")

    @_builtins.property
    @pulumi.getter(name="clusterType")
    def cluster_type(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the type of the cluster that you want to modify. You cannot convert a sharded cluster deployment to a replica set deployment.

        > **WHEN SHOULD YOU USE CLUSTERTYPE?**
        When you set replication_specs, when you are deploying Global Clusters or when you are deploying non-Global replica sets and sharded clusters.

        Accepted values include:
        - `REPLICASET` Replica set
        - `SHARDED` Sharded cluster
        - `GEOSHARDED` Global Cluster
        """
        return pulumi.get(self, "cluster_type")

    @_builtins.property
    @pulumi.getter(name="connectionStrings")
    def connection_strings(self) -> pulumi.Output[Sequence['outputs.ClusterConnectionString']]:
        """
        Set of connection strings that your applications use to connect to this cluster. More information in [Connection-strings](https://docs.mongodb.com/manual/reference/connection-string/). Use the parameters in this object to connect your applications to this cluster. To learn more about the formats of connection strings, see [Connection String Options](https://docs.atlas.mongodb.com/reference/faq/connection-changes/). NOTE: Atlas returns the contents of this object after the cluster is operational, not while it builds the cluster.
        """
        return pulumi.get(self, "connection_strings")

    @_builtins.property
    @pulumi.getter(name="containerId")
    def container_id(self) -> pulumi.Output[_builtins.str]:
        """
        The Container ID is the id of the container created when the first cluster in the region (AWS/Azure) or project (GCP) was created.
        """
        return pulumi.get(self, "container_id")

    @_builtins.property
    @pulumi.getter(name="diskSizeGb")
    def disk_size_gb(self) -> pulumi.Output[_builtins.float]:
        """
        Capacity, in gigabytes, of the host’s root volume. Increase this number to add capacity, up to a maximum possible value of 4096 (i.e., 4 TB). This value must be a positive integer.
        * The minimum disk size for dedicated clusters is 10GB for AWS and GCP. If you specify diskSizeGB with a lower disk size, Atlas defaults to the minimum disk size value.
        * Note: The maximum value for disk storage cannot exceed 50 times the maximum RAM for the selected cluster. If you require additional storage space beyond this limitation, consider upgrading your cluster to a higher tier.
        * Cannot be used with clusters with local NVMe SSDs
        * Cannot be used with Azure clusters
        """
        return pulumi.get(self, "disk_size_gb")

    @_builtins.property
    @pulumi.getter(name="encryptionAtRestProvider")
    def encryption_at_rest_provider(self) -> pulumi.Output[_builtins.str]:
        """
        Possible values are AWS, GCP, AZURE or NONE.  Only needed if you desire to manage the keys, see [Encryption at Rest using Customer Key Management](https://docs.atlas.mongodb.com/security-aws-kms/) for complete documentation.  You must configure encryption at rest for the Atlas project before enabling it on any cluster in the project. For complete documentation on configuring Encryption at Rest, see Encryption at Rest using Customer Key Management. Requires M10 or greater. and for legacy backups, backup_enabled, to be false or omitted. **Note: Atlas encrypts all cluster storage and snapshot volumes, securing all cluster data on disk: a concept known as encryption at rest, by default**.
        """
        return pulumi.get(self, "encryption_at_rest_provider")

    @_builtins.property
    @pulumi.getter
    def labels(self) -> pulumi.Output[Optional[Sequence['outputs.ClusterLabel']]]:
        """
        Set that contains key-value pairs between 1 to 255 characters in length for tagging and categorizing the cluster. See below. **DEPRECATED** Use `tags` instead.
        """
        return pulumi.get(self, "labels")

    @_builtins.property
    @pulumi.getter(name="mongoDbMajorVersion")
    def mongo_db_major_version(self) -> pulumi.Output[_builtins.str]:
        """
        Version of the cluster to deploy. Atlas supports all the MongoDB versions that have **not** reached [End of Live](https://www.mongodb.com/legal/support-policy/lifecycles) for M10+ clusters. If omitted, Atlas deploys the cluster with the default version. For more details, see [documentation](https://www.mongodb.com/docs/atlas/reference/faq/database/#which-versions-of-mongodb-do-service-clusters-use-). Atlas always deploys the cluster with the latest stable release of the specified version. See [Release Notes](https://www.mongodb.com/docs/upcoming/release-notes/) for latest Current Stable Release.
        """
        return pulumi.get(self, "mongo_db_major_version")

    @_builtins.property
    @pulumi.getter(name="mongoDbVersion")
    def mongo_db_version(self) -> pulumi.Output[_builtins.str]:
        """
        Version of MongoDB the cluster runs, in `major-version`.`minor-version` format.
        """
        return pulumi.get(self, "mongo_db_version")

    @_builtins.property
    @pulumi.getter(name="mongoUri")
    def mongo_uri(self) -> pulumi.Output[_builtins.str]:
        """
        Base connection string for the cluster. Atlas only displays this field after the cluster is operational, not while it builds the cluster.
        """
        return pulumi.get(self, "mongo_uri")

    @_builtins.property
    @pulumi.getter(name="mongoUriUpdated")
    def mongo_uri_updated(self) -> pulumi.Output[_builtins.str]:
        """
        Lists when the connection string was last updated. The connection string changes, for example, if you change a replica set to a sharded cluster.
        """
        return pulumi.get(self, "mongo_uri_updated")

    @_builtins.property
    @pulumi.getter(name="mongoUriWithOptions")
    def mongo_uri_with_options(self) -> pulumi.Output[_builtins.str]:
        """
        connection string for connecting to the Atlas cluster. Includes the replicaSet, ssl, and authSource query parameters in the connection string with values appropriate for the cluster.
        """
        return pulumi.get(self, "mongo_uri_with_options")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Name of the cluster as it appears in Atlas. Once the cluster is created, its name cannot be changed. **WARNING** Changing the name will result in destruction of the existing cluster and the creation of a new cluster.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="numShards")
    def num_shards(self) -> pulumi.Output[_builtins.int]:
        """
        Selects whether the cluster is a replica set or a sharded cluster. If you use the replicationSpecs parameter, you must set num_shards.
        """
        return pulumi.get(self, "num_shards")

    @_builtins.property
    @pulumi.getter
    def paused(self) -> pulumi.Output[_builtins.bool]:
        return pulumi.get(self, "paused")

    @_builtins.property
    @pulumi.getter(name="pinnedFcv")
    def pinned_fcv(self) -> pulumi.Output[Optional['outputs.ClusterPinnedFcv']]:
        """
        Pins the Feature Compatibility Version (FCV) to the current MongoDB version with a provided expiration date. To unpin the FCV the `pinned_fcv` attribute must be removed. This operation can take several minutes as the request processes through the MongoDB data plane. Once FCV is unpinned it will not be possible to downgrade the `mongo_db_major_version`. It is advised that updates to `pinned_fcv` are done isolated from other cluster changes. If a plan contains multiple changes, the FCV change will be applied first. If FCV is unpinned past the expiration date the `pinned_fcv` attribute must be removed. The following [knowledge hub article](https://kb.corp.mongodb.com/article/000021785/) and [FCV documentation](https://www.mongodb.com/docs/atlas/tutorial/major-version-change/#manage-feature-compatibility--fcv--during-upgrades) can be referenced for more details. See below.
        """
        return pulumi.get(self, "pinned_fcv")

    @_builtins.property
    @pulumi.getter(name="pitEnabled")
    def pit_enabled(self) -> pulumi.Output[_builtins.bool]:
        """
        Flag that indicates if the cluster uses Continuous Cloud Backup. If set to true, cloud_backup must also be set to true.
        """
        return pulumi.get(self, "pit_enabled")

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Output[_builtins.str]:
        """
        The unique ID for the project to create the cluster.
        """
        return pulumi.get(self, "project_id")

    @_builtins.property
    @pulumi.getter(name="providerAutoScalingComputeMaxInstanceSize")
    def provider_auto_scaling_compute_max_instance_size(self) -> pulumi.Output[_builtins.str]:
        """
        Maximum instance size to which your cluster can automatically scale (e.g., M40). Required if `autoScaling.compute.enabled` is `true`.
        """
        return pulumi.get(self, "provider_auto_scaling_compute_max_instance_size")

    @_builtins.property
    @pulumi.getter(name="providerAutoScalingComputeMinInstanceSize")
    def provider_auto_scaling_compute_min_instance_size(self) -> pulumi.Output[_builtins.str]:
        """
        Minimum instance size to which your cluster can automatically scale (e.g., M10). Required if `autoScaling.compute.scaleDownEnabled` is `true`.
        """
        return pulumi.get(self, "provider_auto_scaling_compute_min_instance_size")

    @_builtins.property
    @pulumi.getter(name="providerDiskIops")
    def provider_disk_iops(self) -> pulumi.Output[_builtins.int]:
        """
        The maximum input/output operations per second (IOPS) the system can perform. The possible values depend on the selected `provider_instance_size_name` and `disk_size_gb`.  This setting requires that `provider_instance_size_name` to be M30 or greater and cannot be used with clusters with local NVMe SSDs.  The default value for `provider_disk_iops` is the same as the cluster tier's Standard IOPS value, as viewable in the Atlas console.  It is used in cases where a higher number of IOPS is needed and possible.  If a value is submitted that is lower or equal to the default IOPS value for the cluster tier Atlas ignores the requested value and uses the default.  More details available under the providerSettings.diskIOPS parameter: [MongoDB API Clusters](https://docs.atlas.mongodb.com/reference/api/clusters-create-one/)
        * You do not need to configure IOPS for a STANDARD disk configuration but only for a PROVISIONED configuration.
        """
        return pulumi.get(self, "provider_disk_iops")

    @_builtins.property
    @pulumi.getter(name="providerDiskTypeName")
    def provider_disk_type_name(self) -> pulumi.Output[_builtins.str]:
        """
        Azure disk type of the server’s root volume. If omitted, Atlas uses the default disk type for the selected providerSettings.instanceSizeName.  Example disk types and associated storage sizes: P4 - 32GB, P6 - 64GB, P10 - 128GB, P15 - 256GB, P20 - 512GB, P30 - 1024GB, P40 - 2048GB, P50 - 4095GB.  More information and the most update to date disk types/storage sizes can be located at https://docs.atlas.mongodb.com/reference/api/clusters-create-one/.
        """
        return pulumi.get(self, "provider_disk_type_name")

    @_builtins.property
    @pulumi.getter(name="providerEncryptEbsVolume")
    @_utilities.deprecated("""All EBS volumes are encrypted by default, the option to disable encryption has been removed""")
    def provider_encrypt_ebs_volume(self) -> pulumi.Output[_builtins.bool]:
        """
        **(Deprecated) The Flag is always true.** Flag that indicates whether the Amazon EBS encryption feature encrypts the host's root volume for both data at rest within the volume and for data moving between the volume and the cluster. Note: This setting is always enabled for clusters with local NVMe SSDs. **Atlas encrypts all cluster storage and snapshot volumes, securing all cluster data on disk: a concept known as encryption at rest, by default.**.
        """
        return pulumi.get(self, "provider_encrypt_ebs_volume")

    @_builtins.property
    @pulumi.getter(name="providerEncryptEbsVolumeFlag")
    def provider_encrypt_ebs_volume_flag(self) -> pulumi.Output[_builtins.bool]:
        return pulumi.get(self, "provider_encrypt_ebs_volume_flag")

    @_builtins.property
    @pulumi.getter(name="providerInstanceSizeName")
    def provider_instance_size_name(self) -> pulumi.Output[_builtins.str]:
        """
        Atlas provides different instance sizes, each with a default storage capacity and RAM size. The instance size you select is used for all the data-bearing servers in your cluster. See [Create a Cluster](https://docs.atlas.mongodb.com/reference/api/clusters-create-one/) `providerSettings.instanceSizeName` for valid values and default resources.
        """
        return pulumi.get(self, "provider_instance_size_name")

    @_builtins.property
    @pulumi.getter(name="providerName")
    def provider_name(self) -> pulumi.Output[_builtins.str]:
        """
        Cloud service provider on which the servers are provisioned.

        The possible values are:

        - `AWS` - Amazon AWS
        - `GCP` - Google Cloud Platform
        - `AZURE` - Microsoft Azure
        - `TENANT` - A multi-tenant deployment on one of the supported cloud service providers. Only valid when providerSettings.instanceSizeName is M0.
        """
        return pulumi.get(self, "provider_name")

    @_builtins.property
    @pulumi.getter(name="providerRegionName")
    def provider_region_name(self) -> pulumi.Output[_builtins.str]:
        """
        Physical location of your MongoDB cluster. The region you choose can affect network latency for clients accessing your databases.  Requires the **Atlas region name**, see the reference list for [AWS](https://docs.atlas.mongodb.com/reference/amazon-aws/), [GCP](https://docs.atlas.mongodb.com/reference/google-gcp/), [Azure](https://docs.atlas.mongodb.com/reference/microsoft-azure/).
        Do not specify this field when creating a multi-region cluster using the replicationSpec document or a Global Cluster with the replicationSpecs array.
        """
        return pulumi.get(self, "provider_region_name")

    @_builtins.property
    @pulumi.getter(name="providerVolumeType")
    def provider_volume_type(self) -> pulumi.Output[_builtins.str]:
        """
        The type of the volume. The possible values are: `STANDARD` and `PROVISIONED`.  `PROVISIONED` is ONLY required if setting IOPS higher than the default instance IOPS.
        > **NOTE:** `STANDARD` is not available for NVME clusters.
        """
        return pulumi.get(self, "provider_volume_type")

    @_builtins.property
    @pulumi.getter(name="redactClientLogData")
    def redact_client_log_data(self) -> pulumi.Output[_builtins.bool]:
        """
        Flag that enables or disables log redaction, see the [manual](https://www.mongodb.com/docs/manual/administration/monitoring/#log-redaction) for more information. Use this in conjunction with Encryption at Rest and TLS/SSL (Transport Encryption) to assist compliance with regulatory requirements. **Note**: Changing this setting on a cluster will trigger a rolling restart as soon as the cluster is updated. The log redaction field is updated via an Atlas API call after cluster creation. Consequently, there may be a brief period during resource creation when log redaction is not yet enabled. To ensure complete log redaction from the outset, use `AdvancedCluster`.
        """
        return pulumi.get(self, "redact_client_log_data")

    @_builtins.property
    @pulumi.getter(name="replicationFactor")
    def replication_factor(self) -> pulumi.Output[_builtins.int]:
        """
        Number of replica set members. Each member keeps a copy of your databases, providing high availability and data redundancy. The possible values are 3, 5, or 7. The default value is 3.
        """
        return pulumi.get(self, "replication_factor")

    @_builtins.property
    @pulumi.getter(name="replicationSpecs")
    def replication_specs(self) -> pulumi.Output[Sequence['outputs.ClusterReplicationSpec']]:
        """
        Configuration for cluster regions.  See Replication Spec below for more details.
        """
        return pulumi.get(self, "replication_specs")

    @_builtins.property
    @pulumi.getter(name="retainBackupsEnabled")
    def retain_backups_enabled(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        - (Optional) Set to true to retain backup snapshots for the deleted cluster. This parameter applies to the Delete operation and only affects M10 and above clusters. If you encounter the `CANNOT_DELETE_SNAPSHOT_WITH_BACKUP_COMPLIANCE_POLICY` error code, see how to delete a cluster with Backup Compliance Policy.
        """
        return pulumi.get(self, "retain_backups_enabled")

    @_builtins.property
    @pulumi.getter(name="snapshotBackupPolicies")
    def snapshot_backup_policies(self) -> pulumi.Output[Sequence['outputs.ClusterSnapshotBackupPolicy']]:
        """
        current snapshot schedule and retention settings for the cluster.
        """
        return pulumi.get(self, "snapshot_backup_policies")

    @_builtins.property
    @pulumi.getter(name="srvAddress")
    def srv_address(self) -> pulumi.Output[_builtins.str]:
        """
        Connection string for connecting to the Atlas cluster. The +srv modifier forces the connection to use TLS/SSL. See the mongoURI for additional options.
        """
        return pulumi.get(self, "srv_address")

    @_builtins.property
    @pulumi.getter(name="stateName")
    def state_name(self) -> pulumi.Output[_builtins.str]:
        """
        Current state of the cluster. The possible states are:
        - IDLE
        - CREATING
        - UPDATING
        - DELETING
        - DELETED
        - REPAIRING
        """
        return pulumi.get(self, "state_name")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence['outputs.ClusterTag']]]:
        """
        Set that contains key-value pairs between 1 to 255 characters in length for tagging and categorizing the cluster. See below.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="terminationProtectionEnabled")
    def termination_protection_enabled(self) -> pulumi.Output[_builtins.bool]:
        """
        Flag that indicates whether termination protection is enabled on the cluster. If set to true, MongoDB Cloud won't delete the cluster. If set to false, MongoDB Cloud will delete the cluster.
        """
        return pulumi.get(self, "termination_protection_enabled")

    @_builtins.property
    @pulumi.getter(name="versionReleaseSystem")
    def version_release_system(self) -> pulumi.Output[_builtins.str]:
        """
        Release cadence that Atlas uses for this cluster. This parameter defaults to `LTS`. If you set this field to `CONTINUOUS`, you must omit the `mongo_db_major_version` field. Atlas accepts:
        - `CONTINUOUS`:  Atlas creates your cluster using the most recent MongoDB release. Atlas automatically updates your cluster to the latest major and rapid MongoDB releases as they become available.
        - `LTS`: Atlas creates your cluster using the latest patch release of the MongoDB version that you specify in the mongoDBMajorVersion field. Atlas automatically updates your cluster to subsequent patch releases of this MongoDB version. Atlas doesn't update your cluster to newer rapid or major MongoDB releases as they become available.
        """
        return pulumi.get(self, "version_release_system")

