# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs

__all__ = [
    'GetSearchIndexesResult',
    'AwaitableGetSearchIndexesResult',
    'get_search_indexes',
    'get_search_indexes_output',
]

@pulumi.output_type
class GetSearchIndexesResult:
    """
    A collection of values returned by getSearchIndexes.
    """
    def __init__(__self__, cluster_name=None, collection_name=None, database=None, id=None, project_id=None, results=None, total_count=None):
        if cluster_name and not isinstance(cluster_name, str):
            raise TypeError("Expected argument 'cluster_name' to be a str")
        pulumi.set(__self__, "cluster_name", cluster_name)
        if collection_name and not isinstance(collection_name, str):
            raise TypeError("Expected argument 'collection_name' to be a str")
        pulumi.set(__self__, "collection_name", collection_name)
        if database and not isinstance(database, str):
            raise TypeError("Expected argument 'database' to be a str")
        pulumi.set(__self__, "database", database)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if project_id and not isinstance(project_id, str):
            raise TypeError("Expected argument 'project_id' to be a str")
        pulumi.set(__self__, "project_id", project_id)
        if results and not isinstance(results, list):
            raise TypeError("Expected argument 'results' to be a list")
        pulumi.set(__self__, "results", results)
        if total_count and not isinstance(total_count, int):
            raise TypeError("Expected argument 'total_count' to be a int")
        pulumi.set(__self__, "total_count", total_count)

    @_builtins.property
    @pulumi.getter(name="clusterName")
    def cluster_name(self) -> _builtins.str:
        return pulumi.get(self, "cluster_name")

    @_builtins.property
    @pulumi.getter(name="collectionName")
    def collection_name(self) -> _builtins.str:
        """
        (Required) Name of the collection the index is on.
        """
        return pulumi.get(self, "collection_name")

    @_builtins.property
    @pulumi.getter
    def database(self) -> _builtins.str:
        """
        (Required) Name of the database the collection is in.
        """
        return pulumi.get(self, "database")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> _builtins.str:
        return pulumi.get(self, "project_id")

    @_builtins.property
    @pulumi.getter
    def results(self) -> Sequence['outputs.GetSearchIndexesResultResult']:
        """
        A list where each represents a search index.
        """
        return pulumi.get(self, "results")

    @_builtins.property
    @pulumi.getter(name="totalCount")
    def total_count(self) -> _builtins.int:
        """
        Represents the total of the search indexes
        """
        return pulumi.get(self, "total_count")


class AwaitableGetSearchIndexesResult(GetSearchIndexesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetSearchIndexesResult(
            cluster_name=self.cluster_name,
            collection_name=self.collection_name,
            database=self.database,
            id=self.id,
            project_id=self.project_id,
            results=self.results,
            total_count=self.total_count)


def get_search_indexes(cluster_name: Optional[_builtins.str] = None,
                       collection_name: Optional[_builtins.str] = None,
                       database: Optional[_builtins.str] = None,
                       project_id: Optional[_builtins.str] = None,
                       opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetSearchIndexesResult:
    """
    ## # Data Source: get_search_indexes

    `get_search_indexes` describes all search indexes. This represents search indexes that have been created.

    > **NOTE:** Groups and projects are synonymous terms. You may find `groupId` in the official documentation.


    :param _builtins.str cluster_name: Name of the cluster containing the collection with one or more Atlas Search indexes.
    :param _builtins.str collection_name: Name of the collection with one or more Atlas Search indexes.
    :param _builtins.str database: (Required) Name of the database the collection is in.
    :param _builtins.str project_id: Unique identifier for the [project](https://docs.atlas.mongodb.com/organizations-projects/#std-label-projects) that contains the specified cluster.
    """
    __args__ = dict()
    __args__['clusterName'] = cluster_name
    __args__['collectionName'] = collection_name
    __args__['database'] = database
    __args__['projectId'] = project_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('mongodbatlas:index/getSearchIndexes:getSearchIndexes', __args__, opts=opts, typ=GetSearchIndexesResult).value

    return AwaitableGetSearchIndexesResult(
        cluster_name=pulumi.get(__ret__, 'cluster_name'),
        collection_name=pulumi.get(__ret__, 'collection_name'),
        database=pulumi.get(__ret__, 'database'),
        id=pulumi.get(__ret__, 'id'),
        project_id=pulumi.get(__ret__, 'project_id'),
        results=pulumi.get(__ret__, 'results'),
        total_count=pulumi.get(__ret__, 'total_count'))
def get_search_indexes_output(cluster_name: Optional[pulumi.Input[_builtins.str]] = None,
                              collection_name: Optional[pulumi.Input[_builtins.str]] = None,
                              database: Optional[pulumi.Input[_builtins.str]] = None,
                              project_id: Optional[pulumi.Input[_builtins.str]] = None,
                              opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetSearchIndexesResult]:
    """
    ## # Data Source: get_search_indexes

    `get_search_indexes` describes all search indexes. This represents search indexes that have been created.

    > **NOTE:** Groups and projects are synonymous terms. You may find `groupId` in the official documentation.


    :param _builtins.str cluster_name: Name of the cluster containing the collection with one or more Atlas Search indexes.
    :param _builtins.str collection_name: Name of the collection with one or more Atlas Search indexes.
    :param _builtins.str database: (Required) Name of the database the collection is in.
    :param _builtins.str project_id: Unique identifier for the [project](https://docs.atlas.mongodb.com/organizations-projects/#std-label-projects) that contains the specified cluster.
    """
    __args__ = dict()
    __args__['clusterName'] = cluster_name
    __args__['collectionName'] = collection_name
    __args__['database'] = database
    __args__['projectId'] = project_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('mongodbatlas:index/getSearchIndexes:getSearchIndexes', __args__, opts=opts, typ=GetSearchIndexesResult)
    return __ret__.apply(lambda __response__: GetSearchIndexesResult(
        cluster_name=pulumi.get(__response__, 'cluster_name'),
        collection_name=pulumi.get(__response__, 'collection_name'),
        database=pulumi.get(__response__, 'database'),
        id=pulumi.get(__response__, 'id'),
        project_id=pulumi.get(__response__, 'project_id'),
        results=pulumi.get(__response__, 'results'),
        total_count=pulumi.get(__response__, 'total_count')))
