# This file was auto-generated by Fern from our API Definition.

# isort: skip_file

import typing
from importlib import import_module

if typing.TYPE_CHECKING:
    from .types import (
        After,
        Ascending,
        Before,
        Count,
        ErrorName,
        ErrorResponse,
        Labels,
        Limit,
        OrganizationId,
        PageToken,
        ValidationErrorResponse,
    )
    from .errors import IsTakenError, NotFoundError, ValidationError
    from . import (
        api_keys,
        attachments,
        domains,
        drafts,
        events,
        inboxes,
        messages,
        metrics,
        pods,
        threads,
        webhooks,
        websockets,
    )
    from .api_keys import (
        ApiKey,
        ApiKeyId,
        CreateApiKeyRequest,
        CreateApiKeyResponse,
        CreatedAt,
        ListApiKeysResponse,
        Name,
        Prefix,
    )
    from .attachments import (
        Attachment,
        AttachmentContent,
        AttachmentContentType,
        AttachmentFilename,
        AttachmentId,
        AttachmentInline,
        AttachmentSize,
        SendAttachment,
    )
    from .client import AgentMail, AsyncAgentMail
    from .domains import (
        ClientId,
        CreateDomainRequest,
        Domain,
        DomainId,
        DomainName,
        DomainSummary,
        FeedbackEnabled,
        ListDomainsResponse,
        RecordStatus,
        RecordType,
        VerificationRecord,
        VerificationStatus,
    )
    from .drafts import (
        CreateDraftRequest,
        Draft,
        DraftAttachments,
        DraftBcc,
        DraftCc,
        DraftClientId,
        DraftHtml,
        DraftId,
        DraftInReplyTo,
        DraftItem,
        DraftLabels,
        DraftPreview,
        DraftReplyTo,
        DraftSendAt,
        DraftSendStatus,
        DraftSubject,
        DraftText,
        DraftTo,
        DraftUpdatedAt,
        ListDraftsResponse,
        UpdateDraftRequest,
    )
    from .environment import AgentMailEnvironment
    from .events import (
        Bounce,
        Complaint,
        Delivery,
        EventId,
        MessageBouncedEvent,
        MessageComplainedEvent,
        MessageDeliveredEvent,
        MessageReceivedEvent,
        MessageRejectedEvent,
        MessageSentEvent,
        Recipient,
        Reject,
        Send,
        Timestamp,
    )
    from .messages import (
        Addresses,
        ListMessagesResponse,
        Message,
        MessageAttachments,
        MessageBcc,
        MessageCc,
        MessageCreatedAt,
        MessageFrom,
        MessageHtml,
        MessageId,
        MessageInReplyTo,
        MessageItem,
        MessageLabels,
        MessagePreview,
        MessageReferences,
        MessageRejectedError,
        MessageReplyTo,
        MessageSize,
        MessageSubject,
        MessageText,
        MessageTimestamp,
        MessageTo,
        MessageUpdatedAt,
        ReplyToMessageRequest,
        SendMessageAttachments,
        SendMessageBcc,
        SendMessageCc,
        SendMessageReplyTo,
        SendMessageRequest,
        SendMessageResponse,
        SendMessageTo,
        UpdateMessageRequest,
    )
    from .metrics import (
        ListMetricsResponse,
        MessageMetrics,
        MetricEndTimestamp,
        MetricEventType,
        MetricEventTypes,
        MetricStartTimestamp,
        MetricTimestamp,
    )
    from .threads import (
        ListThreadsResponse,
        Thread,
        ThreadAttachments,
        ThreadCreatedAt,
        ThreadId,
        ThreadItem,
        ThreadLabels,
        ThreadLastMessageId,
        ThreadMessageCount,
        ThreadPreview,
        ThreadReceivedTimestamp,
        ThreadRecipients,
        ThreadSenders,
        ThreadSentTimestamp,
        ThreadSize,
        ThreadSubject,
        ThreadTimestamp,
        ThreadUpdatedAt,
    )
    from .version import __version__
    from .websockets import Subscribe, Subscribed
_dynamic_imports: typing.Dict[str, str] = {
    "Addresses": ".messages",
    "After": ".types",
    "AgentMail": ".client",
    "AgentMailEnvironment": ".environment",
    "ApiKey": ".api_keys",
    "ApiKeyId": ".api_keys",
    "Ascending": ".types",
    "AsyncAgentMail": ".client",
    "Attachment": ".attachments",
    "AttachmentContent": ".attachments",
    "AttachmentContentType": ".attachments",
    "AttachmentFilename": ".attachments",
    "AttachmentId": ".attachments",
    "AttachmentInline": ".attachments",
    "AttachmentSize": ".attachments",
    "Before": ".types",
    "Bounce": ".events",
    "ClientId": ".domains",
    "Complaint": ".events",
    "Count": ".types",
    "CreateApiKeyRequest": ".api_keys",
    "CreateApiKeyResponse": ".api_keys",
    "CreateDomainRequest": ".domains",
    "CreateDraftRequest": ".drafts",
    "CreatedAt": ".api_keys",
    "Delivery": ".events",
    "Domain": ".domains",
    "DomainId": ".domains",
    "DomainName": ".domains",
    "DomainSummary": ".domains",
    "Draft": ".drafts",
    "DraftAttachments": ".drafts",
    "DraftBcc": ".drafts",
    "DraftCc": ".drafts",
    "DraftClientId": ".drafts",
    "DraftHtml": ".drafts",
    "DraftId": ".drafts",
    "DraftInReplyTo": ".drafts",
    "DraftItem": ".drafts",
    "DraftLabels": ".drafts",
    "DraftPreview": ".drafts",
    "DraftReplyTo": ".drafts",
    "DraftSendAt": ".drafts",
    "DraftSendStatus": ".drafts",
    "DraftSubject": ".drafts",
    "DraftText": ".drafts",
    "DraftTo": ".drafts",
    "DraftUpdatedAt": ".drafts",
    "ErrorName": ".types",
    "ErrorResponse": ".types",
    "EventId": ".events",
    "FeedbackEnabled": ".domains",
    "IsTakenError": ".errors",
    "Labels": ".types",
    "Limit": ".types",
    "ListApiKeysResponse": ".api_keys",
    "ListDomainsResponse": ".domains",
    "ListDraftsResponse": ".drafts",
    "ListMessagesResponse": ".messages",
    "ListMetricsResponse": ".metrics",
    "ListThreadsResponse": ".threads",
    "Message": ".messages",
    "MessageAttachments": ".messages",
    "MessageBcc": ".messages",
    "MessageBouncedEvent": ".events",
    "MessageCc": ".messages",
    "MessageComplainedEvent": ".events",
    "MessageCreatedAt": ".messages",
    "MessageDeliveredEvent": ".events",
    "MessageFrom": ".messages",
    "MessageHtml": ".messages",
    "MessageId": ".messages",
    "MessageInReplyTo": ".messages",
    "MessageItem": ".messages",
    "MessageLabels": ".messages",
    "MessageMetrics": ".metrics",
    "MessagePreview": ".messages",
    "MessageReceivedEvent": ".events",
    "MessageReferences": ".messages",
    "MessageRejectedError": ".messages",
    "MessageRejectedEvent": ".events",
    "MessageReplyTo": ".messages",
    "MessageSentEvent": ".events",
    "MessageSize": ".messages",
    "MessageSubject": ".messages",
    "MessageText": ".messages",
    "MessageTimestamp": ".messages",
    "MessageTo": ".messages",
    "MessageUpdatedAt": ".messages",
    "MetricEndTimestamp": ".metrics",
    "MetricEventType": ".metrics",
    "MetricEventTypes": ".metrics",
    "MetricStartTimestamp": ".metrics",
    "MetricTimestamp": ".metrics",
    "Name": ".api_keys",
    "NotFoundError": ".errors",
    "OrganizationId": ".types",
    "PageToken": ".types",
    "Prefix": ".api_keys",
    "Recipient": ".events",
    "RecordStatus": ".domains",
    "RecordType": ".domains",
    "Reject": ".events",
    "ReplyToMessageRequest": ".messages",
    "Send": ".events",
    "SendAttachment": ".attachments",
    "SendMessageAttachments": ".messages",
    "SendMessageBcc": ".messages",
    "SendMessageCc": ".messages",
    "SendMessageReplyTo": ".messages",
    "SendMessageRequest": ".messages",
    "SendMessageResponse": ".messages",
    "SendMessageTo": ".messages",
    "Subscribe": ".websockets",
    "Subscribed": ".websockets",
    "Thread": ".threads",
    "ThreadAttachments": ".threads",
    "ThreadCreatedAt": ".threads",
    "ThreadId": ".threads",
    "ThreadItem": ".threads",
    "ThreadLabels": ".threads",
    "ThreadLastMessageId": ".threads",
    "ThreadMessageCount": ".threads",
    "ThreadPreview": ".threads",
    "ThreadReceivedTimestamp": ".threads",
    "ThreadRecipients": ".threads",
    "ThreadSenders": ".threads",
    "ThreadSentTimestamp": ".threads",
    "ThreadSize": ".threads",
    "ThreadSubject": ".threads",
    "ThreadTimestamp": ".threads",
    "ThreadUpdatedAt": ".threads",
    "Timestamp": ".events",
    "UpdateDraftRequest": ".drafts",
    "UpdateMessageRequest": ".messages",
    "ValidationError": ".errors",
    "ValidationErrorResponse": ".types",
    "VerificationRecord": ".domains",
    "VerificationStatus": ".domains",
    "__version__": ".version",
    "api_keys": ".api_keys",
    "attachments": ".attachments",
    "domains": ".domains",
    "drafts": ".drafts",
    "events": ".events",
    "inboxes": ".inboxes",
    "messages": ".messages",
    "metrics": ".metrics",
    "pods": ".pods",
    "threads": ".threads",
    "webhooks": ".webhooks",
    "websockets": ".websockets",
}


def __getattr__(attr_name: str) -> typing.Any:
    module_name = _dynamic_imports.get(attr_name)
    if module_name is None:
        raise AttributeError(f"No {attr_name} found in _dynamic_imports for module name -> {__name__}")
    try:
        module = import_module(module_name, __package__)
        if module_name == f".{attr_name}":
            return module
        else:
            return getattr(module, attr_name)
    except ImportError as e:
        raise ImportError(f"Failed to import {attr_name} from {module_name}: {e}") from e
    except AttributeError as e:
        raise AttributeError(f"Failed to get {attr_name} from {module_name}: {e}") from e


def __dir__():
    lazy_attrs = list(_dynamic_imports.keys())
    return sorted(lazy_attrs)


__all__ = [
    "Addresses",
    "After",
    "AgentMail",
    "AgentMailEnvironment",
    "ApiKey",
    "ApiKeyId",
    "Ascending",
    "AsyncAgentMail",
    "Attachment",
    "AttachmentContent",
    "AttachmentContentType",
    "AttachmentFilename",
    "AttachmentId",
    "AttachmentInline",
    "AttachmentSize",
    "Before",
    "Bounce",
    "ClientId",
    "Complaint",
    "Count",
    "CreateApiKeyRequest",
    "CreateApiKeyResponse",
    "CreateDomainRequest",
    "CreateDraftRequest",
    "CreatedAt",
    "Delivery",
    "Domain",
    "DomainId",
    "DomainName",
    "DomainSummary",
    "Draft",
    "DraftAttachments",
    "DraftBcc",
    "DraftCc",
    "DraftClientId",
    "DraftHtml",
    "DraftId",
    "DraftInReplyTo",
    "DraftItem",
    "DraftLabels",
    "DraftPreview",
    "DraftReplyTo",
    "DraftSendAt",
    "DraftSendStatus",
    "DraftSubject",
    "DraftText",
    "DraftTo",
    "DraftUpdatedAt",
    "ErrorName",
    "ErrorResponse",
    "EventId",
    "FeedbackEnabled",
    "IsTakenError",
    "Labels",
    "Limit",
    "ListApiKeysResponse",
    "ListDomainsResponse",
    "ListDraftsResponse",
    "ListMessagesResponse",
    "ListMetricsResponse",
    "ListThreadsResponse",
    "Message",
    "MessageAttachments",
    "MessageBcc",
    "MessageBouncedEvent",
    "MessageCc",
    "MessageComplainedEvent",
    "MessageCreatedAt",
    "MessageDeliveredEvent",
    "MessageFrom",
    "MessageHtml",
    "MessageId",
    "MessageInReplyTo",
    "MessageItem",
    "MessageLabels",
    "MessageMetrics",
    "MessagePreview",
    "MessageReceivedEvent",
    "MessageReferences",
    "MessageRejectedError",
    "MessageRejectedEvent",
    "MessageReplyTo",
    "MessageSentEvent",
    "MessageSize",
    "MessageSubject",
    "MessageText",
    "MessageTimestamp",
    "MessageTo",
    "MessageUpdatedAt",
    "MetricEndTimestamp",
    "MetricEventType",
    "MetricEventTypes",
    "MetricStartTimestamp",
    "MetricTimestamp",
    "Name",
    "NotFoundError",
    "OrganizationId",
    "PageToken",
    "Prefix",
    "Recipient",
    "RecordStatus",
    "RecordType",
    "Reject",
    "ReplyToMessageRequest",
    "Send",
    "SendAttachment",
    "SendMessageAttachments",
    "SendMessageBcc",
    "SendMessageCc",
    "SendMessageReplyTo",
    "SendMessageRequest",
    "SendMessageResponse",
    "SendMessageTo",
    "Subscribe",
    "Subscribed",
    "Thread",
    "ThreadAttachments",
    "ThreadCreatedAt",
    "ThreadId",
    "ThreadItem",
    "ThreadLabels",
    "ThreadLastMessageId",
    "ThreadMessageCount",
    "ThreadPreview",
    "ThreadReceivedTimestamp",
    "ThreadRecipients",
    "ThreadSenders",
    "ThreadSentTimestamp",
    "ThreadSize",
    "ThreadSubject",
    "ThreadTimestamp",
    "ThreadUpdatedAt",
    "Timestamp",
    "UpdateDraftRequest",
    "UpdateMessageRequest",
    "ValidationError",
    "ValidationErrorResponse",
    "VerificationRecord",
    "VerificationStatus",
    "__version__",
    "api_keys",
    "attachments",
    "domains",
    "drafts",
    "events",
    "inboxes",
    "messages",
    "metrics",
    "pods",
    "threads",
    "webhooks",
    "websockets",
]
