# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

import pydantic
from ...core.pydantic_utilities import IS_PYDANTIC_V2
from ...core.unchecked_base_model import UncheckedBaseModel
from .api_key_id import ApiKeyId
from .created_at import CreatedAt
from .name import Name
from .prefix import Prefix


class ApiKey(UncheckedBaseModel):
    api_key_id: ApiKeyId
    prefix: Prefix
    name: Name
    used_at: typing.Optional[dt.datetime] = pydantic.Field(default=None)
    """
    Time at which api key was last used.
    """

    created_at: CreatedAt

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
