# This file was auto-generated by Fern from our API Definition.

import typing

from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ..core.pagination import AsyncPager, SyncPager
from ..core.request_options import RequestOptions
from ..types.limit import Limit
from ..types.page_token import PageToken
from .raw_client import AsyncRawDomainsClient, RawDomainsClient
from .types.domain import Domain
from .types.domain_id import DomainId
from .types.domain_name import DomainName
from .types.domain_summary import DomainSummary
from .types.feedback_enabled import FeedbackEnabled

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class DomainsClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawDomainsClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawDomainsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawDomainsClient
        """
        return self._raw_client

    def list(
        self,
        *,
        limit: typing.Optional[Limit] = None,
        page_token: typing.Optional[PageToken] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> SyncPager[DomainSummary]:
        """
        Parameters
        ----------
        limit : typing.Optional[Limit]

        page_token : typing.Optional[PageToken]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        SyncPager[DomainSummary]

        Examples
        --------
        from agentmail import AgentMail

        client = AgentMail(
            api_key="YOUR_API_KEY",
        )
        response = client.domains.list()
        for item in response:
            yield item
        # alternatively, you can paginate page-by-page
        for page in response.iter_pages():
            yield page
        """
        return self._raw_client.list(limit=limit, page_token=page_token, request_options=request_options)

    def get(self, domain_id: DomainId, *, request_options: typing.Optional[RequestOptions] = None) -> Domain:
        """
        Parameters
        ----------
        domain_id : DomainId

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Domain

        Examples
        --------
        from agentmail import AgentMail

        client = AgentMail(
            api_key="YOUR_API_KEY",
        )
        client.domains.get(
            domain_id="domain_id",
        )
        """
        _response = self._raw_client.get(domain_id, request_options=request_options)
        return _response.data

    def get_zone_file(
        self, domain_id: DomainId, *, request_options: typing.Optional[RequestOptions] = None
    ) -> typing.Iterator[bytes]:
        """
        Parameters
        ----------
        domain_id : DomainId

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration. You can pass in configuration such as `chunk_size`, and more to customize the request and response.

        Returns
        -------
        typing.Iterator[bytes]

        Examples
        --------
        from agentmail import AgentMail

        client = AgentMail(
            api_key="YOUR_API_KEY",
        )
        client.domains.get_zone_file(
            domain_id="domain_id",
        )
        """
        with self._raw_client.get_zone_file(domain_id, request_options=request_options) as r:
            yield from r.data

    def create(
        self,
        *,
        domain: DomainName,
        feedback_enabled: FeedbackEnabled,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> Domain:
        """
        Parameters
        ----------
        domain : DomainName

        feedback_enabled : FeedbackEnabled

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Domain

        Examples
        --------
        from agentmail import AgentMail

        client = AgentMail(
            api_key="YOUR_API_KEY",
        )
        client.domains.create(
            domain="domain",
            feedback_enabled=True,
        )
        """
        _response = self._raw_client.create(
            domain=domain, feedback_enabled=feedback_enabled, request_options=request_options
        )
        return _response.data

    def delete(self, domain_id: DomainId, *, request_options: typing.Optional[RequestOptions] = None) -> None:
        """
        Parameters
        ----------
        domain_id : DomainId

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        from agentmail import AgentMail

        client = AgentMail(
            api_key="YOUR_API_KEY",
        )
        client.domains.delete(
            domain_id="domain_id",
        )
        """
        _response = self._raw_client.delete(domain_id, request_options=request_options)
        return _response.data

    def verify(self, domain_id: DomainId, *, request_options: typing.Optional[RequestOptions] = None) -> None:
        """
        Parameters
        ----------
        domain_id : DomainId

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        from agentmail import AgentMail

        client = AgentMail(
            api_key="YOUR_API_KEY",
        )
        client.domains.verify(
            domain_id="domain_id",
        )
        """
        _response = self._raw_client.verify(domain_id, request_options=request_options)
        return _response.data


class AsyncDomainsClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawDomainsClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawDomainsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawDomainsClient
        """
        return self._raw_client

    async def list(
        self,
        *,
        limit: typing.Optional[Limit] = None,
        page_token: typing.Optional[PageToken] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncPager[DomainSummary]:
        """
        Parameters
        ----------
        limit : typing.Optional[Limit]

        page_token : typing.Optional[PageToken]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncPager[DomainSummary]

        Examples
        --------
        import asyncio

        from agentmail import AsyncAgentMail

        client = AsyncAgentMail(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            response = await client.domains.list()
            async for item in response:
                yield item

            # alternatively, you can paginate page-by-page
            async for page in response.iter_pages():
                yield page


        asyncio.run(main())
        """
        return await self._raw_client.list(limit=limit, page_token=page_token, request_options=request_options)

    async def get(self, domain_id: DomainId, *, request_options: typing.Optional[RequestOptions] = None) -> Domain:
        """
        Parameters
        ----------
        domain_id : DomainId

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Domain

        Examples
        --------
        import asyncio

        from agentmail import AsyncAgentMail

        client = AsyncAgentMail(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.domains.get(
                domain_id="domain_id",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.get(domain_id, request_options=request_options)
        return _response.data

    async def get_zone_file(
        self, domain_id: DomainId, *, request_options: typing.Optional[RequestOptions] = None
    ) -> typing.AsyncIterator[bytes]:
        """
        Parameters
        ----------
        domain_id : DomainId

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration. You can pass in configuration such as `chunk_size`, and more to customize the request and response.

        Returns
        -------
        typing.AsyncIterator[bytes]

        Examples
        --------
        import asyncio

        from agentmail import AsyncAgentMail

        client = AsyncAgentMail(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.domains.get_zone_file(
                domain_id="domain_id",
            )


        asyncio.run(main())
        """
        async with self._raw_client.get_zone_file(domain_id, request_options=request_options) as r:
            async for _chunk in r.data:
                yield _chunk

    async def create(
        self,
        *,
        domain: DomainName,
        feedback_enabled: FeedbackEnabled,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> Domain:
        """
        Parameters
        ----------
        domain : DomainName

        feedback_enabled : FeedbackEnabled

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Domain

        Examples
        --------
        import asyncio

        from agentmail import AsyncAgentMail

        client = AsyncAgentMail(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.domains.create(
                domain="domain",
                feedback_enabled=True,
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.create(
            domain=domain, feedback_enabled=feedback_enabled, request_options=request_options
        )
        return _response.data

    async def delete(self, domain_id: DomainId, *, request_options: typing.Optional[RequestOptions] = None) -> None:
        """
        Parameters
        ----------
        domain_id : DomainId

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        import asyncio

        from agentmail import AsyncAgentMail

        client = AsyncAgentMail(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.domains.delete(
                domain_id="domain_id",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.delete(domain_id, request_options=request_options)
        return _response.data

    async def verify(self, domain_id: DomainId, *, request_options: typing.Optional[RequestOptions] = None) -> None:
        """
        Parameters
        ----------
        domain_id : DomainId

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        import asyncio

        from agentmail import AsyncAgentMail

        client = AsyncAgentMail(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.domains.verify(
                domain_id="domain_id",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.verify(domain_id, request_options=request_options)
        return _response.data
