# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

import pydantic
from ...core.pydantic_utilities import IS_PYDANTIC_V2
from ...core.unchecked_base_model import UncheckedBaseModel
from .client_id import ClientId
from .domain_id import DomainId
from .feedback_enabled import FeedbackEnabled
from .verification_record import VerificationRecord
from .verification_status import VerificationStatus


class Domain(UncheckedBaseModel):
    domain_id: DomainId
    status: VerificationStatus = pydantic.Field()
    """
    The verification status of the domain.
    """

    feedback_enabled: FeedbackEnabled
    records: typing.List[VerificationRecord] = pydantic.Field()
    """
    A list of DNS records required to verify the domain.
    """

    client_id: typing.Optional[ClientId] = None
    updated_at: dt.datetime = pydantic.Field()
    """
    Time at which the domain was last updated.
    """

    created_at: dt.datetime = pydantic.Field()
    """
    Time at which the domain was created.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
