# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ...core.pydantic_utilities import IS_PYDANTIC_V2
from ...core.unchecked_base_model import UncheckedBaseModel
from ...inboxes.types.inbox_id import InboxId
from ...messages.types.message_id import MessageId
from ...threads.types.thread_id import ThreadId
from .recipient import Recipient
from .timestamp import Timestamp


class Bounce(UncheckedBaseModel):
    inbox_id: InboxId
    thread_id: ThreadId
    message_id: MessageId
    timestamp: Timestamp
    type: str = pydantic.Field()
    """
    Bounce type.
    """

    sub_type: str = pydantic.Field()
    """
    Bounce sub-type.
    """

    recipients: typing.List[Recipient] = pydantic.Field()
    """
    Bounced recipients.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
