# This file was auto-generated by Fern from our API Definition.

from __future__ import annotations

import typing

from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ..core.pagination import AsyncPager, SyncPager
from ..core.request_options import RequestOptions
from ..types.limit import Limit
from ..types.page_token import PageToken
from .raw_client import AsyncRawInboxesClient, RawInboxesClient
from .types.client_id import ClientId
from .types.display_name import DisplayName
from .types.inbox import Inbox
from .types.inbox_id import InboxId

if typing.TYPE_CHECKING:
    from .drafts.client import AsyncDraftsClient, DraftsClient
    from .messages.client import AsyncMessagesClient, MessagesClient
    from .metrics.client import AsyncMetricsClient, MetricsClient
    from .threads.client import AsyncThreadsClient, ThreadsClient
# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class InboxesClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawInboxesClient(client_wrapper=client_wrapper)
        self._client_wrapper = client_wrapper
        self._threads: typing.Optional[ThreadsClient] = None
        self._messages: typing.Optional[MessagesClient] = None
        self._drafts: typing.Optional[DraftsClient] = None
        self._metrics: typing.Optional[MetricsClient] = None

    @property
    def with_raw_response(self) -> RawInboxesClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawInboxesClient
        """
        return self._raw_client

    def list(
        self,
        *,
        limit: typing.Optional[Limit] = None,
        page_token: typing.Optional[PageToken] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> SyncPager[Inbox]:
        """
        Parameters
        ----------
        limit : typing.Optional[Limit]

        page_token : typing.Optional[PageToken]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        SyncPager[Inbox]

        Examples
        --------
        from agentmail import AgentMail

        client = AgentMail(
            api_key="YOUR_API_KEY",
        )
        response = client.inboxes.list()
        for item in response:
            yield item
        # alternatively, you can paginate page-by-page
        for page in response.iter_pages():
            yield page
        """
        return self._raw_client.list(limit=limit, page_token=page_token, request_options=request_options)

    def get(self, inbox_id: InboxId, *, request_options: typing.Optional[RequestOptions] = None) -> Inbox:
        """
        Parameters
        ----------
        inbox_id : InboxId

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Inbox

        Examples
        --------
        from agentmail import AgentMail

        client = AgentMail(
            api_key="YOUR_API_KEY",
        )
        client.inboxes.get(
            inbox_id="inbox_id",
        )
        """
        _response = self._raw_client.get(inbox_id, request_options=request_options)
        return _response.data

    def create(
        self,
        *,
        username: typing.Optional[str] = OMIT,
        domain: typing.Optional[str] = OMIT,
        display_name: typing.Optional[DisplayName] = OMIT,
        client_id: typing.Optional[ClientId] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> Inbox:
        """
        Parameters
        ----------
        username : typing.Optional[str]
            Username of address. Randomly generated if not specified.

        domain : typing.Optional[str]
            Domain of address. Must be verified domain. Defaults to `agentmail.to`.

        display_name : typing.Optional[DisplayName]

        client_id : typing.Optional[ClientId]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Inbox

        Examples
        --------
        from agentmail import AgentMail

        client = AgentMail(
            api_key="YOUR_API_KEY",
        )
        client.inboxes.create()
        """
        _response = self._raw_client.create(
            username=username,
            domain=domain,
            display_name=display_name,
            client_id=client_id,
            request_options=request_options,
        )
        return _response.data

    def delete(self, inbox_id: InboxId, *, request_options: typing.Optional[RequestOptions] = None) -> None:
        """
        Parameters
        ----------
        inbox_id : InboxId

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        from agentmail import AgentMail

        client = AgentMail(
            api_key="YOUR_API_KEY",
        )
        client.inboxes.delete(
            inbox_id="inbox_id",
        )
        """
        _response = self._raw_client.delete(inbox_id, request_options=request_options)
        return _response.data

    @property
    def threads(self):
        if self._threads is None:
            from .threads.client import ThreadsClient  # noqa: E402

            self._threads = ThreadsClient(client_wrapper=self._client_wrapper)
        return self._threads

    @property
    def messages(self):
        if self._messages is None:
            from .messages.client import MessagesClient  # noqa: E402

            self._messages = MessagesClient(client_wrapper=self._client_wrapper)
        return self._messages

    @property
    def drafts(self):
        if self._drafts is None:
            from .drafts.client import DraftsClient  # noqa: E402

            self._drafts = DraftsClient(client_wrapper=self._client_wrapper)
        return self._drafts

    @property
    def metrics(self):
        if self._metrics is None:
            from .metrics.client import MetricsClient  # noqa: E402

            self._metrics = MetricsClient(client_wrapper=self._client_wrapper)
        return self._metrics


class AsyncInboxesClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawInboxesClient(client_wrapper=client_wrapper)
        self._client_wrapper = client_wrapper
        self._threads: typing.Optional[AsyncThreadsClient] = None
        self._messages: typing.Optional[AsyncMessagesClient] = None
        self._drafts: typing.Optional[AsyncDraftsClient] = None
        self._metrics: typing.Optional[AsyncMetricsClient] = None

    @property
    def with_raw_response(self) -> AsyncRawInboxesClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawInboxesClient
        """
        return self._raw_client

    async def list(
        self,
        *,
        limit: typing.Optional[Limit] = None,
        page_token: typing.Optional[PageToken] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncPager[Inbox]:
        """
        Parameters
        ----------
        limit : typing.Optional[Limit]

        page_token : typing.Optional[PageToken]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncPager[Inbox]

        Examples
        --------
        import asyncio

        from agentmail import AsyncAgentMail

        client = AsyncAgentMail(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            response = await client.inboxes.list()
            async for item in response:
                yield item

            # alternatively, you can paginate page-by-page
            async for page in response.iter_pages():
                yield page


        asyncio.run(main())
        """
        return await self._raw_client.list(limit=limit, page_token=page_token, request_options=request_options)

    async def get(self, inbox_id: InboxId, *, request_options: typing.Optional[RequestOptions] = None) -> Inbox:
        """
        Parameters
        ----------
        inbox_id : InboxId

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Inbox

        Examples
        --------
        import asyncio

        from agentmail import AsyncAgentMail

        client = AsyncAgentMail(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.inboxes.get(
                inbox_id="inbox_id",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.get(inbox_id, request_options=request_options)
        return _response.data

    async def create(
        self,
        *,
        username: typing.Optional[str] = OMIT,
        domain: typing.Optional[str] = OMIT,
        display_name: typing.Optional[DisplayName] = OMIT,
        client_id: typing.Optional[ClientId] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> Inbox:
        """
        Parameters
        ----------
        username : typing.Optional[str]
            Username of address. Randomly generated if not specified.

        domain : typing.Optional[str]
            Domain of address. Must be verified domain. Defaults to `agentmail.to`.

        display_name : typing.Optional[DisplayName]

        client_id : typing.Optional[ClientId]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Inbox

        Examples
        --------
        import asyncio

        from agentmail import AsyncAgentMail

        client = AsyncAgentMail(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.inboxes.create()


        asyncio.run(main())
        """
        _response = await self._raw_client.create(
            username=username,
            domain=domain,
            display_name=display_name,
            client_id=client_id,
            request_options=request_options,
        )
        return _response.data

    async def delete(self, inbox_id: InboxId, *, request_options: typing.Optional[RequestOptions] = None) -> None:
        """
        Parameters
        ----------
        inbox_id : InboxId

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        import asyncio

        from agentmail import AsyncAgentMail

        client = AsyncAgentMail(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.inboxes.delete(
                inbox_id="inbox_id",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.delete(inbox_id, request_options=request_options)
        return _response.data

    @property
    def threads(self):
        if self._threads is None:
            from .threads.client import AsyncThreadsClient  # noqa: E402

            self._threads = AsyncThreadsClient(client_wrapper=self._client_wrapper)
        return self._threads

    @property
    def messages(self):
        if self._messages is None:
            from .messages.client import AsyncMessagesClient  # noqa: E402

            self._messages = AsyncMessagesClient(client_wrapper=self._client_wrapper)
        return self._messages

    @property
    def drafts(self):
        if self._drafts is None:
            from .drafts.client import AsyncDraftsClient  # noqa: E402

            self._drafts = AsyncDraftsClient(client_wrapper=self._client_wrapper)
        return self._drafts

    @property
    def metrics(self):
        if self._metrics is None:
            from .metrics.client import AsyncMetricsClient  # noqa: E402

            self._metrics = AsyncMetricsClient(client_wrapper=self._client_wrapper)
        return self._metrics
