# This file was auto-generated by Fern from our API Definition.

import typing

from ...attachments.types.attachment_id import AttachmentId
from ...core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ...core.pagination import AsyncPager, SyncPager
from ...core.request_options import RequestOptions
from ...messages.types.message import Message
from ...messages.types.message_html import MessageHtml
from ...messages.types.message_id import MessageId
from ...messages.types.message_item import MessageItem
from ...messages.types.message_labels import MessageLabels
from ...messages.types.message_subject import MessageSubject
from ...messages.types.message_text import MessageText
from ...messages.types.send_message_attachments import SendMessageAttachments
from ...messages.types.send_message_bcc import SendMessageBcc
from ...messages.types.send_message_cc import SendMessageCc
from ...messages.types.send_message_reply_to import SendMessageReplyTo
from ...messages.types.send_message_response import SendMessageResponse
from ...messages.types.send_message_to import SendMessageTo
from ...types.after import After
from ...types.ascending import Ascending
from ...types.before import Before
from ...types.labels import Labels
from ...types.limit import Limit
from ...types.page_token import PageToken
from ..types.inbox_id import InboxId
from .raw_client import AsyncRawMessagesClient, RawMessagesClient

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class MessagesClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawMessagesClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawMessagesClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawMessagesClient
        """
        return self._raw_client

    def list(
        self,
        inbox_id: InboxId,
        *,
        limit: typing.Optional[Limit] = None,
        page_token: typing.Optional[PageToken] = None,
        labels: typing.Optional[Labels] = None,
        before: typing.Optional[Before] = None,
        after: typing.Optional[After] = None,
        ascending: typing.Optional[Ascending] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> SyncPager[MessageItem]:
        """
        Parameters
        ----------
        inbox_id : InboxId

        limit : typing.Optional[Limit]

        page_token : typing.Optional[PageToken]

        labels : typing.Optional[Labels]

        before : typing.Optional[Before]

        after : typing.Optional[After]

        ascending : typing.Optional[Ascending]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        SyncPager[MessageItem]

        Examples
        --------
        from agentmail import AgentMail

        client = AgentMail(
            api_key="YOUR_API_KEY",
        )
        response = client.inboxes.messages.list(
            inbox_id="inbox_id",
        )
        for item in response:
            yield item
        # alternatively, you can paginate page-by-page
        for page in response.iter_pages():
            yield page
        """
        return self._raw_client.list(
            inbox_id,
            limit=limit,
            page_token=page_token,
            labels=labels,
            before=before,
            after=after,
            ascending=ascending,
            request_options=request_options,
        )

    def get(
        self, inbox_id: InboxId, message_id: MessageId, *, request_options: typing.Optional[RequestOptions] = None
    ) -> Message:
        """
        Parameters
        ----------
        inbox_id : InboxId

        message_id : MessageId

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Message

        Examples
        --------
        from agentmail import AgentMail

        client = AgentMail(
            api_key="YOUR_API_KEY",
        )
        client.inboxes.messages.get(
            inbox_id="inbox_id",
            message_id="message_id",
        )
        """
        _response = self._raw_client.get(inbox_id, message_id, request_options=request_options)
        return _response.data

    def get_attachment(
        self,
        inbox_id: InboxId,
        message_id: MessageId,
        attachment_id: AttachmentId,
        *,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> typing.Iterator[bytes]:
        """
        Parameters
        ----------
        inbox_id : InboxId

        message_id : MessageId

        attachment_id : AttachmentId

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration. You can pass in configuration such as `chunk_size`, and more to customize the request and response.

        Returns
        -------
        typing.Iterator[bytes]

        Examples
        --------
        from agentmail import AgentMail

        client = AgentMail(
            api_key="YOUR_API_KEY",
        )
        client.inboxes.messages.get_attachment(
            inbox_id="inbox_id",
            message_id="message_id",
            attachment_id="attachment_id",
        )
        """
        with self._raw_client.get_attachment(inbox_id, message_id, attachment_id, request_options=request_options) as r:
            yield from r.data

    def get_raw(
        self, inbox_id: InboxId, message_id: MessageId, *, request_options: typing.Optional[RequestOptions] = None
    ) -> typing.Iterator[bytes]:
        """
        Parameters
        ----------
        inbox_id : InboxId

        message_id : MessageId

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration. You can pass in configuration such as `chunk_size`, and more to customize the request and response.

        Returns
        -------
        typing.Iterator[bytes]

        Examples
        --------
        from agentmail import AgentMail

        client = AgentMail(
            api_key="YOUR_API_KEY",
        )
        client.inboxes.messages.get_raw(
            inbox_id="inbox_id",
            message_id="message_id",
        )
        """
        with self._raw_client.get_raw(inbox_id, message_id, request_options=request_options) as r:
            yield from r.data

    def send(
        self,
        inbox_id: InboxId,
        *,
        labels: typing.Optional[MessageLabels] = OMIT,
        reply_to: typing.Optional[SendMessageReplyTo] = OMIT,
        to: typing.Optional[SendMessageTo] = OMIT,
        cc: typing.Optional[SendMessageCc] = OMIT,
        bcc: typing.Optional[SendMessageBcc] = OMIT,
        subject: typing.Optional[MessageSubject] = OMIT,
        text: typing.Optional[MessageText] = OMIT,
        html: typing.Optional[MessageHtml] = OMIT,
        attachments: typing.Optional[SendMessageAttachments] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> SendMessageResponse:
        """
        Parameters
        ----------
        inbox_id : InboxId

        labels : typing.Optional[MessageLabels]

        reply_to : typing.Optional[SendMessageReplyTo]

        to : typing.Optional[SendMessageTo]

        cc : typing.Optional[SendMessageCc]

        bcc : typing.Optional[SendMessageBcc]

        subject : typing.Optional[MessageSubject]

        text : typing.Optional[MessageText]

        html : typing.Optional[MessageHtml]

        attachments : typing.Optional[SendMessageAttachments]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        SendMessageResponse

        Examples
        --------
        from agentmail import AgentMail

        client = AgentMail(
            api_key="YOUR_API_KEY",
        )
        client.inboxes.messages.send(
            inbox_id="inbox_id",
        )
        """
        _response = self._raw_client.send(
            inbox_id,
            labels=labels,
            reply_to=reply_to,
            to=to,
            cc=cc,
            bcc=bcc,
            subject=subject,
            text=text,
            html=html,
            attachments=attachments,
            request_options=request_options,
        )
        return _response.data

    def reply(
        self,
        inbox_id: InboxId,
        message_id: MessageId,
        *,
        labels: typing.Optional[MessageLabels] = OMIT,
        reply_to: typing.Optional[SendMessageReplyTo] = OMIT,
        to: typing.Optional[SendMessageTo] = OMIT,
        cc: typing.Optional[SendMessageCc] = OMIT,
        bcc: typing.Optional[SendMessageBcc] = OMIT,
        text: typing.Optional[MessageText] = OMIT,
        html: typing.Optional[MessageHtml] = OMIT,
        attachments: typing.Optional[SendMessageAttachments] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> SendMessageResponse:
        """
        Parameters
        ----------
        inbox_id : InboxId

        message_id : MessageId

        labels : typing.Optional[MessageLabels]

        reply_to : typing.Optional[SendMessageReplyTo]

        to : typing.Optional[SendMessageTo]

        cc : typing.Optional[SendMessageCc]

        bcc : typing.Optional[SendMessageBcc]

        text : typing.Optional[MessageText]

        html : typing.Optional[MessageHtml]

        attachments : typing.Optional[SendMessageAttachments]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        SendMessageResponse

        Examples
        --------
        from agentmail import AgentMail

        client = AgentMail(
            api_key="YOUR_API_KEY",
        )
        client.inboxes.messages.reply(
            inbox_id="inbox_id",
            message_id="message_id",
        )
        """
        _response = self._raw_client.reply(
            inbox_id,
            message_id,
            labels=labels,
            reply_to=reply_to,
            to=to,
            cc=cc,
            bcc=bcc,
            text=text,
            html=html,
            attachments=attachments,
            request_options=request_options,
        )
        return _response.data

    def update(
        self,
        inbox_id: InboxId,
        message_id: MessageId,
        *,
        add_labels: typing.Optional[typing.Sequence[str]] = OMIT,
        remove_labels: typing.Optional[typing.Sequence[str]] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> Message:
        """
        Parameters
        ----------
        inbox_id : InboxId

        message_id : MessageId

        add_labels : typing.Optional[typing.Sequence[str]]
            Labels to add to message.

        remove_labels : typing.Optional[typing.Sequence[str]]
            Labels to remove from message.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Message

        Examples
        --------
        from agentmail import AgentMail

        client = AgentMail(
            api_key="YOUR_API_KEY",
        )
        client.inboxes.messages.update(
            inbox_id="inbox_id",
            message_id="message_id",
        )
        """
        _response = self._raw_client.update(
            inbox_id, message_id, add_labels=add_labels, remove_labels=remove_labels, request_options=request_options
        )
        return _response.data


class AsyncMessagesClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawMessagesClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawMessagesClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawMessagesClient
        """
        return self._raw_client

    async def list(
        self,
        inbox_id: InboxId,
        *,
        limit: typing.Optional[Limit] = None,
        page_token: typing.Optional[PageToken] = None,
        labels: typing.Optional[Labels] = None,
        before: typing.Optional[Before] = None,
        after: typing.Optional[After] = None,
        ascending: typing.Optional[Ascending] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncPager[MessageItem]:
        """
        Parameters
        ----------
        inbox_id : InboxId

        limit : typing.Optional[Limit]

        page_token : typing.Optional[PageToken]

        labels : typing.Optional[Labels]

        before : typing.Optional[Before]

        after : typing.Optional[After]

        ascending : typing.Optional[Ascending]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncPager[MessageItem]

        Examples
        --------
        import asyncio

        from agentmail import AsyncAgentMail

        client = AsyncAgentMail(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            response = await client.inboxes.messages.list(
                inbox_id="inbox_id",
            )
            async for item in response:
                yield item

            # alternatively, you can paginate page-by-page
            async for page in response.iter_pages():
                yield page


        asyncio.run(main())
        """
        return await self._raw_client.list(
            inbox_id,
            limit=limit,
            page_token=page_token,
            labels=labels,
            before=before,
            after=after,
            ascending=ascending,
            request_options=request_options,
        )

    async def get(
        self, inbox_id: InboxId, message_id: MessageId, *, request_options: typing.Optional[RequestOptions] = None
    ) -> Message:
        """
        Parameters
        ----------
        inbox_id : InboxId

        message_id : MessageId

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Message

        Examples
        --------
        import asyncio

        from agentmail import AsyncAgentMail

        client = AsyncAgentMail(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.inboxes.messages.get(
                inbox_id="inbox_id",
                message_id="message_id",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.get(inbox_id, message_id, request_options=request_options)
        return _response.data

    async def get_attachment(
        self,
        inbox_id: InboxId,
        message_id: MessageId,
        attachment_id: AttachmentId,
        *,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> typing.AsyncIterator[bytes]:
        """
        Parameters
        ----------
        inbox_id : InboxId

        message_id : MessageId

        attachment_id : AttachmentId

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration. You can pass in configuration such as `chunk_size`, and more to customize the request and response.

        Returns
        -------
        typing.AsyncIterator[bytes]

        Examples
        --------
        import asyncio

        from agentmail import AsyncAgentMail

        client = AsyncAgentMail(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.inboxes.messages.get_attachment(
                inbox_id="inbox_id",
                message_id="message_id",
                attachment_id="attachment_id",
            )


        asyncio.run(main())
        """
        async with self._raw_client.get_attachment(
            inbox_id, message_id, attachment_id, request_options=request_options
        ) as r:
            async for _chunk in r.data:
                yield _chunk

    async def get_raw(
        self, inbox_id: InboxId, message_id: MessageId, *, request_options: typing.Optional[RequestOptions] = None
    ) -> typing.AsyncIterator[bytes]:
        """
        Parameters
        ----------
        inbox_id : InboxId

        message_id : MessageId

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration. You can pass in configuration such as `chunk_size`, and more to customize the request and response.

        Returns
        -------
        typing.AsyncIterator[bytes]

        Examples
        --------
        import asyncio

        from agentmail import AsyncAgentMail

        client = AsyncAgentMail(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.inboxes.messages.get_raw(
                inbox_id="inbox_id",
                message_id="message_id",
            )


        asyncio.run(main())
        """
        async with self._raw_client.get_raw(inbox_id, message_id, request_options=request_options) as r:
            async for _chunk in r.data:
                yield _chunk

    async def send(
        self,
        inbox_id: InboxId,
        *,
        labels: typing.Optional[MessageLabels] = OMIT,
        reply_to: typing.Optional[SendMessageReplyTo] = OMIT,
        to: typing.Optional[SendMessageTo] = OMIT,
        cc: typing.Optional[SendMessageCc] = OMIT,
        bcc: typing.Optional[SendMessageBcc] = OMIT,
        subject: typing.Optional[MessageSubject] = OMIT,
        text: typing.Optional[MessageText] = OMIT,
        html: typing.Optional[MessageHtml] = OMIT,
        attachments: typing.Optional[SendMessageAttachments] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> SendMessageResponse:
        """
        Parameters
        ----------
        inbox_id : InboxId

        labels : typing.Optional[MessageLabels]

        reply_to : typing.Optional[SendMessageReplyTo]

        to : typing.Optional[SendMessageTo]

        cc : typing.Optional[SendMessageCc]

        bcc : typing.Optional[SendMessageBcc]

        subject : typing.Optional[MessageSubject]

        text : typing.Optional[MessageText]

        html : typing.Optional[MessageHtml]

        attachments : typing.Optional[SendMessageAttachments]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        SendMessageResponse

        Examples
        --------
        import asyncio

        from agentmail import AsyncAgentMail

        client = AsyncAgentMail(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.inboxes.messages.send(
                inbox_id="inbox_id",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.send(
            inbox_id,
            labels=labels,
            reply_to=reply_to,
            to=to,
            cc=cc,
            bcc=bcc,
            subject=subject,
            text=text,
            html=html,
            attachments=attachments,
            request_options=request_options,
        )
        return _response.data

    async def reply(
        self,
        inbox_id: InboxId,
        message_id: MessageId,
        *,
        labels: typing.Optional[MessageLabels] = OMIT,
        reply_to: typing.Optional[SendMessageReplyTo] = OMIT,
        to: typing.Optional[SendMessageTo] = OMIT,
        cc: typing.Optional[SendMessageCc] = OMIT,
        bcc: typing.Optional[SendMessageBcc] = OMIT,
        text: typing.Optional[MessageText] = OMIT,
        html: typing.Optional[MessageHtml] = OMIT,
        attachments: typing.Optional[SendMessageAttachments] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> SendMessageResponse:
        """
        Parameters
        ----------
        inbox_id : InboxId

        message_id : MessageId

        labels : typing.Optional[MessageLabels]

        reply_to : typing.Optional[SendMessageReplyTo]

        to : typing.Optional[SendMessageTo]

        cc : typing.Optional[SendMessageCc]

        bcc : typing.Optional[SendMessageBcc]

        text : typing.Optional[MessageText]

        html : typing.Optional[MessageHtml]

        attachments : typing.Optional[SendMessageAttachments]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        SendMessageResponse

        Examples
        --------
        import asyncio

        from agentmail import AsyncAgentMail

        client = AsyncAgentMail(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.inboxes.messages.reply(
                inbox_id="inbox_id",
                message_id="message_id",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.reply(
            inbox_id,
            message_id,
            labels=labels,
            reply_to=reply_to,
            to=to,
            cc=cc,
            bcc=bcc,
            text=text,
            html=html,
            attachments=attachments,
            request_options=request_options,
        )
        return _response.data

    async def update(
        self,
        inbox_id: InboxId,
        message_id: MessageId,
        *,
        add_labels: typing.Optional[typing.Sequence[str]] = OMIT,
        remove_labels: typing.Optional[typing.Sequence[str]] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> Message:
        """
        Parameters
        ----------
        inbox_id : InboxId

        message_id : MessageId

        add_labels : typing.Optional[typing.Sequence[str]]
            Labels to add to message.

        remove_labels : typing.Optional[typing.Sequence[str]]
            Labels to remove from message.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Message

        Examples
        --------
        import asyncio

        from agentmail import AsyncAgentMail

        client = AsyncAgentMail(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.inboxes.messages.update(
                inbox_id="inbox_id",
                message_id="message_id",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.update(
            inbox_id, message_id, add_labels=add_labels, remove_labels=remove_labels, request_options=request_options
        )
        return _response.data
