# This file was auto-generated by Fern from our API Definition.

import typing
from json.decoder import JSONDecodeError

from ...core.api_error import ApiError
from ...core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ...core.datetime_utils import serialize_datetime
from ...core.http_response import AsyncHttpResponse, HttpResponse
from ...core.jsonable_encoder import jsonable_encoder
from ...core.request_options import RequestOptions
from ...core.unchecked_base_model import construct_type
from ...errors.not_found_error import NotFoundError
from ...errors.validation_error import ValidationError
from ...metrics.types.list_metrics_response import ListMetricsResponse
from ...metrics.types.metric_end_timestamp import MetricEndTimestamp
from ...metrics.types.metric_event_types import MetricEventTypes
from ...metrics.types.metric_start_timestamp import MetricStartTimestamp
from ...types.error_response import ErrorResponse
from ...types.validation_error_response import ValidationErrorResponse
from ..types.inbox_id import InboxId


class RawMetricsClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._client_wrapper = client_wrapper

    def get(
        self,
        inbox_id: InboxId,
        *,
        start_timestamp: MetricStartTimestamp,
        end_timestamp: MetricEndTimestamp,
        event_types: typing.Optional[MetricEventTypes] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[ListMetricsResponse]:
        """
        Parameters
        ----------
        inbox_id : InboxId

        start_timestamp : MetricStartTimestamp

        end_timestamp : MetricEndTimestamp

        event_types : typing.Optional[MetricEventTypes]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[ListMetricsResponse]
        """
        _response = self._client_wrapper.httpx_client.request(
            f"v0/inboxes/{jsonable_encoder(inbox_id)}/metrics",
            base_url=self._client_wrapper.get_environment().http,
            method="GET",
            params={
                "event_types": event_types,
                "start_timestamp": serialize_datetime(start_timestamp),
                "end_timestamp": serialize_datetime(end_timestamp),
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    ListMetricsResponse,
                    construct_type(
                        type_=ListMetricsResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 404:
                raise NotFoundError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        ErrorResponse,
                        construct_type(
                            type_=ErrorResponse,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 400:
                raise ValidationError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        ValidationErrorResponse,
                        construct_type(
                            type_=ValidationErrorResponse,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)


class AsyncRawMetricsClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._client_wrapper = client_wrapper

    async def get(
        self,
        inbox_id: InboxId,
        *,
        start_timestamp: MetricStartTimestamp,
        end_timestamp: MetricEndTimestamp,
        event_types: typing.Optional[MetricEventTypes] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[ListMetricsResponse]:
        """
        Parameters
        ----------
        inbox_id : InboxId

        start_timestamp : MetricStartTimestamp

        end_timestamp : MetricEndTimestamp

        event_types : typing.Optional[MetricEventTypes]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[ListMetricsResponse]
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"v0/inboxes/{jsonable_encoder(inbox_id)}/metrics",
            base_url=self._client_wrapper.get_environment().http,
            method="GET",
            params={
                "event_types": event_types,
                "start_timestamp": serialize_datetime(start_timestamp),
                "end_timestamp": serialize_datetime(end_timestamp),
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    ListMetricsResponse,
                    construct_type(
                        type_=ListMetricsResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 404:
                raise NotFoundError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        ErrorResponse,
                        construct_type(
                            type_=ErrorResponse,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 400:
                raise ValidationError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        ValidationErrorResponse,
                        construct_type(
                            type_=ValidationErrorResponse,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)
