# This file was auto-generated by Fern from our API Definition.

from __future__ import annotations

import typing

from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ..core.pagination import AsyncPager, SyncPager
from ..core.request_options import RequestOptions
from ..types.limit import Limit
from ..types.page_token import PageToken
from .raw_client import AsyncRawPodsClient, RawPodsClient
from .types.client_id import ClientId
from .types.name import Name
from .types.pod import Pod
from .types.pod_id import PodId

if typing.TYPE_CHECKING:
    from .domains.client import AsyncDomainsClient, DomainsClient
    from .drafts.client import AsyncDraftsClient, DraftsClient
    from .inboxes.client import AsyncInboxesClient, InboxesClient
    from .threads.client import AsyncThreadsClient, ThreadsClient
# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class PodsClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawPodsClient(client_wrapper=client_wrapper)
        self._client_wrapper = client_wrapper
        self._inboxes: typing.Optional[InboxesClient] = None
        self._threads: typing.Optional[ThreadsClient] = None
        self._drafts: typing.Optional[DraftsClient] = None
        self._domains: typing.Optional[DomainsClient] = None

    @property
    def with_raw_response(self) -> RawPodsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawPodsClient
        """
        return self._raw_client

    def list(
        self,
        *,
        limit: typing.Optional[Limit] = None,
        page_token: typing.Optional[PageToken] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> SyncPager[Pod]:
        """
        Parameters
        ----------
        limit : typing.Optional[Limit]

        page_token : typing.Optional[PageToken]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        SyncPager[Pod]

        Examples
        --------
        from agentmail import AgentMail

        client = AgentMail(
            api_key="YOUR_API_KEY",
        )
        response = client.pods.list()
        for item in response:
            yield item
        # alternatively, you can paginate page-by-page
        for page in response.iter_pages():
            yield page
        """
        return self._raw_client.list(limit=limit, page_token=page_token, request_options=request_options)

    def get(self, pod_id: PodId, *, request_options: typing.Optional[RequestOptions] = None) -> Pod:
        """
        Parameters
        ----------
        pod_id : PodId

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Pod

        Examples
        --------
        from agentmail import AgentMail

        client = AgentMail(
            api_key="YOUR_API_KEY",
        )
        client.pods.get(
            pod_id="pod_id",
        )
        """
        _response = self._raw_client.get(pod_id, request_options=request_options)
        return _response.data

    def create(
        self,
        *,
        name: typing.Optional[Name] = OMIT,
        client_id: typing.Optional[ClientId] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> Pod:
        """
        Parameters
        ----------
        name : typing.Optional[Name]

        client_id : typing.Optional[ClientId]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Pod

        Examples
        --------
        from agentmail import AgentMail

        client = AgentMail(
            api_key="YOUR_API_KEY",
        )
        client.pods.create()
        """
        _response = self._raw_client.create(name=name, client_id=client_id, request_options=request_options)
        return _response.data

    def delete(self, pod_id: PodId, *, request_options: typing.Optional[RequestOptions] = None) -> None:
        """
        Parameters
        ----------
        pod_id : PodId

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        from agentmail import AgentMail

        client = AgentMail(
            api_key="YOUR_API_KEY",
        )
        client.pods.delete(
            pod_id="pod_id",
        )
        """
        _response = self._raw_client.delete(pod_id, request_options=request_options)
        return _response.data

    @property
    def inboxes(self):
        if self._inboxes is None:
            from .inboxes.client import InboxesClient  # noqa: E402

            self._inboxes = InboxesClient(client_wrapper=self._client_wrapper)
        return self._inboxes

    @property
    def threads(self):
        if self._threads is None:
            from .threads.client import ThreadsClient  # noqa: E402

            self._threads = ThreadsClient(client_wrapper=self._client_wrapper)
        return self._threads

    @property
    def drafts(self):
        if self._drafts is None:
            from .drafts.client import DraftsClient  # noqa: E402

            self._drafts = DraftsClient(client_wrapper=self._client_wrapper)
        return self._drafts

    @property
    def domains(self):
        if self._domains is None:
            from .domains.client import DomainsClient  # noqa: E402

            self._domains = DomainsClient(client_wrapper=self._client_wrapper)
        return self._domains


class AsyncPodsClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawPodsClient(client_wrapper=client_wrapper)
        self._client_wrapper = client_wrapper
        self._inboxes: typing.Optional[AsyncInboxesClient] = None
        self._threads: typing.Optional[AsyncThreadsClient] = None
        self._drafts: typing.Optional[AsyncDraftsClient] = None
        self._domains: typing.Optional[AsyncDomainsClient] = None

    @property
    def with_raw_response(self) -> AsyncRawPodsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawPodsClient
        """
        return self._raw_client

    async def list(
        self,
        *,
        limit: typing.Optional[Limit] = None,
        page_token: typing.Optional[PageToken] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncPager[Pod]:
        """
        Parameters
        ----------
        limit : typing.Optional[Limit]

        page_token : typing.Optional[PageToken]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncPager[Pod]

        Examples
        --------
        import asyncio

        from agentmail import AsyncAgentMail

        client = AsyncAgentMail(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            response = await client.pods.list()
            async for item in response:
                yield item

            # alternatively, you can paginate page-by-page
            async for page in response.iter_pages():
                yield page


        asyncio.run(main())
        """
        return await self._raw_client.list(limit=limit, page_token=page_token, request_options=request_options)

    async def get(self, pod_id: PodId, *, request_options: typing.Optional[RequestOptions] = None) -> Pod:
        """
        Parameters
        ----------
        pod_id : PodId

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Pod

        Examples
        --------
        import asyncio

        from agentmail import AsyncAgentMail

        client = AsyncAgentMail(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.pods.get(
                pod_id="pod_id",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.get(pod_id, request_options=request_options)
        return _response.data

    async def create(
        self,
        *,
        name: typing.Optional[Name] = OMIT,
        client_id: typing.Optional[ClientId] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> Pod:
        """
        Parameters
        ----------
        name : typing.Optional[Name]

        client_id : typing.Optional[ClientId]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Pod

        Examples
        --------
        import asyncio

        from agentmail import AsyncAgentMail

        client = AsyncAgentMail(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.pods.create()


        asyncio.run(main())
        """
        _response = await self._raw_client.create(name=name, client_id=client_id, request_options=request_options)
        return _response.data

    async def delete(self, pod_id: PodId, *, request_options: typing.Optional[RequestOptions] = None) -> None:
        """
        Parameters
        ----------
        pod_id : PodId

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        import asyncio

        from agentmail import AsyncAgentMail

        client = AsyncAgentMail(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.pods.delete(
                pod_id="pod_id",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.delete(pod_id, request_options=request_options)
        return _response.data

    @property
    def inboxes(self):
        if self._inboxes is None:
            from .inboxes.client import AsyncInboxesClient  # noqa: E402

            self._inboxes = AsyncInboxesClient(client_wrapper=self._client_wrapper)
        return self._inboxes

    @property
    def threads(self):
        if self._threads is None:
            from .threads.client import AsyncThreadsClient  # noqa: E402

            self._threads = AsyncThreadsClient(client_wrapper=self._client_wrapper)
        return self._threads

    @property
    def drafts(self):
        if self._drafts is None:
            from .drafts.client import AsyncDraftsClient  # noqa: E402

            self._drafts = AsyncDraftsClient(client_wrapper=self._client_wrapper)
        return self._drafts

    @property
    def domains(self):
        if self._domains is None:
            from .domains.client import AsyncDomainsClient  # noqa: E402

            self._domains = AsyncDomainsClient(client_wrapper=self._client_wrapper)
        return self._domains
