# This file was auto-generated by Fern from our API Definition.

import typing

from ...core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ...core.pagination import AsyncPager, SyncPager
from ...core.request_options import RequestOptions
from ...domains.types.domain import Domain
from ...domains.types.domain_id import DomainId
from ...domains.types.domain_name import DomainName
from ...domains.types.domain_summary import DomainSummary
from ...domains.types.feedback_enabled import FeedbackEnabled
from ...types.after import After
from ...types.ascending import Ascending
from ...types.before import Before
from ...types.labels import Labels
from ...types.limit import Limit
from ...types.page_token import PageToken
from ..types.pod_id import PodId
from .raw_client import AsyncRawDomainsClient, RawDomainsClient

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class DomainsClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawDomainsClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawDomainsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawDomainsClient
        """
        return self._raw_client

    def list(
        self,
        pod_id: PodId,
        *,
        limit: typing.Optional[Limit] = None,
        page_token: typing.Optional[PageToken] = None,
        labels: typing.Optional[Labels] = None,
        before: typing.Optional[Before] = None,
        after: typing.Optional[After] = None,
        ascending: typing.Optional[Ascending] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> SyncPager[DomainSummary]:
        """
        Parameters
        ----------
        pod_id : PodId

        limit : typing.Optional[Limit]

        page_token : typing.Optional[PageToken]

        labels : typing.Optional[Labels]

        before : typing.Optional[Before]

        after : typing.Optional[After]

        ascending : typing.Optional[Ascending]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        SyncPager[DomainSummary]

        Examples
        --------
        from agentmail import AgentMail

        client = AgentMail(
            api_key="YOUR_API_KEY",
        )
        response = client.pods.domains.list(
            pod_id="pod_id",
        )
        for item in response:
            yield item
        # alternatively, you can paginate page-by-page
        for page in response.iter_pages():
            yield page
        """
        return self._raw_client.list(
            pod_id,
            limit=limit,
            page_token=page_token,
            labels=labels,
            before=before,
            after=after,
            ascending=ascending,
            request_options=request_options,
        )

    def create(
        self,
        pod_id: PodId,
        *,
        domain: DomainName,
        feedback_enabled: FeedbackEnabled,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> Domain:
        """
        Parameters
        ----------
        pod_id : PodId

        domain : DomainName

        feedback_enabled : FeedbackEnabled

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Domain

        Examples
        --------
        from agentmail import AgentMail

        client = AgentMail(
            api_key="YOUR_API_KEY",
        )
        client.pods.domains.create(
            pod_id="pod_id",
            domain="domain",
            feedback_enabled=True,
        )
        """
        _response = self._raw_client.create(
            pod_id, domain=domain, feedback_enabled=feedback_enabled, request_options=request_options
        )
        return _response.data

    def delete(
        self, pod_id: PodId, domain_id: DomainId, *, request_options: typing.Optional[RequestOptions] = None
    ) -> None:
        """
        Parameters
        ----------
        pod_id : PodId

        domain_id : DomainId

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        from agentmail import AgentMail

        client = AgentMail(
            api_key="YOUR_API_KEY",
        )
        client.pods.domains.delete(
            pod_id="pod_id",
            domain_id="domain_id",
        )
        """
        _response = self._raw_client.delete(pod_id, domain_id, request_options=request_options)
        return _response.data


class AsyncDomainsClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawDomainsClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawDomainsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawDomainsClient
        """
        return self._raw_client

    async def list(
        self,
        pod_id: PodId,
        *,
        limit: typing.Optional[Limit] = None,
        page_token: typing.Optional[PageToken] = None,
        labels: typing.Optional[Labels] = None,
        before: typing.Optional[Before] = None,
        after: typing.Optional[After] = None,
        ascending: typing.Optional[Ascending] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncPager[DomainSummary]:
        """
        Parameters
        ----------
        pod_id : PodId

        limit : typing.Optional[Limit]

        page_token : typing.Optional[PageToken]

        labels : typing.Optional[Labels]

        before : typing.Optional[Before]

        after : typing.Optional[After]

        ascending : typing.Optional[Ascending]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncPager[DomainSummary]

        Examples
        --------
        import asyncio

        from agentmail import AsyncAgentMail

        client = AsyncAgentMail(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            response = await client.pods.domains.list(
                pod_id="pod_id",
            )
            async for item in response:
                yield item

            # alternatively, you can paginate page-by-page
            async for page in response.iter_pages():
                yield page


        asyncio.run(main())
        """
        return await self._raw_client.list(
            pod_id,
            limit=limit,
            page_token=page_token,
            labels=labels,
            before=before,
            after=after,
            ascending=ascending,
            request_options=request_options,
        )

    async def create(
        self,
        pod_id: PodId,
        *,
        domain: DomainName,
        feedback_enabled: FeedbackEnabled,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> Domain:
        """
        Parameters
        ----------
        pod_id : PodId

        domain : DomainName

        feedback_enabled : FeedbackEnabled

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Domain

        Examples
        --------
        import asyncio

        from agentmail import AsyncAgentMail

        client = AsyncAgentMail(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.pods.domains.create(
                pod_id="pod_id",
                domain="domain",
                feedback_enabled=True,
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.create(
            pod_id, domain=domain, feedback_enabled=feedback_enabled, request_options=request_options
        )
        return _response.data

    async def delete(
        self, pod_id: PodId, domain_id: DomainId, *, request_options: typing.Optional[RequestOptions] = None
    ) -> None:
        """
        Parameters
        ----------
        pod_id : PodId

        domain_id : DomainId

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        import asyncio

        from agentmail import AsyncAgentMail

        client = AsyncAgentMail(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.pods.domains.delete(
                pod_id="pod_id",
                domain_id="domain_id",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.delete(pod_id, domain_id, request_options=request_options)
        return _response.data
