# This file was auto-generated by Fern from our API Definition.

import typing

from ...core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ...core.pagination import AsyncPager, SyncPager
from ...core.request_options import RequestOptions
from ...drafts.types.draft import Draft
from ...drafts.types.draft_id import DraftId
from ...drafts.types.draft_item import DraftItem
from ...types.after import After
from ...types.ascending import Ascending
from ...types.before import Before
from ...types.labels import Labels
from ...types.limit import Limit
from ...types.page_token import PageToken
from ..types.pod_id import PodId
from .raw_client import AsyncRawDraftsClient, RawDraftsClient


class DraftsClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawDraftsClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawDraftsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawDraftsClient
        """
        return self._raw_client

    def list(
        self,
        pod_id: PodId,
        *,
        limit: typing.Optional[Limit] = None,
        page_token: typing.Optional[PageToken] = None,
        labels: typing.Optional[Labels] = None,
        before: typing.Optional[Before] = None,
        after: typing.Optional[After] = None,
        ascending: typing.Optional[Ascending] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> SyncPager[DraftItem]:
        """
        Parameters
        ----------
        pod_id : PodId

        limit : typing.Optional[Limit]

        page_token : typing.Optional[PageToken]

        labels : typing.Optional[Labels]

        before : typing.Optional[Before]

        after : typing.Optional[After]

        ascending : typing.Optional[Ascending]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        SyncPager[DraftItem]

        Examples
        --------
        from agentmail import AgentMail

        client = AgentMail(
            api_key="YOUR_API_KEY",
        )
        response = client.pods.drafts.list(
            pod_id="pod_id",
        )
        for item in response:
            yield item
        # alternatively, you can paginate page-by-page
        for page in response.iter_pages():
            yield page
        """
        return self._raw_client.list(
            pod_id,
            limit=limit,
            page_token=page_token,
            labels=labels,
            before=before,
            after=after,
            ascending=ascending,
            request_options=request_options,
        )

    def get(
        self, pod_id: PodId, draft_id: DraftId, *, request_options: typing.Optional[RequestOptions] = None
    ) -> Draft:
        """
        Parameters
        ----------
        pod_id : PodId

        draft_id : DraftId

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Draft

        Examples
        --------
        from agentmail import AgentMail

        client = AgentMail(
            api_key="YOUR_API_KEY",
        )
        client.pods.drafts.get(
            pod_id="pod_id",
            draft_id="draft_id",
        )
        """
        _response = self._raw_client.get(pod_id, draft_id, request_options=request_options)
        return _response.data


class AsyncDraftsClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawDraftsClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawDraftsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawDraftsClient
        """
        return self._raw_client

    async def list(
        self,
        pod_id: PodId,
        *,
        limit: typing.Optional[Limit] = None,
        page_token: typing.Optional[PageToken] = None,
        labels: typing.Optional[Labels] = None,
        before: typing.Optional[Before] = None,
        after: typing.Optional[After] = None,
        ascending: typing.Optional[Ascending] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncPager[DraftItem]:
        """
        Parameters
        ----------
        pod_id : PodId

        limit : typing.Optional[Limit]

        page_token : typing.Optional[PageToken]

        labels : typing.Optional[Labels]

        before : typing.Optional[Before]

        after : typing.Optional[After]

        ascending : typing.Optional[Ascending]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncPager[DraftItem]

        Examples
        --------
        import asyncio

        from agentmail import AsyncAgentMail

        client = AsyncAgentMail(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            response = await client.pods.drafts.list(
                pod_id="pod_id",
            )
            async for item in response:
                yield item

            # alternatively, you can paginate page-by-page
            async for page in response.iter_pages():
                yield page


        asyncio.run(main())
        """
        return await self._raw_client.list(
            pod_id,
            limit=limit,
            page_token=page_token,
            labels=labels,
            before=before,
            after=after,
            ascending=ascending,
            request_options=request_options,
        )

    async def get(
        self, pod_id: PodId, draft_id: DraftId, *, request_options: typing.Optional[RequestOptions] = None
    ) -> Draft:
        """
        Parameters
        ----------
        pod_id : PodId

        draft_id : DraftId

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Draft

        Examples
        --------
        import asyncio

        from agentmail import AsyncAgentMail

        client = AsyncAgentMail(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.pods.drafts.get(
                pod_id="pod_id",
                draft_id="draft_id",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.get(pod_id, draft_id, request_options=request_options)
        return _response.data
