# This file was auto-generated by Fern from our API Definition.

import typing

from ...core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ...core.pagination import AsyncPager, SyncPager
from ...core.request_options import RequestOptions
from ...inboxes.types.client_id import ClientId
from ...inboxes.types.display_name import DisplayName
from ...inboxes.types.inbox import Inbox
from ...inboxes.types.inbox_id import InboxId
from ...types.after import After
from ...types.ascending import Ascending
from ...types.before import Before
from ...types.labels import Labels
from ...types.limit import Limit
from ...types.page_token import PageToken
from ..types.pod_id import PodId
from .raw_client import AsyncRawInboxesClient, RawInboxesClient

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class InboxesClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawInboxesClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawInboxesClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawInboxesClient
        """
        return self._raw_client

    def list(
        self,
        pod_id: PodId,
        *,
        limit: typing.Optional[Limit] = None,
        page_token: typing.Optional[PageToken] = None,
        labels: typing.Optional[Labels] = None,
        before: typing.Optional[Before] = None,
        after: typing.Optional[After] = None,
        ascending: typing.Optional[Ascending] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> SyncPager[Inbox]:
        """
        Parameters
        ----------
        pod_id : PodId

        limit : typing.Optional[Limit]

        page_token : typing.Optional[PageToken]

        labels : typing.Optional[Labels]

        before : typing.Optional[Before]

        after : typing.Optional[After]

        ascending : typing.Optional[Ascending]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        SyncPager[Inbox]

        Examples
        --------
        from agentmail import AgentMail

        client = AgentMail(
            api_key="YOUR_API_KEY",
        )
        response = client.pods.inboxes.list(
            pod_id="pod_id",
        )
        for item in response:
            yield item
        # alternatively, you can paginate page-by-page
        for page in response.iter_pages():
            yield page
        """
        return self._raw_client.list(
            pod_id,
            limit=limit,
            page_token=page_token,
            labels=labels,
            before=before,
            after=after,
            ascending=ascending,
            request_options=request_options,
        )

    def get(
        self, pod_id: PodId, inbox_id: InboxId, *, request_options: typing.Optional[RequestOptions] = None
    ) -> Inbox:
        """
        Parameters
        ----------
        pod_id : PodId

        inbox_id : InboxId

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Inbox

        Examples
        --------
        from agentmail import AgentMail

        client = AgentMail(
            api_key="YOUR_API_KEY",
        )
        client.pods.inboxes.get(
            pod_id="pod_id",
            inbox_id="inbox_id",
        )
        """
        _response = self._raw_client.get(pod_id, inbox_id, request_options=request_options)
        return _response.data

    def create(
        self,
        pod_id: PodId,
        *,
        username: typing.Optional[str] = OMIT,
        domain: typing.Optional[str] = OMIT,
        display_name: typing.Optional[DisplayName] = OMIT,
        client_id: typing.Optional[ClientId] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> Inbox:
        """
        Parameters
        ----------
        pod_id : PodId

        username : typing.Optional[str]
            Username of address. Randomly generated if not specified.

        domain : typing.Optional[str]
            Domain of address. Must be verified domain. Defaults to `agentmail.to`.

        display_name : typing.Optional[DisplayName]

        client_id : typing.Optional[ClientId]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Inbox

        Examples
        --------
        from agentmail import AgentMail

        client = AgentMail(
            api_key="YOUR_API_KEY",
        )
        client.pods.inboxes.create(
            pod_id="pod_id",
        )
        """
        _response = self._raw_client.create(
            pod_id,
            username=username,
            domain=domain,
            display_name=display_name,
            client_id=client_id,
            request_options=request_options,
        )
        return _response.data

    def delete(
        self, pod_id: PodId, inbox_id: InboxId, *, request_options: typing.Optional[RequestOptions] = None
    ) -> None:
        """
        Parameters
        ----------
        pod_id : PodId

        inbox_id : InboxId

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        from agentmail import AgentMail

        client = AgentMail(
            api_key="YOUR_API_KEY",
        )
        client.pods.inboxes.delete(
            pod_id="pod_id",
            inbox_id="inbox_id",
        )
        """
        _response = self._raw_client.delete(pod_id, inbox_id, request_options=request_options)
        return _response.data


class AsyncInboxesClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawInboxesClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawInboxesClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawInboxesClient
        """
        return self._raw_client

    async def list(
        self,
        pod_id: PodId,
        *,
        limit: typing.Optional[Limit] = None,
        page_token: typing.Optional[PageToken] = None,
        labels: typing.Optional[Labels] = None,
        before: typing.Optional[Before] = None,
        after: typing.Optional[After] = None,
        ascending: typing.Optional[Ascending] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncPager[Inbox]:
        """
        Parameters
        ----------
        pod_id : PodId

        limit : typing.Optional[Limit]

        page_token : typing.Optional[PageToken]

        labels : typing.Optional[Labels]

        before : typing.Optional[Before]

        after : typing.Optional[After]

        ascending : typing.Optional[Ascending]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncPager[Inbox]

        Examples
        --------
        import asyncio

        from agentmail import AsyncAgentMail

        client = AsyncAgentMail(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            response = await client.pods.inboxes.list(
                pod_id="pod_id",
            )
            async for item in response:
                yield item

            # alternatively, you can paginate page-by-page
            async for page in response.iter_pages():
                yield page


        asyncio.run(main())
        """
        return await self._raw_client.list(
            pod_id,
            limit=limit,
            page_token=page_token,
            labels=labels,
            before=before,
            after=after,
            ascending=ascending,
            request_options=request_options,
        )

    async def get(
        self, pod_id: PodId, inbox_id: InboxId, *, request_options: typing.Optional[RequestOptions] = None
    ) -> Inbox:
        """
        Parameters
        ----------
        pod_id : PodId

        inbox_id : InboxId

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Inbox

        Examples
        --------
        import asyncio

        from agentmail import AsyncAgentMail

        client = AsyncAgentMail(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.pods.inboxes.get(
                pod_id="pod_id",
                inbox_id="inbox_id",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.get(pod_id, inbox_id, request_options=request_options)
        return _response.data

    async def create(
        self,
        pod_id: PodId,
        *,
        username: typing.Optional[str] = OMIT,
        domain: typing.Optional[str] = OMIT,
        display_name: typing.Optional[DisplayName] = OMIT,
        client_id: typing.Optional[ClientId] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> Inbox:
        """
        Parameters
        ----------
        pod_id : PodId

        username : typing.Optional[str]
            Username of address. Randomly generated if not specified.

        domain : typing.Optional[str]
            Domain of address. Must be verified domain. Defaults to `agentmail.to`.

        display_name : typing.Optional[DisplayName]

        client_id : typing.Optional[ClientId]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Inbox

        Examples
        --------
        import asyncio

        from agentmail import AsyncAgentMail

        client = AsyncAgentMail(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.pods.inboxes.create(
                pod_id="pod_id",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.create(
            pod_id,
            username=username,
            domain=domain,
            display_name=display_name,
            client_id=client_id,
            request_options=request_options,
        )
        return _response.data

    async def delete(
        self, pod_id: PodId, inbox_id: InboxId, *, request_options: typing.Optional[RequestOptions] = None
    ) -> None:
        """
        Parameters
        ----------
        pod_id : PodId

        inbox_id : InboxId

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        import asyncio

        from agentmail import AsyncAgentMail

        client = AsyncAgentMail(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.pods.inboxes.delete(
                pod_id="pod_id",
                inbox_id="inbox_id",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.delete(pod_id, inbox_id, request_options=request_options)
        return _response.data
