# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

import pydantic
from ...core.pydantic_utilities import IS_PYDANTIC_V2
from ...core.unchecked_base_model import UncheckedBaseModel
from .client_id import ClientId
from .name import Name
from .pod_id import PodId


class Pod(UncheckedBaseModel):
    pod_id: PodId
    name: Name
    updated_at: dt.datetime = pydantic.Field()
    """
    Time at which pod was last updated.
    """

    created_at: dt.datetime = pydantic.Field()
    """
    Time at which pod was created.
    """

    client_id: typing.Optional[ClientId] = None

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
