# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs

__all__ = [
    'AlertPolicyFilter',
    'AlertPolicyFilterCondition',
    'AlertPolicyResponder',
    'AlertPolicyTimeRestriction',
    'AlertPolicyTimeRestrictionRestriction',
    'AlertPolicyTimeRestrictionRestrictionList',
    'ApiIntegrationResponder',
    'EmailIntegrationResponder',
    'EscalationRepeat',
    'EscalationRule',
    'EscalationRuleRecipient',
    'IncidentTemplateStakeholderProperty',
    'IntegrationActionAcknowledge',
    'IntegrationActionAcknowledgeFilter',
    'IntegrationActionAcknowledgeFilterCondition',
    'IntegrationActionAddNote',
    'IntegrationActionAddNoteFilter',
    'IntegrationActionAddNoteFilterCondition',
    'IntegrationActionClose',
    'IntegrationActionCloseFilter',
    'IntegrationActionCloseFilterCondition',
    'IntegrationActionCreate',
    'IntegrationActionCreateFilter',
    'IntegrationActionCreateFilterCondition',
    'IntegrationActionCreateResponder',
    'IntegrationActionIgnore',
    'IntegrationActionIgnoreFilter',
    'IntegrationActionIgnoreFilterCondition',
    'MaintenanceRule',
    'MaintenanceRuleEntity',
    'MaintenanceTime',
    'NotificationPolicyAutoCloseAction',
    'NotificationPolicyAutoCloseActionDuration',
    'NotificationPolicyAutoRestartAction',
    'NotificationPolicyAutoRestartActionDuration',
    'NotificationPolicyDeDuplicationAction',
    'NotificationPolicyDeDuplicationActionDuration',
    'NotificationPolicyDelayAction',
    'NotificationPolicyDelayActionDuration',
    'NotificationPolicyFilter',
    'NotificationPolicyFilterCondition',
    'NotificationPolicyTimeRestriction',
    'NotificationPolicyTimeRestrictionRestriction',
    'NotificationPolicyTimeRestrictionRestrictionList',
    'NotificationRuleCriteria',
    'NotificationRuleCriteriaCondition',
    'NotificationRuleRepeat',
    'NotificationRuleSchedule',
    'NotificationRuleStep',
    'NotificationRuleStepContact',
    'NotificationRuleTimeRestriction',
    'NotificationRuleTimeRestrictionRestriction',
    'ScheduleRotationParticipant',
    'ScheduleRotationTimeRestriction',
    'ScheduleRotationTimeRestrictionRestriction',
    'ScheduleRotationTimeRestrictionRestrictionList',
    'ServiceIncidentRuleIncidentRule',
    'ServiceIncidentRuleIncidentRuleCondition',
    'ServiceIncidentRuleIncidentRuleIncidentProperty',
    'ServiceIncidentRuleIncidentRuleIncidentPropertyStakeholderProperty',
    'TeamMember',
    'TeamRoutingRuleCriteria',
    'TeamRoutingRuleCriteriaCondition',
    'TeamRoutingRuleNotify',
    'TeamRoutingRuleTimeRestriction',
    'TeamRoutingRuleTimeRestrictionRestriction',
    'TeamRoutingRuleTimeRestrictionRestrictionList',
    'UserUserAddress',
    'GetEscalationRepeatResult',
    'GetEscalationRuleResult',
    'GetEscalationRuleRecipientResult',
    'GetTeamMemberResult',
]

@pulumi.output_type
class AlertPolicyFilter(dict):
    def __init__(__self__, *,
                 conditions: Optional[Sequence['outputs.AlertPolicyFilterCondition']] = None,
                 type: Optional[_builtins.str] = None):
        """
        :param Sequence['AlertPolicyFilterConditionArgs'] conditions: Conditions applied to filter. This is a block, structure is documented below.
        :param _builtins.str type: A filter type, supported types are: `match-all`, `match-any-condition`, `match-all-conditions`. Default: `match-all`
        """
        if conditions is not None:
            pulumi.set(__self__, "conditions", conditions)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter
    def conditions(self) -> Optional[Sequence['outputs.AlertPolicyFilterCondition']]:
        """
        Conditions applied to filter. This is a block, structure is documented below.
        """
        return pulumi.get(self, "conditions")

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[_builtins.str]:
        """
        A filter type, supported types are: `match-all`, `match-any-condition`, `match-all-conditions`. Default: `match-all`
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class AlertPolicyFilterCondition(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "expectedValue":
            suggest = "expected_value"
        elif key == "not":
            suggest = "not_"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AlertPolicyFilterCondition. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AlertPolicyFilterCondition.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AlertPolicyFilterCondition.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 field: _builtins.str,
                 operation: _builtins.str,
                 expected_value: Optional[_builtins.str] = None,
                 key: Optional[_builtins.str] = None,
                 not_: Optional[_builtins.bool] = None,
                 order: Optional[_builtins.int] = None):
        """
        :param _builtins.str field: Specifies which alert field will be used in condition. Possible values are `message`, `alias`, `description`, `source`, `entity`, `tags`, `actions`, `details`, `extra-properties`, `responders`, `teams`, `priority`
        :param _builtins.str operation: It is the operation that will be executed for the given field and key. Possible operations are `matches`, `contains`, `starts-with`, `ends-with`, `equals`, `contains-key`, `contains-value`, `greater-than`, `less-than`, `is-empty`, `equals-ignore-whitespace`.
        :param _builtins.str expected_value: User defined value that will be compared with alert field according to the operation. Default: empty string
        :param _builtins.str key: If `field` is set as extra-properties, key could be used for key-value pair
        :param _builtins.bool not_: Indicates behaviour of the given operation. Default: `false`
        :param _builtins.int order: Order of the condition in conditions list
        """
        pulumi.set(__self__, "field", field)
        pulumi.set(__self__, "operation", operation)
        if expected_value is not None:
            pulumi.set(__self__, "expected_value", expected_value)
        if key is not None:
            pulumi.set(__self__, "key", key)
        if not_ is not None:
            pulumi.set(__self__, "not_", not_)
        if order is not None:
            pulumi.set(__self__, "order", order)

    @_builtins.property
    @pulumi.getter
    def field(self) -> _builtins.str:
        """
        Specifies which alert field will be used in condition. Possible values are `message`, `alias`, `description`, `source`, `entity`, `tags`, `actions`, `details`, `extra-properties`, `responders`, `teams`, `priority`
        """
        return pulumi.get(self, "field")

    @_builtins.property
    @pulumi.getter
    def operation(self) -> _builtins.str:
        """
        It is the operation that will be executed for the given field and key. Possible operations are `matches`, `contains`, `starts-with`, `ends-with`, `equals`, `contains-key`, `contains-value`, `greater-than`, `less-than`, `is-empty`, `equals-ignore-whitespace`.
        """
        return pulumi.get(self, "operation")

    @_builtins.property
    @pulumi.getter(name="expectedValue")
    def expected_value(self) -> Optional[_builtins.str]:
        """
        User defined value that will be compared with alert field according to the operation. Default: empty string
        """
        return pulumi.get(self, "expected_value")

    @_builtins.property
    @pulumi.getter
    def key(self) -> Optional[_builtins.str]:
        """
        If `field` is set as extra-properties, key could be used for key-value pair
        """
        return pulumi.get(self, "key")

    @_builtins.property
    @pulumi.getter(name="not")
    def not_(self) -> Optional[_builtins.bool]:
        """
        Indicates behaviour of the given operation. Default: `false`
        """
        return pulumi.get(self, "not_")

    @_builtins.property
    @pulumi.getter
    def order(self) -> Optional[_builtins.int]:
        """
        Order of the condition in conditions list
        """
        return pulumi.get(self, "order")


@pulumi.output_type
class AlertPolicyResponder(dict):
    def __init__(__self__, *,
                 id: _builtins.str,
                 type: _builtins.str,
                 name: Optional[_builtins.str] = None,
                 username: Optional[_builtins.str] = None):
        """
        :param _builtins.str id: ID of the responder
        :param _builtins.str type: Type of responder. Acceptable values are: `user`, `team`, `escalation` or `schedule`
        :param _builtins.str name: Name of the responder
        :param _builtins.str username: Username of the responder
        """
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "type", type)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if username is not None:
            pulumi.set(__self__, "username", username)

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        ID of the responder
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        Type of responder. Acceptable values are: `user`, `team`, `escalation` or `schedule`
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[_builtins.str]:
        """
        Name of the responder
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def username(self) -> Optional[_builtins.str]:
        """
        Username of the responder
        """
        return pulumi.get(self, "username")


@pulumi.output_type
class AlertPolicyTimeRestriction(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "restrictionList":
            suggest = "restriction_list"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AlertPolicyTimeRestriction. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AlertPolicyTimeRestriction.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AlertPolicyTimeRestriction.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 type: _builtins.str,
                 restriction: Optional[Sequence['outputs.AlertPolicyTimeRestrictionRestriction']] = None,
                 restriction_list: Optional[Sequence['outputs.AlertPolicyTimeRestrictionRestrictionList']] = None):
        """
        :param _builtins.str type: Defines if restriction should apply daily on given hours or on certain days and hours. Possible values are: `time-of-day`, `weekday-and-time-of-day`
        :param Sequence['AlertPolicyTimeRestrictionRestrictionArgs'] restriction: A definition of hourly definition applied daily, this has to be used with combination: type = `time-of-day`. This is a block, structure is documented below.
        :param Sequence['AlertPolicyTimeRestrictionRestrictionListArgs'] restriction_list: List of days and hours definitions for field type = `weekday-and-time-of-day`. This is a block, structure is documented below.
        """
        pulumi.set(__self__, "type", type)
        if restriction is not None:
            pulumi.set(__self__, "restriction", restriction)
        if restriction_list is not None:
            pulumi.set(__self__, "restriction_list", restriction_list)

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        Defines if restriction should apply daily on given hours or on certain days and hours. Possible values are: `time-of-day`, `weekday-and-time-of-day`
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter
    def restriction(self) -> Optional[Sequence['outputs.AlertPolicyTimeRestrictionRestriction']]:
        """
        A definition of hourly definition applied daily, this has to be used with combination: type = `time-of-day`. This is a block, structure is documented below.
        """
        return pulumi.get(self, "restriction")

    @_builtins.property
    @pulumi.getter(name="restrictionList")
    def restriction_list(self) -> Optional[Sequence['outputs.AlertPolicyTimeRestrictionRestrictionList']]:
        """
        List of days and hours definitions for field type = `weekday-and-time-of-day`. This is a block, structure is documented below.
        """
        return pulumi.get(self, "restriction_list")


@pulumi.output_type
class AlertPolicyTimeRestrictionRestriction(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "endHour":
            suggest = "end_hour"
        elif key == "endMin":
            suggest = "end_min"
        elif key == "startHour":
            suggest = "start_hour"
        elif key == "startMin":
            suggest = "start_min"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AlertPolicyTimeRestrictionRestriction. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AlertPolicyTimeRestrictionRestriction.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AlertPolicyTimeRestrictionRestriction.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 end_hour: _builtins.int,
                 end_min: _builtins.int,
                 start_hour: _builtins.int,
                 start_min: _builtins.int):
        """
        :param _builtins.int end_hour: Ending hour of restriction.
        :param _builtins.int end_min: Ending minute of restriction on defined `end_hour`
        :param _builtins.int start_hour: Starting hour of restriction.
        :param _builtins.int start_min: Staring minute of restriction on defined `start_hour`
        """
        pulumi.set(__self__, "end_hour", end_hour)
        pulumi.set(__self__, "end_min", end_min)
        pulumi.set(__self__, "start_hour", start_hour)
        pulumi.set(__self__, "start_min", start_min)

    @_builtins.property
    @pulumi.getter(name="endHour")
    def end_hour(self) -> _builtins.int:
        """
        Ending hour of restriction.
        """
        return pulumi.get(self, "end_hour")

    @_builtins.property
    @pulumi.getter(name="endMin")
    def end_min(self) -> _builtins.int:
        """
        Ending minute of restriction on defined `end_hour`
        """
        return pulumi.get(self, "end_min")

    @_builtins.property
    @pulumi.getter(name="startHour")
    def start_hour(self) -> _builtins.int:
        """
        Starting hour of restriction.
        """
        return pulumi.get(self, "start_hour")

    @_builtins.property
    @pulumi.getter(name="startMin")
    def start_min(self) -> _builtins.int:
        """
        Staring minute of restriction on defined `start_hour`
        """
        return pulumi.get(self, "start_min")


@pulumi.output_type
class AlertPolicyTimeRestrictionRestrictionList(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "endDay":
            suggest = "end_day"
        elif key == "endHour":
            suggest = "end_hour"
        elif key == "endMin":
            suggest = "end_min"
        elif key == "startDay":
            suggest = "start_day"
        elif key == "startHour":
            suggest = "start_hour"
        elif key == "startMin":
            suggest = "start_min"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AlertPolicyTimeRestrictionRestrictionList. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AlertPolicyTimeRestrictionRestrictionList.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AlertPolicyTimeRestrictionRestrictionList.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 end_day: _builtins.str,
                 end_hour: _builtins.int,
                 end_min: _builtins.int,
                 start_day: _builtins.str,
                 start_hour: _builtins.int,
                 start_min: _builtins.int):
        """
        :param _builtins.str end_day: Ending day of restriction (eg. `wednesday`)
        :param _builtins.int end_hour: Ending hour of restriction on defined `end_day`
        :param _builtins.int end_min: Ending minute of restriction on defined `end_hour`
        :param _builtins.str start_day: Starting day of restriction (eg. `monday`)
        :param _builtins.int start_hour: Starting hour of restriction on defined `start_day`
        :param _builtins.int start_min: Staring minute of restriction on defined `start_hour`
        """
        pulumi.set(__self__, "end_day", end_day)
        pulumi.set(__self__, "end_hour", end_hour)
        pulumi.set(__self__, "end_min", end_min)
        pulumi.set(__self__, "start_day", start_day)
        pulumi.set(__self__, "start_hour", start_hour)
        pulumi.set(__self__, "start_min", start_min)

    @_builtins.property
    @pulumi.getter(name="endDay")
    def end_day(self) -> _builtins.str:
        """
        Ending day of restriction (eg. `wednesday`)
        """
        return pulumi.get(self, "end_day")

    @_builtins.property
    @pulumi.getter(name="endHour")
    def end_hour(self) -> _builtins.int:
        """
        Ending hour of restriction on defined `end_day`
        """
        return pulumi.get(self, "end_hour")

    @_builtins.property
    @pulumi.getter(name="endMin")
    def end_min(self) -> _builtins.int:
        """
        Ending minute of restriction on defined `end_hour`
        """
        return pulumi.get(self, "end_min")

    @_builtins.property
    @pulumi.getter(name="startDay")
    def start_day(self) -> _builtins.str:
        """
        Starting day of restriction (eg. `monday`)
        """
        return pulumi.get(self, "start_day")

    @_builtins.property
    @pulumi.getter(name="startHour")
    def start_hour(self) -> _builtins.int:
        """
        Starting hour of restriction on defined `start_day`
        """
        return pulumi.get(self, "start_hour")

    @_builtins.property
    @pulumi.getter(name="startMin")
    def start_min(self) -> _builtins.int:
        """
        Staring minute of restriction on defined `start_hour`
        """
        return pulumi.get(self, "start_min")


@pulumi.output_type
class ApiIntegrationResponder(dict):
    def __init__(__self__, *,
                 id: Optional[_builtins.str] = None,
                 type: Optional[_builtins.str] = None):
        """
        :param _builtins.str id: The id of the responder.
        :param _builtins.str type: The responder type.
        """
        if id is not None:
            pulumi.set(__self__, "id", id)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter
    def id(self) -> Optional[_builtins.str]:
        """
        The id of the responder.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[_builtins.str]:
        """
        The responder type.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class EmailIntegrationResponder(dict):
    def __init__(__self__, *,
                 id: Optional[_builtins.str] = None,
                 type: Optional[_builtins.str] = None):
        """
        :param _builtins.str id: The ID of the Opsgenie Email based Integration.
        :param _builtins.str type: The responder type.
        """
        if id is not None:
            pulumi.set(__self__, "id", id)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter
    def id(self) -> Optional[_builtins.str]:
        """
        The ID of the Opsgenie Email based Integration.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[_builtins.str]:
        """
        The responder type.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class EscalationRepeat(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "closeAlertAfterAll":
            suggest = "close_alert_after_all"
        elif key == "resetRecipientStates":
            suggest = "reset_recipient_states"
        elif key == "waitInterval":
            suggest = "wait_interval"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EscalationRepeat. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EscalationRepeat.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EscalationRepeat.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 close_alert_after_all: Optional[_builtins.bool] = None,
                 count: Optional[_builtins.int] = None,
                 reset_recipient_states: Optional[_builtins.bool] = None,
                 wait_interval: Optional[_builtins.int] = None):
        if close_alert_after_all is not None:
            pulumi.set(__self__, "close_alert_after_all", close_alert_after_all)
        if count is not None:
            pulumi.set(__self__, "count", count)
        if reset_recipient_states is not None:
            pulumi.set(__self__, "reset_recipient_states", reset_recipient_states)
        if wait_interval is not None:
            pulumi.set(__self__, "wait_interval", wait_interval)

    @_builtins.property
    @pulumi.getter(name="closeAlertAfterAll")
    def close_alert_after_all(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "close_alert_after_all")

    @_builtins.property
    @pulumi.getter
    def count(self) -> Optional[_builtins.int]:
        return pulumi.get(self, "count")

    @_builtins.property
    @pulumi.getter(name="resetRecipientStates")
    def reset_recipient_states(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "reset_recipient_states")

    @_builtins.property
    @pulumi.getter(name="waitInterval")
    def wait_interval(self) -> Optional[_builtins.int]:
        return pulumi.get(self, "wait_interval")


@pulumi.output_type
class EscalationRule(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "notifyType":
            suggest = "notify_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EscalationRule. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EscalationRule.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EscalationRule.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 condition: _builtins.str,
                 delay: _builtins.int,
                 notify_type: _builtins.str,
                 recipients: Sequence['outputs.EscalationRuleRecipient']):
        """
        :param _builtins.str condition: The condition for notifying the recipient of escalation rule that is based on the alert state. Possible values are: `if-not-acked` and `if-not-closed`. Default: `if-not-acked`
        :param _builtins.int delay: Time delay of the escalation rule, in minutes.
        :param _builtins.str notify_type: Recipient calculation logic for schedules. Possible values are:
        :param Sequence['EscalationRuleRecipientArgs'] recipients: Object of schedule, team, or users which will be notified in escalation. The possible values for participants are: `user`, `schedule`, `team`. There can only be one recipient per each `rules`.
        """
        pulumi.set(__self__, "condition", condition)
        pulumi.set(__self__, "delay", delay)
        pulumi.set(__self__, "notify_type", notify_type)
        pulumi.set(__self__, "recipients", recipients)

    @_builtins.property
    @pulumi.getter
    def condition(self) -> _builtins.str:
        """
        The condition for notifying the recipient of escalation rule that is based on the alert state. Possible values are: `if-not-acked` and `if-not-closed`. Default: `if-not-acked`
        """
        return pulumi.get(self, "condition")

    @_builtins.property
    @pulumi.getter
    def delay(self) -> _builtins.int:
        """
        Time delay of the escalation rule, in minutes.
        """
        return pulumi.get(self, "delay")

    @_builtins.property
    @pulumi.getter(name="notifyType")
    def notify_type(self) -> _builtins.str:
        """
        Recipient calculation logic for schedules. Possible values are:
        """
        return pulumi.get(self, "notify_type")

    @_builtins.property
    @pulumi.getter
    def recipients(self) -> Sequence['outputs.EscalationRuleRecipient']:
        """
        Object of schedule, team, or users which will be notified in escalation. The possible values for participants are: `user`, `schedule`, `team`. There can only be one recipient per each `rules`.
        """
        return pulumi.get(self, "recipients")


@pulumi.output_type
class EscalationRuleRecipient(dict):
    def __init__(__self__, *,
                 id: Optional[_builtins.str] = None,
                 type: Optional[_builtins.str] = None):
        """
        :param _builtins.str id: The ID of the Opsgenie Escalation.
        """
        if id is not None:
            pulumi.set(__self__, "id", id)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter
    def id(self) -> Optional[_builtins.str]:
        """
        The ID of the Opsgenie Escalation.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "type")


@pulumi.output_type
class IncidentTemplateStakeholderProperty(dict):
    def __init__(__self__, *,
                 message: _builtins.str,
                 description: Optional[_builtins.str] = None,
                 enable: Optional[_builtins.bool] = None):
        """
        :param _builtins.str message: Message of the related incident template. This field must not be longer than 130 characters.
        :param _builtins.str description: Description field of the incident template. This field must not be longer than 10000 characters.
        :param _builtins.bool enable: Option to enable stakeholder notifications.Default value is true.
        """
        pulumi.set(__self__, "message", message)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if enable is not None:
            pulumi.set(__self__, "enable", enable)

    @_builtins.property
    @pulumi.getter
    def message(self) -> _builtins.str:
        """
        Message of the related incident template. This field must not be longer than 130 characters.
        """
        return pulumi.get(self, "message")

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[_builtins.str]:
        """
        Description field of the incident template. This field must not be longer than 10000 characters.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def enable(self) -> Optional[_builtins.bool]:
        """
        Option to enable stakeholder notifications.Default value is true.
        """
        return pulumi.get(self, "enable")


@pulumi.output_type
class IntegrationActionAcknowledge(dict):
    def __init__(__self__, *,
                 name: _builtins.str,
                 alias: Optional[_builtins.str] = None,
                 filters: Optional[Sequence['outputs.IntegrationActionAcknowledgeFilter']] = None,
                 note: Optional[_builtins.str] = None,
                 order: Optional[_builtins.int] = None,
                 type: Optional[_builtins.str] = None,
                 user: Optional[_builtins.str] = None):
        """
        :param _builtins.str name: Name of the integration action.
        :param _builtins.str alias: An identifier that is used for alert deduplication. Default: `{{alias}}`.
        :param Sequence['IntegrationActionAcknowledgeFilterArgs'] filters: Used to specify rules for matching alerts and the filter type. Please note that depending on the integration type the field names in the filter conditions are:
               * For SNS integration: `actions`, `alias`, `entity`, `Message`, `recipients`, `responders`, `Subject`, `tags`, `teams`, `eventType`, `Timestamp`, `TopicArn`.
               * For API integration: `message`, `alias`, `description`, `source`, `entity`, `tags`, `actions`, `details`, `extra-properties`, `recipients`, `teams`, `priority`, `eventType`.
               * For Email integration: `from_address`, `from_name`, `conversationSubject`, `subject`
        :param _builtins.str note: Additional alert action note.
        :param _builtins.int order: Integer value that defines in which order the action will be performed. Default: `1`.
        :param _builtins.str type: The responder type - can be `escalation`, `team` or `user`.
        :param _builtins.str user: Owner of the execution for integration action.
        """
        pulumi.set(__self__, "name", name)
        if alias is not None:
            pulumi.set(__self__, "alias", alias)
        if filters is not None:
            pulumi.set(__self__, "filters", filters)
        if note is not None:
            pulumi.set(__self__, "note", note)
        if order is not None:
            pulumi.set(__self__, "order", order)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if user is not None:
            pulumi.set(__self__, "user", user)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Name of the integration action.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def alias(self) -> Optional[_builtins.str]:
        """
        An identifier that is used for alert deduplication. Default: `{{alias}}`.
        """
        return pulumi.get(self, "alias")

    @_builtins.property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.IntegrationActionAcknowledgeFilter']]:
        """
        Used to specify rules for matching alerts and the filter type. Please note that depending on the integration type the field names in the filter conditions are:
        * For SNS integration: `actions`, `alias`, `entity`, `Message`, `recipients`, `responders`, `Subject`, `tags`, `teams`, `eventType`, `Timestamp`, `TopicArn`.
        * For API integration: `message`, `alias`, `description`, `source`, `entity`, `tags`, `actions`, `details`, `extra-properties`, `recipients`, `teams`, `priority`, `eventType`.
        * For Email integration: `from_address`, `from_name`, `conversationSubject`, `subject`
        """
        return pulumi.get(self, "filters")

    @_builtins.property
    @pulumi.getter
    def note(self) -> Optional[_builtins.str]:
        """
        Additional alert action note.
        """
        return pulumi.get(self, "note")

    @_builtins.property
    @pulumi.getter
    def order(self) -> Optional[_builtins.int]:
        """
        Integer value that defines in which order the action will be performed. Default: `1`.
        """
        return pulumi.get(self, "order")

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[_builtins.str]:
        """
        The responder type - can be `escalation`, `team` or `user`.
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter
    def user(self) -> Optional[_builtins.str]:
        """
        Owner of the execution for integration action.
        """
        return pulumi.get(self, "user")


@pulumi.output_type
class IntegrationActionAcknowledgeFilter(dict):
    def __init__(__self__, *,
                 type: _builtins.str,
                 conditions: Optional[Sequence['outputs.IntegrationActionAcknowledgeFilterCondition']] = None):
        """
        :param _builtins.str type: The responder type - can be `escalation`, `team` or `user`.
        """
        pulumi.set(__self__, "type", type)
        if conditions is not None:
            pulumi.set(__self__, "conditions", conditions)

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        The responder type - can be `escalation`, `team` or `user`.
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter
    def conditions(self) -> Optional[Sequence['outputs.IntegrationActionAcknowledgeFilterCondition']]:
        return pulumi.get(self, "conditions")


@pulumi.output_type
class IntegrationActionAcknowledgeFilterCondition(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "expectedValue":
            suggest = "expected_value"
        elif key == "not":
            suggest = "not_"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in IntegrationActionAcknowledgeFilterCondition. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        IntegrationActionAcknowledgeFilterCondition.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        IntegrationActionAcknowledgeFilterCondition.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 field: _builtins.str,
                 operation: _builtins.str,
                 expected_value: Optional[_builtins.str] = None,
                 key: Optional[_builtins.str] = None,
                 not_: Optional[_builtins.bool] = None,
                 order: Optional[_builtins.int] = None):
        """
        :param _builtins.int order: Integer value that defines in which order the action will be performed. Default: `1`.
        """
        pulumi.set(__self__, "field", field)
        pulumi.set(__self__, "operation", operation)
        if expected_value is not None:
            pulumi.set(__self__, "expected_value", expected_value)
        if key is not None:
            pulumi.set(__self__, "key", key)
        if not_ is not None:
            pulumi.set(__self__, "not_", not_)
        if order is not None:
            pulumi.set(__self__, "order", order)

    @_builtins.property
    @pulumi.getter
    def field(self) -> _builtins.str:
        return pulumi.get(self, "field")

    @_builtins.property
    @pulumi.getter
    def operation(self) -> _builtins.str:
        return pulumi.get(self, "operation")

    @_builtins.property
    @pulumi.getter(name="expectedValue")
    def expected_value(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "expected_value")

    @_builtins.property
    @pulumi.getter
    def key(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "key")

    @_builtins.property
    @pulumi.getter(name="not")
    def not_(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "not_")

    @_builtins.property
    @pulumi.getter
    def order(self) -> Optional[_builtins.int]:
        """
        Integer value that defines in which order the action will be performed. Default: `1`.
        """
        return pulumi.get(self, "order")


@pulumi.output_type
class IntegrationActionAddNote(dict):
    def __init__(__self__, *,
                 name: _builtins.str,
                 alias: Optional[_builtins.str] = None,
                 filters: Optional[Sequence['outputs.IntegrationActionAddNoteFilter']] = None,
                 note: Optional[_builtins.str] = None,
                 order: Optional[_builtins.int] = None,
                 type: Optional[_builtins.str] = None,
                 user: Optional[_builtins.str] = None):
        """
        :param _builtins.str name: Name of the integration action.
        :param _builtins.str alias: An identifier that is used for alert deduplication. Default: `{{alias}}`.
        :param Sequence['IntegrationActionAddNoteFilterArgs'] filters: Used to specify rules for matching alerts and the filter type. Please note that depending on the integration type the field names in the filter conditions are:
               * For SNS integration: `actions`, `alias`, `entity`, `Message`, `recipients`, `responders`, `Subject`, `tags`, `teams`, `eventType`, `Timestamp`, `TopicArn`.
               * For API integration: `message`, `alias`, `description`, `source`, `entity`, `tags`, `actions`, `details`, `extra-properties`, `recipients`, `teams`, `priority`, `eventType`.
               * For Email integration: `from_address`, `from_name`, `conversationSubject`, `subject`
        :param _builtins.str note: Additional alert action note.
        :param _builtins.int order: Integer value that defines in which order the action will be performed. Default: `1`.
        :param _builtins.str type: The responder type - can be `escalation`, `team` or `user`.
        :param _builtins.str user: Owner of the execution for integration action.
        """
        pulumi.set(__self__, "name", name)
        if alias is not None:
            pulumi.set(__self__, "alias", alias)
        if filters is not None:
            pulumi.set(__self__, "filters", filters)
        if note is not None:
            pulumi.set(__self__, "note", note)
        if order is not None:
            pulumi.set(__self__, "order", order)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if user is not None:
            pulumi.set(__self__, "user", user)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Name of the integration action.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def alias(self) -> Optional[_builtins.str]:
        """
        An identifier that is used for alert deduplication. Default: `{{alias}}`.
        """
        return pulumi.get(self, "alias")

    @_builtins.property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.IntegrationActionAddNoteFilter']]:
        """
        Used to specify rules for matching alerts and the filter type. Please note that depending on the integration type the field names in the filter conditions are:
        * For SNS integration: `actions`, `alias`, `entity`, `Message`, `recipients`, `responders`, `Subject`, `tags`, `teams`, `eventType`, `Timestamp`, `TopicArn`.
        * For API integration: `message`, `alias`, `description`, `source`, `entity`, `tags`, `actions`, `details`, `extra-properties`, `recipients`, `teams`, `priority`, `eventType`.
        * For Email integration: `from_address`, `from_name`, `conversationSubject`, `subject`
        """
        return pulumi.get(self, "filters")

    @_builtins.property
    @pulumi.getter
    def note(self) -> Optional[_builtins.str]:
        """
        Additional alert action note.
        """
        return pulumi.get(self, "note")

    @_builtins.property
    @pulumi.getter
    def order(self) -> Optional[_builtins.int]:
        """
        Integer value that defines in which order the action will be performed. Default: `1`.
        """
        return pulumi.get(self, "order")

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[_builtins.str]:
        """
        The responder type - can be `escalation`, `team` or `user`.
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter
    def user(self) -> Optional[_builtins.str]:
        """
        Owner of the execution for integration action.
        """
        return pulumi.get(self, "user")


@pulumi.output_type
class IntegrationActionAddNoteFilter(dict):
    def __init__(__self__, *,
                 type: _builtins.str,
                 conditions: Optional[Sequence['outputs.IntegrationActionAddNoteFilterCondition']] = None):
        """
        :param _builtins.str type: The responder type - can be `escalation`, `team` or `user`.
        """
        pulumi.set(__self__, "type", type)
        if conditions is not None:
            pulumi.set(__self__, "conditions", conditions)

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        The responder type - can be `escalation`, `team` or `user`.
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter
    def conditions(self) -> Optional[Sequence['outputs.IntegrationActionAddNoteFilterCondition']]:
        return pulumi.get(self, "conditions")


@pulumi.output_type
class IntegrationActionAddNoteFilterCondition(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "expectedValue":
            suggest = "expected_value"
        elif key == "not":
            suggest = "not_"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in IntegrationActionAddNoteFilterCondition. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        IntegrationActionAddNoteFilterCondition.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        IntegrationActionAddNoteFilterCondition.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 field: _builtins.str,
                 operation: _builtins.str,
                 expected_value: Optional[_builtins.str] = None,
                 key: Optional[_builtins.str] = None,
                 not_: Optional[_builtins.bool] = None,
                 order: Optional[_builtins.int] = None):
        """
        :param _builtins.int order: Integer value that defines in which order the action will be performed. Default: `1`.
        """
        pulumi.set(__self__, "field", field)
        pulumi.set(__self__, "operation", operation)
        if expected_value is not None:
            pulumi.set(__self__, "expected_value", expected_value)
        if key is not None:
            pulumi.set(__self__, "key", key)
        if not_ is not None:
            pulumi.set(__self__, "not_", not_)
        if order is not None:
            pulumi.set(__self__, "order", order)

    @_builtins.property
    @pulumi.getter
    def field(self) -> _builtins.str:
        return pulumi.get(self, "field")

    @_builtins.property
    @pulumi.getter
    def operation(self) -> _builtins.str:
        return pulumi.get(self, "operation")

    @_builtins.property
    @pulumi.getter(name="expectedValue")
    def expected_value(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "expected_value")

    @_builtins.property
    @pulumi.getter
    def key(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "key")

    @_builtins.property
    @pulumi.getter(name="not")
    def not_(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "not_")

    @_builtins.property
    @pulumi.getter
    def order(self) -> Optional[_builtins.int]:
        """
        Integer value that defines in which order the action will be performed. Default: `1`.
        """
        return pulumi.get(self, "order")


@pulumi.output_type
class IntegrationActionClose(dict):
    def __init__(__self__, *,
                 name: _builtins.str,
                 alias: Optional[_builtins.str] = None,
                 filters: Optional[Sequence['outputs.IntegrationActionCloseFilter']] = None,
                 note: Optional[_builtins.str] = None,
                 order: Optional[_builtins.int] = None,
                 type: Optional[_builtins.str] = None,
                 user: Optional[_builtins.str] = None):
        """
        :param _builtins.str name: Name of the integration action.
        :param _builtins.str alias: An identifier that is used for alert deduplication. Default: `{{alias}}`.
        :param Sequence['IntegrationActionCloseFilterArgs'] filters: Used to specify rules for matching alerts and the filter type. Please note that depending on the integration type the field names in the filter conditions are:
               * For SNS integration: `actions`, `alias`, `entity`, `Message`, `recipients`, `responders`, `Subject`, `tags`, `teams`, `eventType`, `Timestamp`, `TopicArn`.
               * For API integration: `message`, `alias`, `description`, `source`, `entity`, `tags`, `actions`, `details`, `extra-properties`, `recipients`, `teams`, `priority`, `eventType`.
               * For Email integration: `from_address`, `from_name`, `conversationSubject`, `subject`
        :param _builtins.str note: Additional alert action note.
        :param _builtins.int order: Integer value that defines in which order the action will be performed. Default: `1`.
        :param _builtins.str type: The responder type - can be `escalation`, `team` or `user`.
        :param _builtins.str user: Owner of the execution for integration action.
        """
        pulumi.set(__self__, "name", name)
        if alias is not None:
            pulumi.set(__self__, "alias", alias)
        if filters is not None:
            pulumi.set(__self__, "filters", filters)
        if note is not None:
            pulumi.set(__self__, "note", note)
        if order is not None:
            pulumi.set(__self__, "order", order)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if user is not None:
            pulumi.set(__self__, "user", user)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Name of the integration action.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def alias(self) -> Optional[_builtins.str]:
        """
        An identifier that is used for alert deduplication. Default: `{{alias}}`.
        """
        return pulumi.get(self, "alias")

    @_builtins.property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.IntegrationActionCloseFilter']]:
        """
        Used to specify rules for matching alerts and the filter type. Please note that depending on the integration type the field names in the filter conditions are:
        * For SNS integration: `actions`, `alias`, `entity`, `Message`, `recipients`, `responders`, `Subject`, `tags`, `teams`, `eventType`, `Timestamp`, `TopicArn`.
        * For API integration: `message`, `alias`, `description`, `source`, `entity`, `tags`, `actions`, `details`, `extra-properties`, `recipients`, `teams`, `priority`, `eventType`.
        * For Email integration: `from_address`, `from_name`, `conversationSubject`, `subject`
        """
        return pulumi.get(self, "filters")

    @_builtins.property
    @pulumi.getter
    def note(self) -> Optional[_builtins.str]:
        """
        Additional alert action note.
        """
        return pulumi.get(self, "note")

    @_builtins.property
    @pulumi.getter
    def order(self) -> Optional[_builtins.int]:
        """
        Integer value that defines in which order the action will be performed. Default: `1`.
        """
        return pulumi.get(self, "order")

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[_builtins.str]:
        """
        The responder type - can be `escalation`, `team` or `user`.
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter
    def user(self) -> Optional[_builtins.str]:
        """
        Owner of the execution for integration action.
        """
        return pulumi.get(self, "user")


@pulumi.output_type
class IntegrationActionCloseFilter(dict):
    def __init__(__self__, *,
                 type: _builtins.str,
                 conditions: Optional[Sequence['outputs.IntegrationActionCloseFilterCondition']] = None):
        """
        :param _builtins.str type: The responder type - can be `escalation`, `team` or `user`.
        """
        pulumi.set(__self__, "type", type)
        if conditions is not None:
            pulumi.set(__self__, "conditions", conditions)

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        The responder type - can be `escalation`, `team` or `user`.
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter
    def conditions(self) -> Optional[Sequence['outputs.IntegrationActionCloseFilterCondition']]:
        return pulumi.get(self, "conditions")


@pulumi.output_type
class IntegrationActionCloseFilterCondition(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "expectedValue":
            suggest = "expected_value"
        elif key == "not":
            suggest = "not_"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in IntegrationActionCloseFilterCondition. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        IntegrationActionCloseFilterCondition.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        IntegrationActionCloseFilterCondition.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 field: _builtins.str,
                 operation: _builtins.str,
                 expected_value: Optional[_builtins.str] = None,
                 key: Optional[_builtins.str] = None,
                 not_: Optional[_builtins.bool] = None,
                 order: Optional[_builtins.int] = None):
        """
        :param _builtins.int order: Integer value that defines in which order the action will be performed. Default: `1`.
        """
        pulumi.set(__self__, "field", field)
        pulumi.set(__self__, "operation", operation)
        if expected_value is not None:
            pulumi.set(__self__, "expected_value", expected_value)
        if key is not None:
            pulumi.set(__self__, "key", key)
        if not_ is not None:
            pulumi.set(__self__, "not_", not_)
        if order is not None:
            pulumi.set(__self__, "order", order)

    @_builtins.property
    @pulumi.getter
    def field(self) -> _builtins.str:
        return pulumi.get(self, "field")

    @_builtins.property
    @pulumi.getter
    def operation(self) -> _builtins.str:
        return pulumi.get(self, "operation")

    @_builtins.property
    @pulumi.getter(name="expectedValue")
    def expected_value(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "expected_value")

    @_builtins.property
    @pulumi.getter
    def key(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "key")

    @_builtins.property
    @pulumi.getter(name="not")
    def not_(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "not_")

    @_builtins.property
    @pulumi.getter
    def order(self) -> Optional[_builtins.int]:
        """
        Integer value that defines in which order the action will be performed. Default: `1`.
        """
        return pulumi.get(self, "order")


@pulumi.output_type
class IntegrationActionCreate(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "alertActions":
            suggest = "alert_actions"
        elif key == "appendAttachments":
            suggest = "append_attachments"
        elif key == "customPriority":
            suggest = "custom_priority"
        elif key == "extraProperties":
            suggest = "extra_properties"
        elif key == "ignoreAlertActionsFromPayload":
            suggest = "ignore_alert_actions_from_payload"
        elif key == "ignoreExtraPropertiesFromPayload":
            suggest = "ignore_extra_properties_from_payload"
        elif key == "ignoreRespondersFromPayload":
            suggest = "ignore_responders_from_payload"
        elif key == "ignoreTagsFromPayload":
            suggest = "ignore_tags_from_payload"
        elif key == "ignoreTeamsFromPayload":
            suggest = "ignore_teams_from_payload"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in IntegrationActionCreate. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        IntegrationActionCreate.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        IntegrationActionCreate.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: _builtins.str,
                 alert_actions: Optional[Sequence[_builtins.str]] = None,
                 alias: Optional[_builtins.str] = None,
                 append_attachments: Optional[_builtins.bool] = None,
                 custom_priority: Optional[_builtins.str] = None,
                 description: Optional[_builtins.str] = None,
                 entity: Optional[_builtins.str] = None,
                 extra_properties: Optional[Mapping[str, _builtins.str]] = None,
                 filters: Optional[Sequence['outputs.IntegrationActionCreateFilter']] = None,
                 ignore_alert_actions_from_payload: Optional[_builtins.bool] = None,
                 ignore_extra_properties_from_payload: Optional[_builtins.bool] = None,
                 ignore_responders_from_payload: Optional[_builtins.bool] = None,
                 ignore_tags_from_payload: Optional[_builtins.bool] = None,
                 ignore_teams_from_payload: Optional[_builtins.bool] = None,
                 message: Optional[_builtins.str] = None,
                 note: Optional[_builtins.str] = None,
                 order: Optional[_builtins.int] = None,
                 priority: Optional[_builtins.str] = None,
                 responders: Optional[Sequence['outputs.IntegrationActionCreateResponder']] = None,
                 source: Optional[_builtins.str] = None,
                 tags: Optional[Sequence[_builtins.str]] = None,
                 type: Optional[_builtins.str] = None,
                 user: Optional[_builtins.str] = None):
        """
        :param _builtins.str name: Name of the integration action.
        :param _builtins.str alias: An identifier that is used for alert deduplication. Default: `{{alias}}`.
        :param _builtins.str custom_priority: Custom alert priority. e.g. ``{{message.substring(0,2)}}``
        :param _builtins.str description: Detailed description of the alert, anything that may not have fit in the `message` field.
        :param _builtins.str entity: The entity the alert is related to.
        :param Mapping[str, _builtins.str] extra_properties: Set of user defined properties specified as a map.
        :param Sequence['IntegrationActionCreateFilterArgs'] filters: Used to specify rules for matching alerts and the filter type. Please note that depending on the integration type the field names in the filter conditions are:
               * For SNS integration: `actions`, `alias`, `entity`, `Message`, `recipients`, `responders`, `Subject`, `tags`, `teams`, `eventType`, `Timestamp`, `TopicArn`.
               * For API integration: `message`, `alias`, `description`, `source`, `entity`, `tags`, `actions`, `details`, `extra-properties`, `recipients`, `teams`, `priority`, `eventType`.
               * For Email integration: `from_address`, `from_name`, `conversationSubject`, `subject`
        :param _builtins.bool ignore_responders_from_payload: If enabled, the integration will ignore responders sent in request payloads.
        :param _builtins.bool ignore_teams_from_payload: If enabled, the integration will ignore teams sent in request payloads.
        :param _builtins.str message: Alert text limited to 130 characters.
        :param _builtins.str note: Additional alert action note.
        :param _builtins.int order: Integer value that defines in which order the action will be performed. Default: `1`.
        :param _builtins.str priority: Alert priority.
        :param Sequence['IntegrationActionCreateResponderArgs'] responders: User, schedule, teams or escalation names to calculate which users will receive notifications of the alert.
        :param _builtins.str source: User defined field to specify source of action.
        :param Sequence[_builtins.str] tags: Comma separated list of labels to be attached to the alert.
        :param _builtins.str type: The responder type - can be `escalation`, `team` or `user`.
        :param _builtins.str user: Owner of the execution for integration action.
        """
        pulumi.set(__self__, "name", name)
        if alert_actions is not None:
            pulumi.set(__self__, "alert_actions", alert_actions)
        if alias is not None:
            pulumi.set(__self__, "alias", alias)
        if append_attachments is not None:
            pulumi.set(__self__, "append_attachments", append_attachments)
        if custom_priority is not None:
            pulumi.set(__self__, "custom_priority", custom_priority)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if entity is not None:
            pulumi.set(__self__, "entity", entity)
        if extra_properties is not None:
            pulumi.set(__self__, "extra_properties", extra_properties)
        if filters is not None:
            pulumi.set(__self__, "filters", filters)
        if ignore_alert_actions_from_payload is not None:
            pulumi.set(__self__, "ignore_alert_actions_from_payload", ignore_alert_actions_from_payload)
        if ignore_extra_properties_from_payload is not None:
            pulumi.set(__self__, "ignore_extra_properties_from_payload", ignore_extra_properties_from_payload)
        if ignore_responders_from_payload is not None:
            pulumi.set(__self__, "ignore_responders_from_payload", ignore_responders_from_payload)
        if ignore_tags_from_payload is not None:
            pulumi.set(__self__, "ignore_tags_from_payload", ignore_tags_from_payload)
        if ignore_teams_from_payload is not None:
            pulumi.set(__self__, "ignore_teams_from_payload", ignore_teams_from_payload)
        if message is not None:
            pulumi.set(__self__, "message", message)
        if note is not None:
            pulumi.set(__self__, "note", note)
        if order is not None:
            pulumi.set(__self__, "order", order)
        if priority is not None:
            pulumi.set(__self__, "priority", priority)
        if responders is not None:
            pulumi.set(__self__, "responders", responders)
        if source is not None:
            pulumi.set(__self__, "source", source)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if user is not None:
            pulumi.set(__self__, "user", user)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Name of the integration action.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="alertActions")
    def alert_actions(self) -> Optional[Sequence[_builtins.str]]:
        return pulumi.get(self, "alert_actions")

    @_builtins.property
    @pulumi.getter
    def alias(self) -> Optional[_builtins.str]:
        """
        An identifier that is used for alert deduplication. Default: `{{alias}}`.
        """
        return pulumi.get(self, "alias")

    @_builtins.property
    @pulumi.getter(name="appendAttachments")
    def append_attachments(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "append_attachments")

    @_builtins.property
    @pulumi.getter(name="customPriority")
    def custom_priority(self) -> Optional[_builtins.str]:
        """
        Custom alert priority. e.g. ``{{message.substring(0,2)}}``
        """
        return pulumi.get(self, "custom_priority")

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[_builtins.str]:
        """
        Detailed description of the alert, anything that may not have fit in the `message` field.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def entity(self) -> Optional[_builtins.str]:
        """
        The entity the alert is related to.
        """
        return pulumi.get(self, "entity")

    @_builtins.property
    @pulumi.getter(name="extraProperties")
    def extra_properties(self) -> Optional[Mapping[str, _builtins.str]]:
        """
        Set of user defined properties specified as a map.
        """
        return pulumi.get(self, "extra_properties")

    @_builtins.property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.IntegrationActionCreateFilter']]:
        """
        Used to specify rules for matching alerts and the filter type. Please note that depending on the integration type the field names in the filter conditions are:
        * For SNS integration: `actions`, `alias`, `entity`, `Message`, `recipients`, `responders`, `Subject`, `tags`, `teams`, `eventType`, `Timestamp`, `TopicArn`.
        * For API integration: `message`, `alias`, `description`, `source`, `entity`, `tags`, `actions`, `details`, `extra-properties`, `recipients`, `teams`, `priority`, `eventType`.
        * For Email integration: `from_address`, `from_name`, `conversationSubject`, `subject`
        """
        return pulumi.get(self, "filters")

    @_builtins.property
    @pulumi.getter(name="ignoreAlertActionsFromPayload")
    def ignore_alert_actions_from_payload(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "ignore_alert_actions_from_payload")

    @_builtins.property
    @pulumi.getter(name="ignoreExtraPropertiesFromPayload")
    def ignore_extra_properties_from_payload(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "ignore_extra_properties_from_payload")

    @_builtins.property
    @pulumi.getter(name="ignoreRespondersFromPayload")
    def ignore_responders_from_payload(self) -> Optional[_builtins.bool]:
        """
        If enabled, the integration will ignore responders sent in request payloads.
        """
        return pulumi.get(self, "ignore_responders_from_payload")

    @_builtins.property
    @pulumi.getter(name="ignoreTagsFromPayload")
    def ignore_tags_from_payload(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "ignore_tags_from_payload")

    @_builtins.property
    @pulumi.getter(name="ignoreTeamsFromPayload")
    def ignore_teams_from_payload(self) -> Optional[_builtins.bool]:
        """
        If enabled, the integration will ignore teams sent in request payloads.
        """
        return pulumi.get(self, "ignore_teams_from_payload")

    @_builtins.property
    @pulumi.getter
    def message(self) -> Optional[_builtins.str]:
        """
        Alert text limited to 130 characters.
        """
        return pulumi.get(self, "message")

    @_builtins.property
    @pulumi.getter
    def note(self) -> Optional[_builtins.str]:
        """
        Additional alert action note.
        """
        return pulumi.get(self, "note")

    @_builtins.property
    @pulumi.getter
    def order(self) -> Optional[_builtins.int]:
        """
        Integer value that defines in which order the action will be performed. Default: `1`.
        """
        return pulumi.get(self, "order")

    @_builtins.property
    @pulumi.getter
    def priority(self) -> Optional[_builtins.str]:
        """
        Alert priority.
        """
        return pulumi.get(self, "priority")

    @_builtins.property
    @pulumi.getter
    def responders(self) -> Optional[Sequence['outputs.IntegrationActionCreateResponder']]:
        """
        User, schedule, teams or escalation names to calculate which users will receive notifications of the alert.
        """
        return pulumi.get(self, "responders")

    @_builtins.property
    @pulumi.getter
    def source(self) -> Optional[_builtins.str]:
        """
        User defined field to specify source of action.
        """
        return pulumi.get(self, "source")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[Sequence[_builtins.str]]:
        """
        Comma separated list of labels to be attached to the alert.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[_builtins.str]:
        """
        The responder type - can be `escalation`, `team` or `user`.
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter
    def user(self) -> Optional[_builtins.str]:
        """
        Owner of the execution for integration action.
        """
        return pulumi.get(self, "user")


@pulumi.output_type
class IntegrationActionCreateFilter(dict):
    def __init__(__self__, *,
                 type: _builtins.str,
                 conditions: Optional[Sequence['outputs.IntegrationActionCreateFilterCondition']] = None):
        """
        :param _builtins.str type: The responder type - can be `escalation`, `team` or `user`.
        """
        pulumi.set(__self__, "type", type)
        if conditions is not None:
            pulumi.set(__self__, "conditions", conditions)

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        The responder type - can be `escalation`, `team` or `user`.
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter
    def conditions(self) -> Optional[Sequence['outputs.IntegrationActionCreateFilterCondition']]:
        return pulumi.get(self, "conditions")


@pulumi.output_type
class IntegrationActionCreateFilterCondition(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "expectedValue":
            suggest = "expected_value"
        elif key == "not":
            suggest = "not_"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in IntegrationActionCreateFilterCondition. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        IntegrationActionCreateFilterCondition.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        IntegrationActionCreateFilterCondition.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 field: _builtins.str,
                 operation: _builtins.str,
                 expected_value: Optional[_builtins.str] = None,
                 key: Optional[_builtins.str] = None,
                 not_: Optional[_builtins.bool] = None,
                 order: Optional[_builtins.int] = None):
        """
        :param _builtins.int order: Integer value that defines in which order the action will be performed. Default: `1`.
        """
        pulumi.set(__self__, "field", field)
        pulumi.set(__self__, "operation", operation)
        if expected_value is not None:
            pulumi.set(__self__, "expected_value", expected_value)
        if key is not None:
            pulumi.set(__self__, "key", key)
        if not_ is not None:
            pulumi.set(__self__, "not_", not_)
        if order is not None:
            pulumi.set(__self__, "order", order)

    @_builtins.property
    @pulumi.getter
    def field(self) -> _builtins.str:
        return pulumi.get(self, "field")

    @_builtins.property
    @pulumi.getter
    def operation(self) -> _builtins.str:
        return pulumi.get(self, "operation")

    @_builtins.property
    @pulumi.getter(name="expectedValue")
    def expected_value(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "expected_value")

    @_builtins.property
    @pulumi.getter
    def key(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "key")

    @_builtins.property
    @pulumi.getter(name="not")
    def not_(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "not_")

    @_builtins.property
    @pulumi.getter
    def order(self) -> Optional[_builtins.int]:
        """
        Integer value that defines in which order the action will be performed. Default: `1`.
        """
        return pulumi.get(self, "order")


@pulumi.output_type
class IntegrationActionCreateResponder(dict):
    def __init__(__self__, *,
                 id: _builtins.str,
                 type: _builtins.str):
        """
        :param _builtins.str id: The id of the responder.
        :param _builtins.str type: The responder type - can be `escalation`, `team` or `user`.
        """
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The id of the responder.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        The responder type - can be `escalation`, `team` or `user`.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class IntegrationActionIgnore(dict):
    def __init__(__self__, *,
                 name: _builtins.str,
                 filters: Optional[Sequence['outputs.IntegrationActionIgnoreFilter']] = None,
                 order: Optional[_builtins.int] = None,
                 type: Optional[_builtins.str] = None):
        """
        :param _builtins.str name: Name of the integration action.
        :param Sequence['IntegrationActionIgnoreFilterArgs'] filters: Used to specify rules for matching alerts and the filter type. Please note that depending on the integration type the field names in the filter conditions are:
               * For SNS integration: `actions`, `alias`, `entity`, `Message`, `recipients`, `responders`, `Subject`, `tags`, `teams`, `eventType`, `Timestamp`, `TopicArn`.
               * For API integration: `message`, `alias`, `description`, `source`, `entity`, `tags`, `actions`, `details`, `extra-properties`, `recipients`, `teams`, `priority`, `eventType`.
               * For Email integration: `from_address`, `from_name`, `conversationSubject`, `subject`
        :param _builtins.int order: Integer value that defines in which order the action will be performed. Default: `1`.
        :param _builtins.str type: The responder type - can be `escalation`, `team` or `user`.
        """
        pulumi.set(__self__, "name", name)
        if filters is not None:
            pulumi.set(__self__, "filters", filters)
        if order is not None:
            pulumi.set(__self__, "order", order)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Name of the integration action.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.IntegrationActionIgnoreFilter']]:
        """
        Used to specify rules for matching alerts and the filter type. Please note that depending on the integration type the field names in the filter conditions are:
        * For SNS integration: `actions`, `alias`, `entity`, `Message`, `recipients`, `responders`, `Subject`, `tags`, `teams`, `eventType`, `Timestamp`, `TopicArn`.
        * For API integration: `message`, `alias`, `description`, `source`, `entity`, `tags`, `actions`, `details`, `extra-properties`, `recipients`, `teams`, `priority`, `eventType`.
        * For Email integration: `from_address`, `from_name`, `conversationSubject`, `subject`
        """
        return pulumi.get(self, "filters")

    @_builtins.property
    @pulumi.getter
    def order(self) -> Optional[_builtins.int]:
        """
        Integer value that defines in which order the action will be performed. Default: `1`.
        """
        return pulumi.get(self, "order")

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[_builtins.str]:
        """
        The responder type - can be `escalation`, `team` or `user`.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class IntegrationActionIgnoreFilter(dict):
    def __init__(__self__, *,
                 type: _builtins.str,
                 conditions: Optional[Sequence['outputs.IntegrationActionIgnoreFilterCondition']] = None):
        """
        :param _builtins.str type: The responder type - can be `escalation`, `team` or `user`.
        """
        pulumi.set(__self__, "type", type)
        if conditions is not None:
            pulumi.set(__self__, "conditions", conditions)

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        The responder type - can be `escalation`, `team` or `user`.
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter
    def conditions(self) -> Optional[Sequence['outputs.IntegrationActionIgnoreFilterCondition']]:
        return pulumi.get(self, "conditions")


@pulumi.output_type
class IntegrationActionIgnoreFilterCondition(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "expectedValue":
            suggest = "expected_value"
        elif key == "not":
            suggest = "not_"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in IntegrationActionIgnoreFilterCondition. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        IntegrationActionIgnoreFilterCondition.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        IntegrationActionIgnoreFilterCondition.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 field: _builtins.str,
                 operation: _builtins.str,
                 expected_value: Optional[_builtins.str] = None,
                 key: Optional[_builtins.str] = None,
                 not_: Optional[_builtins.bool] = None,
                 order: Optional[_builtins.int] = None):
        """
        :param _builtins.int order: Integer value that defines in which order the action will be performed. Default: `1`.
        """
        pulumi.set(__self__, "field", field)
        pulumi.set(__self__, "operation", operation)
        if expected_value is not None:
            pulumi.set(__self__, "expected_value", expected_value)
        if key is not None:
            pulumi.set(__self__, "key", key)
        if not_ is not None:
            pulumi.set(__self__, "not_", not_)
        if order is not None:
            pulumi.set(__self__, "order", order)

    @_builtins.property
    @pulumi.getter
    def field(self) -> _builtins.str:
        return pulumi.get(self, "field")

    @_builtins.property
    @pulumi.getter
    def operation(self) -> _builtins.str:
        return pulumi.get(self, "operation")

    @_builtins.property
    @pulumi.getter(name="expectedValue")
    def expected_value(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "expected_value")

    @_builtins.property
    @pulumi.getter
    def key(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "key")

    @_builtins.property
    @pulumi.getter(name="not")
    def not_(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "not_")

    @_builtins.property
    @pulumi.getter
    def order(self) -> Optional[_builtins.int]:
        """
        Integer value that defines in which order the action will be performed. Default: `1`.
        """
        return pulumi.get(self, "order")


@pulumi.output_type
class MaintenanceRule(dict):
    def __init__(__self__, *,
                 entities: Sequence['outputs.MaintenanceRuleEntity'],
                 state: Optional[_builtins.str] = None):
        """
        :param Sequence['MaintenanceRuleEntityArgs'] entities: This field represents the entity that maintenance will be applied. Entity field takes two mandatory fields as id and type.
        :param _builtins.str state: State of rule that will be defined in maintenance and can take either enabled or disabled for policy type rules. This field has to be disabled for integration type entity rules.
        """
        pulumi.set(__self__, "entities", entities)
        if state is not None:
            pulumi.set(__self__, "state", state)

    @_builtins.property
    @pulumi.getter
    def entities(self) -> Sequence['outputs.MaintenanceRuleEntity']:
        """
        This field represents the entity that maintenance will be applied. Entity field takes two mandatory fields as id and type.
        """
        return pulumi.get(self, "entities")

    @_builtins.property
    @pulumi.getter
    def state(self) -> Optional[_builtins.str]:
        """
        State of rule that will be defined in maintenance and can take either enabled or disabled for policy type rules. This field has to be disabled for integration type entity rules.
        """
        return pulumi.get(self, "state")


@pulumi.output_type
class MaintenanceRuleEntity(dict):
    def __init__(__self__, *,
                 id: Optional[_builtins.str] = None,
                 type: Optional[_builtins.str] = None):
        """
        :param _builtins.str id: The id of the entity that maintenance will be applied.
        :param _builtins.str type: The type of the entity that maintenance will be applied. It can be either integration or policy.
        """
        if id is not None:
            pulumi.set(__self__, "id", id)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter
    def id(self) -> Optional[_builtins.str]:
        """
        The id of the entity that maintenance will be applied.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[_builtins.str]:
        """
        The type of the entity that maintenance will be applied. It can be either integration or policy.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class MaintenanceTime(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "endDate":
            suggest = "end_date"
        elif key == "startDate":
            suggest = "start_date"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MaintenanceTime. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MaintenanceTime.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MaintenanceTime.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 type: _builtins.str,
                 end_date: Optional[_builtins.str] = None,
                 start_date: Optional[_builtins.str] = None):
        """
        :param _builtins.str end_date: This parameter takes a date format as (yyyy-MM-dd'T'HH:mm:ssZ) (e.g. 2019-06-11T08:00:00+02:00).
        :param _builtins.str start_date: This parameter takes a date format as (yyyy-MM-dd'T'HH:mm:ssZ) (e.g. 2019-06-11T08:00:00+02:00).
        """
        pulumi.set(__self__, "type", type)
        if end_date is not None:
            pulumi.set(__self__, "end_date", end_date)
        if start_date is not None:
            pulumi.set(__self__, "start_date", start_date)

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter(name="endDate")
    def end_date(self) -> Optional[_builtins.str]:
        """
        This parameter takes a date format as (yyyy-MM-dd'T'HH:mm:ssZ) (e.g. 2019-06-11T08:00:00+02:00).
        """
        return pulumi.get(self, "end_date")

    @_builtins.property
    @pulumi.getter(name="startDate")
    def start_date(self) -> Optional[_builtins.str]:
        """
        This parameter takes a date format as (yyyy-MM-dd'T'HH:mm:ssZ) (e.g. 2019-06-11T08:00:00+02:00).
        """
        return pulumi.get(self, "start_date")


@pulumi.output_type
class NotificationPolicyAutoCloseAction(dict):
    def __init__(__self__, *,
                 durations: Sequence['outputs.NotificationPolicyAutoCloseActionDuration']):
        """
        :param Sequence['NotificationPolicyAutoCloseActionDurationArgs'] durations: Duration of this action. This is a block, structure is documented below.
        """
        pulumi.set(__self__, "durations", durations)

    @_builtins.property
    @pulumi.getter
    def durations(self) -> Sequence['outputs.NotificationPolicyAutoCloseActionDuration']:
        """
        Duration of this action. This is a block, structure is documented below.
        """
        return pulumi.get(self, "durations")


@pulumi.output_type
class NotificationPolicyAutoCloseActionDuration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "timeAmount":
            suggest = "time_amount"
        elif key == "timeUnit":
            suggest = "time_unit"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NotificationPolicyAutoCloseActionDuration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NotificationPolicyAutoCloseActionDuration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NotificationPolicyAutoCloseActionDuration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 time_amount: _builtins.int,
                 time_unit: Optional[_builtins.str] = None):
        """
        :param _builtins.int time_amount: A amount of time in `time_units`. This is a integer attribute.
        :param _builtins.str time_unit: Valid time units are: `minutes`, `hours`, `days`. Default: `minutes`
        """
        pulumi.set(__self__, "time_amount", time_amount)
        if time_unit is not None:
            pulumi.set(__self__, "time_unit", time_unit)

    @_builtins.property
    @pulumi.getter(name="timeAmount")
    def time_amount(self) -> _builtins.int:
        """
        A amount of time in `time_units`. This is a integer attribute.
        """
        return pulumi.get(self, "time_amount")

    @_builtins.property
    @pulumi.getter(name="timeUnit")
    def time_unit(self) -> Optional[_builtins.str]:
        """
        Valid time units are: `minutes`, `hours`, `days`. Default: `minutes`
        """
        return pulumi.get(self, "time_unit")


@pulumi.output_type
class NotificationPolicyAutoRestartAction(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "maxRepeatCount":
            suggest = "max_repeat_count"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NotificationPolicyAutoRestartAction. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NotificationPolicyAutoRestartAction.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NotificationPolicyAutoRestartAction.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 durations: Sequence['outputs.NotificationPolicyAutoRestartActionDuration'],
                 max_repeat_count: _builtins.int):
        """
        :param Sequence['NotificationPolicyAutoRestartActionDurationArgs'] durations: Duration of this action. This is a block, structure is documented below.
        :param _builtins.int max_repeat_count: How many times to repeat. This is a integer attribute.
        """
        pulumi.set(__self__, "durations", durations)
        pulumi.set(__self__, "max_repeat_count", max_repeat_count)

    @_builtins.property
    @pulumi.getter
    def durations(self) -> Sequence['outputs.NotificationPolicyAutoRestartActionDuration']:
        """
        Duration of this action. This is a block, structure is documented below.
        """
        return pulumi.get(self, "durations")

    @_builtins.property
    @pulumi.getter(name="maxRepeatCount")
    def max_repeat_count(self) -> _builtins.int:
        """
        How many times to repeat. This is a integer attribute.
        """
        return pulumi.get(self, "max_repeat_count")


@pulumi.output_type
class NotificationPolicyAutoRestartActionDuration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "timeAmount":
            suggest = "time_amount"
        elif key == "timeUnit":
            suggest = "time_unit"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NotificationPolicyAutoRestartActionDuration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NotificationPolicyAutoRestartActionDuration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NotificationPolicyAutoRestartActionDuration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 time_amount: _builtins.int,
                 time_unit: Optional[_builtins.str] = None):
        """
        :param _builtins.int time_amount: A amount of time in `time_units`. This is a integer attribute.
        :param _builtins.str time_unit: Valid time units are: `minutes`, `hours`, `days`. Default: `minutes`
        """
        pulumi.set(__self__, "time_amount", time_amount)
        if time_unit is not None:
            pulumi.set(__self__, "time_unit", time_unit)

    @_builtins.property
    @pulumi.getter(name="timeAmount")
    def time_amount(self) -> _builtins.int:
        """
        A amount of time in `time_units`. This is a integer attribute.
        """
        return pulumi.get(self, "time_amount")

    @_builtins.property
    @pulumi.getter(name="timeUnit")
    def time_unit(self) -> Optional[_builtins.str]:
        """
        Valid time units are: `minutes`, `hours`, `days`. Default: `minutes`
        """
        return pulumi.get(self, "time_unit")


@pulumi.output_type
class NotificationPolicyDeDuplicationAction(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "deDuplicationActionType":
            suggest = "de_duplication_action_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NotificationPolicyDeDuplicationAction. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NotificationPolicyDeDuplicationAction.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NotificationPolicyDeDuplicationAction.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 count: _builtins.int,
                 de_duplication_action_type: _builtins.str,
                 durations: Optional[Sequence['outputs.NotificationPolicyDeDuplicationActionDuration']] = None):
        """
        :param _builtins.int count: Count
        :param _builtins.str de_duplication_action_type: Deduplication type. Possible values are: "value-based", "frequency-based"
        :param Sequence['NotificationPolicyDeDuplicationActionDurationArgs'] durations: Duration of this action (only required for "frequency-based" de-duplication action). This is a block, structure is documented below.
        """
        pulumi.set(__self__, "count", count)
        pulumi.set(__self__, "de_duplication_action_type", de_duplication_action_type)
        if durations is not None:
            pulumi.set(__self__, "durations", durations)

    @_builtins.property
    @pulumi.getter
    def count(self) -> _builtins.int:
        """
        Count
        """
        return pulumi.get(self, "count")

    @_builtins.property
    @pulumi.getter(name="deDuplicationActionType")
    def de_duplication_action_type(self) -> _builtins.str:
        """
        Deduplication type. Possible values are: "value-based", "frequency-based"
        """
        return pulumi.get(self, "de_duplication_action_type")

    @_builtins.property
    @pulumi.getter
    def durations(self) -> Optional[Sequence['outputs.NotificationPolicyDeDuplicationActionDuration']]:
        """
        Duration of this action (only required for "frequency-based" de-duplication action). This is a block, structure is documented below.
        """
        return pulumi.get(self, "durations")


@pulumi.output_type
class NotificationPolicyDeDuplicationActionDuration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "timeAmount":
            suggest = "time_amount"
        elif key == "timeUnit":
            suggest = "time_unit"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NotificationPolicyDeDuplicationActionDuration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NotificationPolicyDeDuplicationActionDuration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NotificationPolicyDeDuplicationActionDuration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 time_amount: _builtins.int,
                 time_unit: Optional[_builtins.str] = None):
        """
        :param _builtins.int time_amount: A amount of time in `time_units`. This is a integer attribute.
        :param _builtins.str time_unit: Valid time units are: `minutes`, `hours`, `days`. Default: `minutes`
        """
        pulumi.set(__self__, "time_amount", time_amount)
        if time_unit is not None:
            pulumi.set(__self__, "time_unit", time_unit)

    @_builtins.property
    @pulumi.getter(name="timeAmount")
    def time_amount(self) -> _builtins.int:
        """
        A amount of time in `time_units`. This is a integer attribute.
        """
        return pulumi.get(self, "time_amount")

    @_builtins.property
    @pulumi.getter(name="timeUnit")
    def time_unit(self) -> Optional[_builtins.str]:
        """
        Valid time units are: `minutes`, `hours`, `days`. Default: `minutes`
        """
        return pulumi.get(self, "time_unit")


@pulumi.output_type
class NotificationPolicyDelayAction(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "delayOption":
            suggest = "delay_option"
        elif key == "untilHour":
            suggest = "until_hour"
        elif key == "untilMinute":
            suggest = "until_minute"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NotificationPolicyDelayAction. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NotificationPolicyDelayAction.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NotificationPolicyDelayAction.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 delay_option: _builtins.str,
                 durations: Optional[Sequence['outputs.NotificationPolicyDelayActionDuration']] = None,
                 until_hour: Optional[_builtins.int] = None,
                 until_minute: Optional[_builtins.int] = None):
        """
        :param _builtins.str delay_option: Defines until what day to delay or for what duration. Possible values are: `for-duration`, `next-time`, `next-weekday`, `next-monday`, `next-tuesday`, `next-wednesday`, `next-thursday`, `next-friday`, `next-saturday`, `next-sunday`
        :param Sequence['NotificationPolicyDelayActionDurationArgs'] durations: Duration of this action. If `delay_option` = `for-duration` this has to be set. This is a block, structure is documented below.
        :param _builtins.int until_hour: Until what hour notifications will be delayed. If `delay_option` is set to antyhing else then `for-duration` this has to be set.
        :param _builtins.int until_minute: Until what minute on `until_hour` notifications will be delayed. If `delay_option` is set to antyhing else then `for-duration` this has to be set.
        """
        pulumi.set(__self__, "delay_option", delay_option)
        if durations is not None:
            pulumi.set(__self__, "durations", durations)
        if until_hour is not None:
            pulumi.set(__self__, "until_hour", until_hour)
        if until_minute is not None:
            pulumi.set(__self__, "until_minute", until_minute)

    @_builtins.property
    @pulumi.getter(name="delayOption")
    def delay_option(self) -> _builtins.str:
        """
        Defines until what day to delay or for what duration. Possible values are: `for-duration`, `next-time`, `next-weekday`, `next-monday`, `next-tuesday`, `next-wednesday`, `next-thursday`, `next-friday`, `next-saturday`, `next-sunday`
        """
        return pulumi.get(self, "delay_option")

    @_builtins.property
    @pulumi.getter
    def durations(self) -> Optional[Sequence['outputs.NotificationPolicyDelayActionDuration']]:
        """
        Duration of this action. If `delay_option` = `for-duration` this has to be set. This is a block, structure is documented below.
        """
        return pulumi.get(self, "durations")

    @_builtins.property
    @pulumi.getter(name="untilHour")
    def until_hour(self) -> Optional[_builtins.int]:
        """
        Until what hour notifications will be delayed. If `delay_option` is set to antyhing else then `for-duration` this has to be set.
        """
        return pulumi.get(self, "until_hour")

    @_builtins.property
    @pulumi.getter(name="untilMinute")
    def until_minute(self) -> Optional[_builtins.int]:
        """
        Until what minute on `until_hour` notifications will be delayed. If `delay_option` is set to antyhing else then `for-duration` this has to be set.
        """
        return pulumi.get(self, "until_minute")


@pulumi.output_type
class NotificationPolicyDelayActionDuration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "timeAmount":
            suggest = "time_amount"
        elif key == "timeUnit":
            suggest = "time_unit"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NotificationPolicyDelayActionDuration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NotificationPolicyDelayActionDuration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NotificationPolicyDelayActionDuration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 time_amount: _builtins.int,
                 time_unit: Optional[_builtins.str] = None):
        """
        :param _builtins.int time_amount: A amount of time in `time_units`. This is a integer attribute.
        :param _builtins.str time_unit: Valid time units are: `minutes`, `hours`, `days`. Default: `minutes`
        """
        pulumi.set(__self__, "time_amount", time_amount)
        if time_unit is not None:
            pulumi.set(__self__, "time_unit", time_unit)

    @_builtins.property
    @pulumi.getter(name="timeAmount")
    def time_amount(self) -> _builtins.int:
        """
        A amount of time in `time_units`. This is a integer attribute.
        """
        return pulumi.get(self, "time_amount")

    @_builtins.property
    @pulumi.getter(name="timeUnit")
    def time_unit(self) -> Optional[_builtins.str]:
        """
        Valid time units are: `minutes`, `hours`, `days`. Default: `minutes`
        """
        return pulumi.get(self, "time_unit")


@pulumi.output_type
class NotificationPolicyFilter(dict):
    def __init__(__self__, *,
                 conditions: Optional[Sequence['outputs.NotificationPolicyFilterCondition']] = None,
                 type: Optional[_builtins.str] = None):
        """
        :param Sequence['NotificationPolicyFilterConditionArgs'] conditions: Conditions applied to filter. This is a block, structure is documented below.
        :param _builtins.str type: A filter type, supported types are: `match-all`, `match-any-condition`, `match-all-conditions`. Default: `match-all`
        """
        if conditions is not None:
            pulumi.set(__self__, "conditions", conditions)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter
    def conditions(self) -> Optional[Sequence['outputs.NotificationPolicyFilterCondition']]:
        """
        Conditions applied to filter. This is a block, structure is documented below.
        """
        return pulumi.get(self, "conditions")

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[_builtins.str]:
        """
        A filter type, supported types are: `match-all`, `match-any-condition`, `match-all-conditions`. Default: `match-all`
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class NotificationPolicyFilterCondition(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "expectedValue":
            suggest = "expected_value"
        elif key == "not":
            suggest = "not_"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NotificationPolicyFilterCondition. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NotificationPolicyFilterCondition.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NotificationPolicyFilterCondition.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 field: _builtins.str,
                 operation: _builtins.str,
                 expected_value: Optional[_builtins.str] = None,
                 key: Optional[_builtins.str] = None,
                 not_: Optional[_builtins.bool] = None,
                 order: Optional[_builtins.int] = None):
        """
        :param _builtins.str field: Specifies which alert field will be used in condition. Possible values are `message`, `alias`, `description`, `source`, `entity`, `tags`, `actions`, `details`, `extra-properties`, `responders`, `teams`, `priority`
        :param _builtins.str operation: It is the operation that will be executed for the given field and key. Possible operations are `matches`, `contains`, `starts-with`, `ends-with`, `equals`, `contains-key`, `contains-value`, `greater-than`, `less-than`, `is-empty`, `equals-ignore-whitespace`.
        :param _builtins.str expected_value: User defined value that will be compared with alert field according to the operation. Default: empty string
        :param _builtins.str key: If `field` is set as extra-properties, key could be used for key-value pair
        :param _builtins.bool not_: Indicates behaviour of the given operation. Default: `false`
        :param _builtins.int order: Order of the condition in conditions list
        """
        pulumi.set(__self__, "field", field)
        pulumi.set(__self__, "operation", operation)
        if expected_value is not None:
            pulumi.set(__self__, "expected_value", expected_value)
        if key is not None:
            pulumi.set(__self__, "key", key)
        if not_ is not None:
            pulumi.set(__self__, "not_", not_)
        if order is not None:
            pulumi.set(__self__, "order", order)

    @_builtins.property
    @pulumi.getter
    def field(self) -> _builtins.str:
        """
        Specifies which alert field will be used in condition. Possible values are `message`, `alias`, `description`, `source`, `entity`, `tags`, `actions`, `details`, `extra-properties`, `responders`, `teams`, `priority`
        """
        return pulumi.get(self, "field")

    @_builtins.property
    @pulumi.getter
    def operation(self) -> _builtins.str:
        """
        It is the operation that will be executed for the given field and key. Possible operations are `matches`, `contains`, `starts-with`, `ends-with`, `equals`, `contains-key`, `contains-value`, `greater-than`, `less-than`, `is-empty`, `equals-ignore-whitespace`.
        """
        return pulumi.get(self, "operation")

    @_builtins.property
    @pulumi.getter(name="expectedValue")
    def expected_value(self) -> Optional[_builtins.str]:
        """
        User defined value that will be compared with alert field according to the operation. Default: empty string
        """
        return pulumi.get(self, "expected_value")

    @_builtins.property
    @pulumi.getter
    def key(self) -> Optional[_builtins.str]:
        """
        If `field` is set as extra-properties, key could be used for key-value pair
        """
        return pulumi.get(self, "key")

    @_builtins.property
    @pulumi.getter(name="not")
    def not_(self) -> Optional[_builtins.bool]:
        """
        Indicates behaviour of the given operation. Default: `false`
        """
        return pulumi.get(self, "not_")

    @_builtins.property
    @pulumi.getter
    def order(self) -> Optional[_builtins.int]:
        """
        Order of the condition in conditions list
        """
        return pulumi.get(self, "order")


@pulumi.output_type
class NotificationPolicyTimeRestriction(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "restrictionList":
            suggest = "restriction_list"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NotificationPolicyTimeRestriction. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NotificationPolicyTimeRestriction.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NotificationPolicyTimeRestriction.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 type: _builtins.str,
                 restriction: Optional[Sequence['outputs.NotificationPolicyTimeRestrictionRestriction']] = None,
                 restriction_list: Optional[Sequence['outputs.NotificationPolicyTimeRestrictionRestrictionList']] = None):
        """
        :param _builtins.str type: Defines if restriction should apply daily on given hours or on certain days and hours. Possible values are: `time-of-day`, `weekday-and-time-of-day`
        :param Sequence['NotificationPolicyTimeRestrictionRestrictionArgs'] restriction: A definition of hourly definition applied daily, this has to be used with combination: type = `time-of-day`. This is a block, structure is documented below.
        :param Sequence['NotificationPolicyTimeRestrictionRestrictionListArgs'] restriction_list: List of days and hours definitions for field type = `weekday-and-time-of-day`. This is a block, structure is documented below.
        """
        pulumi.set(__self__, "type", type)
        if restriction is not None:
            pulumi.set(__self__, "restriction", restriction)
        if restriction_list is not None:
            pulumi.set(__self__, "restriction_list", restriction_list)

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        Defines if restriction should apply daily on given hours or on certain days and hours. Possible values are: `time-of-day`, `weekday-and-time-of-day`
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter
    def restriction(self) -> Optional[Sequence['outputs.NotificationPolicyTimeRestrictionRestriction']]:
        """
        A definition of hourly definition applied daily, this has to be used with combination: type = `time-of-day`. This is a block, structure is documented below.
        """
        return pulumi.get(self, "restriction")

    @_builtins.property
    @pulumi.getter(name="restrictionList")
    def restriction_list(self) -> Optional[Sequence['outputs.NotificationPolicyTimeRestrictionRestrictionList']]:
        """
        List of days and hours definitions for field type = `weekday-and-time-of-day`. This is a block, structure is documented below.
        """
        return pulumi.get(self, "restriction_list")


@pulumi.output_type
class NotificationPolicyTimeRestrictionRestriction(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "endHour":
            suggest = "end_hour"
        elif key == "endMin":
            suggest = "end_min"
        elif key == "startHour":
            suggest = "start_hour"
        elif key == "startMin":
            suggest = "start_min"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NotificationPolicyTimeRestrictionRestriction. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NotificationPolicyTimeRestrictionRestriction.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NotificationPolicyTimeRestrictionRestriction.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 end_hour: _builtins.int,
                 end_min: _builtins.int,
                 start_hour: _builtins.int,
                 start_min: _builtins.int):
        """
        :param _builtins.int end_hour: Ending hour of restriction.
        :param _builtins.int end_min: Ending minute of restriction on defined `end_hour`
        :param _builtins.int start_hour: Starting hour of restriction.
        :param _builtins.int start_min: Staring minute of restriction on defined `start_hour`
        """
        pulumi.set(__self__, "end_hour", end_hour)
        pulumi.set(__self__, "end_min", end_min)
        pulumi.set(__self__, "start_hour", start_hour)
        pulumi.set(__self__, "start_min", start_min)

    @_builtins.property
    @pulumi.getter(name="endHour")
    def end_hour(self) -> _builtins.int:
        """
        Ending hour of restriction.
        """
        return pulumi.get(self, "end_hour")

    @_builtins.property
    @pulumi.getter(name="endMin")
    def end_min(self) -> _builtins.int:
        """
        Ending minute of restriction on defined `end_hour`
        """
        return pulumi.get(self, "end_min")

    @_builtins.property
    @pulumi.getter(name="startHour")
    def start_hour(self) -> _builtins.int:
        """
        Starting hour of restriction.
        """
        return pulumi.get(self, "start_hour")

    @_builtins.property
    @pulumi.getter(name="startMin")
    def start_min(self) -> _builtins.int:
        """
        Staring minute of restriction on defined `start_hour`
        """
        return pulumi.get(self, "start_min")


@pulumi.output_type
class NotificationPolicyTimeRestrictionRestrictionList(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "endDay":
            suggest = "end_day"
        elif key == "endHour":
            suggest = "end_hour"
        elif key == "endMin":
            suggest = "end_min"
        elif key == "startDay":
            suggest = "start_day"
        elif key == "startHour":
            suggest = "start_hour"
        elif key == "startMin":
            suggest = "start_min"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NotificationPolicyTimeRestrictionRestrictionList. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NotificationPolicyTimeRestrictionRestrictionList.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NotificationPolicyTimeRestrictionRestrictionList.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 end_day: _builtins.str,
                 end_hour: _builtins.int,
                 end_min: _builtins.int,
                 start_day: _builtins.str,
                 start_hour: _builtins.int,
                 start_min: _builtins.int):
        """
        :param _builtins.str end_day: Ending day of restriction (eg. `wednesday`)
        :param _builtins.int end_hour: Ending hour of restriction on defined `end_day`
        :param _builtins.int end_min: Ending minute of restriction on defined `end_hour`
        :param _builtins.str start_day: Starting day of restriction (eg. `monday`)
        :param _builtins.int start_hour: Starting hour of restriction on defined `start_day`
        :param _builtins.int start_min: Staring minute of restriction on defined `start_hour`
        """
        pulumi.set(__self__, "end_day", end_day)
        pulumi.set(__self__, "end_hour", end_hour)
        pulumi.set(__self__, "end_min", end_min)
        pulumi.set(__self__, "start_day", start_day)
        pulumi.set(__self__, "start_hour", start_hour)
        pulumi.set(__self__, "start_min", start_min)

    @_builtins.property
    @pulumi.getter(name="endDay")
    def end_day(self) -> _builtins.str:
        """
        Ending day of restriction (eg. `wednesday`)
        """
        return pulumi.get(self, "end_day")

    @_builtins.property
    @pulumi.getter(name="endHour")
    def end_hour(self) -> _builtins.int:
        """
        Ending hour of restriction on defined `end_day`
        """
        return pulumi.get(self, "end_hour")

    @_builtins.property
    @pulumi.getter(name="endMin")
    def end_min(self) -> _builtins.int:
        """
        Ending minute of restriction on defined `end_hour`
        """
        return pulumi.get(self, "end_min")

    @_builtins.property
    @pulumi.getter(name="startDay")
    def start_day(self) -> _builtins.str:
        """
        Starting day of restriction (eg. `monday`)
        """
        return pulumi.get(self, "start_day")

    @_builtins.property
    @pulumi.getter(name="startHour")
    def start_hour(self) -> _builtins.int:
        """
        Starting hour of restriction on defined `start_day`
        """
        return pulumi.get(self, "start_hour")

    @_builtins.property
    @pulumi.getter(name="startMin")
    def start_min(self) -> _builtins.int:
        """
        Staring minute of restriction on defined `start_hour`
        """
        return pulumi.get(self, "start_min")


@pulumi.output_type
class NotificationRuleCriteria(dict):
    def __init__(__self__, *,
                 type: _builtins.str,
                 conditions: Optional[Sequence['outputs.NotificationRuleCriteriaCondition']] = None):
        """
        :param _builtins.str type: Kind of matching filter. Possible values: `match-all`, `match-any-condition`, `match-all-conditions`
        :param Sequence['NotificationRuleCriteriaConditionArgs'] conditions: Defines the fields and values when the condition applies
        """
        pulumi.set(__self__, "type", type)
        if conditions is not None:
            pulumi.set(__self__, "conditions", conditions)

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        Kind of matching filter. Possible values: `match-all`, `match-any-condition`, `match-all-conditions`
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter
    def conditions(self) -> Optional[Sequence['outputs.NotificationRuleCriteriaCondition']]:
        """
        Defines the fields and values when the condition applies
        """
        return pulumi.get(self, "conditions")


@pulumi.output_type
class NotificationRuleCriteriaCondition(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "expectedValue":
            suggest = "expected_value"
        elif key == "not":
            suggest = "not_"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NotificationRuleCriteriaCondition. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NotificationRuleCriteriaCondition.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NotificationRuleCriteriaCondition.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 field: _builtins.str,
                 operation: _builtins.str,
                 expected_value: Optional[_builtins.str] = None,
                 key: Optional[_builtins.str] = None,
                 not_: Optional[_builtins.bool] = None,
                 order: Optional[_builtins.int] = None):
        """
        :param _builtins.str field: Possible values: `message`, `alias`, `description`, `source`, `entity`, `tags`, `actions`, `details`, `extra-properties`, `recipients`, `teams`, `priority`
        :param _builtins.str operation: Possible values: `matches`, `contains`, `starts-with`, `ends-with`, `equals`, `contains-key`, `contains-value`, `greater-than`, `less-than`, `is-empty`, `equals-ignore-whitespace`
        :param _builtins.str expected_value: User defined value that will be compared with alert field according to the operation. Default: empty string
        :param _builtins.str key: If 'field' is set as 'extra-properties', key could be used for key-value pair
        :param _builtins.bool not_: Indicates behaviour of the given operation. Default: `false`
        :param _builtins.int order: Order of the condition in conditions list
        """
        pulumi.set(__self__, "field", field)
        pulumi.set(__self__, "operation", operation)
        if expected_value is not None:
            pulumi.set(__self__, "expected_value", expected_value)
        if key is not None:
            pulumi.set(__self__, "key", key)
        if not_ is not None:
            pulumi.set(__self__, "not_", not_)
        if order is not None:
            pulumi.set(__self__, "order", order)

    @_builtins.property
    @pulumi.getter
    def field(self) -> _builtins.str:
        """
        Possible values: `message`, `alias`, `description`, `source`, `entity`, `tags`, `actions`, `details`, `extra-properties`, `recipients`, `teams`, `priority`
        """
        return pulumi.get(self, "field")

    @_builtins.property
    @pulumi.getter
    def operation(self) -> _builtins.str:
        """
        Possible values: `matches`, `contains`, `starts-with`, `ends-with`, `equals`, `contains-key`, `contains-value`, `greater-than`, `less-than`, `is-empty`, `equals-ignore-whitespace`
        """
        return pulumi.get(self, "operation")

    @_builtins.property
    @pulumi.getter(name="expectedValue")
    def expected_value(self) -> Optional[_builtins.str]:
        """
        User defined value that will be compared with alert field according to the operation. Default: empty string
        """
        return pulumi.get(self, "expected_value")

    @_builtins.property
    @pulumi.getter
    def key(self) -> Optional[_builtins.str]:
        """
        If 'field' is set as 'extra-properties', key could be used for key-value pair
        """
        return pulumi.get(self, "key")

    @_builtins.property
    @pulumi.getter(name="not")
    def not_(self) -> Optional[_builtins.bool]:
        """
        Indicates behaviour of the given operation. Default: `false`
        """
        return pulumi.get(self, "not_")

    @_builtins.property
    @pulumi.getter
    def order(self) -> Optional[_builtins.int]:
        """
        Order of the condition in conditions list
        """
        return pulumi.get(self, "order")


@pulumi.output_type
class NotificationRuleRepeat(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "loopAfter":
            suggest = "loop_after"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NotificationRuleRepeat. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NotificationRuleRepeat.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NotificationRuleRepeat.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 loop_after: _builtins.int,
                 enabled: Optional[_builtins.bool] = None):
        """
        :param _builtins.bool enabled: If policy should be enabled. Default: `true`
        """
        pulumi.set(__self__, "loop_after", loop_after)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)

    @_builtins.property
    @pulumi.getter(name="loopAfter")
    def loop_after(self) -> _builtins.int:
        return pulumi.get(self, "loop_after")

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> Optional[_builtins.bool]:
        """
        If policy should be enabled. Default: `true`
        """
        return pulumi.get(self, "enabled")


@pulumi.output_type
class NotificationRuleSchedule(dict):
    def __init__(__self__, *,
                 name: _builtins.str,
                 type: _builtins.str):
        """
        :param _builtins.str name: Name of the notification policy
        :param _builtins.str type: Kind of matching filter. Possible values: `match-all`, `match-any-condition`, `match-all-conditions`
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Name of the notification policy
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        Kind of matching filter. Possible values: `match-all`, `match-any-condition`, `match-all-conditions`
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class NotificationRuleStep(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "sendAfter":
            suggest = "send_after"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NotificationRuleStep. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NotificationRuleStep.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NotificationRuleStep.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 contacts: Sequence['outputs.NotificationRuleStepContact'],
                 enabled: Optional[_builtins.bool] = None,
                 send_after: Optional[_builtins.int] = None):
        """
        :param Sequence['NotificationRuleStepContactArgs'] contacts: Defines the contact that notification will be sent to. This is a block, structure is documented below.
        :param _builtins.bool enabled: Defined if this step is enabled. Default: `true`
        :param _builtins.int send_after: Time period, in minutes, notification will be sent after.
        """
        pulumi.set(__self__, "contacts", contacts)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if send_after is not None:
            pulumi.set(__self__, "send_after", send_after)

    @_builtins.property
    @pulumi.getter
    def contacts(self) -> Sequence['outputs.NotificationRuleStepContact']:
        """
        Defines the contact that notification will be sent to. This is a block, structure is documented below.
        """
        return pulumi.get(self, "contacts")

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> Optional[_builtins.bool]:
        """
        Defined if this step is enabled. Default: `true`
        """
        return pulumi.get(self, "enabled")

    @_builtins.property
    @pulumi.getter(name="sendAfter")
    def send_after(self) -> Optional[_builtins.int]:
        """
        Time period, in minutes, notification will be sent after.
        """
        return pulumi.get(self, "send_after")


@pulumi.output_type
class NotificationRuleStepContact(dict):
    def __init__(__self__, *,
                 method: _builtins.str,
                 to: _builtins.str):
        """
        :param _builtins.str method: Contact method. Possible values: `email`, `sms`, `voice`, `mobile`
        :param _builtins.str to: Address of a given method (eg. email address for `email`, phone number for `sms`/`voice` or mobile application name for `mobile`)
        """
        pulumi.set(__self__, "method", method)
        pulumi.set(__self__, "to", to)

    @_builtins.property
    @pulumi.getter
    def method(self) -> _builtins.str:
        """
        Contact method. Possible values: `email`, `sms`, `voice`, `mobile`
        """
        return pulumi.get(self, "method")

    @_builtins.property
    @pulumi.getter
    def to(self) -> _builtins.str:
        """
        Address of a given method (eg. email address for `email`, phone number for `sms`/`voice` or mobile application name for `mobile`)
        """
        return pulumi.get(self, "to")


@pulumi.output_type
class NotificationRuleTimeRestriction(dict):
    def __init__(__self__, *,
                 type: _builtins.str,
                 restriction: Optional[Sequence['outputs.NotificationRuleTimeRestrictionRestriction']] = None,
                 restrictions: Optional[Sequence['outputs.NotificationRuleTimeRestrictionRestriction']] = None):
        """
        :param _builtins.str type: Kind of matching filter. Possible values: `match-all`, `match-any-condition`, `match-all-conditions`
        """
        pulumi.set(__self__, "type", type)
        if restriction is not None:
            pulumi.set(__self__, "restriction", restriction)
        if restrictions is not None:
            pulumi.set(__self__, "restrictions", restrictions)

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        Kind of matching filter. Possible values: `match-all`, `match-any-condition`, `match-all-conditions`
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter
    def restriction(self) -> Optional[Sequence['outputs.NotificationRuleTimeRestrictionRestriction']]:
        return pulumi.get(self, "restriction")

    @_builtins.property
    @pulumi.getter
    def restrictions(self) -> Optional[Sequence['outputs.NotificationRuleTimeRestrictionRestriction']]:
        return pulumi.get(self, "restrictions")


@pulumi.output_type
class NotificationRuleTimeRestrictionRestriction(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "endDay":
            suggest = "end_day"
        elif key == "endHour":
            suggest = "end_hour"
        elif key == "endMin":
            suggest = "end_min"
        elif key == "startDay":
            suggest = "start_day"
        elif key == "startHour":
            suggest = "start_hour"
        elif key == "startMin":
            suggest = "start_min"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NotificationRuleTimeRestrictionRestriction. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NotificationRuleTimeRestrictionRestriction.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NotificationRuleTimeRestrictionRestriction.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 end_day: _builtins.str,
                 end_hour: _builtins.int,
                 end_min: _builtins.int,
                 start_day: _builtins.str,
                 start_hour: _builtins.int,
                 start_min: _builtins.int):
        pulumi.set(__self__, "end_day", end_day)
        pulumi.set(__self__, "end_hour", end_hour)
        pulumi.set(__self__, "end_min", end_min)
        pulumi.set(__self__, "start_day", start_day)
        pulumi.set(__self__, "start_hour", start_hour)
        pulumi.set(__self__, "start_min", start_min)

    @_builtins.property
    @pulumi.getter(name="endDay")
    def end_day(self) -> _builtins.str:
        return pulumi.get(self, "end_day")

    @_builtins.property
    @pulumi.getter(name="endHour")
    def end_hour(self) -> _builtins.int:
        return pulumi.get(self, "end_hour")

    @_builtins.property
    @pulumi.getter(name="endMin")
    def end_min(self) -> _builtins.int:
        return pulumi.get(self, "end_min")

    @_builtins.property
    @pulumi.getter(name="startDay")
    def start_day(self) -> _builtins.str:
        return pulumi.get(self, "start_day")

    @_builtins.property
    @pulumi.getter(name="startHour")
    def start_hour(self) -> _builtins.int:
        return pulumi.get(self, "start_hour")

    @_builtins.property
    @pulumi.getter(name="startMin")
    def start_min(self) -> _builtins.int:
        return pulumi.get(self, "start_min")


@pulumi.output_type
class ScheduleRotationParticipant(dict):
    def __init__(__self__, *,
                 type: _builtins.str,
                 id: Optional[_builtins.str] = None):
        """
        :param _builtins.str type: The responder type.
        :param _builtins.str id: The id of the responder.
        """
        pulumi.set(__self__, "type", type)
        if id is not None:
            pulumi.set(__self__, "id", id)

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        The responder type.
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter
    def id(self) -> Optional[_builtins.str]:
        """
        The id of the responder.
        """
        return pulumi.get(self, "id")


@pulumi.output_type
class ScheduleRotationTimeRestriction(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "restrictionList":
            suggest = "restriction_list"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ScheduleRotationTimeRestriction. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ScheduleRotationTimeRestriction.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ScheduleRotationTimeRestriction.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 type: _builtins.str,
                 restriction: Optional[Sequence['outputs.ScheduleRotationTimeRestrictionRestriction']] = None,
                 restriction_list: Optional[Sequence['outputs.ScheduleRotationTimeRestrictionRestrictionList']] = None):
        """
        :param _builtins.str type: This parameter should be set to `time-of-day` or `weekday-and-time-of-day`.
        :param Sequence['ScheduleRotationTimeRestrictionRestrictionArgs'] restriction: It is a restriction object which is described below. In this case startDay/endDay fields are not supported. This can be used only if time restriction type is `time-of-day`.
        :param Sequence['ScheduleRotationTimeRestrictionRestrictionListArgs'] restriction_list: It is a restriction object which is described below. This can be used only if time restriction type is `weekday-and-time-of-day`.
        """
        pulumi.set(__self__, "type", type)
        if restriction is not None:
            pulumi.set(__self__, "restriction", restriction)
        if restriction_list is not None:
            pulumi.set(__self__, "restriction_list", restriction_list)

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        This parameter should be set to `time-of-day` or `weekday-and-time-of-day`.
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter
    def restriction(self) -> Optional[Sequence['outputs.ScheduleRotationTimeRestrictionRestriction']]:
        """
        It is a restriction object which is described below. In this case startDay/endDay fields are not supported. This can be used only if time restriction type is `time-of-day`.
        """
        return pulumi.get(self, "restriction")

    @_builtins.property
    @pulumi.getter(name="restrictionList")
    def restriction_list(self) -> Optional[Sequence['outputs.ScheduleRotationTimeRestrictionRestrictionList']]:
        """
        It is a restriction object which is described below. This can be used only if time restriction type is `weekday-and-time-of-day`.
        """
        return pulumi.get(self, "restriction_list")


@pulumi.output_type
class ScheduleRotationTimeRestrictionRestriction(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "endHour":
            suggest = "end_hour"
        elif key == "endMin":
            suggest = "end_min"
        elif key == "startHour":
            suggest = "start_hour"
        elif key == "startMin":
            suggest = "start_min"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ScheduleRotationTimeRestrictionRestriction. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ScheduleRotationTimeRestrictionRestriction.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ScheduleRotationTimeRestrictionRestriction.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 end_hour: _builtins.int,
                 end_min: _builtins.int,
                 start_hour: _builtins.int,
                 start_min: _builtins.int):
        """
        :param _builtins.int end_hour: Value of the hour that frame will end.
        :param _builtins.int end_min: Value of the minute that frame will end. Minutes may take 0 or 30 as value. Otherwise they will be converted to nearest 0 or 30 automatically.
        :param _builtins.int start_hour: Value of the hour that frame will start.
        :param _builtins.int start_min: Value of the minute that frame will start. Minutes may take 0 or 30 as value. Otherwise they will be converted to nearest 0 or 30 automatically.
        """
        pulumi.set(__self__, "end_hour", end_hour)
        pulumi.set(__self__, "end_min", end_min)
        pulumi.set(__self__, "start_hour", start_hour)
        pulumi.set(__self__, "start_min", start_min)

    @_builtins.property
    @pulumi.getter(name="endHour")
    def end_hour(self) -> _builtins.int:
        """
        Value of the hour that frame will end.
        """
        return pulumi.get(self, "end_hour")

    @_builtins.property
    @pulumi.getter(name="endMin")
    def end_min(self) -> _builtins.int:
        """
        Value of the minute that frame will end. Minutes may take 0 or 30 as value. Otherwise they will be converted to nearest 0 or 30 automatically.
        """
        return pulumi.get(self, "end_min")

    @_builtins.property
    @pulumi.getter(name="startHour")
    def start_hour(self) -> _builtins.int:
        """
        Value of the hour that frame will start.
        """
        return pulumi.get(self, "start_hour")

    @_builtins.property
    @pulumi.getter(name="startMin")
    def start_min(self) -> _builtins.int:
        """
        Value of the minute that frame will start. Minutes may take 0 or 30 as value. Otherwise they will be converted to nearest 0 or 30 automatically.
        """
        return pulumi.get(self, "start_min")


@pulumi.output_type
class ScheduleRotationTimeRestrictionRestrictionList(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "endDay":
            suggest = "end_day"
        elif key == "endHour":
            suggest = "end_hour"
        elif key == "endMin":
            suggest = "end_min"
        elif key == "startDay":
            suggest = "start_day"
        elif key == "startHour":
            suggest = "start_hour"
        elif key == "startMin":
            suggest = "start_min"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ScheduleRotationTimeRestrictionRestrictionList. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ScheduleRotationTimeRestrictionRestrictionList.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ScheduleRotationTimeRestrictionRestrictionList.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 end_day: _builtins.str,
                 end_hour: _builtins.int,
                 end_min: _builtins.int,
                 start_day: _builtins.str,
                 start_hour: _builtins.int,
                 start_min: _builtins.int):
        """
        :param _builtins.str end_day: Value of the day that frame will end.
        :param _builtins.int end_hour: Value of the hour that frame will end.
        :param _builtins.int end_min: Value of the minute that frame will end. Minutes may take 0 or 30 as value. Otherwise they will be converted to nearest 0 or 30 automatically.
               
               Both `start_day` and `end_day` can assume only `monday`, `tuesday`, `wednesday`, `thursday`, `friday`, `saturday`, or `sunday` values.
        :param _builtins.str start_day: Value of the day that frame will start.
        :param _builtins.int start_hour: Value of the hour that frame will start
        :param _builtins.int start_min: Value of the minute that frame will start. Minutes may take 0 or 30 as value. Otherwise they will be converted to nearest 0 or 30 automatically.
        """
        pulumi.set(__self__, "end_day", end_day)
        pulumi.set(__self__, "end_hour", end_hour)
        pulumi.set(__self__, "end_min", end_min)
        pulumi.set(__self__, "start_day", start_day)
        pulumi.set(__self__, "start_hour", start_hour)
        pulumi.set(__self__, "start_min", start_min)

    @_builtins.property
    @pulumi.getter(name="endDay")
    def end_day(self) -> _builtins.str:
        """
        Value of the day that frame will end.
        """
        return pulumi.get(self, "end_day")

    @_builtins.property
    @pulumi.getter(name="endHour")
    def end_hour(self) -> _builtins.int:
        """
        Value of the hour that frame will end.
        """
        return pulumi.get(self, "end_hour")

    @_builtins.property
    @pulumi.getter(name="endMin")
    def end_min(self) -> _builtins.int:
        """
        Value of the minute that frame will end. Minutes may take 0 or 30 as value. Otherwise they will be converted to nearest 0 or 30 automatically.

        Both `start_day` and `end_day` can assume only `monday`, `tuesday`, `wednesday`, `thursday`, `friday`, `saturday`, or `sunday` values.
        """
        return pulumi.get(self, "end_min")

    @_builtins.property
    @pulumi.getter(name="startDay")
    def start_day(self) -> _builtins.str:
        """
        Value of the day that frame will start.
        """
        return pulumi.get(self, "start_day")

    @_builtins.property
    @pulumi.getter(name="startHour")
    def start_hour(self) -> _builtins.int:
        """
        Value of the hour that frame will start
        """
        return pulumi.get(self, "start_hour")

    @_builtins.property
    @pulumi.getter(name="startMin")
    def start_min(self) -> _builtins.int:
        """
        Value of the minute that frame will start. Minutes may take 0 or 30 as value. Otherwise they will be converted to nearest 0 or 30 automatically.
        """
        return pulumi.get(self, "start_min")


@pulumi.output_type
class ServiceIncidentRuleIncidentRule(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "incidentProperties":
            suggest = "incident_properties"
        elif key == "conditionMatchType":
            suggest = "condition_match_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceIncidentRuleIncidentRule. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceIncidentRuleIncidentRule.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceIncidentRuleIncidentRule.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 incident_properties: Sequence['outputs.ServiceIncidentRuleIncidentRuleIncidentProperty'],
                 condition_match_type: Optional[_builtins.str] = None,
                 conditions: Optional[Sequence['outputs.ServiceIncidentRuleIncidentRuleCondition']] = None):
        """
        :param Sequence['ServiceIncidentRuleIncidentRuleIncidentPropertyArgs'] incident_properties: Properties for incident rule. This is a block, structure is documented below.
        :param _builtins.str condition_match_type: A Condition type, supported types are: `match-all`, `match-any-condition`, `match-all-conditions`. Default: `match-all`
        :param Sequence['ServiceIncidentRuleIncidentRuleConditionArgs'] conditions: Conditions applied to incident. This is a block, structure is documented below.
        """
        pulumi.set(__self__, "incident_properties", incident_properties)
        if condition_match_type is not None:
            pulumi.set(__self__, "condition_match_type", condition_match_type)
        if conditions is not None:
            pulumi.set(__self__, "conditions", conditions)

    @_builtins.property
    @pulumi.getter(name="incidentProperties")
    def incident_properties(self) -> Sequence['outputs.ServiceIncidentRuleIncidentRuleIncidentProperty']:
        """
        Properties for incident rule. This is a block, structure is documented below.
        """
        return pulumi.get(self, "incident_properties")

    @_builtins.property
    @pulumi.getter(name="conditionMatchType")
    def condition_match_type(self) -> Optional[_builtins.str]:
        """
        A Condition type, supported types are: `match-all`, `match-any-condition`, `match-all-conditions`. Default: `match-all`
        """
        return pulumi.get(self, "condition_match_type")

    @_builtins.property
    @pulumi.getter
    def conditions(self) -> Optional[Sequence['outputs.ServiceIncidentRuleIncidentRuleCondition']]:
        """
        Conditions applied to incident. This is a block, structure is documented below.
        """
        return pulumi.get(self, "conditions")


@pulumi.output_type
class ServiceIncidentRuleIncidentRuleCondition(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "expectedValue":
            suggest = "expected_value"
        elif key == "not":
            suggest = "not_"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceIncidentRuleIncidentRuleCondition. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceIncidentRuleIncidentRuleCondition.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceIncidentRuleIncidentRuleCondition.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 field: _builtins.str,
                 operation: _builtins.str,
                 expected_value: Optional[_builtins.str] = None,
                 key: Optional[_builtins.str] = None,
                 not_: Optional[_builtins.bool] = None):
        """
        :param _builtins.str field: Specifies which alert field will be used in condition. Possible values are `message`, `alias`, `description`, `source`, `entity`, `tags`, `actions`, `details`, `extra-properties`, `recipients`, `teams`, `priority`
        :param _builtins.str operation: It is the operation that will be executed for the given field and key. Possible operations are `matches`, `contains`, `starts-with`, `ends-with`, `equals`, `contains-key`, `contains-value`, `greater-than`, `less-than`, `is-empty`, `equals-ignore-whitespace`.
        :param _builtins.str expected_value: User defined value that will be compared with alert field according to the operation. Default: empty string
        :param _builtins.str key: If 'field' is set as 'extra-properties', key could be used for key-value pair
        :param _builtins.bool not_: Indicates behaviour of the given operation. Default: false
        """
        pulumi.set(__self__, "field", field)
        pulumi.set(__self__, "operation", operation)
        if expected_value is not None:
            pulumi.set(__self__, "expected_value", expected_value)
        if key is not None:
            pulumi.set(__self__, "key", key)
        if not_ is not None:
            pulumi.set(__self__, "not_", not_)

    @_builtins.property
    @pulumi.getter
    def field(self) -> _builtins.str:
        """
        Specifies which alert field will be used in condition. Possible values are `message`, `alias`, `description`, `source`, `entity`, `tags`, `actions`, `details`, `extra-properties`, `recipients`, `teams`, `priority`
        """
        return pulumi.get(self, "field")

    @_builtins.property
    @pulumi.getter
    def operation(self) -> _builtins.str:
        """
        It is the operation that will be executed for the given field and key. Possible operations are `matches`, `contains`, `starts-with`, `ends-with`, `equals`, `contains-key`, `contains-value`, `greater-than`, `less-than`, `is-empty`, `equals-ignore-whitespace`.
        """
        return pulumi.get(self, "operation")

    @_builtins.property
    @pulumi.getter(name="expectedValue")
    def expected_value(self) -> Optional[_builtins.str]:
        """
        User defined value that will be compared with alert field according to the operation. Default: empty string
        """
        return pulumi.get(self, "expected_value")

    @_builtins.property
    @pulumi.getter
    def key(self) -> Optional[_builtins.str]:
        """
        If 'field' is set as 'extra-properties', key could be used for key-value pair
        """
        return pulumi.get(self, "key")

    @_builtins.property
    @pulumi.getter(name="not")
    def not_(self) -> Optional[_builtins.bool]:
        """
        Indicates behaviour of the given operation. Default: false
        """
        return pulumi.get(self, "not_")


@pulumi.output_type
class ServiceIncidentRuleIncidentRuleIncidentProperty(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "stakeholderProperties":
            suggest = "stakeholder_properties"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceIncidentRuleIncidentRuleIncidentProperty. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceIncidentRuleIncidentRuleIncidentProperty.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceIncidentRuleIncidentRuleIncidentProperty.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 message: _builtins.str,
                 priority: _builtins.str,
                 stakeholder_properties: Sequence['outputs.ServiceIncidentRuleIncidentRuleIncidentPropertyStakeholderProperty'],
                 description: Optional[_builtins.str] = None,
                 details: Optional[Mapping[str, _builtins.str]] = None,
                 tags: Optional[Sequence[_builtins.str]] = None):
        """
        :param _builtins.str message: Message of the related incident rule.
        :param _builtins.str priority: Priority level of the alert. Possible values are `P1`, `P2`, `P3`, `P4` and `P5`
        :param Sequence['ServiceIncidentRuleIncidentRuleIncidentPropertyStakeholderPropertyArgs'] stakeholder_properties: DEtails about stakeholders for this rule. This is a block, structure is documented below.
        :param _builtins.str description: Description field of the incident rule.
        :param Mapping[str, _builtins.str] details: Map of key-value pairs to use as custom properties of the alert.
        :param Sequence[_builtins.str] tags: Tags of the alert.
        """
        pulumi.set(__self__, "message", message)
        pulumi.set(__self__, "priority", priority)
        pulumi.set(__self__, "stakeholder_properties", stakeholder_properties)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if details is not None:
            pulumi.set(__self__, "details", details)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter
    def message(self) -> _builtins.str:
        """
        Message of the related incident rule.
        """
        return pulumi.get(self, "message")

    @_builtins.property
    @pulumi.getter
    def priority(self) -> _builtins.str:
        """
        Priority level of the alert. Possible values are `P1`, `P2`, `P3`, `P4` and `P5`
        """
        return pulumi.get(self, "priority")

    @_builtins.property
    @pulumi.getter(name="stakeholderProperties")
    def stakeholder_properties(self) -> Sequence['outputs.ServiceIncidentRuleIncidentRuleIncidentPropertyStakeholderProperty']:
        """
        DEtails about stakeholders for this rule. This is a block, structure is documented below.
        """
        return pulumi.get(self, "stakeholder_properties")

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[_builtins.str]:
        """
        Description field of the incident rule.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def details(self) -> Optional[Mapping[str, _builtins.str]]:
        """
        Map of key-value pairs to use as custom properties of the alert.
        """
        return pulumi.get(self, "details")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[Sequence[_builtins.str]]:
        """
        Tags of the alert.
        """
        return pulumi.get(self, "tags")


@pulumi.output_type
class ServiceIncidentRuleIncidentRuleIncidentPropertyStakeholderProperty(dict):
    def __init__(__self__, *,
                 message: _builtins.str,
                 description: Optional[_builtins.str] = None,
                 enable: Optional[_builtins.bool] = None):
        """
        :param _builtins.str message: Message that is to be passed to audience that is generally used to provide a content information about the alert.
        :param _builtins.str description: Description that is generally used to provide a detailed information about the alert.
        :param _builtins.bool enable: Option to enable stakeholder notifications.Default value is true.
        """
        pulumi.set(__self__, "message", message)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if enable is not None:
            pulumi.set(__self__, "enable", enable)

    @_builtins.property
    @pulumi.getter
    def message(self) -> _builtins.str:
        """
        Message that is to be passed to audience that is generally used to provide a content information about the alert.
        """
        return pulumi.get(self, "message")

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[_builtins.str]:
        """
        Description that is generally used to provide a detailed information about the alert.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def enable(self) -> Optional[_builtins.bool]:
        """
        Option to enable stakeholder notifications.Default value is true.
        """
        return pulumi.get(self, "enable")


@pulumi.output_type
class TeamMember(dict):
    def __init__(__self__, *,
                 id: _builtins.str,
                 role: Optional[_builtins.str] = None,
                 username: Optional[_builtins.str] = None):
        """
        :param _builtins.str id: The UUID for the member to add to this Team.
        :param _builtins.str role: The role for the user within the Team - can be either `admin` or `user`. Default: `user`.
        """
        pulumi.set(__self__, "id", id)
        if role is not None:
            pulumi.set(__self__, "role", role)
        if username is not None:
            pulumi.set(__self__, "username", username)

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The UUID for the member to add to this Team.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def role(self) -> Optional[_builtins.str]:
        """
        The role for the user within the Team - can be either `admin` or `user`. Default: `user`.
        """
        return pulumi.get(self, "role")

    @_builtins.property
    @pulumi.getter
    def username(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "username")


@pulumi.output_type
class TeamRoutingRuleCriteria(dict):
    def __init__(__self__, *,
                 type: _builtins.str,
                 conditions: Optional[Sequence['outputs.TeamRoutingRuleCriteriaCondition']] = None):
        """
        :param _builtins.str type: Type of the operation will be applied on conditions. Should be one of `match-all`, `match-any-condition` or `match-all-conditions`.
        :param Sequence['TeamRoutingRuleCriteriaConditionArgs'] conditions: List of conditions will be checked before applying team routing rule. This field declaration should be omitted if the criteria type is set to match-all.
        """
        pulumi.set(__self__, "type", type)
        if conditions is not None:
            pulumi.set(__self__, "conditions", conditions)

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        Type of the operation will be applied on conditions. Should be one of `match-all`, `match-any-condition` or `match-all-conditions`.
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter
    def conditions(self) -> Optional[Sequence['outputs.TeamRoutingRuleCriteriaCondition']]:
        """
        List of conditions will be checked before applying team routing rule. This field declaration should be omitted if the criteria type is set to match-all.
        """
        return pulumi.get(self, "conditions")


@pulumi.output_type
class TeamRoutingRuleCriteriaCondition(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "expectedValue":
            suggest = "expected_value"
        elif key == "not":
            suggest = "not_"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TeamRoutingRuleCriteriaCondition. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TeamRoutingRuleCriteriaCondition.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TeamRoutingRuleCriteriaCondition.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 field: _builtins.str,
                 operation: _builtins.str,
                 expected_value: Optional[_builtins.str] = None,
                 key: Optional[_builtins.str] = None,
                 not_: Optional[_builtins.bool] = None,
                 order: Optional[_builtins.int] = None):
        """
        :param _builtins.str field: Specifies which alert field will be used in condition. Possible values are `message`, `alias`, `description`, `source`, `entity`, `tags`, `actions`, `extra-properties`, `recipients`, `teams` or `priority`.
        :param _builtins.str operation: It is the operation that will be executed for the given field and key. Possible operations are `matches`, `contains`, `starts-with`, `ends-with`, `equals`, `contains-key`, `contains-value`, `greater-than`, `less-than`, `is-empty` and `equals-ignore-whitespace`.
               
               * `expectedValue` - (Optional) User defined value that will be compared with alert field according to the operation. Default: empty string.
        :param _builtins.str key: If field is set as extra-properties, key could be used for key-value pair.
        :param _builtins.bool not_: Indicates behaviour of the given operation. Default value is false.
        :param _builtins.int order: Order of the condition in conditions list.
        """
        pulumi.set(__self__, "field", field)
        pulumi.set(__self__, "operation", operation)
        if expected_value is not None:
            pulumi.set(__self__, "expected_value", expected_value)
        if key is not None:
            pulumi.set(__self__, "key", key)
        if not_ is not None:
            pulumi.set(__self__, "not_", not_)
        if order is not None:
            pulumi.set(__self__, "order", order)

    @_builtins.property
    @pulumi.getter
    def field(self) -> _builtins.str:
        """
        Specifies which alert field will be used in condition. Possible values are `message`, `alias`, `description`, `source`, `entity`, `tags`, `actions`, `extra-properties`, `recipients`, `teams` or `priority`.
        """
        return pulumi.get(self, "field")

    @_builtins.property
    @pulumi.getter
    def operation(self) -> _builtins.str:
        """
        It is the operation that will be executed for the given field and key. Possible operations are `matches`, `contains`, `starts-with`, `ends-with`, `equals`, `contains-key`, `contains-value`, `greater-than`, `less-than`, `is-empty` and `equals-ignore-whitespace`.

        * `expectedValue` - (Optional) User defined value that will be compared with alert field according to the operation. Default: empty string.
        """
        return pulumi.get(self, "operation")

    @_builtins.property
    @pulumi.getter(name="expectedValue")
    def expected_value(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "expected_value")

    @_builtins.property
    @pulumi.getter
    def key(self) -> Optional[_builtins.str]:
        """
        If field is set as extra-properties, key could be used for key-value pair.
        """
        return pulumi.get(self, "key")

    @_builtins.property
    @pulumi.getter(name="not")
    def not_(self) -> Optional[_builtins.bool]:
        """
        Indicates behaviour of the given operation. Default value is false.
        """
        return pulumi.get(self, "not_")

    @_builtins.property
    @pulumi.getter
    def order(self) -> Optional[_builtins.int]:
        """
        Order of the condition in conditions list.
        """
        return pulumi.get(self, "order")


@pulumi.output_type
class TeamRoutingRuleNotify(dict):
    def __init__(__self__, *,
                 type: _builtins.str,
                 id: Optional[_builtins.str] = None,
                 name: Optional[_builtins.str] = None):
        pulumi.set(__self__, "type", type)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter
    def id(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "name")


@pulumi.output_type
class TeamRoutingRuleTimeRestriction(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "restrictionList":
            suggest = "restriction_list"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TeamRoutingRuleTimeRestriction. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TeamRoutingRuleTimeRestriction.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TeamRoutingRuleTimeRestriction.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 type: _builtins.str,
                 restriction: Optional[Sequence['outputs.TeamRoutingRuleTimeRestrictionRestriction']] = None,
                 restriction_list: Optional[Sequence['outputs.TeamRoutingRuleTimeRestrictionRestrictionList']] = None):
        pulumi.set(__self__, "type", type)
        if restriction is not None:
            pulumi.set(__self__, "restriction", restriction)
        if restriction_list is not None:
            pulumi.set(__self__, "restriction_list", restriction_list)

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter
    def restriction(self) -> Optional[Sequence['outputs.TeamRoutingRuleTimeRestrictionRestriction']]:
        return pulumi.get(self, "restriction")

    @_builtins.property
    @pulumi.getter(name="restrictionList")
    def restriction_list(self) -> Optional[Sequence['outputs.TeamRoutingRuleTimeRestrictionRestrictionList']]:
        return pulumi.get(self, "restriction_list")


@pulumi.output_type
class TeamRoutingRuleTimeRestrictionRestriction(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "endHour":
            suggest = "end_hour"
        elif key == "endMin":
            suggest = "end_min"
        elif key == "startHour":
            suggest = "start_hour"
        elif key == "startMin":
            suggest = "start_min"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TeamRoutingRuleTimeRestrictionRestriction. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TeamRoutingRuleTimeRestrictionRestriction.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TeamRoutingRuleTimeRestrictionRestriction.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 end_hour: _builtins.int,
                 end_min: _builtins.int,
                 start_hour: _builtins.int,
                 start_min: _builtins.int):
        pulumi.set(__self__, "end_hour", end_hour)
        pulumi.set(__self__, "end_min", end_min)
        pulumi.set(__self__, "start_hour", start_hour)
        pulumi.set(__self__, "start_min", start_min)

    @_builtins.property
    @pulumi.getter(name="endHour")
    def end_hour(self) -> _builtins.int:
        return pulumi.get(self, "end_hour")

    @_builtins.property
    @pulumi.getter(name="endMin")
    def end_min(self) -> _builtins.int:
        return pulumi.get(self, "end_min")

    @_builtins.property
    @pulumi.getter(name="startHour")
    def start_hour(self) -> _builtins.int:
        return pulumi.get(self, "start_hour")

    @_builtins.property
    @pulumi.getter(name="startMin")
    def start_min(self) -> _builtins.int:
        return pulumi.get(self, "start_min")


@pulumi.output_type
class TeamRoutingRuleTimeRestrictionRestrictionList(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "endDay":
            suggest = "end_day"
        elif key == "endHour":
            suggest = "end_hour"
        elif key == "endMin":
            suggest = "end_min"
        elif key == "startDay":
            suggest = "start_day"
        elif key == "startHour":
            suggest = "start_hour"
        elif key == "startMin":
            suggest = "start_min"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TeamRoutingRuleTimeRestrictionRestrictionList. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TeamRoutingRuleTimeRestrictionRestrictionList.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TeamRoutingRuleTimeRestrictionRestrictionList.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 end_day: _builtins.str,
                 end_hour: _builtins.int,
                 end_min: _builtins.int,
                 start_day: _builtins.str,
                 start_hour: _builtins.int,
                 start_min: _builtins.int):
        pulumi.set(__self__, "end_day", end_day)
        pulumi.set(__self__, "end_hour", end_hour)
        pulumi.set(__self__, "end_min", end_min)
        pulumi.set(__self__, "start_day", start_day)
        pulumi.set(__self__, "start_hour", start_hour)
        pulumi.set(__self__, "start_min", start_min)

    @_builtins.property
    @pulumi.getter(name="endDay")
    def end_day(self) -> _builtins.str:
        return pulumi.get(self, "end_day")

    @_builtins.property
    @pulumi.getter(name="endHour")
    def end_hour(self) -> _builtins.int:
        return pulumi.get(self, "end_hour")

    @_builtins.property
    @pulumi.getter(name="endMin")
    def end_min(self) -> _builtins.int:
        return pulumi.get(self, "end_min")

    @_builtins.property
    @pulumi.getter(name="startDay")
    def start_day(self) -> _builtins.str:
        return pulumi.get(self, "start_day")

    @_builtins.property
    @pulumi.getter(name="startHour")
    def start_hour(self) -> _builtins.int:
        return pulumi.get(self, "start_hour")

    @_builtins.property
    @pulumi.getter(name="startMin")
    def start_min(self) -> _builtins.int:
        return pulumi.get(self, "start_min")


@pulumi.output_type
class UserUserAddress(dict):
    def __init__(__self__, *,
                 city: _builtins.str,
                 country: _builtins.str,
                 line: _builtins.str,
                 state: _builtins.str,
                 zipcode: _builtins.str):
        pulumi.set(__self__, "city", city)
        pulumi.set(__self__, "country", country)
        pulumi.set(__self__, "line", line)
        pulumi.set(__self__, "state", state)
        pulumi.set(__self__, "zipcode", zipcode)

    @_builtins.property
    @pulumi.getter
    def city(self) -> _builtins.str:
        return pulumi.get(self, "city")

    @_builtins.property
    @pulumi.getter
    def country(self) -> _builtins.str:
        return pulumi.get(self, "country")

    @_builtins.property
    @pulumi.getter
    def line(self) -> _builtins.str:
        return pulumi.get(self, "line")

    @_builtins.property
    @pulumi.getter
    def state(self) -> _builtins.str:
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter
    def zipcode(self) -> _builtins.str:
        return pulumi.get(self, "zipcode")


@pulumi.output_type
class GetEscalationRepeatResult(dict):
    def __init__(__self__, *,
                 close_alert_after_all: Optional[_builtins.bool] = None,
                 count: Optional[_builtins.int] = None,
                 reset_recipient_states: Optional[_builtins.bool] = None,
                 wait_interval: Optional[_builtins.int] = None):
        if close_alert_after_all is not None:
            pulumi.set(__self__, "close_alert_after_all", close_alert_after_all)
        if count is not None:
            pulumi.set(__self__, "count", count)
        if reset_recipient_states is not None:
            pulumi.set(__self__, "reset_recipient_states", reset_recipient_states)
        if wait_interval is not None:
            pulumi.set(__self__, "wait_interval", wait_interval)

    @_builtins.property
    @pulumi.getter(name="closeAlertAfterAll")
    def close_alert_after_all(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "close_alert_after_all")

    @_builtins.property
    @pulumi.getter
    def count(self) -> Optional[_builtins.int]:
        return pulumi.get(self, "count")

    @_builtins.property
    @pulumi.getter(name="resetRecipientStates")
    def reset_recipient_states(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "reset_recipient_states")

    @_builtins.property
    @pulumi.getter(name="waitInterval")
    def wait_interval(self) -> Optional[_builtins.int]:
        return pulumi.get(self, "wait_interval")


@pulumi.output_type
class GetEscalationRuleResult(dict):
    def __init__(__self__, *,
                 condition: _builtins.str,
                 delay: _builtins.int,
                 notify_type: _builtins.str,
                 recipients: Sequence['outputs.GetEscalationRuleRecipientResult']):
        pulumi.set(__self__, "condition", condition)
        pulumi.set(__self__, "delay", delay)
        pulumi.set(__self__, "notify_type", notify_type)
        pulumi.set(__self__, "recipients", recipients)

    @_builtins.property
    @pulumi.getter
    def condition(self) -> _builtins.str:
        return pulumi.get(self, "condition")

    @_builtins.property
    @pulumi.getter
    def delay(self) -> _builtins.int:
        return pulumi.get(self, "delay")

    @_builtins.property
    @pulumi.getter(name="notifyType")
    def notify_type(self) -> _builtins.str:
        return pulumi.get(self, "notify_type")

    @_builtins.property
    @pulumi.getter
    def recipients(self) -> Sequence['outputs.GetEscalationRuleRecipientResult']:
        return pulumi.get(self, "recipients")


@pulumi.output_type
class GetEscalationRuleRecipientResult(dict):
    def __init__(__self__, *,
                 id: Optional[_builtins.str] = None,
                 type: Optional[_builtins.str] = None):
        """
        :param _builtins.str id: The ID of the Opsgenie Escalation.
        """
        if id is not None:
            pulumi.set(__self__, "id", id)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter
    def id(self) -> Optional[_builtins.str]:
        """
        The ID of the Opsgenie Escalation.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "type")


@pulumi.output_type
class GetTeamMemberResult(dict):
    def __init__(__self__, *,
                 id: Optional[_builtins.str] = None,
                 role: Optional[_builtins.str] = None,
                 username: Optional[_builtins.str] = None):
        """
        :param _builtins.str id: The ID of the Opsgenie Team.
        """
        if id is not None:
            pulumi.set(__self__, "id", id)
        if role is not None:
            pulumi.set(__self__, "role", role)
        if username is not None:
            pulumi.set(__self__, "username", username)

    @_builtins.property
    @pulumi.getter
    def id(self) -> Optional[_builtins.str]:
        """
        The ID of the Opsgenie Team.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def role(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "role")

    @_builtins.property
    @pulumi.getter
    def username(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "username")


